/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AbstractUndirectedGraphTest;
import com.google.common.graph.GraphConfig;
import com.google.common.graph.Graphs;
import com.google.common.graph.UndirectedGraph;
import com.google.common.truth.Truth;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IncidenceSetSimpleUndirectedGraphTest
extends AbstractUndirectedGraphTest {
    @Override
    public UndirectedGraph<Integer, String> createGraph() {
        return Graphs.createUndirected((GraphConfig)Graphs.config().noSelfLoops());
    }

    @Override
    @Test
    public void nodes_checkReturnedSetMutability() {
        Set nodes = this.undirectedGraph.nodes();
        try {
            nodes.add(N2);
            Assert.fail((String)"Set returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.addNode(N1);
            Truth.assertThat((Iterable)this.undirectedGraph.nodes()).containsExactlyElementsIn((Iterable)nodes);
        }
    }

    @Override
    @Test
    public void edges_checkReturnedSetMutability() {
        Set edges = this.undirectedGraph.edges();
        try {
            edges.add("1-2");
            Assert.fail((String)"Set returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.addEdge("1-2", N1, N2);
            Truth.assertThat((Iterable)this.undirectedGraph.edges()).containsExactlyElementsIn((Iterable)edges);
        }
    }

    @Override
    @Test
    public void incidentEdges_checkReturnedSetMutability() {
        this.addNode(N1);
        Set incidentEdges = this.undirectedGraph.incidentEdges((Object)N1);
        try {
            incidentEdges.add("1-2");
            Assert.fail((String)"Set returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.addEdge("1-2", N1, N2);
            Truth.assertThat((Iterable)this.undirectedGraph.incidentEdges((Object)N1)).containsExactlyElementsIn((Iterable)incidentEdges);
        }
    }

    @Override
    @Test
    public void incidentNodes_checkReturnedSetMutability() {
        this.addEdge("1-2", N1, N2);
        Set incidentNodes = this.undirectedGraph.incidentNodes((Object)"1-2");
        try {
            incidentNodes.add(N3);
            Assert.fail((String)"Set returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Override
    @Test
    public void adjacentNodes_checkReturnedSetMutability() {
        this.addNode(N1);
        Set adjacentNodes = this.undirectedGraph.adjacentNodes((Object)N1);
        try {
            adjacentNodes.add(N2);
            Assert.fail((String)"Set returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.addEdge("1-2", N1, N2);
            Truth.assertThat((Iterable)this.undirectedGraph.adjacentNodes((Object)N1)).containsExactlyElementsIn((Iterable)adjacentNodes);
        }
    }

    @Override
    @Test
    public void adjacentEdges_checkReturnedSetMutability() {
        this.addEdge("1-2", N1, N2);
        Set adjacentEdges = this.undirectedGraph.adjacentEdges((Object)"1-2");
        try {
            adjacentEdges.add("2-3");
            Assert.fail((String)"Set returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.addEdge("2-3", N2, N3);
            Truth.assertThat((Iterable)this.undirectedGraph.adjacentEdges((Object)"1-2")).containsExactlyElementsIn((Iterable)adjacentEdges);
        }
    }

    @Override
    @Test
    public void edgesConnecting_checkReturnedSetMutability() {
        this.addNode(N1);
        this.addNode(N2);
        Set edgesConnecting = this.undirectedGraph.edgesConnecting((Object)N1, (Object)N2);
        try {
            edgesConnecting.add("2-3");
            Assert.fail((String)"Set returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.addEdge("1-2", N1, N2);
            Truth.assertThat((Iterable)this.undirectedGraph.edgesConnecting((Object)N1, (Object)N2)).containsExactlyElementsIn((Iterable)edgesConnecting);
        }
    }

    @Override
    @Test
    public void inEdges_checkReturnedSetMutability() {
        this.addNode(N2);
        Set inEdges = this.undirectedGraph.inEdges((Object)N2);
        try {
            inEdges.add("1-2");
            Assert.fail((String)"Set returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.addEdge("1-2", N1, N2);
            Truth.assertThat((Iterable)this.undirectedGraph.inEdges((Object)N2)).containsExactlyElementsIn((Iterable)inEdges);
        }
    }

    @Override
    @Test
    public void outEdges_checkReturnedSetMutability() {
        this.addNode(N1);
        Set outEdges = this.undirectedGraph.outEdges((Object)N1);
        try {
            outEdges.add("1-2");
            Assert.fail((String)"Set returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.addEdge("1-2", N1, N2);
            Truth.assertThat((Iterable)this.undirectedGraph.outEdges((Object)N1)).containsExactlyElementsIn((Iterable)outEdges);
        }
    }

    @Override
    @Test
    public void predecessors_checkReturnedSetMutability() {
        this.addNode(N2);
        Set predecessors = this.undirectedGraph.predecessors((Object)N2);
        try {
            predecessors.add(N1);
            Assert.fail((String)"Set returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.addEdge("1-2", N1, N2);
            Truth.assertThat((Iterable)this.undirectedGraph.predecessors((Object)N2)).containsExactlyElementsIn((Iterable)predecessors);
        }
    }

    @Override
    @Test
    public void successors_checkReturnedSetMutability() {
        this.addNode(N1);
        Set successors = this.undirectedGraph.successors((Object)N1);
        try {
            successors.add(N2);
            Assert.fail((String)"Set returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.addEdge("1-2", N1, N2);
            Truth.assertThat((Iterable)this.undirectedGraph.successors((Object)N1)).containsExactlyElementsIn((Iterable)successors);
        }
    }

    @Test
    public void addEdge_selfLoop() {
        try {
            this.addEdge("1-1", N1, N1);
            Assert.fail((String)"Should not be allowed to add a self-loop edge.");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"self-loops are not allowed");
        }
    }

    @Test
    public void addEdge_nodesNotInGraph() {
        this.undirectedGraph.addNode((Object)N1);
        Assert.assertTrue((boolean)this.undirectedGraph.addEdge((Object)"1-5", (Object)N1, (Object)N5));
        Assert.assertTrue((boolean)this.undirectedGraph.addEdge((Object)"4-1", (Object)N4, (Object)N1));
        Assert.assertTrue((boolean)this.undirectedGraph.addEdge((Object)"2-3", (Object)N2, (Object)N3));
        Truth.assertThat((Iterable)this.undirectedGraph.nodes()).containsExactly(new Object[]{N1, N5, N4, N2, N3}).inOrder();
        Truth.assertThat((Iterable)this.undirectedGraph.edges()).containsExactly(new Object[]{"1-5", "4-1", "2-3"}).inOrder();
        Truth.assertThat((Iterable)this.undirectedGraph.edgesConnecting((Object)N1, (Object)N5)).containsExactly(new Object[]{"1-5"});
        Truth.assertThat((Iterable)this.undirectedGraph.edgesConnecting((Object)N4, (Object)N1)).containsExactly(new Object[]{"4-1"});
        Truth.assertThat((Iterable)this.undirectedGraph.edgesConnecting((Object)N2, (Object)N3)).containsExactly(new Object[]{"2-3"});
        Truth.assertThat((Iterable)this.undirectedGraph.edgesConnecting((Object)N3, (Object)N2)).containsExactly(new Object[]{"2-3"});
    }
}

