/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.IncidentNodes;
import com.google.common.testing.EqualsTester;
import com.google.common.truth.Truth;
import java.util.Set;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class IncidentNodesTest {
    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{IncidentNodes.of((Object)"foo", (Object)"bar"), IncidentNodes.of((Object)"bar", (Object)"foo"), IncidentNodes.of((Set)ImmutableSet.of((Object)"foo", (Object)"bar")), IncidentNodes.of((Set)ImmutableSet.of((Object)"bar", (Object)"foo"))}).addEqualityGroup(new Object[]{IncidentNodes.of((Object)"test", (Object)"test"), IncidentNodes.of((Set)ImmutableSet.of((Object)"test"))}).testEquals();
    }

    @Test
    public void testNodes_basic() {
        IncidentNodes incidentNodes = IncidentNodes.of((Object)"foo", (Object)"bar");
        Truth.assertThat((String)((String)incidentNodes.node1())).isEqualTo((Object)"foo");
        Truth.assertThat((String)((String)incidentNodes.node2())).isEqualTo((Object)"bar");
    }

    @Test
    public void testNodes_orderedSet() {
        IncidentNodes incidentNodes = IncidentNodes.of((Set)ImmutableSet.of((Object)"foo", (Object)"bar"));
        Truth.assertThat((String)((String)incidentNodes.node1())).isEqualTo((Object)"foo");
        Truth.assertThat((String)((String)incidentNodes.node2())).isEqualTo((Object)"bar");
    }

    @Test
    public void testNodes_selfLoop() {
        IncidentNodes incidentNodes = IncidentNodes.of((Set)ImmutableSet.of((Object)"test"));
        Truth.assertThat((String)((String)incidentNodes.node1())).isEqualTo((Object)"test");
        Truth.assertThat((String)((String)incidentNodes.node2())).isEqualTo((Object)"test");
    }

    @Test
    public void testSet_basic() {
        IncidentNodes incidentNodes = IncidentNodes.of((Object)"source", (Object)"target");
        Truth.assertThat((Iterable)incidentNodes).containsExactly(new Object[]{"source", "target"}).inOrder();
        new EqualsTester().addEqualityGroup(new Object[]{incidentNodes, ImmutableSet.of((Object)"source", (Object)"target")}).testEquals();
    }

    @Test
    public void testSet_selfLoop() {
        IncidentNodes incidentNodes = IncidentNodes.of((Object)new String("node"), (Object)new String("node"));
        Truth.assertThat((Iterable)incidentNodes).containsExactly(new Object[]{"node"}).inOrder();
        new EqualsTester().addEqualityGroup(new Object[]{incidentNodes, ImmutableSet.of((Object)"node")}).testEquals();
    }
}

