/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.DirectedGraph;
import com.google.common.graph.GraphConfig;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableDirectedGraph;
import com.google.common.graph.ImmutableUndirectedGraph;
import com.google.common.graph.UndirectedGraph;
import com.google.common.testing.AbstractPackageSanityTests;
import com.google.common.truth.Truth;
import junit.framework.AssertionFailedError;

public class PackageSanityTests
extends AbstractPackageSanityTests {
    private static final GraphConfig CONFIG_A = Graphs.config().multigraph().expectedNodeCount(10);
    private static final GraphConfig CONFIG_B = Graphs.config().noSelfLoops().expectedNodeCount(16);
    private static final ImmutableDirectedGraph<String, String> IMMUTABLE_DIRECTED_A = ImmutableDirectedGraph.builder().addNode((Object)"A").build();
    private static final ImmutableDirectedGraph<String, String> IMMUTABLE_DIRECTED_B = ImmutableDirectedGraph.builder().addNode((Object)"B").build();
    private static final ImmutableUndirectedGraph<String, String> IMMUTABLE_UNDIRECTED_A = ImmutableUndirectedGraph.builder().addNode((Object)"A").build();
    private static final ImmutableUndirectedGraph<String, String> IMMUTABLE_UNDIRECTED_B = ImmutableUndirectedGraph.builder().addNode((Object)"B").build();

    public PackageSanityTests() {
        this.setDistinctValues(GraphConfig.class, CONFIG_A, CONFIG_B);
        this.setDistinctValues(DirectedGraph.class, IMMUTABLE_DIRECTED_A, IMMUTABLE_DIRECTED_B);
        this.setDistinctValues(UndirectedGraph.class, IMMUTABLE_UNDIRECTED_A, IMMUTABLE_UNDIRECTED_B);
    }

    public void testNulls() throws Exception {
        try {
            super.testNulls();
        }
        catch (AssertionFailedError e) {
            Truth.assertThat((String)e.getCause().getMessage()).contains((CharSequence)"not an element of this graph");
        }
    }
}

