/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.HashTestUtils;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.MessageDigestHashFunction;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import junit.framework.TestCase;

public class MessageDigestHashFunctionTest
extends TestCase {
    private static final ImmutableSet<String> INPUTS = ImmutableSet.of((Object)"", (Object)"Z", (Object)"foobar");
    private static final ImmutableMap<String, HashFunction> ALGORITHMS = new ImmutableMap.Builder().put((Object)"MD5", (Object)Hashing.md5()).put((Object)"SHA", (Object)Hashing.sha1()).put((Object)"SHA1", (Object)Hashing.sha1()).put((Object)"sHa-1", (Object)Hashing.sha1()).put((Object)"SHA-1", (Object)Hashing.sha1()).put((Object)"SHA-256", (Object)Hashing.sha256()).put((Object)"SHA-384", (Object)Hashing.sha384()).put((Object)"SHA-512", (Object)Hashing.sha512()).build();

    public void testHashing() {
        for (String stringToTest : INPUTS) {
            for (String algorithmToTest : ALGORITHMS.keySet()) {
                MessageDigestHashFunctionTest.assertMessageDigestHashing(HashTestUtils.ascii(stringToTest), algorithmToTest);
            }
        }
    }

    public void testPutAfterHash() {
        Hasher sha1 = Hashing.sha1().newHasher();
        MessageDigestHashFunctionTest.assertEquals((String)"2fd4e1c67a2d28fced849ee1bb76e7391b93eb12", (String)sha1.putString((CharSequence)"The quick brown fox jumps over the lazy dog", Charsets.UTF_8).hash().toString());
        try {
            sha1.putInt(42);
            MessageDigestHashFunctionTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testHashTwice() {
        Hasher sha1 = Hashing.sha1().newHasher();
        MessageDigestHashFunctionTest.assertEquals((String)"2fd4e1c67a2d28fced849ee1bb76e7391b93eb12", (String)sha1.putString((CharSequence)"The quick brown fox jumps over the lazy dog", Charsets.UTF_8).hash().toString());
        try {
            sha1.hash();
            MessageDigestHashFunctionTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testToString() {
        MessageDigestHashFunctionTest.assertEquals((String)"Hashing.md5()", (String)Hashing.md5().toString());
        MessageDigestHashFunctionTest.assertEquals((String)"Hashing.sha1()", (String)Hashing.sha1().toString());
        MessageDigestHashFunctionTest.assertEquals((String)"Hashing.sha256()", (String)Hashing.sha256().toString());
        MessageDigestHashFunctionTest.assertEquals((String)"Hashing.sha512()", (String)Hashing.sha512().toString());
    }

    private static void assertMessageDigestHashing(byte[] input, String algorithmName) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithmName);
            MessageDigestHashFunctionTest.assertEquals((Object)HashCode.fromBytes((byte[])digest.digest(input)), (Object)((HashFunction)ALGORITHMS.get((Object)algorithmName)).hashBytes(input));
            for (int bytes = 4; bytes <= digest.getDigestLength(); ++bytes) {
                MessageDigestHashFunctionTest.assertEquals((Object)HashCode.fromBytes((byte[])Arrays.copyOf(digest.digest(input), bytes)), (Object)new MessageDigestHashFunction(algorithmName, bytes, algorithmName).hashBytes(input));
            }
            try {
                int maxSize = digest.getDigestLength();
                new MessageDigestHashFunction(algorithmName, maxSize + 1, algorithmName);
                MessageDigestHashFunctionTest.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new AssertionError((Object)nsae);
        }
    }
}

