/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import junit.framework.TestCase;

public class SipHashFunctionTest
extends TestCase {
    private static final long K0 = 506097522914230528L;
    private static final long K1 = 1084818905618843912L;
    private static final HashFunction SIP_WITH_KEY = Hashing.sipHash24((long)506097522914230528L, (long)1084818905618843912L);
    private static final HashFunction SIP_WITHOUT_KEY = Hashing.sipHash24();
    private static final long[] EXPECTED = new long[]{8246050544436514353L, 8428550223375919101L, 967288799772626778L, -8833979346009227731L, -3519680893311416393L, 1762690195596617357L, -3762398573937892402L, -6124331488671313609L, -7785046478206851998L, -7061500321231936336L, 8817410102741809651L, -814255129352229465L, 8439340791604635131L, 1507111754042457488L, -638443999941954834L, -6833708440360172059L, 4551675220716592091L, 7609651759622801300L, 5458842069249151900L, -4941072086954581571L, -4695463366588436840L, -3390423611906234425L, -7830801433600246136L, -6337686672341414200L, -5139362784294097004L, -4836423040314787606L, 1718182323771086323L, 3399761846665465773L, -2428096965567985243L, -6439496115894786703L, -5942601604866117848L, 3663839902933566274L, 8153574914611379406L, -6344688662296823581L, 1360280716319199800L, 1576317954979633070L, 3552776872709694388L, 178333021418699137L, -3828951500492370867L, -7295874868217416868L, 1026444043506460624L, -5977329114303407726L, 1761759337908409769L, -3123797484879926379L, -489408989802390030L, -6245491010462984313L, -2622557471210953456L, -3428197208555948565L, -1868250800467498671L, -4078319331645214826L, -1268815138646720910L, -6804141381229668774L, 758724319039419570L, -9100676172257911953L, 9198639672290634986L, 2618616414355072153L, -5220305633730001987L, -1577714088829904373L, 6982299211676602387L, 7351800817158466451L, 7828642298779898337L, -6961881534150859277L, -1937893227286601897L, -7671263709330258574L};

    public void testVectors() {
        for (int i = 0; i < EXPECTED.length; ++i) {
            byte[] msg = new byte[i];
            for (int j = 0; j < i; ++j) {
                msg[j] = (byte)j;
            }
            SipHashFunctionTest.assertSip(msg, EXPECTED[i]);
        }
    }

    public void test15ByteStringFromSipHashPaper() {
        byte[] message = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14};
        long k0 = 506097522914230528L;
        long k1 = 1084818905618843912L;
        SipHashFunctionTest.assertEquals((long)-6833708440360172059L, (long)Hashing.sipHash24((long)k0, (long)k1).hashBytes(message).asLong());
    }

    public void testKnownValues() {
        SipHashFunctionTest.assertSip(new byte[0], 8246050544436514353L);
        SipHashFunctionTest.assertSip(new byte[]{97}, 3144613055062689994L);
        SipHashFunctionTest.assertSip(new byte[1000000], 2891400056537786178L);
        SipHashFunctionTest.assertSip("12345678", 149469851762178027L);
        SipHashFunctionTest.assertSip("abcdef", 3057513031921025117L);
        SipHashFunctionTest.assertSip("SipHash", -8996774569131282592L);
    }

    public void testCollisionsDueToIncorrectSignExtension() {
        byte[] col1 = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, -128};
        byte[] col2 = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, -127};
        byte[] col3 = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, -1};
        ImmutableSet hashCodes = ImmutableSet.of((Object)SIP_WITH_KEY.hashBytes(col1), (Object)SIP_WITH_KEY.hashBytes(col2), (Object)SIP_WITH_KEY.hashBytes(col3));
        SipHashFunctionTest.assertEquals((int)3, (int)hashCodes.size());
    }

    public void testToString() {
        SipHashFunctionTest.assertEquals((String)"Hashing.sipHash24(506097522914230528, 1084818905618843912)", (String)SIP_WITH_KEY.toString());
        SipHashFunctionTest.assertEquals((String)"Hashing.sipHash24(506097522914230528, 1084818905618843912)", (String)SIP_WITHOUT_KEY.toString());
        SipHashFunctionTest.assertEquals((String)"Hashing.sipHash24(20, 13)", (String)Hashing.sipHash24((long)20L, (long)13L).toString());
    }

    private static void assertSip(String input, long expected) {
        SipHashFunctionTest.assertEquals((long)expected, (long)SIP_WITH_KEY.hashString((CharSequence)input, Charsets.UTF_8).asLong());
        SipHashFunctionTest.assertEquals((long)expected, (long)SIP_WITH_KEY.newHasher().putString((CharSequence)input, Charsets.UTF_8).hash().asLong());
        SipHashFunctionTest.assertEquals((long)expected, (long)SIP_WITHOUT_KEY.hashString((CharSequence)input, Charsets.UTF_8).asLong());
        SipHashFunctionTest.assertEquals((long)expected, (long)SIP_WITHOUT_KEY.newHasher().putString((CharSequence)input, Charsets.UTF_8).hash().asLong());
    }

    private static void assertSip(byte[] input, long expected) {
        SipHashFunctionTest.assertEquals((long)expected, (long)SIP_WITH_KEY.hashBytes(input).asLong());
        SipHashFunctionTest.assertEquals((long)expected, (long)SIP_WITH_KEY.newHasher().putBytes(input).hash().asLong());
        SipHashFunctionTest.assertEquals((long)expected, (long)SIP_WITHOUT_KEY.hashBytes(input).asLong());
        SipHashFunctionTest.assertEquals((long)expected, (long)SIP_WITHOUT_KEY.newHasher().putBytes(input).hash().asLong());
    }
}

