/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteSinkTester;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteSourceTester;
import com.google.common.io.CharSinkTester;
import com.google.common.io.CharSourceTester;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import com.google.common.io.IoTestCase;
import com.google.common.io.LineProcessor;
import com.google.common.io.SourceSinkFactories;
import com.google.common.primitives.Bytes;
import com.google.common.truth.Truth;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestSuite;

public class FilesTest
extends IoTestCase {
    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)ByteSourceTester.tests("Files.asByteSource[File]", SourceSinkFactories.fileByteSourceFactory(), true));
        suite.addTest((Test)ByteSinkTester.tests("Files.asByteSink[File]", SourceSinkFactories.fileByteSinkFactory()));
        suite.addTest((Test)ByteSinkTester.tests("Files.asByteSink[File, APPEND]", SourceSinkFactories.appendingFileByteSinkFactory()));
        suite.addTest((Test)CharSourceTester.tests("Files.asCharSource[File, Charset]", SourceSinkFactories.fileCharSourceFactory(), false));
        suite.addTest((Test)CharSinkTester.tests("Files.asCharSink[File, Charset]", SourceSinkFactories.fileCharSinkFactory()));
        suite.addTest((Test)CharSinkTester.tests("Files.asCharSink[File, Charset, APPEND]", SourceSinkFactories.appendingFileCharSinkFactory()));
        suite.addTestSuite(FilesTest.class);
        return suite;
    }

    public void testRoundTripSources() throws Exception {
        File asciiFile = this.getTestFile("ascii.txt");
        ByteSource byteSource = Files.asByteSource((File)asciiFile);
        FilesTest.assertSame((Object)byteSource, (Object)byteSource.asCharSource(Charsets.UTF_8).asByteSource(Charsets.UTF_8));
    }

    public void testToByteArray() throws IOException {
        File asciiFile = this.getTestFile("ascii.txt");
        File i18nFile = this.getTestFile("i18n.txt");
        FilesTest.assertTrue((boolean)Arrays.equals(" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~".getBytes(Charsets.US_ASCII), Files.toByteArray((File)asciiFile)));
        FilesTest.assertTrue((boolean)Arrays.equals("\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1".getBytes(Charsets.UTF_8), Files.toByteArray((File)i18nFile)));
        FilesTest.assertTrue((boolean)Arrays.equals("\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1".getBytes(Charsets.UTF_8), Files.asByteSource((File)i18nFile).read()));
    }

    public void testReadFile_withCorrectSize() throws IOException {
        File asciiFile = this.getTestFile("ascii.txt");
        Closer closer = Closer.create();
        try {
            InputStream in = (InputStream)closer.register((Closeable)new FileInputStream(asciiFile));
            byte[] bytes = Files.readFile((InputStream)in, (long)asciiFile.length());
            FilesTest.assertTrue((boolean)Arrays.equals(" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~".getBytes(Charsets.US_ASCII), bytes));
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    public void testReadFile_withSmallerSize() throws IOException {
        File asciiFile = this.getTestFile("ascii.txt");
        Closer closer = Closer.create();
        try {
            InputStream in = (InputStream)closer.register((Closeable)new FileInputStream(asciiFile));
            byte[] bytes = Files.readFile((InputStream)in, (long)10L);
            FilesTest.assertTrue((boolean)Arrays.equals(" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~".getBytes(Charsets.US_ASCII), bytes));
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    public void testReadFile_withLargerSize() throws IOException {
        File asciiFile = this.getTestFile("ascii.txt");
        Closer closer = Closer.create();
        try {
            InputStream in = (InputStream)closer.register((Closeable)new FileInputStream(asciiFile));
            byte[] bytes = Files.readFile((InputStream)in, (long)500L);
            FilesTest.assertTrue((boolean)Arrays.equals(" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~".getBytes(Charsets.US_ASCII), bytes));
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    public void testReadFile_withSizeZero() throws IOException {
        File asciiFile = this.getTestFile("ascii.txt");
        Closer closer = Closer.create();
        try {
            InputStream in = (InputStream)closer.register((Closeable)new FileInputStream(asciiFile));
            byte[] bytes = Files.readFile((InputStream)in, (long)0L);
            FilesTest.assertTrue((boolean)Arrays.equals(" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~".getBytes(Charsets.US_ASCII), bytes));
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    public void testToString() throws IOException {
        File asciiFile = this.getTestFile("ascii.txt");
        File i18nFile = this.getTestFile("i18n.txt");
        FilesTest.assertEquals((String)" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~", (String)Files.toString((File)asciiFile, (Charset)Charsets.US_ASCII));
        FilesTest.assertEquals((String)"\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1", (String)Files.toString((File)i18nFile, (Charset)Charsets.UTF_8));
        Truth.assertThat((String)Files.toString((File)i18nFile, (Charset)Charsets.US_ASCII)).isNotEqualTo((Object)"\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1");
    }

    public void testWriteString() throws IOException {
        File temp = this.createTempFile();
        Files.write((CharSequence)"\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1", (File)temp, (Charset)Charsets.UTF_16LE);
        FilesTest.assertEquals((String)"\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1", (String)Files.toString((File)temp, (Charset)Charsets.UTF_16LE));
    }

    public void testWriteBytes() throws IOException {
        File temp = this.createTempFile();
        byte[] data = FilesTest.newPreFilledByteArray(2000);
        Files.write((byte[])data, (File)temp);
        FilesTest.assertTrue((boolean)Arrays.equals(data, Files.toByteArray((File)temp)));
        try {
            Files.write(null, (File)temp);
            FilesTest.fail((String)"expected exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAppendString() throws IOException {
        File temp = this.createTempFile();
        Files.append((CharSequence)"\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1", (File)temp, (Charset)Charsets.UTF_16LE);
        FilesTest.assertEquals((String)"\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1", (String)Files.toString((File)temp, (Charset)Charsets.UTF_16LE));
        Files.append((CharSequence)"\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1", (File)temp, (Charset)Charsets.UTF_16LE);
        FilesTest.assertEquals((String)"\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1", (String)Files.toString((File)temp, (Charset)Charsets.UTF_16LE));
        Files.append((CharSequence)"\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1", (File)temp, (Charset)Charsets.UTF_16LE);
        FilesTest.assertEquals((String)"\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1", (String)Files.toString((File)temp, (Charset)Charsets.UTF_16LE));
    }

    public void testCopyToOutputStream() throws IOException {
        File i18nFile = this.getTestFile("i18n.txt");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Files.copy((File)i18nFile, (OutputStream)out);
        FilesTest.assertEquals((String)"\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1", (String)out.toString("UTF-8"));
    }

    public void testCopyToAppendable() throws IOException {
        File i18nFile = this.getTestFile("i18n.txt");
        StringBuilder sb = new StringBuilder();
        Files.copy((File)i18nFile, (Charset)Charsets.UTF_8, (Appendable)sb);
        FilesTest.assertEquals((String)"\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1", (String)sb.toString());
    }

    public void testCopyFile() throws IOException {
        File i18nFile = this.getTestFile("i18n.txt");
        File temp = this.createTempFile();
        Files.copy((File)i18nFile, (File)temp);
        FilesTest.assertEquals((String)"\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1", (String)Files.toString((File)temp, (Charset)Charsets.UTF_8));
    }

    public void testCopyEqualFiles() throws IOException {
        File temp1 = this.createTempFile();
        File temp2 = FilesTest.file(temp1.getPath(), new String[0]);
        FilesTest.assertEquals((Object)temp1, (Object)temp2);
        Files.write((CharSequence)" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~", (File)temp1, (Charset)Charsets.UTF_8);
        try {
            Files.copy((File)temp1, (File)temp2);
            FilesTest.fail((String)"Expected an IAE to be thrown but wasn't");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        FilesTest.assertEquals((String)" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~", (String)Files.toString((File)temp1, (Charset)Charsets.UTF_8));
    }

    public void testCopySameFile() throws IOException {
        File temp = this.createTempFile();
        Files.write((CharSequence)" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~", (File)temp, (Charset)Charsets.UTF_8);
        try {
            Files.copy((File)temp, (File)temp);
            FilesTest.fail((String)"Expected an IAE to be thrown but wasn't");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        FilesTest.assertEquals((String)" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~", (String)Files.toString((File)temp, (Charset)Charsets.UTF_8));
    }

    public void testCopyIdenticalFiles() throws IOException {
        File temp1 = this.createTempFile();
        Files.write((CharSequence)" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~", (File)temp1, (Charset)Charsets.UTF_8);
        File temp2 = this.createTempFile();
        Files.write((CharSequence)" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~", (File)temp2, (Charset)Charsets.UTF_8);
        Files.copy((File)temp1, (File)temp2);
        FilesTest.assertEquals((String)" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~", (String)Files.toString((File)temp1, (Charset)Charsets.UTF_8));
    }

    public void testEqual() throws IOException {
        File asciiFile = this.getTestFile("ascii.txt");
        File i18nFile = this.getTestFile("i18n.txt");
        FilesTest.assertFalse((boolean)Files.equal((File)asciiFile, (File)i18nFile));
        FilesTest.assertTrue((boolean)Files.equal((File)asciiFile, (File)asciiFile));
        File temp = this.createTempFile();
        Files.copy((File)asciiFile, (File)temp);
        FilesTest.assertTrue((boolean)Files.equal((File)asciiFile, (File)temp));
        Files.copy((File)i18nFile, (File)temp);
        FilesTest.assertTrue((boolean)Files.equal((File)i18nFile, (File)temp));
        Files.copy((File)asciiFile, (File)temp);
        RandomAccessFile rf = new RandomAccessFile(temp, "rw");
        rf.writeByte(0);
        rf.close();
        FilesTest.assertEquals((long)asciiFile.length(), (long)temp.length());
        FilesTest.assertFalse((boolean)Files.equal((File)asciiFile, (File)temp));
        FilesTest.assertTrue((boolean)Files.asByteSource((File)asciiFile).contentEquals(Files.asByteSource((File)asciiFile)));
        FilesTest.assertTrue((boolean)Files.equal((File)asciiFile, (File)new BadLengthFile(asciiFile, 0L)));
    }

    public void testNewReader() throws IOException {
        File asciiFile = this.getTestFile("ascii.txt");
        try {
            Files.newReader((File)asciiFile, null);
            FilesTest.fail((String)"expected exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            Files.newReader(null, (Charset)Charsets.UTF_8);
            FilesTest.fail((String)"expected exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        BufferedReader r = Files.newReader((File)asciiFile, (Charset)Charsets.US_ASCII);
        try {
            FilesTest.assertEquals((String)" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~", (String)r.readLine());
        }
        finally {
            r.close();
        }
    }

    public void testNewWriter() throws IOException {
        File temp = this.createTempFile();
        try {
            Files.newWriter((File)temp, null);
            FilesTest.fail((String)"expected exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            Files.newWriter(null, (Charset)Charsets.UTF_8);
            FilesTest.fail((String)"expected exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        BufferedWriter w = Files.newWriter((File)temp, (Charset)Charsets.UTF_8);
        try {
            w.write("\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1");
        }
        finally {
            w.close();
        }
        File i18nFile = this.getTestFile("i18n.txt");
        FilesTest.assertTrue((boolean)Files.equal((File)i18nFile, (File)temp));
    }

    public void testTouch() throws IOException {
        File temp = this.createTempFile();
        FilesTest.assertTrue((boolean)temp.exists());
        FilesTest.assertTrue((boolean)temp.delete());
        FilesTest.assertFalse((boolean)temp.exists());
        Files.touch((File)temp);
        FilesTest.assertTrue((boolean)temp.exists());
        Files.touch((File)temp);
        FilesTest.assertTrue((boolean)temp.exists());
        try {
            Files.touch((File)new File(temp.getPath()){
                private static final long serialVersionUID = 0L;

                @Override
                public boolean setLastModified(long t) {
                    return false;
                }
            });
            FilesTest.fail((String)"expected exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testTouchTime() throws IOException {
        File temp = this.createTempFile();
        FilesTest.assertTrue((boolean)temp.exists());
        temp.setLastModified(0L);
        FilesTest.assertEquals((long)0L, (long)temp.lastModified());
        Files.touch((File)temp);
        Truth.assertThat((Long)temp.lastModified()).isNotEqualTo((Object)0);
    }

    public void testCreateParentDirs_root() throws IOException {
        File file = FilesTest.root();
        FilesTest.assertNull((Object)file.getParentFile());
        FilesTest.assertNull((Object)file.getCanonicalFile().getParentFile());
        Files.createParentDirs((File)file);
    }

    public void testCreateParentDirs_relativePath() throws IOException {
        File file = FilesTest.file("nonexistent.file", new String[0]);
        FilesTest.assertNull((Object)file.getParentFile());
        FilesTest.assertNotNull((Object)file.getCanonicalFile().getParentFile());
        Files.createParentDirs((File)file);
    }

    public void testCreateParentDirs_noParentsNeeded() throws IOException {
        File file = FilesTest.file(this.getTempDir(), "nonexistent.file");
        FilesTest.assertTrue((boolean)file.getParentFile().exists());
        Files.createParentDirs((File)file);
    }

    public void testCreateParentDirs_oneParentNeeded() throws IOException {
        File file = FilesTest.file(this.getTempDir(), "parent", "nonexistent.file");
        File parent = file.getParentFile();
        FilesTest.assertFalse((boolean)parent.exists());
        try {
            Files.createParentDirs((File)file);
            FilesTest.assertTrue((boolean)parent.exists());
        }
        finally {
            FilesTest.assertTrue((boolean)parent.delete());
        }
    }

    public void testCreateParentDirs_multipleParentsNeeded() throws IOException {
        File file = FilesTest.file(this.getTempDir(), "grandparent", "parent", "nonexistent.file");
        File parent = file.getParentFile();
        File grandparent = parent.getParentFile();
        FilesTest.assertFalse((boolean)grandparent.exists());
        Files.createParentDirs((File)file);
        FilesTest.assertTrue((boolean)parent.exists());
    }

    public void testCreateParentDirs_nonDirectoryParentExists() throws IOException {
        File parent = this.getTestFile("ascii.txt");
        FilesTest.assertTrue((boolean)parent.isFile());
        File file = FilesTest.file(parent, "foo");
        try {
            Files.createParentDirs((File)file);
            FilesTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testCreateTempDir() {
        File temp = Files.createTempDir();
        FilesTest.assertTrue((boolean)temp.exists());
        FilesTest.assertTrue((boolean)temp.isDirectory());
        Truth.assertThat((Object[])temp.listFiles()).isEmpty();
        FilesTest.assertTrue((boolean)temp.delete());
    }

    public void testMove() throws IOException {
        File i18nFile = this.getTestFile("i18n.txt");
        File temp1 = this.createTempFile();
        File temp2 = this.createTempFile();
        Files.copy((File)i18nFile, (File)temp1);
        this.moveHelper(true, temp1, temp2);
        FilesTest.assertTrue((boolean)Files.equal((File)temp2, (File)i18nFile));
    }

    public void testMoveViaCopy() throws IOException {
        File i18nFile = this.getTestFile("i18n.txt");
        File temp1 = this.createTempFile();
        File temp2 = this.createTempFile();
        Files.copy((File)i18nFile, (File)temp1);
        this.moveHelper(true, new UnmovableFile(temp1, false, true), temp2);
        FilesTest.assertTrue((boolean)Files.equal((File)temp2, (File)i18nFile));
    }

    public void testMoveFailures() throws IOException {
        File temp1 = this.createTempFile();
        File temp2 = this.createTempFile();
        this.moveHelper(false, new UnmovableFile(temp1, false, false), temp2);
        this.moveHelper(false, new UnmovableFile(temp1, false, false), new UnmovableFile(temp2, true, false));
        try {
            File asciiFile = this.getTestFile("ascii.txt");
            this.moveHelper(false, asciiFile, asciiFile);
            FilesTest.fail((String)"expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void moveHelper(boolean success, File from, File to) throws IOException {
        block4: {
            try {
                Files.move((File)from, (File)to);
                if (success) {
                    FilesTest.assertFalse((boolean)from.exists());
                    FilesTest.assertTrue((boolean)to.exists());
                } else {
                    FilesTest.fail((String)"expected exception");
                }
            }
            catch (IOException possiblyExpected) {
                if (!success) break block4;
                throw possiblyExpected;
            }
        }
    }

    public void testLineReading() throws IOException {
        File temp = this.createTempFile();
        FilesTest.assertNull((Object)Files.readFirstLine((File)temp, (Charset)Charsets.UTF_8));
        FilesTest.assertTrue((boolean)Files.readLines((File)temp, (Charset)Charsets.UTF_8).isEmpty());
        PrintWriter w = new PrintWriter(Files.newWriter((File)temp, (Charset)Charsets.UTF_8));
        w.println("hello");
        w.println("");
        w.println(" world  ");
        w.println("");
        w.close();
        FilesTest.assertEquals((String)"hello", (String)Files.readFirstLine((File)temp, (Charset)Charsets.UTF_8));
        FilesTest.assertEquals((Object)ImmutableList.of((Object)"hello", (Object)"", (Object)" world  ", (Object)""), (Object)Files.readLines((File)temp, (Charset)Charsets.UTF_8));
        FilesTest.assertTrue((boolean)temp.delete());
    }

    public void testReadLines_withLineProcessor() throws IOException {
        File temp = this.createTempFile();
        LineProcessor<List<String>> collect = new LineProcessor<List<String>>(){
            List<String> collector = new ArrayList<String>();

            public boolean processLine(String line) {
                this.collector.add(line);
                return true;
            }

            public List<String> getResult() {
                return this.collector;
            }
        };
        Truth.assertThat((Iterable)((Iterable)Files.readLines((File)temp, (Charset)Charsets.UTF_8, (LineProcessor)collect))).isEmpty();
        PrintWriter w = new PrintWriter(Files.newWriter((File)temp, (Charset)Charsets.UTF_8));
        w.println("hello");
        w.println("");
        w.println(" world  ");
        w.println("");
        w.close();
        Files.readLines((File)temp, (Charset)Charsets.UTF_8, (LineProcessor)collect);
        Truth.assertThat((Iterable)((Iterable)collect.getResult())).containsExactly(new Object[]{"hello", "", " world  ", ""}).inOrder();
        LineProcessor<List<String>> collectNonEmptyLines = new LineProcessor<List<String>>(){
            List<String> collector = new ArrayList<String>();

            public boolean processLine(String line) {
                if (line.length() > 0) {
                    this.collector.add(line);
                }
                return true;
            }

            public List<String> getResult() {
                return this.collector;
            }
        };
        Files.readLines((File)temp, (Charset)Charsets.UTF_8, (LineProcessor)collectNonEmptyLines);
        Truth.assertThat((Iterable)((Iterable)collectNonEmptyLines.getResult())).containsExactly(new Object[]{"hello", " world  "}).inOrder();
        FilesTest.assertTrue((boolean)temp.delete());
    }

    public void testHash() throws IOException {
        File asciiFile = this.getTestFile("ascii.txt");
        File i18nFile = this.getTestFile("i18n.txt");
        String init = "d41d8cd98f00b204e9800998ecf8427e";
        FilesTest.assertEquals((String)init, (String)Hashing.md5().newHasher().hash().toString());
        String asciiHash = "e5df5a39f2b8cb71b24e1d8038f93131";
        FilesTest.assertEquals((String)asciiHash, (String)Files.hash((File)asciiFile, (HashFunction)Hashing.md5()).toString());
        String i18nHash = "7fa826962ce2079c8334cd4ebf33aea4";
        FilesTest.assertEquals((String)i18nHash, (String)Files.hash((File)i18nFile, (HashFunction)Hashing.md5()).toString());
    }

    public void testMap() throws IOException {
        int size = 1024;
        byte[] bytes = FilesTest.newPreFilledByteArray(size);
        File file = this.createTempFile();
        Files.write((byte[])bytes, (File)file);
        MappedByteBuffer actual = Files.map((File)file);
        ByteBuffer expected = ByteBuffer.wrap(bytes);
        FilesTest.assertTrue((String)"ByteBuffers should be equal.", (boolean)expected.equals(actual));
    }

    public void testMap_noSuchFile() throws IOException {
        File file = this.createTempFile();
        boolean deleted = file.delete();
        FilesTest.assertTrue((boolean)deleted);
        try {
            Files.map((File)file);
            FilesTest.fail((String)"Should have thrown FileNotFoundException.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void testMap_readWrite() throws IOException {
        int size = 1024;
        byte[] expectedBytes = new byte[size];
        byte[] bytes = FilesTest.newPreFilledByteArray(1024);
        File file = this.createTempFile();
        Files.write((byte[])bytes, (File)file);
        Random random = new Random();
        random.nextBytes(expectedBytes);
        MappedByteBuffer map = Files.map((File)file, (FileChannel.MapMode)FileChannel.MapMode.READ_WRITE);
        map.put(expectedBytes);
        byte[] actualBytes = Files.toByteArray((File)file);
        FilesTest.assertTrue((boolean)Arrays.equals(expectedBytes, actualBytes));
    }

    public void testMap_readWrite_creates() throws IOException {
        int size = 1024;
        byte[] expectedBytes = FilesTest.newPreFilledByteArray(1024);
        File file = this.createTempFile();
        boolean deleted = file.delete();
        FilesTest.assertTrue((boolean)deleted);
        FilesTest.assertFalse((boolean)file.exists());
        MappedByteBuffer map = Files.map((File)file, (FileChannel.MapMode)FileChannel.MapMode.READ_WRITE, (long)size);
        map.put(expectedBytes);
        FilesTest.assertTrue((boolean)file.exists());
        FilesTest.assertTrue((boolean)file.isFile());
        FilesTest.assertEquals((long)size, (long)file.length());
        byte[] actualBytes = Files.toByteArray((File)file);
        FilesTest.assertTrue((boolean)Arrays.equals(expectedBytes, actualBytes));
    }

    public void testMap_readWrite_max_value_plus_1() throws IOException {
        File file = this.createTempFile();
        try {
            Files.map((File)file, (FileChannel.MapMode)FileChannel.MapMode.READ_WRITE, (long)0x80000000L);
            FilesTest.fail((String)"Should throw when size exceeds Integer.MAX_VALUE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetFileExtension() {
        FilesTest.assertEquals((String)"txt", (String)Files.getFileExtension((String)".txt"));
        FilesTest.assertEquals((String)"txt", (String)Files.getFileExtension((String)"blah.txt"));
        FilesTest.assertEquals((String)"txt", (String)Files.getFileExtension((String)"blah..txt"));
        FilesTest.assertEquals((String)"txt", (String)Files.getFileExtension((String)".blah.txt"));
        FilesTest.assertEquals((String)"txt", (String)Files.getFileExtension((String)"/tmp/blah.txt"));
        FilesTest.assertEquals((String)"gz", (String)Files.getFileExtension((String)"blah.tar.gz"));
        FilesTest.assertEquals((String)"", (String)Files.getFileExtension((String)"/"));
        FilesTest.assertEquals((String)"", (String)Files.getFileExtension((String)"."));
        FilesTest.assertEquals((String)"", (String)Files.getFileExtension((String)".."));
        FilesTest.assertEquals((String)"", (String)Files.getFileExtension((String)"..."));
        FilesTest.assertEquals((String)"", (String)Files.getFileExtension((String)"blah"));
        FilesTest.assertEquals((String)"", (String)Files.getFileExtension((String)"blah."));
        FilesTest.assertEquals((String)"", (String)Files.getFileExtension((String)".blah."));
        FilesTest.assertEquals((String)"", (String)Files.getFileExtension((String)"/foo.bar/blah"));
        FilesTest.assertEquals((String)"", (String)Files.getFileExtension((String)"/foo/.bar/blah"));
    }

    public void testGetNameWithoutExtension() {
        FilesTest.assertEquals((String)"", (String)Files.getNameWithoutExtension((String)".txt"));
        FilesTest.assertEquals((String)"blah", (String)Files.getNameWithoutExtension((String)"blah.txt"));
        FilesTest.assertEquals((String)"blah.", (String)Files.getNameWithoutExtension((String)"blah..txt"));
        FilesTest.assertEquals((String)".blah", (String)Files.getNameWithoutExtension((String)".blah.txt"));
        FilesTest.assertEquals((String)"blah", (String)Files.getNameWithoutExtension((String)"/tmp/blah.txt"));
        FilesTest.assertEquals((String)"blah.tar", (String)Files.getNameWithoutExtension((String)"blah.tar.gz"));
        FilesTest.assertEquals((String)"", (String)Files.getNameWithoutExtension((String)"/"));
        FilesTest.assertEquals((String)"", (String)Files.getNameWithoutExtension((String)"."));
        FilesTest.assertEquals((String)".", (String)Files.getNameWithoutExtension((String)".."));
        FilesTest.assertEquals((String)"..", (String)Files.getNameWithoutExtension((String)"..."));
        FilesTest.assertEquals((String)"blah", (String)Files.getNameWithoutExtension((String)"blah"));
        FilesTest.assertEquals((String)"blah", (String)Files.getNameWithoutExtension((String)"blah."));
        FilesTest.assertEquals((String)".blah", (String)Files.getNameWithoutExtension((String)".blah."));
        FilesTest.assertEquals((String)"blah", (String)Files.getNameWithoutExtension((String)"/foo.bar/blah"));
        FilesTest.assertEquals((String)"blah", (String)Files.getNameWithoutExtension((String)"/foo/.bar/blah"));
    }

    public void testReadBytes() throws IOException {
        ByteProcessor<byte[]> processor = new ByteProcessor<byte[]>(){
            private final ByteArrayOutputStream out = new ByteArrayOutputStream();

            public boolean processBytes(byte[] buffer, int offset, int length) throws IOException {
                if (length >= 0) {
                    this.out.write(buffer, offset, length);
                }
                return true;
            }

            public byte[] getResult() {
                return this.out.toByteArray();
            }
        };
        File asciiFile = this.getTestFile("ascii.txt");
        byte[] result = (byte[])Files.readBytes((File)asciiFile, (ByteProcessor)processor);
        FilesTest.assertEquals((Object)Bytes.asList((byte[])Files.toByteArray((File)asciiFile)), (Object)Bytes.asList((byte[])result));
    }

    public void testReadBytes_returnFalse() throws IOException {
        ByteProcessor<byte[]> processor = new ByteProcessor<byte[]>(){
            private final ByteArrayOutputStream out = new ByteArrayOutputStream();

            public boolean processBytes(byte[] buffer, int offset, int length) throws IOException {
                if (length > 0) {
                    this.out.write(buffer, offset, 1);
                    return false;
                }
                return true;
            }

            public byte[] getResult() {
                return this.out.toByteArray();
            }
        };
        File asciiFile = this.getTestFile("ascii.txt");
        byte[] result = (byte[])Files.readBytes((File)asciiFile, (ByteProcessor)processor);
        FilesTest.assertEquals((int)1, (int)result.length);
    }

    public void testPredicates() throws IOException {
        File asciiFile = this.getTestFile("ascii.txt");
        File dir = asciiFile.getParentFile();
        FilesTest.assertTrue((boolean)Files.isDirectory().apply((Object)dir));
        FilesTest.assertFalse((boolean)Files.isFile().apply((Object)dir));
        FilesTest.assertFalse((boolean)Files.isDirectory().apply((Object)asciiFile));
        FilesTest.assertTrue((boolean)Files.isFile().apply((Object)asciiFile));
    }

    private static File root() {
        return File.listRoots()[0];
    }

    private static File file(String first, String ... more) {
        return FilesTest.file(new File(first), more);
    }

    private static File file(File first, String ... more) {
        File file = first;
        for (String name : more) {
            file = new File(file, name);
        }
        return file;
    }

    private static class UnmovableFile
    extends File {
        private final boolean canRename;
        private final boolean canDelete;
        private static final long serialVersionUID = 0L;

        public UnmovableFile(File file, boolean canRename, boolean canDelete) {
            super(file.getPath());
            this.canRename = canRename;
            this.canDelete = canDelete;
        }

        @Override
        public boolean renameTo(File to) {
            return this.canRename && super.renameTo(to);
        }

        @Override
        public boolean delete() {
            return this.canDelete && super.delete();
        }
    }

    private static class BadLengthFile
    extends File {
        private final long badLength;
        private static final long serialVersionUID = 0L;

        public BadLengthFile(File delegate, long badLength) {
            super(delegate.getPath());
            this.badLength = badLength;
        }

        @Override
        public long length() {
            return this.badLength;
        }
    }
}

