/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;

public abstract class IoTestCase
extends TestCase {
    private static final Logger logger = Logger.getLogger(IoTestCase.class.getName());
    static final String I18N = "\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1";
    static final String ASCII = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";
    private File testDir;
    private File tempDir;
    private final Set<File> filesToDelete = Sets.newHashSet();

    protected void tearDown() {
        for (File file : this.filesToDelete) {
            if (!file.exists()) continue;
            this.delete(file);
        }
        this.filesToDelete.clear();
    }

    private File getTestDir() throws IOException {
        if (this.testDir != null) {
            return this.testDir;
        }
        URL testFileUrl = IoTestCase.class.getResource("testdata/i18n.txt");
        if (testFileUrl == null) {
            throw new RuntimeException("unable to locate testdata directory");
        }
        if (testFileUrl.getProtocol().equals("file")) {
            try {
                File testFile = new File(testFileUrl.toURI());
                this.testDir = testFile.getParentFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.testDir == null) {
            this.testDir = this.createTempDir();
        }
        return this.testDir;
    }

    protected final File getTestFile(String name) throws IOException {
        File file = new File(this.getTestDir(), name);
        if (!file.exists()) {
            URL resourceUrl = IoTestCase.class.getResource("testdata/" + name);
            if (resourceUrl == null) {
                return null;
            }
            IoTestCase.copy(resourceUrl, file);
        }
        return file;
    }

    protected final File createTempDir() throws IOException {
        File tempFile = File.createTempFile("IoTestCase", "");
        if (!tempFile.delete() || !tempFile.mkdir()) {
            throw new IOException("failed to create temp dir");
        }
        this.filesToDelete.add(tempFile);
        return tempFile;
    }

    protected final File getTempDir() throws IOException {
        if (this.tempDir == null) {
            this.tempDir = this.createTempDir();
        }
        return this.tempDir;
    }

    protected final File createTempFile() throws IOException {
        return File.createTempFile("test", null, this.getTempDir());
    }

    static byte[] newPreFilledByteArray(int size) {
        return IoTestCase.newPreFilledByteArray(0, size);
    }

    static byte[] newPreFilledByteArray(int offset, int size) {
        byte[] array = new byte[size];
        for (int i = 0; i < size; ++i) {
            array[i] = (byte)(offset + i);
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(URL url, File file) throws IOException {
        InputStream in = url.openStream();
        try {
            FileOutputStream out = new FileOutputStream(file);
            try {
                byte[] buf = new byte[4096];
                int read = in.read(buf);
                while (read != -1) {
                    ((OutputStream)out).write(buf, 0, read);
                    read = in.read(buf);
                }
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        finally {
            in.close();
        }
    }

    private boolean delete(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                if (this.delete(f)) continue;
                return false;
            }
        }
        if (!file.delete()) {
            logger.log(Level.WARNING, "couldn't delete file: {0}", new Object[]{file});
            return false;
        }
        return true;
    }
}

