/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.common.math.DoubleMath;
import com.google.common.math.MathBenchmarking;

public class DoubleMathBenchmark {
    private static final double[] positiveDoubles = new double[65536];
    private static final int[] factorials = new int[65536];
    private static final double[] doubles = new double[65536];

    @BeforeExperiment
    void setUp() {
        for (int i = 0; i < 65536; ++i) {
            DoubleMathBenchmark.positiveDoubles[i] = MathBenchmarking.randomPositiveDouble();
            DoubleMathBenchmark.doubles[i] = MathBenchmarking.randomDouble(64);
            DoubleMathBenchmark.factorials[i] = MathBenchmarking.RANDOM_SOURCE.nextInt(100);
        }
    }

    @Benchmark
    long log2(int reps) {
        long tmp = 0L;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += Double.doubleToRawLongBits(DoubleMath.log2((double)positiveDoubles[j]));
        }
        return tmp;
    }

    @Benchmark
    long factorial(int reps) {
        long tmp = 0L;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += Double.doubleToRawLongBits(DoubleMath.factorial((int)factorials[j]));
        }
        return tmp;
    }

    @Benchmark
    int isMathematicalInteger(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            if (!DoubleMath.isMathematicalInteger((double)doubles[j])) continue;
            ++tmp;
        }
        return tmp;
    }

    @Benchmark
    int isPowerOfTwo(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            if (!DoubleMath.isPowerOfTwo((double)doubles[j])) continue;
            ++tmp;
        }
        return tmp;
    }
}

