/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.math.DoubleMath;
import com.google.common.math.MathBenchmarking;
import java.math.RoundingMode;

public class DoubleMathRoundingBenchmark {
    private static final double[] doubleInIntRange = new double[65536];
    private static final double[] doubleInLongRange = new double[65536];
    private static final double[] positiveDoubles = new double[65536];
    @Param(value={"DOWN", "UP", "FLOOR", "CEILING", "HALF_EVEN", "HALF_UP", "HALF_DOWN"})
    RoundingMode mode;

    @BeforeExperiment
    void setUp() {
        for (int i = 0; i < 65536; ++i) {
            DoubleMathRoundingBenchmark.doubleInIntRange[i] = MathBenchmarking.randomDouble(30);
            DoubleMathRoundingBenchmark.doubleInLongRange[i] = MathBenchmarking.randomDouble(62);
            DoubleMathRoundingBenchmark.positiveDoubles[i] = MathBenchmarking.randomPositiveDouble();
        }
    }

    @Benchmark
    int roundToInt(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += DoubleMath.roundToInt((double)doubleInIntRange[j], (RoundingMode)this.mode);
        }
        return tmp;
    }

    @Benchmark
    long roundToLong(int reps) {
        long tmp = 0L;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += DoubleMath.roundToLong((double)doubleInLongRange[j], (RoundingMode)this.mode);
        }
        return tmp;
    }

    @Benchmark
    int roundToBigInteger(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += DoubleMath.roundToBigInteger((double)positiveDoubles[j], (RoundingMode)this.mode).intValue();
        }
        return tmp;
    }

    @Benchmark
    int log2Round(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += DoubleMath.log2((double)positiveDoubles[j], (RoundingMode)this.mode);
        }
        return tmp;
    }
}

