/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.collect.ImmutableMap;
import com.google.common.math.LongMath;
import com.google.common.math.Quantiles;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

enum QuantilesAlgorithm {
    SORTING{

        @Override
        double singleQuantile(int index, int scale, double[] dataset) {
            Arrays.sort(dataset);
            return this.singleQuantileFromSorted(index, scale, dataset);
        }

        @Override
        Map<Integer, Double> multipleQuantiles(Collection<Integer> indexes, int scale, double[] dataset) {
            Arrays.sort(dataset);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int index : indexes) {
                builder.put((Object)index, (Object)this.singleQuantileFromSorted(index, scale, dataset));
            }
            return builder.build();
        }

        private double singleQuantileFromSorted(int index, int scale, double[] dataset) {
            long numerator = (long)index * (long)(dataset.length - 1);
            int positionFloor = (int)LongMath.divide((long)numerator, (long)scale, (RoundingMode)RoundingMode.DOWN);
            int remainder = (int)(numerator - (long)(positionFloor * scale));
            if (remainder == 0) {
                return dataset[positionFloor];
            }
            double positionFrac = (double)remainder / (double)scale;
            return dataset[positionFloor] + positionFrac * (dataset[positionFloor + 1] - dataset[positionFloor]);
        }
    }
    ,
    QUICKSELECT{

        @Override
        double singleQuantile(int index, int scale, double[] dataset) {
            long numerator = (long)index * (long)(dataset.length - 1);
            int positionFloor = (int)LongMath.divide((long)numerator, (long)scale, (RoundingMode)RoundingMode.DOWN);
            int remainder = (int)(numerator - (long)(positionFloor * scale));
            double percentileFloor = 2.select(positionFloor, dataset);
            if (remainder == 0) {
                return percentileFloor;
            }
            double percentileCeiling = 2.getMinValue(dataset, positionFloor + 1);
            double positionFrac = (double)remainder / (double)scale;
            return percentileFloor + positionFrac * (percentileCeiling - percentileFloor);
        }

        @Override
        Map<Integer, Double> multipleQuantiles(Collection<Integer> indexes, int scale, double[] dataset) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int index : indexes) {
                builder.put((Object)index, (Object)this.singleQuantile(index, scale, dataset));
            }
            return builder.build();
        }
    }
    ,
    TARGET{

        @Override
        double singleQuantile(int index, int scale, double[] dataset) {
            return Quantiles.scale((int)scale).index(index).computeInPlace(dataset);
        }

        @Override
        Map<Integer, Double> multipleQuantiles(Collection<Integer> indexes, int scale, double[] dataset) {
            return Quantiles.scale((int)scale).indexes(indexes).computeInPlace(dataset);
        }
    };


    abstract double singleQuantile(int var1, int var2, double[] var3);

    abstract Map<Integer, Double> multipleQuantiles(Collection<Integer> var1, int var2, double[] var3);

    static double getMinValue(double[] array, int from) {
        int min = from;
        for (int i = from + 1; i < array.length; ++i) {
            if (!(array[min] > array[i])) continue;
            min = i;
        }
        return array[min];
    }

    static double select(int k, double[] array) {
        int from = 0;
        int to = array.length - 1;
        while (true) {
            if (to <= from + 1) {
                if (to == from + 1 && array[to] < array[from]) {
                    QuantilesAlgorithm.swap(array, from, to);
                }
                return array[k];
            }
            int midIndex = from + to >>> 1;
            QuantilesAlgorithm.swap(array, midIndex, from + 1);
            if (array[from] > array[to]) {
                QuantilesAlgorithm.swap(array, from, to);
            }
            if (array[from + 1] > array[to]) {
                QuantilesAlgorithm.swap(array, from + 1, to);
            }
            if (array[from] > array[from + 1]) {
                QuantilesAlgorithm.swap(array, from, from + 1);
            }
            int low = from + 1;
            int high = to;
            double partition = array[from + 1];
            while (true) {
                if (array[++low] < partition) {
                    continue;
                }
                while (array[--high] > partition) {
                }
                if (high < low) break;
                QuantilesAlgorithm.swap(array, low, high);
            }
            array[from + 1] = array[high];
            array[high] = partition;
            if (high >= k) {
                to = high - 1;
            }
            if (high > k) continue;
            from = low;
        }
    }

    private static void swap(double[] array, int i, int j) {
        double temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }
}

