/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.primitives.Chars;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class CharsTest
extends TestCase {
    private static final char[] EMPTY = new char[0];
    private static final char[] ARRAY1 = new char[]{'\u0001'};
    private static final char[] ARRAY234 = new char[]{'\u0002', '\u0003', '\u0004'};
    private static final char LEAST = '\u0000';
    private static final char GREATEST = '\uffff';
    private static final char[] VALUES = new char[]{'\u0000', 'a', '\u00e0', '\udcaa', '\uffff'};

    public void testHashCode() {
        for (char value : VALUES) {
            CharsTest.assertEquals((int)Character.valueOf(value).hashCode(), (int)Chars.hashCode((char)value));
        }
    }

    public void testCheckedCast() {
        for (char value : VALUES) {
            CharsTest.assertEquals((char)value, (char)Chars.checkedCast((long)value));
        }
        this.assertCastFails(65536L);
        this.assertCastFails(-1L);
        this.assertCastFails(Long.MAX_VALUE);
        this.assertCastFails(Long.MIN_VALUE);
    }

    public void testSaturatedCast() {
        for (char value : VALUES) {
            CharsTest.assertEquals((char)value, (char)Chars.saturatedCast((long)value));
        }
        CharsTest.assertEquals((char)'\uffff', (char)Chars.saturatedCast((long)65536L));
        CharsTest.assertEquals((char)'\u0000', (char)Chars.saturatedCast((long)-1L));
        CharsTest.assertEquals((char)'\uffff', (char)Chars.saturatedCast((long)Long.MAX_VALUE));
        CharsTest.assertEquals((char)'\u0000', (char)Chars.saturatedCast((long)Long.MIN_VALUE));
    }

    private void assertCastFails(long value) {
        try {
            Chars.checkedCast((long)value);
            CharsTest.fail((String)("Cast to char should have failed: " + value));
        }
        catch (IllegalArgumentException ex) {
            CharsTest.assertTrue((String)(value + " not found in exception text: " + ex.getMessage()), (boolean)ex.getMessage().contains(String.valueOf(value)));
        }
    }

    public void testCompare() {
        for (char x : VALUES) {
            for (char y : VALUES) {
                CharsTest.assertEquals((String)(x + ", " + y), (int)Character.valueOf(x).compareTo(Character.valueOf(y)), (int)Chars.compare((char)x, (char)y));
            }
        }
    }

    public void testContains() {
        CharsTest.assertFalse((boolean)Chars.contains((char[])EMPTY, (char)'\u0001'));
        CharsTest.assertFalse((boolean)Chars.contains((char[])ARRAY1, (char)'\u0002'));
        CharsTest.assertFalse((boolean)Chars.contains((char[])ARRAY234, (char)'\u0001'));
        CharsTest.assertTrue((boolean)Chars.contains((char[])new char[]{'\uffff'}, (char)'\uffff'));
        CharsTest.assertTrue((boolean)Chars.contains((char[])ARRAY234, (char)'\u0002'));
        CharsTest.assertTrue((boolean)Chars.contains((char[])ARRAY234, (char)'\u0003'));
        CharsTest.assertTrue((boolean)Chars.contains((char[])ARRAY234, (char)'\u0004'));
    }

    public void testIndexOf() {
        CharsTest.assertEquals((int)-1, (int)Chars.indexOf((char[])EMPTY, (char)'\u0001'));
        CharsTest.assertEquals((int)-1, (int)Chars.indexOf((char[])ARRAY1, (char)'\u0002'));
        CharsTest.assertEquals((int)-1, (int)Chars.indexOf((char[])ARRAY234, (char)'\u0001'));
        CharsTest.assertEquals((int)0, (int)Chars.indexOf((char[])new char[]{'\uffff'}, (char)'\uffff'));
        CharsTest.assertEquals((int)0, (int)Chars.indexOf((char[])ARRAY234, (char)'\u0002'));
        CharsTest.assertEquals((int)1, (int)Chars.indexOf((char[])ARRAY234, (char)'\u0003'));
        CharsTest.assertEquals((int)2, (int)Chars.indexOf((char[])ARRAY234, (char)'\u0004'));
        CharsTest.assertEquals((int)1, (int)Chars.indexOf((char[])new char[]{'\u0002', '\u0003', '\u0002', '\u0003'}, (char)'\u0003'));
    }

    public void testIndexOf_arrayTarget() {
        CharsTest.assertEquals((int)0, (int)Chars.indexOf((char[])EMPTY, (char[])EMPTY));
        CharsTest.assertEquals((int)0, (int)Chars.indexOf((char[])ARRAY234, (char[])EMPTY));
        CharsTest.assertEquals((int)-1, (int)Chars.indexOf((char[])EMPTY, (char[])ARRAY234));
        CharsTest.assertEquals((int)-1, (int)Chars.indexOf((char[])ARRAY234, (char[])ARRAY1));
        CharsTest.assertEquals((int)-1, (int)Chars.indexOf((char[])ARRAY1, (char[])ARRAY234));
        CharsTest.assertEquals((int)0, (int)Chars.indexOf((char[])ARRAY1, (char[])ARRAY1));
        CharsTest.assertEquals((int)0, (int)Chars.indexOf((char[])ARRAY234, (char[])ARRAY234));
        CharsTest.assertEquals((int)0, (int)Chars.indexOf((char[])ARRAY234, (char[])new char[]{'\u0002', '\u0003'}));
        CharsTest.assertEquals((int)1, (int)Chars.indexOf((char[])ARRAY234, (char[])new char[]{'\u0003', '\u0004'}));
        CharsTest.assertEquals((int)1, (int)Chars.indexOf((char[])ARRAY234, (char[])new char[]{'\u0003'}));
        CharsTest.assertEquals((int)2, (int)Chars.indexOf((char[])ARRAY234, (char[])new char[]{'\u0004'}));
        CharsTest.assertEquals((int)1, (int)Chars.indexOf((char[])new char[]{'\u0002', '\u0003', '\u0003', '\u0003', '\u0003'}, (char[])new char[]{'\u0003'}));
        CharsTest.assertEquals((int)2, (int)Chars.indexOf((char[])new char[]{'\u0002', '\u0003', '\u0002', '\u0003', '\u0004', '\u0002', '\u0003'}, (char[])new char[]{'\u0002', '\u0003', '\u0004'}));
        CharsTest.assertEquals((int)1, (int)Chars.indexOf((char[])new char[]{'\u0002', '\u0002', '\u0003', '\u0004', '\u0002', '\u0003', '\u0004'}, (char[])new char[]{'\u0002', '\u0003', '\u0004'}));
        CharsTest.assertEquals((int)-1, (int)Chars.indexOf((char[])new char[]{'\u0004', '\u0003', '\u0002'}, (char[])new char[]{'\u0002', '\u0003', '\u0004'}));
    }

    public void testLastIndexOf() {
        CharsTest.assertEquals((int)-1, (int)Chars.lastIndexOf((char[])EMPTY, (char)'\u0001'));
        CharsTest.assertEquals((int)-1, (int)Chars.lastIndexOf((char[])ARRAY1, (char)'\u0002'));
        CharsTest.assertEquals((int)-1, (int)Chars.lastIndexOf((char[])ARRAY234, (char)'\u0001'));
        CharsTest.assertEquals((int)0, (int)Chars.lastIndexOf((char[])new char[]{'\uffff'}, (char)'\uffff'));
        CharsTest.assertEquals((int)0, (int)Chars.lastIndexOf((char[])ARRAY234, (char)'\u0002'));
        CharsTest.assertEquals((int)1, (int)Chars.lastIndexOf((char[])ARRAY234, (char)'\u0003'));
        CharsTest.assertEquals((int)2, (int)Chars.lastIndexOf((char[])ARRAY234, (char)'\u0004'));
        CharsTest.assertEquals((int)3, (int)Chars.lastIndexOf((char[])new char[]{'\u0002', '\u0003', '\u0002', '\u0003'}, (char)'\u0003'));
    }

    public void testMax_noArgs() {
        try {
            Chars.max((char[])new char[0]);
            CharsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMax() {
        CharsTest.assertEquals((char)'\u0000', (char)Chars.max((char[])new char[]{'\u0000'}));
        CharsTest.assertEquals((char)'\uffff', (char)Chars.max((char[])new char[]{'\uffff'}));
        CharsTest.assertEquals((char)'\t', (char)Chars.max((char[])new char[]{'\b', '\u0006', '\u0007', '\u0005', '\u0003', '\u0000', '\t'}));
    }

    public void testMin_noArgs() {
        try {
            Chars.min((char[])new char[0]);
            CharsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMin() {
        CharsTest.assertEquals((char)'\u0000', (char)Chars.min((char[])new char[]{'\u0000'}));
        CharsTest.assertEquals((char)'\uffff', (char)Chars.min((char[])new char[]{'\uffff'}));
        CharsTest.assertEquals((char)'\u0000', (char)Chars.min((char[])new char[]{'\b', '\u0006', '\u0007', '\u0005', '\u0003', '\u0000', '\t'}));
    }

    public void testConcat() {
        CharsTest.assertTrue((boolean)Arrays.equals(EMPTY, Chars.concat((char[][])new char[0][])));
        CharsTest.assertTrue((boolean)Arrays.equals(EMPTY, Chars.concat((char[][])new char[][]{EMPTY})));
        CharsTest.assertTrue((boolean)Arrays.equals(EMPTY, Chars.concat((char[][])new char[][]{EMPTY, EMPTY, EMPTY})));
        CharsTest.assertTrue((boolean)Arrays.equals(ARRAY1, Chars.concat((char[][])new char[][]{ARRAY1})));
        CharsTest.assertNotSame((Object)ARRAY1, (Object)Chars.concat((char[][])new char[][]{ARRAY1}));
        CharsTest.assertTrue((boolean)Arrays.equals(ARRAY1, Chars.concat((char[][])new char[][]{EMPTY, ARRAY1, EMPTY})));
        CharsTest.assertTrue((boolean)Arrays.equals(new char[]{'\u0001', '\u0001', '\u0001'}, Chars.concat((char[][])new char[][]{ARRAY1, ARRAY1, ARRAY1})));
        CharsTest.assertTrue((boolean)Arrays.equals(new char[]{'\u0001', '\u0002', '\u0003', '\u0004'}, Chars.concat((char[][])new char[][]{ARRAY1, ARRAY234})));
    }

    @GwtIncompatible
    public void testFromByteArray() {
        CharsTest.assertEquals((char)'\u2345', (char)Chars.fromByteArray((byte[])new byte[]{35, 69, -36}));
        CharsTest.assertEquals((char)'\ufedc', (char)Chars.fromByteArray((byte[])new byte[]{-2, -36}));
    }

    @GwtIncompatible
    public void testFromByteArrayFails() {
        try {
            Chars.fromByteArray((byte[])new byte[1]);
            CharsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testFromBytes() {
        CharsTest.assertEquals((char)'\u2345', (char)Chars.fromBytes((byte)35, (byte)69));
        CharsTest.assertEquals((char)'\ufedc', (char)Chars.fromBytes((byte)-2, (byte)-36));
    }

    @GwtIncompatible
    public void testByteArrayRoundTrips() {
        char c = '\u0000';
        for (int hi = 0; hi < 256; ++hi) {
            for (int lo = 0; lo < 256; ++lo) {
                char result = Chars.fromByteArray((byte[])new byte[]{(byte)hi, (byte)lo});
                CharsTest.assertEquals((String)String.format(Locale.ROOT, "hi=%s, lo=%s, expected=%s, result=%s", hi, lo, (int)c, (int)result), (char)c, (char)result);
                byte[] bytes = Chars.toByteArray((char)c);
                CharsTest.assertEquals((byte)((byte)hi), (byte)bytes[0]);
                CharsTest.assertEquals((byte)((byte)lo), (byte)bytes[1]);
                c = (char)(c + '\u0001');
            }
        }
        CharsTest.assertEquals((char)'\u0000', (char)c);
    }

    @GwtIncompatible
    public void testByteArrayRoundTripsFails() {
        try {
            Chars.fromByteArray((byte[])new byte[]{17});
            CharsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEnsureCapacity() {
        CharsTest.assertSame((Object)EMPTY, (Object)Chars.ensureCapacity((char[])EMPTY, (int)0, (int)1));
        CharsTest.assertSame((Object)ARRAY1, (Object)Chars.ensureCapacity((char[])ARRAY1, (int)0, (int)1));
        CharsTest.assertSame((Object)ARRAY1, (Object)Chars.ensureCapacity((char[])ARRAY1, (int)1, (int)1));
        CharsTest.assertTrue((boolean)Arrays.equals(new char[]{'\u0001', '\u0000', '\u0000'}, Chars.ensureCapacity((char[])ARRAY1, (int)2, (int)1)));
    }

    public void testEnsureCapacity_fail() {
        try {
            Chars.ensureCapacity((char[])ARRAY1, (int)-1, (int)1);
            CharsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Chars.ensureCapacity((char[])ARRAY1, (int)1, (int)-1);
            CharsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testJoin() {
        CharsTest.assertEquals((String)"", (String)Chars.join((String)",", (char[])EMPTY));
        CharsTest.assertEquals((String)"1", (String)Chars.join((String)",", (char[])new char[]{'1'}));
        CharsTest.assertEquals((String)"1,2", (String)Chars.join((String)",", (char[])new char[]{'1', '2'}));
        CharsTest.assertEquals((String)"123", (String)Chars.join((String)"", (char[])new char[]{'1', '2', '3'}));
    }

    public void testLexicographicalComparator() {
        List ordered = Arrays.asList(new char[0], {'\u0000'}, {'\u0000', '\u0000'}, {'\u0000', '\u0001'}, {'\u0001'}, {'\u0001', '\u0000'}, {'\uffff', '\ufffe'}, {'\uffff', '\uffff'}, {'\uffff', '\uffff', '\uffff'});
        Comparator comparator = Chars.lexicographicalComparator();
        Helpers.testComparator((Comparator)comparator, ordered);
    }

    @GwtIncompatible
    public void testLexicographicalComparatorSerializable() {
        Comparator comparator = Chars.lexicographicalComparator();
        CharsTest.assertSame((Object)comparator, (Object)SerializableTester.reserialize((Object)comparator));
    }

    public void testToArray() {
        List<Character> none = Arrays.asList(new Character[0]);
        CharsTest.assertTrue((boolean)Arrays.equals(EMPTY, Chars.toArray(none)));
        List<Character> one = Arrays.asList(Character.valueOf('\u0001'));
        CharsTest.assertTrue((boolean)Arrays.equals(ARRAY1, Chars.toArray(one)));
        char[] array = new char[]{'\u0000', '\u0001', 'A'};
        List<Character> three = Arrays.asList(Character.valueOf('\u0000'), Character.valueOf('\u0001'), Character.valueOf('A'));
        CharsTest.assertTrue((boolean)Arrays.equals(array, Chars.toArray(three)));
        CharsTest.assertTrue((boolean)Arrays.equals(array, Chars.toArray((Collection)Chars.asList((char[])array))));
    }

    public void testToArray_threadSafe() {
        for (int delta : new int[]{1, 0, -1}) {
            for (int i = 0; i < VALUES.length; ++i) {
                List list = Chars.asList((char[])VALUES).subList(0, i);
                Collection misleadingSize = Helpers.misleadingSizeCollection((int)delta);
                misleadingSize.addAll(list);
                char[] arr = Chars.toArray((Collection)misleadingSize);
                CharsTest.assertEquals((int)i, (int)arr.length);
                for (int j = 0; j < i; ++j) {
                    CharsTest.assertEquals((char)VALUES[j], (char)arr[j]);
                }
            }
        }
    }

    public void testToArray_withNull() {
        List<Character> list = Arrays.asList(Character.valueOf('\u0000'), Character.valueOf('\u0001'), null);
        try {
            Chars.toArray(list);
            CharsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAsList_isAView() {
        char[] array = new char[]{'\u0000', '\u0001'};
        List list = Chars.asList((char[])array);
        list.set(0, Character.valueOf('\u0002'));
        CharsTest.assertTrue((boolean)Arrays.equals(new char[]{'\u0002', '\u0001'}, array));
        array[1] = 3;
        CharsTest.assertEquals(Arrays.asList(Character.valueOf('\u0002'), Character.valueOf('\u0003')), (Object)list);
    }

    public void testAsList_toArray_roundTrip() {
        char[] array = new char[]{'\u0000', '\u0001', '\u0002'};
        List list = Chars.asList((char[])array);
        char[] newArray = Chars.toArray((Collection)list);
        list.set(0, Character.valueOf('\u0004'));
        CharsTest.assertTrue((boolean)Arrays.equals(new char[]{'\u0000', '\u0001', '\u0002'}, newArray));
        newArray[1] = 5;
        CharsTest.assertEquals((char)'\u0001', (char)((Character)list.get(1)).charValue());
    }

    public void testAsList_subList_toArray_roundTrip() {
        char[] array = new char[]{'\u0000', '\u0001', '\u0002', '\u0003'};
        List list = Chars.asList((char[])array);
        CharsTest.assertTrue((boolean)Arrays.equals(new char[]{'\u0001', '\u0002'}, Chars.toArray(list.subList(1, 3))));
        CharsTest.assertTrue((boolean)Arrays.equals(new char[0], Chars.toArray(list.subList(2, 2))));
    }

    public void testAsListEmpty() {
        CharsTest.assertSame(Collections.emptyList(), (Object)Chars.asList((char[])EMPTY));
    }

    @GwtIncompatible
    public void testNulls() {
        new NullPointerTester().testAllPublicStaticMethods(Chars.class);
    }
}

