/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import com.google.common.testing.NullPointerTester;
import java.util.Set;
import junit.framework.TestCase;

public class PrimitivesTest
extends TestCase {
    public void testIsWrapperType() {
        PrimitivesTest.assertTrue((boolean)Primitives.isWrapperType(Void.class));
        PrimitivesTest.assertFalse((boolean)Primitives.isWrapperType(Void.TYPE));
    }

    public void testWrap() {
        PrimitivesTest.assertSame(Integer.class, (Object)Primitives.wrap(Integer.TYPE));
        PrimitivesTest.assertSame(Integer.class, (Object)Primitives.wrap(Integer.class));
        PrimitivesTest.assertSame(String.class, (Object)Primitives.wrap(String.class));
    }

    public void testUnwrap() {
        PrimitivesTest.assertSame(Integer.TYPE, (Object)Primitives.unwrap(Integer.class));
        PrimitivesTest.assertSame(Integer.TYPE, (Object)Primitives.unwrap(Integer.TYPE));
        PrimitivesTest.assertSame(String.class, (Object)Primitives.unwrap(String.class));
    }

    public void testAllPrimitiveTypes() {
        Set primitives = Primitives.allPrimitiveTypes();
        PrimitivesTest.assertEquals((Object)ImmutableSet.of(Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, (Object[])new Object[]{Long.TYPE, Short.TYPE, Void.TYPE}), (Object)primitives);
        try {
            primitives.remove(Boolean.TYPE);
            PrimitivesTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testAllWrapperTypes() {
        Set wrappers = Primitives.allWrapperTypes();
        PrimitivesTest.assertEquals((Object)ImmutableSet.of(Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, (Object[])new Object[]{Long.class, Short.class, Void.class}), (Object)wrappers);
        try {
            wrappers.remove(Boolean.class);
            PrimitivesTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testNullPointerExceptions() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(Primitives.class);
    }
}

