/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.primitives.Longs;
import com.google.common.primitives.UnsignedInts;
import com.google.common.testing.NullPointerTester;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class UnsignedIntsTest
extends TestCase {
    private static final long[] UNSIGNED_INTS = new long[]{0L, 1L, 2L, 3L, 305419896L, 1514346168L, 1828162123L, 4279918987L, 0xFFFFFFFDL, 0xFFFFFFFEL, 0xFFFFFFFFL};
    private static final int LEAST = 0;
    private static final int GREATEST = -1;

    public void testToLong() {
        for (long a : UNSIGNED_INTS) {
            UnsignedIntsTest.assertEquals((long)a, (long)UnsignedInts.toLong((int)((int)a)));
        }
    }

    public void testCompare() {
        for (long a : UNSIGNED_INTS) {
            for (long b : UNSIGNED_INTS) {
                int cmpAsLongs = Longs.compare((long)a, (long)b);
                int cmpAsUInt = UnsignedInts.compare((int)((int)a), (int)((int)b));
                UnsignedIntsTest.assertEquals((int)Integer.signum(cmpAsLongs), (int)Integer.signum(cmpAsUInt));
            }
        }
    }

    public void testMax_noArgs() {
        try {
            UnsignedInts.max((int[])new int[0]);
            UnsignedIntsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMax() {
        UnsignedIntsTest.assertEquals((int)0, (int)UnsignedInts.max((int[])new int[]{0}));
        UnsignedIntsTest.assertEquals((int)-1, (int)UnsignedInts.max((int[])new int[]{-1}));
        UnsignedIntsTest.assertEquals((int)-15048309, (int)UnsignedInts.max((int[])new int[]{8, 6, 7, 305419896, 1514346168, -15048309, 0}));
    }

    public void testMin_noArgs() {
        try {
            UnsignedInts.min((int[])new int[0]);
            UnsignedIntsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMin() {
        UnsignedIntsTest.assertEquals((int)0, (int)UnsignedInts.min((int[])new int[]{0}));
        UnsignedIntsTest.assertEquals((int)-1, (int)UnsignedInts.min((int[])new int[]{-1}));
        UnsignedIntsTest.assertEquals((int)0, (int)UnsignedInts.min((int[])new int[]{8, 6, 7, 305419896, 1514346168, -15048309, 0}));
    }

    public void testLexicographicalComparator() {
        List ordered = Arrays.asList(new int[0], {0}, {0, 0}, {0, 1}, {1}, {1, 0}, {-1, -2}, {-1, -1}, {-1, -1, -1});
        Comparator comparator = UnsignedInts.lexicographicalComparator();
        Helpers.testComparator((Comparator)comparator, ordered);
    }

    public void testDivide() {
        for (long a : UNSIGNED_INTS) {
            for (long b : UNSIGNED_INTS) {
                try {
                    UnsignedIntsTest.assertEquals((int)((int)(a / b)), (int)UnsignedInts.divide((int)((int)a), (int)((int)b)));
                    UnsignedIntsTest.assertFalse((b == 0L ? 1 : 0) != 0);
                }
                catch (ArithmeticException e) {
                    UnsignedIntsTest.assertEquals((long)0L, (long)b);
                }
            }
        }
    }

    public void testRemainder() {
        for (long a : UNSIGNED_INTS) {
            for (long b : UNSIGNED_INTS) {
                try {
                    UnsignedIntsTest.assertEquals((int)((int)(a % b)), (int)UnsignedInts.remainder((int)((int)a), (int)((int)b)));
                    UnsignedIntsTest.assertFalse((b == 0L ? 1 : 0) != 0);
                }
                catch (ArithmeticException e) {
                    UnsignedIntsTest.assertEquals((long)0L, (long)b);
                }
            }
        }
    }

    @GwtIncompatible
    public void testDivideRemainderEuclideanProperty() {
        Random r = new Random(0L);
        for (int i = 0; i < 1000000; ++i) {
            int divisor;
            int dividend = r.nextInt();
            UnsignedIntsTest.assertTrue((dividend - ((divisor = r.nextInt()) * UnsignedInts.divide((int)dividend, (int)divisor) + UnsignedInts.remainder((int)dividend, (int)divisor)) == 0 ? 1 : 0) != 0);
        }
    }

    public void testParseInt() {
        for (long a : UNSIGNED_INTS) {
            UnsignedIntsTest.assertEquals((int)((int)a), (int)UnsignedInts.parseUnsignedInt((String)Long.toString(a)));
        }
    }

    public void testParseIntFail() {
        try {
            UnsignedInts.parseUnsignedInt((String)Long.toString(0x100000000L));
            UnsignedIntsTest.fail((String)"Expected NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testParseIntWithRadix() {
        for (long a : UNSIGNED_INTS) {
            for (int radix = 2; radix <= 36; ++radix) {
                UnsignedIntsTest.assertEquals((int)((int)a), (int)UnsignedInts.parseUnsignedInt((String)Long.toString(a, radix), (int)radix));
            }
        }
    }

    public void testParseIntWithRadixLimits() {
        for (int radix = 2; radix <= 36; ++radix) {
            String maxAsString = Long.toString(0xFFFFFFFFL, radix);
            UnsignedIntsTest.assertEquals((int)-1, (int)UnsignedInts.parseUnsignedInt((String)maxAsString, (int)radix));
            try {
                long overflow = 0x100000000L;
                String overflowAsString = Long.toString(overflow, radix);
                UnsignedInts.parseUnsignedInt((String)overflowAsString, (int)radix);
                UnsignedIntsTest.fail();
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void testParseIntThrowsExceptionForInvalidRadix() {
        try {
            UnsignedInts.parseUnsignedInt((String)"0", (int)1);
            UnsignedIntsTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            UnsignedInts.parseUnsignedInt((String)"0", (int)37);
            UnsignedIntsTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            UnsignedInts.parseUnsignedInt((String)"0", (int)-1);
            UnsignedIntsTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testDecodeInt() {
        UnsignedIntsTest.assertEquals((int)-1, (int)UnsignedInts.decode((String)"0xffffffff"));
        UnsignedIntsTest.assertEquals((int)342391, (int)UnsignedInts.decode((String)"01234567"));
        UnsignedIntsTest.assertEquals((int)305419896, (int)UnsignedInts.decode((String)"#12345678"));
        UnsignedIntsTest.assertEquals((int)76543210, (int)UnsignedInts.decode((String)"76543210"));
        UnsignedIntsTest.assertEquals((int)324505909, (int)UnsignedInts.decode((String)"0x13579135"));
        UnsignedIntsTest.assertEquals((int)324505909, (int)UnsignedInts.decode((String)"0X13579135"));
        UnsignedIntsTest.assertEquals((int)0, (int)UnsignedInts.decode((String)"0"));
    }

    public void testDecodeIntFails() {
        try {
            UnsignedInts.decode((String)"0xfffffffff");
            UnsignedIntsTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            UnsignedInts.decode((String)"-5");
            UnsignedIntsTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            UnsignedInts.decode((String)"-0x5");
            UnsignedIntsTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            UnsignedInts.decode((String)"-05");
            UnsignedIntsTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testToString() {
        int[] bases = new int[]{2, 5, 7, 8, 10, 16};
        for (long a : UNSIGNED_INTS) {
            for (int base : bases) {
                UnsignedIntsTest.assertEquals((String)UnsignedInts.toString((int)((int)a), (int)base), (String)Long.toString(a, base));
            }
        }
    }

    public void testJoin() {
        UnsignedIntsTest.assertEquals((String)"", (String)UnsignedIntsTest.join(new int[0]));
        UnsignedIntsTest.assertEquals((String)"1", (String)UnsignedIntsTest.join(1));
        UnsignedIntsTest.assertEquals((String)"1,2", (String)UnsignedIntsTest.join(1, 2));
        UnsignedIntsTest.assertEquals((String)"4294967295,2147483648", (String)UnsignedIntsTest.join(-1, Integer.MIN_VALUE));
        UnsignedIntsTest.assertEquals((String)"123", (String)UnsignedInts.join((String)"", (int[])new int[]{1, 2, 3}));
    }

    private static String join(int ... values) {
        return UnsignedInts.join((String)",", (int[])values);
    }

    @GwtIncompatible
    public void testNulls() {
        new NullPointerTester().testAllPublicStaticMethods(UnsignedInts.class);
    }
}

