/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.common.primitives.UnsignedLongs;
import java.util.Random;

public class UnsignedLongsBenchmark {
    private static final int ARRAY_SIZE = 65536;
    private static final int ARRAY_MASK = 65535;
    private static final Random RANDOM_SOURCE = new Random(314159265358979L);
    private static final long[] longs = new long[65536];
    private static final long[] divisors = new long[65536];
    private static final String[] decimalStrings = new String[65536];
    private static final String[] binaryStrings = new String[65536];
    private static final String[] hexStrings = new String[65536];
    private static final String[] prefixedHexStrings = new String[65536];

    @BeforeExperiment
    void setUp() {
        for (int i = 0; i < 65536; ++i) {
            UnsignedLongsBenchmark.longs[i] = UnsignedLongsBenchmark.random();
            UnsignedLongsBenchmark.divisors[i] = UnsignedLongsBenchmark.randomDivisor(longs[i]);
            UnsignedLongsBenchmark.decimalStrings[i] = UnsignedLongs.toString((long)longs[i]);
            UnsignedLongsBenchmark.binaryStrings[i] = UnsignedLongs.toString((long)longs[i], (int)2);
            UnsignedLongsBenchmark.hexStrings[i] = UnsignedLongs.toString((long)longs[i], (int)16);
            UnsignedLongsBenchmark.prefixedHexStrings[i] = "0x" + hexStrings[i];
        }
    }

    @Benchmark
    long divide(int reps) {
        long tmp = 0L;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += UnsignedLongs.divide((long)longs[j], (long)divisors[j]);
        }
        return tmp;
    }

    @Benchmark
    long remainder(int reps) {
        long tmp = 0L;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += UnsignedLongs.remainder((long)longs[j], (long)divisors[j]);
        }
        return tmp;
    }

    @Benchmark
    long parseUnsignedLong(int reps) {
        long tmp = 0L;
        int scaledReps = reps / 3 + 1;
        for (int i = 0; i < scaledReps; ++i) {
            int j = i & 0xFFFF;
            tmp += UnsignedLongs.parseUnsignedLong((String)decimalStrings[j]);
            tmp += UnsignedLongs.parseUnsignedLong((String)hexStrings[j], (int)16);
            tmp += UnsignedLongs.parseUnsignedLong((String)binaryStrings[j], (int)2);
        }
        return tmp;
    }

    @Benchmark
    long parseDecode10(int reps) {
        long tmp = 0L;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += UnsignedLongs.decode((String)decimalStrings[j]);
        }
        return tmp;
    }

    @Benchmark
    long parseDecode16(int reps) {
        long tmp = 0L;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += UnsignedLongs.decode((String)prefixedHexStrings[j]);
        }
        return tmp;
    }

    @Benchmark
    int toString(int reps) {
        int tmp = 0;
        int scaledReps = reps / 3 + 1;
        for (int i = 0; i < scaledReps; ++i) {
            int j = i & 0xFFFF;
            long x = longs[j];
            tmp += UnsignedLongs.toString((long)x).length();
            tmp += UnsignedLongs.toString((long)x, (int)16).length();
            tmp += UnsignedLongs.toString((long)x, (int)2).length();
        }
        return tmp;
    }

    private static long random() {
        return RANDOM_SOURCE.nextLong();
    }

    private static long randomDivisor(long dividend) {
        long r = RANDOM_SOURCE.nextLong();
        if (dividend == -1L) {
            return r;
        }
        return UnsignedLongs.remainder((long)r, (long)(dividend + 1L));
    }
}

