/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.primitives.UnsignedLongs;
import com.google.common.testing.NullPointerTester;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class UnsignedLongsTest
extends TestCase {
    private static final long LEAST = 0L;
    private static final long GREATEST = -1L;

    public void testCompare() {
        UnsignedLongsTest.assertTrue((UnsignedLongs.compare((long)0L, (long)-1L) < 0 ? 1 : 0) != 0);
        UnsignedLongsTest.assertTrue((UnsignedLongs.compare((long)-1L, (long)0L) > 0 ? 1 : 0) != 0);
        UnsignedLongsTest.assertTrue((UnsignedLongs.compare((long)-64631992877716974L, (long)-1L) < 0 ? 1 : 0) != 0);
        UnsignedLongsTest.assertTrue((UnsignedLongs.compare((long)-1L, (long)-64631992877716974L) > 0 ? 1 : 0) != 0);
        UnsignedLongsTest.assertTrue((UnsignedLongs.compare((long)6504067269626408013L, (long)-64631992877716974L) < 0 ? 1 : 0) != 0);
        UnsignedLongsTest.assertTrue((UnsignedLongs.compare((long)-64631992877716974L, (long)6504067269626408013L) > 0 ? 1 : 0) != 0);
        UnsignedLongsTest.assertTrue((UnsignedLongs.compare((long)6504067269626408013L, (long)7851896530399809066L) < 0 ? 1 : 0) != 0);
        UnsignedLongsTest.assertTrue((UnsignedLongs.compare((long)7851896530399809066L, (long)6504067269626408013L) > 0 ? 1 : 0) != 0);
        UnsignedLongsTest.assertTrue((UnsignedLongs.compare((long)-64631992877716974L, (long)-64631992877716974L) == 0 ? 1 : 0) != 0);
    }

    public void testMax_noArgs() {
        try {
            UnsignedLongs.max((long[])new long[0]);
            UnsignedLongsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMax() {
        UnsignedLongsTest.assertEquals((long)0L, (long)UnsignedLongs.max((long[])new long[]{0L}));
        UnsignedLongsTest.assertEquals((long)-1L, (long)UnsignedLongs.max((long[])new long[]{-1L}));
        UnsignedLongsTest.assertEquals((long)-64631992877716974L, (long)UnsignedLongs.max((long[])new long[]{6504067269626408013L, 8L, 100L, 0L, 7851896530399809066L, -64631992877716974L}));
    }

    public void testMin_noArgs() {
        try {
            UnsignedLongs.min((long[])new long[0]);
            UnsignedLongsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMin() {
        UnsignedLongsTest.assertEquals((long)0L, (long)UnsignedLongs.min((long[])new long[]{0L}));
        UnsignedLongsTest.assertEquals((long)-1L, (long)UnsignedLongs.min((long[])new long[]{-1L}));
        UnsignedLongsTest.assertEquals((long)0L, (long)UnsignedLongs.min((long[])new long[]{6504067269626408013L, 8L, 100L, 0L, 7851896530399809066L, -64631992877716974L}));
    }

    public void testLexicographicalComparator() {
        List ordered = Arrays.asList(new long[0], {0L}, {0L, 0L}, {0L, 1L}, {1L}, {1L, 0L}, {-1L, -2L}, {-1L, -1L}, {-1L, -1L, -1L});
        Comparator comparator = UnsignedLongs.lexicographicalComparator();
        Helpers.testComparator((Comparator)comparator, ordered);
    }

    public void testDivide() {
        UnsignedLongsTest.assertEquals((long)2L, (long)UnsignedLongs.divide((long)14L, (long)5L));
        UnsignedLongsTest.assertEquals((long)0L, (long)UnsignedLongs.divide((long)0L, (long)50L));
        UnsignedLongsTest.assertEquals((long)1L, (long)UnsignedLongs.divide((long)-2L, (long)-3L));
        UnsignedLongsTest.assertEquals((long)0L, (long)UnsignedLongs.divide((long)-3L, (long)-2L));
        UnsignedLongsTest.assertEquals((long)0x1000100010000L, (long)UnsignedLongs.divide((long)-2L, (long)65535L));
        UnsignedLongsTest.assertEquals((long)Long.MAX_VALUE, (long)UnsignedLongs.divide((long)-2L, (long)2L));
        UnsignedLongsTest.assertEquals((long)0x3333333333333332L, (long)UnsignedLongs.divide((long)-2L, (long)5L));
    }

    public void testRemainder() {
        UnsignedLongsTest.assertEquals((long)4L, (long)UnsignedLongs.remainder((long)14L, (long)5L));
        UnsignedLongsTest.assertEquals((long)0L, (long)UnsignedLongs.remainder((long)0L, (long)50L));
        UnsignedLongsTest.assertEquals((long)1L, (long)UnsignedLongs.remainder((long)-2L, (long)-3L));
        UnsignedLongsTest.assertEquals((long)-3L, (long)UnsignedLongs.remainder((long)-3L, (long)-2L));
        UnsignedLongsTest.assertEquals((long)65534L, (long)UnsignedLongs.remainder((long)-2L, (long)65535L));
        UnsignedLongsTest.assertEquals((long)0L, (long)UnsignedLongs.remainder((long)-2L, (long)2L));
        UnsignedLongsTest.assertEquals((long)4L, (long)UnsignedLongs.remainder((long)-2L, (long)5L));
    }

    @GwtIncompatible
    public void testDivideRemainderEuclideanProperty() {
        Random r = new Random(0L);
        for (int i = 0; i < 1000000; ++i) {
            long dividend = r.nextLong();
            long divisor = r.nextLong();
            UnsignedLongsTest.assertEquals((long)0L, (long)(dividend - (divisor * UnsignedLongs.divide((long)dividend, (long)divisor) + UnsignedLongs.remainder((long)dividend, (long)divisor))));
        }
    }

    public void testParseLong() {
        UnsignedLongsTest.assertEquals((long)-1L, (long)UnsignedLongs.parseUnsignedLong((String)"18446744073709551615"));
        UnsignedLongsTest.assertEquals((long)Long.MAX_VALUE, (long)UnsignedLongs.parseUnsignedLong((String)"9223372036854775807"));
        UnsignedLongsTest.assertEquals((long)-64631992877716974L, (long)UnsignedLongs.parseUnsignedLong((String)"18382112080831834642"));
        UnsignedLongsTest.assertEquals((long)6504067269626408013L, (long)UnsignedLongs.parseUnsignedLong((String)"6504067269626408013"));
        UnsignedLongsTest.assertEquals((long)7851896530399809066L, (long)UnsignedLongs.parseUnsignedLong((String)"7851896530399809066"));
    }

    public void testParseLongFails() {
        try {
            UnsignedLongs.parseUnsignedLong((String)"18446744073709551616");
            UnsignedLongsTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testDecodeLong() {
        UnsignedLongsTest.assertEquals((long)-1L, (long)UnsignedLongs.decode((String)"0xffffffffffffffff"));
        UnsignedLongsTest.assertEquals((long)342391L, (long)UnsignedLongs.decode((String)"01234567"));
        UnsignedLongsTest.assertEquals((long)1311768467294899695L, (long)UnsignedLongs.decode((String)"#1234567890abcdef"));
        UnsignedLongsTest.assertEquals((long)987654321012345678L, (long)UnsignedLongs.decode((String)"987654321012345678"));
        UnsignedLongsTest.assertEquals((long)87108891784066425L, (long)UnsignedLongs.decode((String)"0x135791357913579"));
        UnsignedLongsTest.assertEquals((long)87108891784066425L, (long)UnsignedLongs.decode((String)"0X135791357913579"));
        UnsignedLongsTest.assertEquals((long)0L, (long)UnsignedLongs.decode((String)"0"));
    }

    public void testDecodeLongFails() {
        try {
            UnsignedLongs.decode((String)"0xfffffffffffffffff");
            UnsignedLongsTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            UnsignedLongs.decode((String)"-5");
            UnsignedLongsTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            UnsignedLongs.decode((String)"-0x5");
            UnsignedLongsTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            UnsignedLongs.decode((String)"-05");
            UnsignedLongsTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testParseLongWithRadix() {
        UnsignedLongsTest.assertEquals((long)-1L, (long)UnsignedLongs.parseUnsignedLong((String)"ffffffffffffffff", (int)16));
        UnsignedLongsTest.assertEquals((long)1311768467294899695L, (long)UnsignedLongs.parseUnsignedLong((String)"1234567890abcdef", (int)16));
    }

    public void testParseLongWithRadixLimits() {
        BigInteger max = BigInteger.ZERO.setBit(64).subtract(BigInteger.ONE);
        for (int radix = 2; radix <= 36; ++radix) {
            String maxAsString = max.toString(radix);
            UnsignedLongsTest.assertEquals((long)max.longValue(), (long)UnsignedLongs.parseUnsignedLong((String)maxAsString, (int)radix));
            try {
                BigInteger overflow = max.add(BigInteger.ONE);
                String overflowAsString = overflow.toString(radix);
                UnsignedLongs.parseUnsignedLong((String)overflowAsString, (int)radix);
                UnsignedLongsTest.fail();
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            UnsignedLongs.parseUnsignedLong((String)"1234567890abcdef1", (int)16);
            UnsignedLongsTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testParseLongThrowsExceptionForInvalidRadix() {
        try {
            UnsignedLongs.parseUnsignedLong((String)"0", (int)1);
            UnsignedLongsTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            UnsignedLongs.parseUnsignedLong((String)"0", (int)37);
            UnsignedLongsTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            UnsignedLongs.parseUnsignedLong((String)"0", (int)-1);
            UnsignedLongsTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testToString() {
        int[] bases;
        String[] tests = new String[]{"ffffffffffffffff", "7fffffffffffffff", "ff1a618b7f65ea12", "5a4316b8c153ac4d", "6cf78a4b139a4e2a"};
        for (int base : bases = new int[]{2, 5, 7, 8, 10, 16}) {
            for (String x : tests) {
                BigInteger xValue = new BigInteger(x, 16);
                long xLong = xValue.longValue();
                UnsignedLongsTest.assertEquals((String)xValue.toString(base), (String)UnsignedLongs.toString((long)xLong, (int)base));
            }
        }
    }

    public void testJoin() {
        UnsignedLongsTest.assertEquals((String)"", (String)UnsignedLongs.join((String)",", (long[])new long[0]));
        UnsignedLongsTest.assertEquals((String)"1", (String)UnsignedLongs.join((String)",", (long[])new long[]{1L}));
        UnsignedLongsTest.assertEquals((String)"1,2", (String)UnsignedLongs.join((String)",", (long[])new long[]{1L, 2L}));
        UnsignedLongsTest.assertEquals((String)"18446744073709551615,9223372036854775808", (String)UnsignedLongs.join((String)",", (long[])new long[]{-1L, Long.MIN_VALUE}));
        UnsignedLongsTest.assertEquals((String)"123", (String)UnsignedLongs.join((String)"", (long[])new long[]{1L, 2L, 3L}));
        UnsignedLongsTest.assertEquals((String)"184467440737095516159223372036854775808", (String)UnsignedLongs.join((String)"", (long[])new long[]{-1L, Long.MIN_VALUE}));
    }

    @GwtIncompatible
    public void testNulls() {
        new NullPointerTester().testAllPublicStaticMethods(UnsignedLongs.class);
    }
}

