/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.common.reflect.AndroidIncompatible;
import com.google.common.reflect.ClassPath;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.truth.Truth;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import junit.framework.TestCase;
import org.junit.Test;

public class ClassPathTest
extends TestCase {
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{ClassPathTest.classInfo(ClassPathTest.class), ClassPathTest.classInfo(ClassPathTest.class)}).addEqualityGroup(new Object[]{ClassPathTest.classInfo(Test.class), ClassPathTest.classInfo(Test.class, ((Object)((Object)this)).getClass().getClassLoader())}).addEqualityGroup(new Object[]{new ClassPath.ResourceInfo("a/b/c.txt", ((Object)((Object)this)).getClass().getClassLoader()), new ClassPath.ResourceInfo("a/b/c.txt", ((Object)((Object)this)).getClass().getClassLoader())}).addEqualityGroup(new Object[]{new ClassPath.ResourceInfo("x.txt", ((Object)((Object)this)).getClass().getClassLoader())}).testEquals();
    }

    @AndroidIncompatible
    public void testClassPathEntries_emptyURLClassLoader_noParent() {
        Truth.assertThat((Iterable)ClassPath.Scanner.getClassPathEntries((ClassLoader)new URLClassLoader(new URL[0], null)).keySet()).isEmpty();
    }

    @AndroidIncompatible
    public void testClassPathEntries_URLClassLoader_noParent() throws Exception {
        URL url1 = new URL("file:/a");
        URL url2 = new URL("file:/b");
        URLClassLoader classloader = new URLClassLoader(new URL[]{url1, url2}, null);
        ClassPathTest.assertEquals((Object)ImmutableMap.of((Object)new File("/a"), (Object)classloader, (Object)new File("/b"), (Object)classloader), (Object)ClassPath.Scanner.getClassPathEntries((ClassLoader)classloader));
    }

    @AndroidIncompatible
    public void testClassPathEntries_URLClassLoader_withParent() throws Exception {
        URL url1 = new URL("file:/a");
        URL url2 = new URL("file:/b");
        URLClassLoader parent = new URLClassLoader(new URL[]{url1}, null);
        URLClassLoader child = new URLClassLoader(new URL[]{url2}, (ClassLoader)parent){};
        ImmutableMap classPathEntries = ClassPath.Scanner.getClassPathEntries((ClassLoader)child);
        ClassPathTest.assertEquals((Object)ImmutableMap.of((Object)new File("/a"), (Object)parent, (Object)new File("/b"), (Object)child), (Object)classPathEntries);
        Truth.assertThat((Iterable)classPathEntries.keySet()).containsExactly(new Object[]{new File("/a"), new File("/b")}).inOrder();
    }

    @AndroidIncompatible
    public void testClassPathEntries_duplicateUri_parentWins() throws Exception {
        URL url = new URL("file:/a");
        URLClassLoader parent = new URLClassLoader(new URL[]{url}, null);
        URLClassLoader child = new URLClassLoader(new URL[]{url}, (ClassLoader)parent){};
        ClassPathTest.assertEquals((Object)ImmutableMap.of((Object)new File("/a"), (Object)parent), (Object)ClassPath.Scanner.getClassPathEntries((ClassLoader)child));
    }

    @AndroidIncompatible
    public void testClassPathEntries_notURLClassLoader_noParent() {
        Truth.assertThat((Iterable)ClassPath.Scanner.getClassPathEntries((ClassLoader)new ClassLoader(null){}).keySet()).isEmpty();
    }

    @AndroidIncompatible
    public void testClassPathEntries_notURLClassLoader_withParent() throws Exception {
        URL url = new URL("file:/a");
        URLClassLoader parent = new URLClassLoader(new URL[]{url}, null);
        ClassPathTest.assertEquals((Object)ImmutableMap.of((Object)new File("/a"), (Object)parent), (Object)ClassPath.Scanner.getClassPathEntries((ClassLoader)new ClassLoader((ClassLoader)parent){}));
    }

    @AndroidIncompatible
    public void testClassPathEntries_notURLClassLoader_withParentAndGrandParent() throws Exception {
        URL url1 = new URL("file:/a");
        URL url2 = new URL("file:/b");
        URLClassLoader grandParent = new URLClassLoader(new URL[]{url1}, null);
        URLClassLoader parent = new URLClassLoader(new URL[]{url2}, (ClassLoader)grandParent);
        ClassPathTest.assertEquals((Object)ImmutableMap.of((Object)new File("/a"), (Object)grandParent, (Object)new File("/b"), (Object)parent), (Object)ClassPath.Scanner.getClassPathEntries((ClassLoader)new ClassLoader((ClassLoader)parent){}));
    }

    @AndroidIncompatible
    public void testClassPathEntries_notURLClassLoader_withGrandParent() throws Exception {
        URL url = new URL("file:/a");
        URLClassLoader grandParent = new URLClassLoader(new URL[]{url}, null);
        ClassLoader parent = new ClassLoader((ClassLoader)grandParent){};
        ClassPathTest.assertEquals((Object)ImmutableMap.of((Object)new File("/a"), (Object)grandParent), (Object)ClassPath.Scanner.getClassPathEntries((ClassLoader)new ClassLoader(parent){}));
    }

    public void testScan_classPathCycle() throws IOException {
        File jarFile = File.createTempFile("with_circular_class_path", ".jar");
        try {
            ClassPathTest.writeSelfReferencingJarFile(jarFile, "test.txt");
            ClassPath.DefaultScanner scanner = new ClassPath.DefaultScanner();
            scanner.scan(jarFile, ClassPathTest.class.getClassLoader());
            ClassPathTest.assertEquals((int)1, (int)scanner.getResources().size());
        }
        finally {
            jarFile.delete();
        }
    }

    public void testScanFromFile_fileNotExists() throws IOException {
        ClassLoader classLoader = ClassPathTest.class.getClassLoader();
        ClassPath.DefaultScanner scanner = new ClassPath.DefaultScanner();
        scanner.scan(new File("no/such/file/anywhere"), classLoader);
        Truth.assertThat((Iterable)scanner.getResources()).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScanFromFile_notJarFile() throws IOException {
        ClassLoader classLoader = ClassPathTest.class.getClassLoader();
        File notJar = File.createTempFile("not_a_jar", "txt");
        ClassPath.DefaultScanner scanner = new ClassPath.DefaultScanner();
        try {
            scanner.scan(notJar, classLoader);
        }
        finally {
            notJar.delete();
        }
        Truth.assertThat((Iterable)scanner.getResources()).isEmpty();
    }

    public void testGetClassPathEntry() throws MalformedURLException, URISyntaxException {
        ClassPathTest.assertEquals((Object)new File("/usr/test/dep.jar").toURI(), (Object)ClassPath.Scanner.getClassPathEntry((File)new File("/home/build/outer.jar"), (String)"file:/usr/test/dep.jar").toURI());
        ClassPathTest.assertEquals((Object)new File("/home/build/a.jar").toURI(), (Object)ClassPath.Scanner.getClassPathEntry((File)new File("/home/build/outer.jar"), (String)"a.jar").toURI());
        ClassPathTest.assertEquals((Object)new File("/home/build/x/y/z").toURI(), (Object)ClassPath.Scanner.getClassPathEntry((File)new File("/home/build/outer.jar"), (String)"x/y/z").toURI());
        ClassPathTest.assertEquals((Object)new File("/home/build/x/y/z.jar").toURI(), (Object)ClassPath.Scanner.getClassPathEntry((File)new File("/home/build/outer.jar"), (String)"x/y/z.jar").toURI());
        ClassPathTest.assertEquals((String)"/home/build/x y.jar", (String)ClassPath.Scanner.getClassPathEntry((File)new File("/home/build/outer.jar"), (String)"x y.jar").getFile());
    }

    public void testGetClassPathFromManifest_nullManifest() {
        Truth.assertThat((Iterable)ClassPath.Scanner.getClassPathFromManifest((File)new File("some.jar"), null)).isEmpty();
    }

    public void testGetClassPathFromManifest_noClassPath() throws IOException {
        File jarFile = new File("base.jar");
        Truth.assertThat((Iterable)ClassPath.Scanner.getClassPathFromManifest((File)jarFile, (Manifest)ClassPathTest.manifest(""))).isEmpty();
    }

    public void testGetClassPathFromManifest_emptyClassPath() throws IOException {
        File jarFile = new File("base.jar");
        Truth.assertThat((Iterable)ClassPath.Scanner.getClassPathFromManifest((File)jarFile, (Manifest)ClassPathTest.manifestClasspath(""))).isEmpty();
    }

    public void testGetClassPathFromManifest_badClassPath() throws IOException {
        File jarFile = new File("base.jar");
        Manifest manifest = ClassPathTest.manifestClasspath("nosuchscheme:an_invalid^path");
        Truth.assertThat((Iterable)ClassPath.Scanner.getClassPathFromManifest((File)jarFile, (Manifest)manifest)).isEmpty();
    }

    public void testGetClassPathFromManifest_pathWithStrangeCharacter() throws IOException {
        File jarFile = new File("base/some.jar");
        Manifest manifest = ClassPathTest.manifestClasspath("file:the^file.jar");
        Truth.assertThat((Iterable)ClassPath.Scanner.getClassPathFromManifest((File)jarFile, (Manifest)manifest)).containsExactly(new Object[]{ClassPathTest.fullpath("base/the^file.jar")});
    }

    public void testGetClassPathFromManifest_relativeDirectory() throws IOException {
        File jarFile = new File("base/some.jar");
        Manifest manifest = ClassPathTest.manifestClasspath("with/relative/dir");
        Truth.assertThat((Iterable)ClassPath.Scanner.getClassPathFromManifest((File)jarFile, (Manifest)manifest)).containsExactly(new Object[]{ClassPathTest.fullpath("base/with/relative/dir")});
    }

    public void testGetClassPathFromManifest_relativeJar() throws IOException {
        File jarFile = new File("base/some.jar");
        Manifest manifest = ClassPathTest.manifestClasspath("with/relative.jar");
        Truth.assertThat((Iterable)ClassPath.Scanner.getClassPathFromManifest((File)jarFile, (Manifest)manifest)).containsExactly(new Object[]{ClassPathTest.fullpath("base/with/relative.jar")});
    }

    public void testGetClassPathFromManifest_jarInCurrentDirectory() throws IOException {
        File jarFile = new File("base/some.jar");
        Manifest manifest = ClassPathTest.manifestClasspath("current.jar");
        Truth.assertThat((Iterable)ClassPath.Scanner.getClassPathFromManifest((File)jarFile, (Manifest)manifest)).containsExactly(new Object[]{ClassPathTest.fullpath("base/current.jar")});
    }

    public void testGetClassPathFromManifest_absoluteDirectory() throws IOException {
        File jarFile = new File("base/some.jar");
        Manifest manifest = ClassPathTest.manifestClasspath("file:/with/absolute/dir");
        Truth.assertThat((Iterable)ClassPath.Scanner.getClassPathFromManifest((File)jarFile, (Manifest)manifest)).containsExactly(new Object[]{ClassPathTest.fullpath("/with/absolute/dir")});
    }

    public void testGetClassPathFromManifest_absoluteJar() throws IOException {
        File jarFile = new File("base/some.jar");
        Manifest manifest = ClassPathTest.manifestClasspath("file:/with/absolute.jar");
        Truth.assertThat((Iterable)ClassPath.Scanner.getClassPathFromManifest((File)jarFile, (Manifest)manifest)).containsExactly(new Object[]{ClassPathTest.fullpath("/with/absolute.jar")});
    }

    public void testGetClassPathFromManifest_multiplePaths() throws IOException {
        File jarFile = new File("base/some.jar");
        Manifest manifest = ClassPathTest.manifestClasspath("file:/with/absolute.jar relative.jar  relative/dir");
        Truth.assertThat((Iterable)ClassPath.Scanner.getClassPathFromManifest((File)jarFile, (Manifest)manifest)).containsExactly(new Object[]{ClassPathTest.fullpath("/with/absolute.jar"), ClassPathTest.fullpath("base/relative.jar"), ClassPathTest.fullpath("base/relative/dir")}).inOrder();
    }

    public void testGetClassPathFromManifest_leadingBlanks() throws IOException {
        File jarFile = new File("base/some.jar");
        Manifest manifest = ClassPathTest.manifestClasspath(" relative.jar");
        Truth.assertThat((Iterable)ClassPath.Scanner.getClassPathFromManifest((File)jarFile, (Manifest)manifest)).containsExactly(new Object[]{ClassPathTest.fullpath("base/relative.jar")});
    }

    public void testGetClassPathFromManifest_trailingBlanks() throws IOException {
        File jarFile = new File("base/some.jar");
        Manifest manifest = ClassPathTest.manifestClasspath("relative.jar ");
        Truth.assertThat((Iterable)ClassPath.Scanner.getClassPathFromManifest((File)jarFile, (Manifest)manifest)).containsExactly(new Object[]{ClassPathTest.fullpath("base/relative.jar")});
    }

    public void testGetClassName() {
        ClassPathTest.assertEquals((String)"abc.d.Abc", (String)ClassPath.getClassName((String)"abc/d/Abc.class"));
    }

    public void testResourceInfo_of() {
        ClassPathTest.assertEquals(ClassPath.ClassInfo.class, ClassPathTest.resourceInfo(ClassPathTest.class).getClass());
        ClassPathTest.assertEquals(ClassPath.ClassInfo.class, ClassPathTest.resourceInfo(ClassPath.class).getClass());
        ClassPathTest.assertEquals(ClassPath.ClassInfo.class, ClassPathTest.resourceInfo(Nested.class).getClass());
    }

    public void testGetSimpleName() {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        ClassPathTest.assertEquals((String)"Foo", (String)new ClassPath.ClassInfo("Foo.class", classLoader).getSimpleName());
        ClassPathTest.assertEquals((String)"Foo", (String)new ClassPath.ClassInfo("a/b/Foo.class", classLoader).getSimpleName());
        ClassPathTest.assertEquals((String)"Foo", (String)new ClassPath.ClassInfo("a/b/Bar$Foo.class", classLoader).getSimpleName());
        ClassPathTest.assertEquals((String)"", (String)new ClassPath.ClassInfo("a/b/Bar$1.class", classLoader).getSimpleName());
        ClassPathTest.assertEquals((String)"Foo", (String)new ClassPath.ClassInfo("a/b/Bar$Foo.class", classLoader).getSimpleName());
        ClassPathTest.assertEquals((String)"", (String)new ClassPath.ClassInfo("a/b/Bar$1.class", classLoader).getSimpleName());
        ClassPathTest.assertEquals((String)"Local", (String)new ClassPath.ClassInfo("a/b/Bar$1Local.class", classLoader).getSimpleName());
    }

    public void testGetPackageName() {
        ClassPathTest.assertEquals((String)"", (String)new ClassPath.ClassInfo("Foo.class", ((Object)((Object)this)).getClass().getClassLoader()).getPackageName());
        ClassPathTest.assertEquals((String)"a.b", (String)new ClassPath.ClassInfo("a/b/Foo.class", ((Object)((Object)this)).getClass().getClassLoader()).getPackageName());
    }

    private static boolean contentEquals(URL left, URL right) throws IOException {
        return Resources.asByteSource((URL)left).contentEquals(Resources.asByteSource((URL)right));
    }

    public void testNulls() throws IOException {
        new NullPointerTester().testAllPublicStaticMethods(ClassPath.class);
        new NullPointerTester().testAllPublicInstanceMethods((Object)ClassPath.from((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
    }

    public void testResourceScanner() throws IOException {
        ResourceScanner scanner = new ResourceScanner();
        scanner.scan(ClassLoader.getSystemClassLoader());
        Truth.assertThat(scanner.resources).contains((Object)"com/google/common/reflect/ClassPathTest.class");
    }

    private static ClassPath.ClassInfo findClass(Iterable<ClassPath.ClassInfo> classes, Class<?> cls) {
        for (ClassPath.ClassInfo classInfo : classes) {
            if (!classInfo.getName().equals(cls.getName())) continue;
            return classInfo;
        }
        throw new AssertionError((Object)("failed to find " + cls));
    }

    private static ClassPath.ResourceInfo resourceInfo(Class<?> cls) {
        String resource = cls.getName().replace('.', '/') + ".class";
        ClassLoader loader = cls.getClassLoader();
        return ClassPath.ResourceInfo.of((String)resource, (ClassLoader)loader);
    }

    private static ClassPath.ClassInfo classInfo(Class<?> cls) {
        return ClassPathTest.classInfo(cls, cls.getClassLoader());
    }

    private static ClassPath.ClassInfo classInfo(Class<?> cls, ClassLoader classLoader) {
        String resource = cls.getName().replace('.', '/') + ".class";
        return new ClassPath.ClassInfo(resource, classLoader);
    }

    private static Manifest manifestClasspath(String classpath) throws IOException {
        return ClassPathTest.manifest("Class-Path: " + classpath + "\n");
    }

    private static void writeSelfReferencingJarFile(File jarFile, String ... entries) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, jarFile.getName());
        Closer closer = Closer.create();
        try {
            FileOutputStream fileOut = (FileOutputStream)closer.register((Closeable)new FileOutputStream(jarFile));
            JarOutputStream jarOut = (JarOutputStream)closer.register((Closeable)new JarOutputStream(fileOut));
            for (String entry : entries) {
                jarOut.putNextEntry(new ZipEntry(entry));
                Resources.copy((URL)ClassPathTest.class.getResource(entry), (OutputStream)jarOut);
                jarOut.closeEntry();
            }
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    private static Manifest manifest(String content) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes(Charsets.US_ASCII));
        Manifest manifest = new Manifest();
        manifest.read(in);
        return manifest;
    }

    private static File fullpath(String path) {
        return new File(new File(path).toURI());
    }

    private static class ResourceScanner
    extends ClassPath.Scanner {
        final Set<String> resources = new HashSet<String>();

        private ResourceScanner() {
        }

        protected void scanDirectory(ClassLoader loader, File root) throws IOException {
            URI base = root.toURI();
            for (File entry : Files.fileTreeTraverser().preOrderTraversal((Object)root)) {
                String resourceName = new File(base.relativize(entry.toURI()).getPath()).getPath();
                this.resources.add(resourceName);
            }
        }

        protected void scanJarFile(ClassLoader loader, JarFile file) throws IOException {
            Enumeration<JarEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                this.resources.add(entries.nextElement().getName());
            }
        }
    }

    private static class Nested {
        private Nested() {
        }
    }
}

