/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.reflect.AndroidIncompatible;
import com.google.common.reflect.ImmutableTypeToInstanceMap;
import com.google.common.reflect.TypeToken;
import com.google.common.truth.Truth;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ImmutableTypeToInstanceMapTest
extends TestCase {
    @AndroidIncompatible
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ImmutableTypeToInstanceMapTest.class);
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new TestTypeToInstanceMapGenerator(){

            public Map<TypeToken, Object> create(Object ... elements) {
                ImmutableTypeToInstanceMap.Builder builder = ImmutableTypeToInstanceMap.builder();
                for (Object object : elements) {
                    Map.Entry entry = (Map.Entry)object;
                    builder.put((TypeToken)entry.getKey(), entry.getValue());
                }
                return builder.build();
            }
        }).named("ImmutableTypeToInstanceMap")).withFeatures(new Feature[]{MapFeature.REJECTS_DUPLICATES_AT_CREATION, MapFeature.RESTRICTS_KEYS, CollectionFeature.KNOWN_ORDER, CollectionSize.ANY, MapFeature.ALLOWS_ANY_NULL_QUERIES})).createTestSuite());
        return suite;
    }

    public void testEmpty() {
        ImmutableTypeToInstanceMapTest.assertEquals((int)0, (int)ImmutableTypeToInstanceMap.of().size());
    }

    public void testPrimitiveAndWrapper() {
        ImmutableTypeToInstanceMap map = ImmutableTypeToInstanceMap.builder().put(Integer.class, (Object)0).put(Integer.TYPE, (Object)1).build();
        ImmutableTypeToInstanceMapTest.assertEquals((int)2, (int)map.size());
        ImmutableTypeToInstanceMapTest.assertEquals((int)0, (int)((Integer)map.getInstance(Integer.class)));
        ImmutableTypeToInstanceMapTest.assertEquals((int)0, (int)((Integer)map.getInstance(TypeToken.of(Integer.class))));
        ImmutableTypeToInstanceMapTest.assertEquals((int)1, (int)((Integer)map.getInstance(Integer.TYPE)));
        ImmutableTypeToInstanceMapTest.assertEquals((int)1, (int)((Integer)map.getInstance(TypeToken.of(Integer.TYPE))));
    }

    public void testParameterizedType() {
        TypeToken<ImmutableList<Integer>> type = new TypeToken<ImmutableList<Integer>>(){};
        ImmutableTypeToInstanceMap map = ImmutableTypeToInstanceMap.builder().put((TypeToken)type, (Object)ImmutableList.of((Object)1)).build();
        ImmutableTypeToInstanceMapTest.assertEquals((int)1, (int)map.size());
        ImmutableTypeToInstanceMapTest.assertEquals((Object)ImmutableList.of((Object)1), (Object)map.getInstance((TypeToken)type));
    }

    public void testGeneriArrayType() {
        ImmutableList[] array = new ImmutableList[]{ImmutableList.of((Object)1)};
        TypeToken<ImmutableList<Integer>[]> type = new TypeToken<ImmutableList<Integer>[]>(){};
        ImmutableTypeToInstanceMap map = ImmutableTypeToInstanceMap.builder().put((TypeToken)type, (Object)array).build();
        ImmutableTypeToInstanceMapTest.assertEquals((int)1, (int)map.size());
        Truth.assertThat((Object[])((Object[])map.getInstance((TypeToken)type))).asList().containsExactly(new Object[]{array[0]});
    }

    public void testWildcardType() {
        TypeToken type = new TypeToken<ImmutableList<?>>(){};
        ImmutableTypeToInstanceMap map = ImmutableTypeToInstanceMap.builder().put(type, (Object)ImmutableList.of((Object)1)).build();
        ImmutableTypeToInstanceMapTest.assertEquals((int)1, (int)map.size());
        ImmutableTypeToInstanceMapTest.assertEquals((Object)ImmutableList.of((Object)1), (Object)map.getInstance(type));
    }

    public void testGetInstance_containsTypeVariable() {
        ImmutableTypeToInstanceMap map = ImmutableTypeToInstanceMap.of();
        try {
            map.getInstance(this.anyIterableType());
            ImmutableTypeToInstanceMapTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPut_containsTypeVariable() {
        ImmutableTypeToInstanceMap.Builder builder = ImmutableTypeToInstanceMap.builder();
        try {
            builder.put(this.anyIterableType(), (Object)ImmutableList.of((Object)1));
            ImmutableTypeToInstanceMapTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private <T> TypeToken<Iterable<T>> anyIterableType() {
        return new TypeToken<Iterable<T>>(){};
    }

    static abstract class TestTypeToInstanceMapGenerator
    implements TestMapGenerator<TypeToken, Object> {
        TestTypeToInstanceMapGenerator() {
        }

        public TypeToken[] createKeyArray(int length) {
            return new TypeToken[length];
        }

        public Object[] createValueArray(int length) {
            return new Object[length];
        }

        public SampleElements<Map.Entry<TypeToken, Object>> samples() {
            return new SampleElements(TestTypeToInstanceMapGenerator.entry(TypeToken.of(Integer.class), 0), TestTypeToInstanceMapGenerator.entry(TypeToken.of(Number.class), 1), TestTypeToInstanceMapGenerator.entry(new TypeToken<ImmutableList<Integer>>(){}, ImmutableList.of((Object)2)), TestTypeToInstanceMapGenerator.entry(new TypeToken<int[]>(){}, new int[]{3}), TestTypeToInstanceMapGenerator.entry(new TypeToken<Iterable<?>>(){}, ImmutableList.of((Object)"4")));
        }

        private static Map.Entry<TypeToken, Object> entry(TypeToken<?> k, Object v) {
            return Maps.immutableEntry(k, (Object)v);
        }

        public Map.Entry<TypeToken, Object>[] createArray(int length) {
            return new Map.Entry[length];
        }

        public Iterable<Map.Entry<TypeToken, Object>> order(List<Map.Entry<TypeToken, Object>> insertionOrder) {
            return insertionOrder;
        }
    }
}

