/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.AndroidIncompatible;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.Parameter;
import com.google.common.reflect.TypeCapture;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.common.reflect.Types;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.Truth;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;

@AndroidIncompatible
public class TypeTokenTest
extends TestCase {
    public void testValueEqualityNotInstanceEquality() {
        TypeToken<List<String>> a = new TypeToken<List<String>>(){};
        TypeToken<List<String>> b = new TypeToken<List<String>>(){};
        TypeTokenTest.assertEquals((Object)a, (Object)b);
    }

    public <T> void testVariableTypeTokenNotAllowed() {
        try {
            new TypeToken<T>(){};
            TypeTokenTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testRawTypeIsCorrect() {
        TypeToken<List<String>> token = new TypeToken<List<String>>(){};
        TypeTokenTest.assertEquals(List.class, (Object)token.getRawType());
    }

    public void testTypeIsCorrect() {
        TypeToken<List<String>> token = new TypeToken<List<String>>(){};
        TypeTokenTest.assertEquals((Object)StringList.class.getGenericInterfaces()[0], (Object)token.getType());
    }

    public void testGetClass() {
        TypeToken token = TypeToken.of(List.class);
        TypeTokenTest.assertEquals((Object)new TypeToken<List>(){}, (Object)token);
    }

    public void testGetType() {
        TypeToken t = TypeToken.of((Type)StringList.class.getGenericInterfaces()[0]);
        TypeTokenTest.assertEquals((Object)new TypeToken<List<String>>(){}, (Object)t);
    }

    public void testNonStaticLocalClass() {
        TypeToken<Local<String>> type = new TypeToken<Local<String>>(){};
        class Local<T> {
            Local() {
            }
        }
        TypeTokenTest.assertEquals((Object)Types.newParameterizedType(Local.class, (Type[])new Type[]{String.class}), (Object)type.getType());
        TypeTokenTest.assertEquals((Object)new Local<String>(){
            {
            }
        }.getClass().getGenericSuperclass(), (Object)type.getType());
    }

    public void testStaticLocalClass() {
        TypeTokenTest.doTestStaticLocalClass();
    }

    private static void doTestStaticLocalClass() {
        TypeToken<Local<String>> type = new TypeToken<Local<String>>(){};
        class Local<T> {
            Local() {
            }
        }
        TypeTokenTest.assertEquals((Object)Types.newParameterizedType(Local.class, (Type[])new Type[]{String.class}), (Object)type.getType());
        TypeTokenTest.assertEquals((Object)new Local<String>(){
            {
            }
        }.getClass().getGenericSuperclass(), (Object)type.getType());
    }

    public void testGenericArrayType() {
        TypeToken<List<String>[]> token = new TypeToken<List<String>[]>(){};
        TypeTokenTest.assertEquals(List[].class, (Object)token.getRawType());
        Truth.assertThat((Object)token.getType()).isInstanceOf(GenericArrayType.class);
    }

    public void testMultiDimensionalGenericArrayType() {
        TypeToken<List<Long>[][][]> token = new TypeToken<List<Long>[][][]>(){};
        TypeTokenTest.assertEquals(List[][][].class, (Object)token.getRawType());
        Truth.assertThat((Object)token.getType()).isInstanceOf(GenericArrayType.class);
    }

    public <T> void testGenericVariableTypeArrays() {
        TypeTokenTest.assertEquals((String)"T[]", (String)new TypeToken<T[]>(){}.toString());
    }

    public void testResolveType() throws Exception {
        Method getFromList = List.class.getMethod("get", Integer.TYPE);
        TypeToken returnType = new TypeToken<List<String>>(){}.resolveType(getFromList.getGenericReturnType());
        TypeTokenTest.assertEquals(String.class, (Object)returnType.getType());
    }

    public <F extends Enum<F> & Iterable<Long>> void testResolveType_fromTypeVariable() {
        TypeToken f = TypeToken.of((Type)new TypeCapture<F>(){}.capture());
        TypeTokenTest.assertEquals(String.class, (Object)f.resolveType(Function.class.getTypeParameters()[0]).getType());
        TypeTokenTest.assertEquals(Integer.class, (Object)f.resolveType(Function.class.getTypeParameters()[1]).getType());
        TypeTokenTest.assertEquals(Long.class, (Object)f.resolveType(Iterable.class.getTypeParameters()[0]).getType());
    }

    public <E extends Comparable<Iterable<String>> & Iterable<Integer>> void testResolveType_fromTypeVariable_onlyDirectBoundsAreUsed() {
        TypeToken e = TypeToken.of((Type)new TypeCapture<E>(){}.capture());
        TypeTokenTest.assertEquals(Integer.class, (Object)e.resolveType(Iterable.class.getTypeParameters()[0]).getType());
    }

    public void testResolveType_fromWildcard() {
        ParameterizedType withWildcardType = (ParameterizedType)new TypeCapture<Comparable<? extends Iterable<String>>>(){}.capture();
        TypeToken wildcardType = TypeToken.of((Type)withWildcardType.getActualTypeArguments()[0]);
        TypeTokenTest.assertEquals(String.class, (Object)wildcardType.resolveType(Iterable.class.getTypeParameters()[0]).getType());
    }

    public void testGetTypes_noSuperclass() {
        TypeToken.TypeSet types = new TypeToken<Object>(){}.getTypes();
        Truth.assertThat((Iterable)types).contains((Object)TypeToken.of(Object.class));
        Truth.assertThat((Iterable)types.rawTypes()).contains(Object.class);
        Truth.assertThat((Iterable)types.interfaces()).isEmpty();
        Truth.assertThat((Iterable)types.interfaces().rawTypes()).isEmpty();
        Truth.assertThat((Iterable)types.classes()).contains((Object)TypeToken.of(Object.class));
        Truth.assertThat((Iterable)types.classes().rawTypes()).contains(Object.class);
    }

    public void testGetTypes_fromInterface() {
        TypeToken.TypeSet types = new TypeToken<Interface1>(){}.getTypes();
        Truth.assertThat((Iterable)types).contains((Object)TypeToken.of(Interface1.class));
        Truth.assertThat((Iterable)types.rawTypes()).contains(Interface1.class);
        Truth.assertThat((Iterable)types.interfaces()).contains((Object)TypeToken.of(Interface1.class));
        Truth.assertThat((Iterable)types.interfaces().rawTypes()).contains(Interface1.class);
        Truth.assertThat((Iterable)types.classes()).isEmpty();
        Truth.assertThat((Iterable)types.classes().rawTypes()).isEmpty();
    }

    public void testGetTypes_fromPrimitive() {
        TypeToken.TypeSet types = TypeToken.of(Integer.TYPE).getTypes();
        Truth.assertThat((Iterable)types).contains((Object)TypeToken.of(Integer.TYPE));
        Truth.assertThat((Iterable)types.rawTypes()).contains(Integer.TYPE);
        Truth.assertThat((Iterable)types.interfaces()).isEmpty();
        Truth.assertThat((Iterable)types.interfaces().rawTypes()).isEmpty();
        Truth.assertThat((Iterable)types.classes()).contains((Object)TypeToken.of(Integer.TYPE));
        Truth.assertThat((Iterable)types.classes().rawTypes()).contains(Integer.TYPE);
    }

    public void testGetTypes_withInterfacesAndSuperclasses() {
        TypeToken.TypeSet types = new TypeToken<1Class3<String>>(){}.getTypes();
        abstract class Class2
        extends Class1
        implements Interface12 {
            Class2() {
            }
        }
        TypeTokenTest.makeUnmodifiable(types).containsExactly(new Object[]{new TypeToken<1Class3<String>>(){}, new TypeToken<Interface3<String>>(){}, new TypeToken<Iterable<String>>(){}, TypeToken.of(Class2.class), TypeToken.of(Interface12.class), TypeToken.of(Interface1.class), TypeToken.of(Interface2.class), TypeToken.of(Class1.class), TypeToken.of(Object.class)});
        TypeTokenTest.makeUnmodifiable(types.interfaces()).containsExactly(new Object[]{new TypeToken<Interface3<String>>(){}, TypeToken.of(Interface12.class), TypeToken.of(Interface1.class), TypeToken.of(Interface2.class), new TypeToken<Iterable<String>>(){}});
        TypeTokenTest.makeUnmodifiable(types.classes()).containsExactly(new Object[]{new TypeToken<1Class3<String>>(){}, TypeToken.of(Class2.class), TypeToken.of(Class1.class), TypeToken.of(Object.class)});
        TypeTokenTest.assertSubtypeFirst(types);
    }

    public void testGetTypes_rawTypes_withInterfacesAndSuperclasses() {
        TypeToken.TypeSet types = new TypeToken<Class3<String>>(){}.getTypes();
        abstract class Class3<T>
        extends Class2
        implements Interface3<T> {
            Class3() {
                abstract class Class2
                extends Class1
                implements Interface12 {
                    Class2() {
                    }
                }
            }
        }
        TypeTokenTest.makeUnmodifiable(types.rawTypes()).containsExactly(new Object[]{Class3.class, Interface3.class, Iterable.class, Class2.class, Interface12.class, Interface1.class, Interface2.class, Class1.class, Object.class});
        TypeTokenTest.makeUnmodifiable(types.interfaces().rawTypes()).containsExactly(new Object[]{Interface3.class, Interface12.class, Interface1.class, Interface2.class, Iterable.class});
        TypeTokenTest.makeUnmodifiable(types.classes().rawTypes()).containsExactly(new Object[]{Class3.class, Class2.class, Class1.class, Object.class});
        TypeTokenTest.assertSubtypeFirst(types);
    }

    public <A extends Class1, B extends A> void testGetTypes_ignoresTypeVariablesByDefault() {
        TypeToken.TypeSet types = TypeToken.of((Type)new TypeCapture<B>(){}.capture()).getTypes();
        TypeTokenTest.makeUnmodifiable(types).containsExactly(new Object[]{TypeToken.of(Interface1.class), TypeToken.of(Class1.class), TypeToken.of(Object.class)});
        TypeTokenTest.assertSubtypeFirst(types);
        TypeTokenTest.makeUnmodifiable(types.interfaces()).containsExactly(new Object[]{TypeToken.of(Interface1.class)});
        TypeTokenTest.makeUnmodifiable(types.classes()).containsExactly(new Object[]{TypeToken.of(Class1.class), TypeToken.of(Object.class)}).inOrder();
    }

    public <A extends Class1, B extends A> void testGetTypes_rawTypes_ignoresTypeVariablesByDefault() {
        TypeToken.TypeSet types = TypeToken.of((Type)new TypeCapture<B>(){}.capture()).getTypes();
        TypeTokenTest.makeUnmodifiable(types.rawTypes()).containsExactly(new Object[]{Interface1.class, Class1.class, Object.class});
        TypeTokenTest.makeUnmodifiable(types.interfaces().rawTypes()).containsExactly(new Object[]{Interface1.class});
        TypeTokenTest.makeUnmodifiable(types.classes().rawTypes()).containsExactly(new Object[]{Class1.class, Object.class}).inOrder();
    }

    public <A extends Interface1 & Interface2> void testGetTypes_manyBounds() {
        TypeToken.TypeSet types = TypeToken.of((Type)new TypeCapture<A>(){}.capture()).getTypes();
        TypeTokenTest.makeUnmodifiable(types.rawTypes()).containsExactly(new Object[]{Interface1.class, Interface2.class, Interface3.class, Iterable.class});
    }

    private static void assertSubtypeFirst(TypeToken.TypeSet types) {
        TypeTokenTest.assertSubtypeTokenBeforeSupertypeToken(types);
        TypeTokenTest.assertSubtypeTokenBeforeSupertypeToken(types.interfaces());
        TypeTokenTest.assertSubtypeTokenBeforeSupertypeToken(types.classes());
        TypeTokenTest.assertSubtypeBeforeSupertype(types.rawTypes());
        TypeTokenTest.assertSubtypeBeforeSupertype(types.interfaces().rawTypes());
        TypeTokenTest.assertSubtypeBeforeSupertype(types.classes().rawTypes());
    }

    private static void assertSubtypeTokenBeforeSupertypeToken(Iterable<? extends TypeToken<?>> types) {
        int i = 0;
        for (TypeToken<?> left : types) {
            int j = 0;
            for (TypeToken<?> right : types) {
                if (left.isSupertypeOf(right)) {
                    TypeTokenTest.assertTrue((String)(left + " should be after " + right), (i >= j ? 1 : 0) != 0);
                }
                ++j;
            }
            ++i;
        }
    }

    private static void assertSubtypeBeforeSupertype(Iterable<? extends Class<?>> types) {
        int i = 0;
        for (Class<?> left : types) {
            int j = 0;
            for (Class<?> right : types) {
                if (left.isAssignableFrom(right)) {
                    TypeTokenTest.assertTrue((String)(left + " should be after " + right), (i >= j ? 1 : 0) != 0);
                }
                ++j;
            }
            ++i;
        }
    }

    public void testAssertSubtypeTokenBeforeSupertypeToken_empty() {
        TypeTokenTest.assertSubtypeTokenBeforeSupertypeToken(ImmutableList.of());
    }

    public void testAssertSubtypeTokenBeforeSupertypeToken_oneType() {
        TypeTokenTest.assertSubtypeTokenBeforeSupertypeToken(ImmutableList.of((Object)TypeToken.of(String.class)));
    }

    public void testAssertSubtypeTokenBeforeSupertypeToken_subtypeFirst() {
        TypeTokenTest.assertSubtypeTokenBeforeSupertypeToken(ImmutableList.of((Object)TypeToken.of(String.class), (Object)TypeToken.of(CharSequence.class)));
    }

    public void testAssertSubtypeTokenBeforeSupertypeToken_supertypeFirst() {
        try {
            TypeTokenTest.assertSubtypeTokenBeforeSupertypeToken(ImmutableList.of((Object)TypeToken.of(CharSequence.class), (Object)TypeToken.of(String.class)));
        }
        catch (AssertionError expected) {
            return;
        }
        TypeTokenTest.fail();
    }

    public void testAssertSubtypeTokenBeforeSupertypeToken_duplicate() {
        try {
            TypeTokenTest.assertSubtypeTokenBeforeSupertypeToken(ImmutableList.of((Object)TypeToken.of(String.class), (Object)TypeToken.of(String.class)));
        }
        catch (AssertionError expected) {
            return;
        }
        TypeTokenTest.fail();
    }

    public void testAssertSubtypeBeforeSupertype_empty() {
        TypeTokenTest.assertSubtypeBeforeSupertype(ImmutableList.of());
    }

    public void testAssertSubtypeBeforeSupertype_oneType() {
        TypeTokenTest.assertSubtypeBeforeSupertype(ImmutableList.of(String.class));
    }

    public void testAssertSubtypeBeforeSupertype_subtypeFirst() {
        TypeTokenTest.assertSubtypeBeforeSupertype(ImmutableList.of(String.class, CharSequence.class));
    }

    public void testAssertSubtypeBeforeSupertype_supertypeFirst() {
        try {
            TypeTokenTest.assertSubtypeBeforeSupertype(ImmutableList.of(CharSequence.class, String.class));
        }
        catch (AssertionError expected) {
            return;
        }
        TypeTokenTest.fail();
    }

    public void testAssertSubtypeBeforeSupertype_duplicate() {
        try {
            TypeTokenTest.assertSubtypeBeforeSupertype(ImmutableList.of(String.class, String.class));
        }
        catch (AssertionError expected) {
            return;
        }
        TypeTokenTest.fail();
    }

    public void testGetGenericSuperclass_noSuperclass() {
        TypeTokenTest.assertNull((Object)new TypeToken<Object>(){}.getGenericSuperclass());
        TypeTokenTest.assertEquals((Object)TypeToken.of(Object.class), (Object)new TypeToken<Object[]>(){}.getGenericSuperclass());
        TypeTokenTest.assertNull((Object)new TypeToken<List<String>>(){}.getGenericSuperclass());
        TypeTokenTest.assertEquals((Object)TypeToken.of(Object.class), (Object)new TypeToken<List<String>[]>(){}.getGenericSuperclass());
    }

    public void testGetGenericSuperclass_withSuperclass() {
        TypeToken superToken = new TypeToken<ArrayList<String>>(){}.getGenericSuperclass();
        TypeTokenTest.assertEquals(ArrayList.class.getSuperclass(), (Object)superToken.getRawType());
        TypeTokenTest.assertEquals(String.class, (Object)((ParameterizedType)superToken.getType()).getActualTypeArguments()[0]);
        TypeTokenTest.assertEquals((Object)TypeToken.of(Base.class), (Object)TypeToken.of(Sub.class).getGenericSuperclass());
        TypeTokenTest.assertEquals((Object)TypeToken.of(Object.class), (Object)TypeToken.of(Sub[].class).getGenericSuperclass());
    }

    public <T> void testGetGenericSuperclass_typeVariable_unbounded() {
        TypeTokenTest.assertEquals((Object)TypeToken.of(Object.class), (Object)TypeToken.of((Type)new TypeCapture<T>(){}.capture()).getGenericSuperclass());
        TypeTokenTest.assertEquals((Object)TypeToken.of(Object.class), (Object)new TypeToken<T[]>(){}.getGenericSuperclass());
    }

    public <T extends ArrayList<String>> void testGetGenericSuperclass_typeVariable_boundIsClass() {
        TypeTokenTest.assertEquals((Object)new TypeToken<ArrayList<String>>(){}, (Object)TypeToken.of((Type)new TypeCapture<T>(){}.capture()).getGenericSuperclass());
        TypeTokenTest.assertEquals((Object)TypeToken.of(Object.class), (Object)new TypeToken<T[]>(){}.getGenericSuperclass());
    }

    public <T extends Enum<T>> void testGetGenericSuperclass_typeVariable_boundIsFBoundedClass() {
        TypeTokenTest.assertEquals((Object)new TypeToken<Enum<T>>(){}, (Object)TypeToken.of((Type)new TypeCapture<T>(){}.capture()).getGenericSuperclass());
        TypeTokenTest.assertEquals((Object)TypeToken.of(Object.class), (Object)new TypeToken<T[]>(){}.getGenericSuperclass());
    }

    public <T extends List<String> & CharSequence> void testGetGenericSuperclass_typeVariable_boundIsInterface() {
        TypeTokenTest.assertNull((Object)TypeToken.of((Type)new TypeCapture<T>(){}.capture()).getGenericSuperclass());
        TypeTokenTest.assertEquals((Object)TypeToken.of(Object.class), (Object)new TypeToken<T[]>(){}.getGenericSuperclass());
    }

    public <T extends ArrayList<String>, T1 extends T> void testGetGenericSuperclass_typeVariable_boundIsTypeVariableAndClass() {
        TypeTokenTest.assertEquals((Object)TypeToken.of((Type)new TypeCapture<T>(){}.capture()), (Object)TypeToken.of((Type)new TypeCapture<T1>(){}.capture()).getGenericSuperclass());
        TypeTokenTest.assertEquals((Object)TypeToken.of(Object.class), (Object)new TypeToken<T[]>(){}.getGenericSuperclass());
    }

    public <T extends List<String> & CharSequence, T1 extends T> void testGetGenericSuperclass_typeVariable_boundIsTypeVariableAndInterface() {
        TypeTokenTest.assertNull((Object)TypeToken.of((Type)new TypeCapture<T1>(){}.capture()).getGenericSuperclass());
        TypeTokenTest.assertEquals((Object)TypeToken.of(Object.class), (Object)new TypeToken<T1[]>(){}.getGenericSuperclass());
    }

    public void testGetGenericSuperclass_wildcard_lowerBounded() {
        TypeTokenTest.assertEquals((Object)TypeToken.of(Object.class), (Object)TypeToken.of((Type)Types.supertypeOf(String.class)).getGenericSuperclass());
        TypeTokenTest.assertEquals((Object)new TypeToken<Object>(){}, (Object)TypeToken.of((Type)Types.supertypeOf(String[].class)).getGenericSuperclass());
        TypeTokenTest.assertEquals((Object)new TypeToken<Object>(){}, (Object)TypeToken.of((Type)Types.supertypeOf(CharSequence.class)).getGenericSuperclass());
    }

    public void testGetGenericSuperclass_wildcard_boundIsClass() {
        TypeTokenTest.assertEquals((Object)TypeToken.of(Object.class), (Object)TypeToken.of((Type)Types.subtypeOf(Object.class)).getGenericSuperclass());
        TypeTokenTest.assertEquals((Object)new TypeToken<Object[]>(){}, (Object)TypeToken.of((Type)Types.subtypeOf(Object[].class)).getGenericSuperclass());
    }

    public void testGetGenericSuperclass_wildcard_boundIsInterface() {
        TypeTokenTest.assertNull((Object)TypeToken.of((Type)Types.subtypeOf(CharSequence.class)).getGenericSuperclass());
        TypeTokenTest.assertEquals((Object)new TypeToken<CharSequence[]>(){}, (Object)TypeToken.of((Type)Types.subtypeOf(CharSequence[].class)).getGenericSuperclass());
    }

    public <T> void testGetGenericInterfaces_typeVariable_unbounded() {
        Truth.assertThat((Iterable)TypeToken.of((Type)new TypeCapture<T>(){}.capture()).getGenericInterfaces()).isEmpty();
        TypeTokenTest.assertHasArrayInterfaces(new TypeToken<T[]>(){});
    }

    public <T extends NoInterface> void testGetGenericInterfaces_typeVariable_boundIsClass() {
        Truth.assertThat((Iterable)TypeToken.of((Type)new TypeCapture<T>(){}.capture()).getGenericInterfaces()).isEmpty();
        TypeTokenTest.assertHasArrayInterfaces(new TypeToken<T[]>(){});
    }

    public <T extends NoInterface> void testGetGenericInterfaces_typeVariable_boundsAreClassWithInterface() {
        TypeTokenTest.makeUnmodifiable(TypeToken.of((Type)new TypeCapture<T>(){}.capture()).getGenericInterfaces()).containsExactly(new Object[]{new TypeToken<Iterable<String>>(){}});
        TypeTokenTest.assertHasArrayInterfaces(new TypeToken<T[]>(){});
    }

    public <T extends CharSequence & Iterable<String>> void testGetGenericInterfaces_typeVariable_boundsAreInterfaces() {
        TypeTokenTest.makeUnmodifiable(TypeToken.of((Type)new TypeCapture<T>(){}.capture()).getGenericInterfaces()).containsExactly(new Object[]{TypeToken.of(CharSequence.class), new TypeToken<Iterable<String>>(){}});
        TypeTokenTest.assertHasArrayInterfaces(new TypeToken<T[]>(){});
    }

    public <T extends CharSequence & Iterable<T>> void testGetGenericInterfaces_typeVariable_boundsAreFBoundedInterfaces() {
        TypeTokenTest.makeUnmodifiable(TypeToken.of((Type)new TypeCapture<T>(){}.capture()).getGenericInterfaces()).containsExactly(new Object[]{TypeToken.of(CharSequence.class), new TypeToken<Iterable<T>>(){}});
        TypeTokenTest.assertHasArrayInterfaces(new TypeToken<T[]>(){});
    }

    public <T extends Base> void testGetGenericInterfaces_typeVariable_boundsAreClassWithFBoundedInterface() {
        TypeTokenTest.makeUnmodifiable(TypeToken.of((Type)new TypeCapture<T>(){}.capture()).getGenericInterfaces()).containsExactly(new Object[]{new TypeToken<Iterable<T>>(){}});
        TypeTokenTest.assertHasArrayInterfaces(new TypeToken<T[]>(){});
    }

    public <T extends NoInterface, T1 extends T, T2 extends T1> void testGetGenericInterfaces_typeVariable_boundIsTypeVariableAndClass() {
        Truth.assertThat((Iterable)TypeToken.of((Type)new TypeCapture<T2>(){}.capture()).getGenericInterfaces()).isEmpty();
        TypeTokenTest.assertHasArrayInterfaces(new TypeToken<T2[]>(){});
    }

    public <T extends Iterable<T>, T1 extends T, T2 extends T1> void testGetGenericInterfaces_typeVariable_boundIsTypeVariableAndInterface() {
        TypeTokenTest.makeUnmodifiable(TypeToken.of((Type)new TypeCapture<T2>(){}.capture()).getGenericInterfaces()).containsExactly(new Object[]{TypeToken.of((Type)new TypeCapture<T1>(){}.capture())});
        TypeTokenTest.assertHasArrayInterfaces(new TypeToken<T2[]>(){});
    }

    public void testGetGenericInterfaces_wildcard_lowerBounded() {
        Truth.assertThat((Iterable)TypeToken.of((Type)Types.supertypeOf(String.class)).getGenericInterfaces()).isEmpty();
        Truth.assertThat((Iterable)TypeToken.of((Type)Types.supertypeOf(String[].class)).getGenericInterfaces()).isEmpty();
    }

    public void testGetGenericInterfaces_wildcard_boundIsClass() {
        Truth.assertThat((Iterable)TypeToken.of((Type)Types.subtypeOf(Object.class)).getGenericInterfaces()).isEmpty();
        Truth.assertThat((Iterable)TypeToken.of((Type)Types.subtypeOf(Object[].class)).getGenericInterfaces()).isEmpty();
    }

    public void testGetGenericInterfaces_wildcard_boundIsInterface() {
        TypeToken<Iterable<String>> interfaceType = new TypeToken<Iterable<String>>(){};
        TypeTokenTest.makeUnmodifiable(TypeToken.of((Type)Types.subtypeOf((Type)interfaceType.getType())).getGenericInterfaces()).containsExactly(new Object[]{interfaceType});
        TypeTokenTest.assertHasArrayInterfaces(new TypeToken<Iterable<String>[]>(){});
    }

    public void testGetGenericInterfaces_noInterface() {
        Truth.assertThat((Iterable)new TypeToken<NoInterface>(){}.getGenericInterfaces()).isEmpty();
        TypeTokenTest.assertHasArrayInterfaces(new TypeToken<NoInterface[]>(){});
    }

    public void testGetGenericInterfaces_withInterfaces() {
        HashMap interfaceMap = Maps.newHashMap();
        for (TypeToken interfaceType : new TypeToken<Implementation<Integer, String>>(){}.getGenericInterfaces()) {
            interfaceMap.put(interfaceType.getRawType(), interfaceType.getType());
        }
        TypeTokenTest.assertEquals((Object)ImmutableMap.of(Iterable.class, (Object)new TypeToken<Iterable<String>>(){}.getType(), Map.class, (Object)new TypeToken<Map<Integer, String>>(){}.getType()), (Object)interfaceMap);
    }

    public void testAssignableClassToClass() {
        TypeToken<List> tokL = new TypeToken<List>(){};
        TypeTokenTest.assertTrue((boolean)tokL.isSupertypeOf(List.class));
        TypeTokenTest.assertTrue((boolean)tokL.isSupertypeOf(ArrayList.class));
        TypeTokenTest.assertFalse((boolean)tokL.isSupertypeOf(List[].class));
        TypeToken<Number> tokN = new TypeToken<Number>(){};
        TypeTokenTest.assertTrue((boolean)tokN.isSupertypeOf(Number.class));
        TypeTokenTest.assertTrue((boolean)tokN.isSupertypeOf(Integer.class));
    }

    public <T> void testAssignableParameterizedTypeToObject() {
        TypeTokenTest.assertTrue((boolean)TypeToken.of(Object.class).isSupertypeOf(TypeToken.of((Type)new TypeCapture<T>(){}.capture())));
        TypeTokenTest.assertFalse((boolean)TypeToken.of(Integer.TYPE).isSupertypeOf(TypeToken.of((Type)new TypeCapture<T>(){}.capture())));
    }

    public <T, T1 extends T> void testAssignableGenericArrayToGenericArray() {
        TypeTokenTest.assertTrue((boolean)new TypeToken<T[]>(){}.isSupertypeOf((TypeToken)new TypeToken<T[]>(){}));
        TypeTokenTest.assertTrue((boolean)new TypeToken<T[]>(){}.isSupertypeOf((TypeToken)new TypeToken<T1[]>(){}));
        TypeTokenTest.assertFalse((boolean)new TypeToken<T[]>(){}.isSupertypeOf((TypeToken)new TypeToken<T[][]>(){}));
    }

    public <T, T1 extends T> void testAssignableGenericArrayToClass() {
        TypeTokenTest.assertTrue((boolean)TypeToken.of(Object[].class.getSuperclass()).isSupertypeOf((TypeToken)new TypeToken<T[]>(){}));
        for (Class<?> interfaceType : Object[].class.getInterfaces()) {
            TypeTokenTest.assertTrue((boolean)TypeToken.of(interfaceType).isSupertypeOf((TypeToken)new TypeToken<T[]>(){}));
        }
        TypeTokenTest.assertTrue((boolean)TypeToken.of(Object.class).isSupertypeOf((TypeToken)new TypeToken<T[]>(){}));
        TypeTokenTest.assertFalse((boolean)TypeToken.of(String.class).isSupertypeOf((TypeToken)new TypeToken<T[]>(){}));
    }

    public void testAssignableWildcardBoundedByArrayToArrayClass() {
        WildcardType wildcardType = Types.subtypeOf(Object[].class);
        TypeTokenTest.assertTrue((boolean)TypeToken.of(Object[].class).isSupertypeOf((Type)wildcardType));
        TypeTokenTest.assertTrue((boolean)TypeToken.of(Object.class).isSupertypeOf((Type)wildcardType));
        TypeTokenTest.assertFalse((boolean)TypeToken.of((Type)wildcardType).isSupertypeOf((Type)wildcardType));
        TypeTokenTest.assertFalse((boolean)TypeToken.of(int[].class).isSupertypeOf((Type)wildcardType));
    }

    public void testAssignableWildcardTypeParameterToClassTypeParameter() {
        TypeToken<Iterable<? extends Object[]>> wildcardType = new TypeToken<Iterable<? extends Object[]>>(){};
        TypeTokenTest.assertFalse((boolean)new TypeToken<Iterable<Object[]>>(){}.isSupertypeOf((TypeToken)wildcardType));
        TypeTokenTest.assertFalse((boolean)new TypeToken<Iterable<Object>>(){}.isSupertypeOf((TypeToken)wildcardType));
        TypeTokenTest.assertTrue((boolean)wildcardType.isSupertypeOf((TypeToken)wildcardType));
        TypeTokenTest.assertFalse((boolean)new TypeToken<Iterable<int[]>>(){}.isSupertypeOf((TypeToken)wildcardType));
    }

    public void testAssignableArrayClassToBoundedWildcard() {
        TypeToken subtypeOfArray = TypeToken.of((Type)Types.subtypeOf(Object[].class));
        TypeToken supertypeOfArray = TypeToken.of((Type)Types.supertypeOf(Object[].class));
        TypeTokenTest.assertFalse((boolean)subtypeOfArray.isSupertypeOf(Object[].class));
        TypeTokenTest.assertFalse((boolean)subtypeOfArray.isSupertypeOf(Object[][].class));
        TypeTokenTest.assertFalse((boolean)subtypeOfArray.isSupertypeOf(String[].class));
        TypeTokenTest.assertTrue((boolean)supertypeOfArray.isSupertypeOf(Object[].class));
        TypeTokenTest.assertFalse((boolean)supertypeOfArray.isSupertypeOf(Object.class));
        TypeTokenTest.assertTrue((boolean)supertypeOfArray.isSupertypeOf(Object[][].class));
        TypeTokenTest.assertTrue((boolean)supertypeOfArray.isSupertypeOf(String[].class));
    }

    public void testAssignableClassTypeParameterToWildcardTypeParameter() {
        TypeToken<Iterable<? extends Object[]>> subtypeOfArray = new TypeToken<Iterable<? extends Object[]>>(){};
        TypeToken<Iterable<? super Object[]>> supertypeOfArray = new TypeToken<Iterable<? super Object[]>>(){};
        TypeTokenTest.assertTrue((boolean)subtypeOfArray.isSupertypeOf((TypeToken)new TypeToken<Iterable<Object[]>>(){}));
        TypeTokenTest.assertTrue((boolean)subtypeOfArray.isSupertypeOf((TypeToken)new TypeToken<Iterable<Object[][]>>(){}));
        TypeTokenTest.assertTrue((boolean)subtypeOfArray.isSupertypeOf((TypeToken)new TypeToken<Iterable<String[]>>(){}));
        TypeTokenTest.assertTrue((boolean)supertypeOfArray.isSupertypeOf((TypeToken)new TypeToken<Iterable<Object[]>>(){}));
        TypeTokenTest.assertTrue((boolean)supertypeOfArray.isSupertypeOf((TypeToken)new TypeToken<Iterable<Object>>(){}));
        TypeTokenTest.assertFalse((boolean)supertypeOfArray.isSupertypeOf((TypeToken)new TypeToken<Iterable<Object[][]>>(){}));
        TypeTokenTest.assertFalse((boolean)supertypeOfArray.isSupertypeOf((TypeToken)new TypeToken<Iterable<String[]>>(){}));
    }

    public void testAssignableNonParameterizedClassToWildcard() {
        TypeToken supertypeOfString = TypeToken.of((Type)Types.supertypeOf(String.class));
        TypeTokenTest.assertFalse((boolean)supertypeOfString.isSupertypeOf(supertypeOfString));
        TypeTokenTest.assertFalse((boolean)supertypeOfString.isSupertypeOf(Object.class));
        TypeTokenTest.assertFalse((boolean)supertypeOfString.isSupertypeOf(CharSequence.class));
        TypeTokenTest.assertTrue((boolean)supertypeOfString.isSupertypeOf(String.class));
        TypeTokenTest.assertTrue((boolean)supertypeOfString.isSupertypeOf((Type)Types.subtypeOf(String.class)));
    }

    public void testAssignableWildcardBoundedByIntArrayToArrayClass() {
        WildcardType wildcardType = Types.subtypeOf(int[].class);
        TypeTokenTest.assertTrue((boolean)TypeToken.of(int[].class).isSupertypeOf((Type)wildcardType));
        TypeTokenTest.assertTrue((boolean)TypeToken.of(Object.class).isSupertypeOf((Type)wildcardType));
        TypeTokenTest.assertFalse((boolean)TypeToken.of((Type)wildcardType).isSupertypeOf((Type)wildcardType));
        TypeTokenTest.assertFalse((boolean)TypeToken.of(Object[].class).isSupertypeOf((Type)wildcardType));
    }

    public void testAssignableWildcardTypeParameterBoundedByIntArrayToArrayClassTypeParameter() {
        TypeToken<Iterable<? extends int[]>> wildcardType = new TypeToken<Iterable<? extends int[]>>(){};
        TypeTokenTest.assertFalse((boolean)new TypeToken<Iterable<int[]>>(){}.isSupertypeOf((TypeToken)wildcardType));
        TypeTokenTest.assertFalse((boolean)new TypeToken<Iterable<Object>>(){}.isSupertypeOf((TypeToken)wildcardType));
        TypeTokenTest.assertTrue((boolean)wildcardType.isSupertypeOf((TypeToken)wildcardType));
        TypeTokenTest.assertFalse((boolean)new TypeToken<Iterable<Object[]>>(){}.isSupertypeOf((TypeToken)wildcardType));
    }

    public void testAssignableWildcardToWildcard() {
        TypeToken subtypeOfArray = TypeToken.of((Type)Types.subtypeOf(Object[].class));
        TypeToken supertypeOfArray = TypeToken.of((Type)Types.supertypeOf(Object[].class));
        TypeTokenTest.assertTrue((boolean)supertypeOfArray.isSupertypeOf(subtypeOfArray));
        TypeTokenTest.assertFalse((boolean)supertypeOfArray.isSupertypeOf(supertypeOfArray));
        TypeTokenTest.assertFalse((boolean)subtypeOfArray.isSupertypeOf(subtypeOfArray));
        TypeTokenTest.assertFalse((boolean)subtypeOfArray.isSupertypeOf(supertypeOfArray));
    }

    public void testAssignableWildcardTypeParameterToWildcardTypeParameter() {
        TypeToken<Iterable<? extends Object[]>> subtypeOfArray = new TypeToken<Iterable<? extends Object[]>>(){};
        TypeToken<Iterable<? super Object[]>> supertypeOfArray = new TypeToken<Iterable<? super Object[]>>(){};
        TypeTokenTest.assertFalse((boolean)supertypeOfArray.isSupertypeOf((TypeToken)subtypeOfArray));
        TypeTokenTest.assertTrue((boolean)supertypeOfArray.isSupertypeOf((TypeToken)supertypeOfArray));
        TypeTokenTest.assertTrue((boolean)subtypeOfArray.isSupertypeOf((TypeToken)subtypeOfArray));
        TypeTokenTest.assertFalse((boolean)subtypeOfArray.isSupertypeOf((TypeToken)supertypeOfArray));
    }

    public <T> void testAssignableGenericArrayToArrayClass() {
        TypeTokenTest.assertTrue((boolean)TypeToken.of(Object[].class).isSupertypeOf((TypeToken)new TypeToken<T[]>(){}));
        TypeTokenTest.assertTrue((boolean)TypeToken.of(Object[].class).isSupertypeOf((TypeToken)new TypeToken<T[][]>(){}));
        TypeTokenTest.assertTrue((boolean)TypeToken.of(Object[][].class).isSupertypeOf((TypeToken)new TypeToken<T[][]>(){}));
    }

    public void testAssignableParameterizedTypeToClass() {
        TypeToken<List> tokL = new TypeToken<List>(){};
        TypeTokenTest.assertTrue((boolean)tokL.isSupertypeOf(StringList.class));
        TypeTokenTest.assertTrue((boolean)tokL.isSupertypeOf(StringList.class.getGenericInterfaces()[0]));
        TypeToken<Second> tokS = new TypeToken<Second>(){};
        TypeTokenTest.assertTrue((boolean)tokS.isSupertypeOf(Second.class));
        TypeTokenTest.assertTrue((boolean)tokS.isSupertypeOf(Third.class.getGenericSuperclass()));
    }

    public void testAssignableArrayToClass() {
        TypeToken<List[]> tokL = new TypeToken<List[]>(){};
        TypeTokenTest.assertTrue((boolean)tokL.isSupertypeOf(List[].class));
        TypeTokenTest.assertFalse((boolean)tokL.isSupertypeOf(List.class));
        TypeToken<Second[]> tokS = new TypeToken<Second[]>(){};
        TypeTokenTest.assertTrue((boolean)tokS.isSupertypeOf(Second[].class));
        TypeTokenTest.assertTrue((boolean)tokS.isSupertypeOf(Third[].class));
    }

    public void testAssignableTokenToClass() {
        TypeToken<List> tokL = new TypeToken<List>(){};
        TypeTokenTest.assertTrue((boolean)tokL.isSupertypeOf((TypeToken)new TypeToken<List>(){}));
        TypeTokenTest.assertTrue((boolean)tokL.isSupertypeOf((TypeToken)new TypeToken<List<String>>(){}));
        TypeTokenTest.assertTrue((boolean)tokL.isSupertypeOf(new TypeToken<List<?>>(){}));
        TypeToken<Second> tokS = new TypeToken<Second>(){};
        TypeTokenTest.assertTrue((boolean)tokS.isSupertypeOf((TypeToken)new TypeToken<Second>(){}));
        TypeTokenTest.assertTrue((boolean)tokS.isSupertypeOf((TypeToken)new TypeToken<Third>(){}));
        TypeTokenTest.assertTrue((boolean)tokS.isSupertypeOf((TypeToken)new TypeToken<Third<String, Integer>>(){}));
        TypeToken<List[]> tokA = new TypeToken<List[]>(){};
        TypeTokenTest.assertTrue((boolean)tokA.isSupertypeOf((TypeToken)new TypeToken<List[]>(){}));
        TypeTokenTest.assertTrue((boolean)tokA.isSupertypeOf((TypeToken)new TypeToken<List<String>[]>(){}));
        TypeTokenTest.assertTrue((boolean)tokA.isSupertypeOf((TypeToken)new TypeToken<List<?>[]>(){}));
    }

    public void testAssignableClassToType() {
        TypeToken<List<String>> tokenL = new TypeToken<List<String>>(){};
        TypeTokenTest.assertTrue((boolean)tokenL.isSupertypeOf(StringList.class));
        TypeTokenTest.assertFalse((boolean)tokenL.isSupertypeOf(List.class));
        TypeToken<First<String>> tokenF = new TypeToken<First<String>>(){};
        TypeTokenTest.assertTrue((boolean)tokenF.isSupertypeOf(ConcreteIS.class));
        TypeTokenTest.assertFalse((boolean)tokenF.isSupertypeOf(ConcreteSI.class));
    }

    public void testAssignableClassToArrayType() {
        TypeToken<List<String>[]> tokenL = new TypeToken<List<String>[]>(){};
        TypeTokenTest.assertTrue((boolean)tokenL.isSupertypeOf(StringList[].class));
        TypeTokenTest.assertFalse((boolean)tokenL.isSupertypeOf(List[].class));
    }

    public void testAssignableParameterizedTypeToType() {
        TypeToken<List<String>> tokenL = new TypeToken<List<String>>(){};
        TypeTokenTest.assertTrue((boolean)tokenL.isSupertypeOf(StringList.class.getGenericInterfaces()[0]));
        TypeTokenTest.assertFalse((boolean)tokenL.isSupertypeOf(IntegerList.class.getGenericInterfaces()[0]));
        TypeToken<First<String>> tokenF = new TypeToken<First<String>>(){};
        TypeTokenTest.assertTrue((boolean)tokenF.isSupertypeOf(ConcreteIS.class.getGenericSuperclass()));
        TypeTokenTest.assertFalse((boolean)tokenF.isSupertypeOf(ConcreteSI.class.getGenericSuperclass()));
    }

    public void testGenericArrayTypeToArrayType() {
        TypeToken<List<String>[]> tokL = new TypeToken<List<String>[]>(){};
        TypeToken<ArrayList<String>[]> token = new TypeToken<ArrayList<String>[]>(){};
        TypeTokenTest.assertTrue((boolean)tokL.isSupertypeOf(tokL.getType()));
        TypeTokenTest.assertTrue((boolean)tokL.isSupertypeOf(token.getType()));
    }

    public void testAssignableTokenToType() {
        TypeToken<List<String>> tokenL = new TypeToken<List<String>>(){};
        TypeTokenTest.assertTrue((boolean)tokenL.isSupertypeOf((TypeToken)new TypeToken<List<String>>(){}));
        TypeTokenTest.assertTrue((boolean)tokenL.isSupertypeOf((TypeToken)new TypeToken<ArrayList<String>>(){}));
        TypeTokenTest.assertTrue((boolean)tokenL.isSupertypeOf((TypeToken)new TypeToken<StringList>(){}));
        TypeToken<First<String>> tokenF = new TypeToken<First<String>>(){};
        TypeTokenTest.assertTrue((boolean)tokenF.isSupertypeOf((TypeToken)new TypeToken<Second<String>>(){}));
        TypeTokenTest.assertTrue((boolean)tokenF.isSupertypeOf((TypeToken)new TypeToken<Third<String, Integer>>(){}));
        TypeTokenTest.assertFalse((boolean)tokenF.isSupertypeOf((TypeToken)new TypeToken<Third<Integer, String>>(){}));
        TypeTokenTest.assertTrue((boolean)tokenF.isSupertypeOf((TypeToken)new TypeToken<Fourth<Integer, String>>(){}));
        TypeTokenTest.assertFalse((boolean)tokenF.isSupertypeOf((TypeToken)new TypeToken<Fourth<String, Integer>>(){}));
        TypeTokenTest.assertTrue((boolean)tokenF.isSupertypeOf((TypeToken)new TypeToken<ConcreteIS>(){}));
        TypeTokenTest.assertFalse((boolean)tokenF.isSupertypeOf((TypeToken)new TypeToken<ConcreteSI>(){}));
    }

    public void testAssignableWithWildcards() {
        TypeToken unboundedToken = new TypeToken<List<?>>(){};
        TypeToken<List<? extends Number>> upperBoundToken = new TypeToken<List<? extends Number>>(){};
        TypeToken<List<? super Number>> lowerBoundToken = new TypeToken<List<? super Number>>(){};
        TypeToken<List<Number>> concreteToken = new TypeToken<List<Number>>(){};
        TypeToken<List<Integer>> subtypeToken = new TypeToken<List<Integer>>(){};
        TypeToken<List<Serializable>> supertypeToken = new TypeToken<List<Serializable>>(){};
        ImmutableList allTokens = ImmutableList.of((Object)unboundedToken, (Object)upperBoundToken, (Object)lowerBoundToken, (Object)concreteToken, (Object)subtypeToken, (Object)supertypeToken);
        for (TypeToken typeToken : allTokens) {
            TypeTokenTest.assertTrue((String)typeToken.toString(), (boolean)unboundedToken.isSupertypeOf(typeToken));
        }
        TypeTokenTest.assertFalse((boolean)upperBoundToken.isSupertypeOf(unboundedToken));
        TypeTokenTest.assertTrue((boolean)upperBoundToken.isSupertypeOf((TypeToken)upperBoundToken));
        TypeTokenTest.assertFalse((boolean)upperBoundToken.isSupertypeOf((TypeToken)lowerBoundToken));
        TypeTokenTest.assertTrue((boolean)upperBoundToken.isSupertypeOf((TypeToken)concreteToken));
        TypeTokenTest.assertTrue((boolean)upperBoundToken.isSupertypeOf((TypeToken)subtypeToken));
        TypeTokenTest.assertFalse((boolean)upperBoundToken.isSupertypeOf((TypeToken)supertypeToken));
        TypeTokenTest.assertFalse((boolean)lowerBoundToken.isSupertypeOf(unboundedToken));
        TypeTokenTest.assertFalse((boolean)lowerBoundToken.isSupertypeOf((TypeToken)upperBoundToken));
        TypeTokenTest.assertTrue((boolean)lowerBoundToken.isSupertypeOf((TypeToken)lowerBoundToken));
        TypeTokenTest.assertTrue((boolean)lowerBoundToken.isSupertypeOf((TypeToken)concreteToken));
        TypeTokenTest.assertFalse((boolean)lowerBoundToken.isSupertypeOf((TypeToken)subtypeToken));
        TypeTokenTest.assertTrue((boolean)lowerBoundToken.isSupertypeOf((TypeToken)supertypeToken));
        for (TypeToken typeToken : allTokens) {
            TypeTokenTest.assertEquals((String)typeToken.toString(), (typeToken == concreteToken ? 1 : 0) != 0, (boolean)concreteToken.isSupertypeOf(typeToken));
        }
        for (TypeToken typeToken : allTokens) {
            TypeTokenTest.assertEquals((String)typeToken.toString(), (typeToken == subtypeToken ? 1 : 0) != 0, (boolean)subtypeToken.isSupertypeOf(typeToken));
        }
        for (TypeToken typeToken : allTokens) {
            TypeTokenTest.assertEquals((String)typeToken.toString(), (typeToken == supertypeToken ? 1 : 0) != 0, (boolean)supertypeToken.isSupertypeOf(typeToken));
        }
    }

    public <N1 extends Number, N2 extends Number, N11 extends N1> void testisSupertypeOf_typeVariable() {
        TypeTokenTest.assertAssignable(TypeToken.of((Type)new TypeCapture<N1>(){}.capture()), TypeToken.of((Type)new TypeCapture<N1>(){}.capture()));
        TypeTokenTest.assertNotAssignable(new TypeToken<List<N11>>(){}, new TypeToken<List<N1>>(){});
        TypeTokenTest.assertNotAssignable(new TypeToken<Number>(){}, TypeToken.of((Type)new TypeCapture<N1>(){}.capture()));
        TypeTokenTest.assertAssignable(TypeToken.of((Type)new TypeCapture<N11>(){}.capture()), TypeToken.of((Type)new TypeCapture<N1>(){}.capture()));
        TypeTokenTest.assertNotAssignable(TypeToken.of((Type)new TypeCapture<N2>(){}.capture()), TypeToken.of((Type)new TypeCapture<N1>(){}.capture()));
    }

    public <N1 extends Number, N2 extends Number, N11 extends N1> void testisSupertypeOf_equalWildcardTypes() {
        TypeTokenTest.assertAssignable(new TypeToken<List<? extends N1>>(){}, new TypeToken<List<? extends N1>>(){});
        TypeTokenTest.assertAssignable(new TypeToken<List<? super N1>>(){}, new TypeToken<List<? super N1>>(){});
        TypeTokenTest.assertAssignable(new TypeToken<List<? extends Number>>(){}, new TypeToken<List<? extends Number>>(){});
        TypeTokenTest.assertAssignable(new TypeToken<List<? super Number>>(){}, new TypeToken<List<? super Number>>(){});
    }

    public <N> void testisSupertypeOf_wildcard_noBound() {
        TypeTokenTest.assertAssignable(new TypeToken<List<? super N>>(){}, new TypeToken<List<?>>(){});
        TypeTokenTest.assertAssignable(new TypeToken<List<N>>(){}, new TypeToken<List<?>>(){});
    }

    public <N1 extends Number, N2 extends Number, N11 extends N1> void testisSupertypeOf_wildcardType_upperBoundMatch() {
        TypeTokenTest.assertAssignable(new TypeToken<List<N11>>(){}, new TypeToken<List<? extends N1>>(){});
        TypeTokenTest.assertNotAssignable(new TypeToken<List<N1>>(){}, new TypeToken<List<? extends N11>>(){});
        TypeTokenTest.assertNotAssignable(new TypeToken<List<Number>>(){}, new TypeToken<List<? extends N11>>(){});
        TypeTokenTest.assertAssignable(new TypeToken<List<N1>>(){}, new TypeToken<List<? extends Number>>(){});
        TypeTokenTest.assertAssignable(new TypeToken<ArrayList<N1>>(){}, new TypeToken<List<? extends Number>>(){});
        TypeTokenTest.assertAssignable(new TypeToken<List<? extends N11>>(){}, new TypeToken<List<? extends Number>>(){});
    }

    public <N1 extends Number, N2 extends Number, N11 extends N1> void testisSupertypeOf_wildcardType_lowerBoundMatch() {
        TypeTokenTest.assertAssignable(new TypeToken<List<N1>>(){}, new TypeToken<List<? super N11>>(){});
        TypeTokenTest.assertAssignable(new TypeToken<ArrayList<Number>>(){}, new TypeToken<List<? super N1>>(){});
        TypeTokenTest.assertNotAssignable(new TypeToken<ArrayList<? super N11>>(){}, new TypeToken<List<? super Number>>(){});
        TypeTokenTest.assertAssignable(new TypeToken<ArrayList<? super N1>>(){}, new TypeToken<List<? super N11>>(){});
        TypeTokenTest.assertAssignable(new TypeToken<ArrayList<? super Number>>(){}, new TypeToken<List<? super N11>>(){});
        TypeTokenTest.assertNotAssignable(new TypeToken<ArrayList<N11>>(){}, new TypeToken<List<? super Number>>(){});
        TypeTokenTest.assertAssignable(new TypeToken<ArrayList<Number>>(){}, new TypeToken<List<? super Number>>(){});
        TypeTokenTest.assertAssignable(new TypeToken<ArrayList<Object>>(){}, new TypeToken<List<? super Number>>(){});
    }

    public <L extends List<R>, R extends List<L>> void testisSupertypeOf_recursiveTypeVariableBounds() {
        TypeTokenTest.assertAssignable(TypeToken.of((Type)new TypeCapture<L>(){}.capture()), TypeToken.of((Type)new TypeCapture<L>(){}.capture()));
        TypeTokenTest.assertNotAssignable(TypeToken.of((Type)new TypeCapture<R>(){}.capture()), TypeToken.of((Type)new TypeCapture<L>(){}.capture()));
        TypeTokenTest.assertAssignable(TypeToken.of((Type)new TypeCapture<L>(){}.capture()), new TypeToken<List<R>>(){});
    }

    public void testisSupertypeOf_resolved() {
        TypeTokenTest.assertFalse((boolean)Assignability.of().isAssignable());
        TypeTokenTest.assertTrue((boolean)new Assignability<Integer, Integer>(){}.isAssignable());
        TypeTokenTest.assertTrue((boolean)new Assignability<Integer, Object>(){}.isAssignable());
        TypeTokenTest.assertFalse((boolean)new Assignability<Integer, String>(){}.isAssignable());
        TypeTokenTest.assignabilityTestWithTypeVariables();
    }

    public <From extends String> void testMultipleTypeBoundsAssignability() {
        TypeTokenTest.assertTrue((boolean)new Assignability<From, String>(){}.isAssignable());
        TypeTokenTest.assertFalse((boolean)new Assignability<From, Number>(){}.isAssignable());
        TypeTokenTest.assertTrue((boolean)new Assignability<From, Iterable<? extends CharSequence>>(){}.isAssignable());
        TypeTokenTest.assertFalse((boolean)new Assignability<From, Iterable<Object>>(){}.isAssignable());
    }

    private static <N1 extends Number, N11 extends N1> void assignabilityTestWithTypeVariables() {
        TypeTokenTest.assertTrue((boolean)new Assignability<N11, N1>(){}.isAssignable());
        TypeTokenTest.assertTrue((boolean)new Assignability<N11, Number>(){}.isAssignable());
        TypeTokenTest.assertFalse((boolean)new Assignability<Number, N11>(){}.isAssignable());
    }

    public void testIsArray_arrayClasses() {
        TypeTokenTest.assertTrue((boolean)TypeToken.of(Object[].class).isArray());
        TypeTokenTest.assertTrue((boolean)TypeToken.of(Object[][].class).isArray());
        TypeTokenTest.assertTrue((boolean)TypeToken.of(char[].class).isArray());
        TypeTokenTest.assertTrue((boolean)TypeToken.of(char[][].class).isArray());
        TypeTokenTest.assertTrue((boolean)TypeToken.of(byte[].class).isArray());
        TypeTokenTest.assertTrue((boolean)TypeToken.of(short[].class).isArray());
        TypeTokenTest.assertTrue((boolean)TypeToken.of(int[].class).isArray());
        TypeTokenTest.assertTrue((boolean)TypeToken.of(long[].class).isArray());
        TypeTokenTest.assertTrue((boolean)TypeToken.of(float[].class).isArray());
        TypeTokenTest.assertTrue((boolean)TypeToken.of(double[].class).isArray());
        TypeTokenTest.assertFalse((boolean)TypeToken.of(Object.class).isArray());
        TypeTokenTest.assertFalse((boolean)TypeToken.of(Void.TYPE).isArray());
    }

    public <T> void testIsArray_genericArrayClasses() {
        TypeTokenTest.assertFalse((boolean)TypeToken.of((Type)new TypeCapture<T>(){}.capture()).isArray());
        TypeTokenTest.assertTrue((boolean)new TypeToken<T[]>(){}.isArray());
        TypeTokenTest.assertTrue((boolean)new TypeToken<T[][]>(){}.isArray());
    }

    public void testIsArray_wildcardType() {
        TypeTokenTest.assertTrue((boolean)TypeToken.of((Type)Types.subtypeOf(Object[].class)).isArray());
        TypeTokenTest.assertTrue((boolean)TypeToken.of((Type)Types.subtypeOf(int[].class)).isArray());
        TypeTokenTest.assertFalse((boolean)TypeToken.of((Type)Types.subtypeOf(Object.class)).isArray());
        TypeTokenTest.assertFalse((boolean)TypeToken.of((Type)Types.supertypeOf(Object[].class)).isArray());
    }

    public <T extends Integer> void testPrimitiveWrappingAndUnwrapping() {
        for (Class type : Primitives.allPrimitiveTypes()) {
            TypeTokenTest.assertIsPrimitive(TypeToken.of((Class)type));
        }
        for (Class type : Primitives.allWrapperTypes()) {
            TypeTokenTest.assertIsWrapper(TypeToken.of((Class)type));
        }
        TypeTokenTest.assertNotPrimitiveNorWrapper(TypeToken.of(String.class));
        TypeTokenTest.assertNotPrimitiveNorWrapper(TypeToken.of(Object[].class));
        TypeTokenTest.assertNotPrimitiveNorWrapper(TypeToken.of((Type)Types.subtypeOf(Object.class)));
        TypeTokenTest.assertNotPrimitiveNorWrapper(new TypeToken<List<String>>(){});
        TypeTokenTest.assertNotPrimitiveNorWrapper(TypeToken.of((Type)new TypeCapture<T>(){}.capture()));
    }

    public void testGetComponentType_arrayClasses() {
        TypeTokenTest.assertEquals(Object.class, (Object)TypeToken.of(Object[].class).getComponentType().getType());
        TypeTokenTest.assertEquals(Object[].class, (Object)TypeToken.of(Object[][].class).getComponentType().getType());
        TypeTokenTest.assertEquals(Character.TYPE, (Object)TypeToken.of(char[].class).getComponentType().getType());
        TypeTokenTest.assertEquals(char[].class, (Object)TypeToken.of(char[][].class).getComponentType().getType());
        TypeTokenTest.assertEquals(Byte.TYPE, (Object)TypeToken.of(byte[].class).getComponentType().getType());
        TypeTokenTest.assertEquals(Short.TYPE, (Object)TypeToken.of(short[].class).getComponentType().getType());
        TypeTokenTest.assertEquals(Integer.TYPE, (Object)TypeToken.of(int[].class).getComponentType().getType());
        TypeTokenTest.assertEquals(Long.TYPE, (Object)TypeToken.of(long[].class).getComponentType().getType());
        TypeTokenTest.assertEquals(Float.TYPE, (Object)TypeToken.of(float[].class).getComponentType().getType());
        TypeTokenTest.assertEquals(Double.TYPE, (Object)TypeToken.of(double[].class).getComponentType().getType());
        TypeTokenTest.assertNull((Object)TypeToken.of(Object.class).getComponentType());
        TypeTokenTest.assertNull((Object)TypeToken.of(Void.TYPE).getComponentType());
    }

    public <T> void testGetComponentType_genericArrayClasses() {
        TypeTokenTest.assertNull((Object)TypeToken.of((Type)new TypeCapture<T>(){}.capture()).getComponentType());
        TypeTokenTest.assertEquals((Object)TypeToken.of((Type)new TypeCapture<T>(){}.capture()), (Object)new TypeToken<T[]>(){}.getComponentType());
        TypeTokenTest.assertEquals((Object)new TypeToken<T[]>(){}, (Object)new TypeToken<T[][]>(){}.getComponentType());
    }

    public void testGetComponentType_wildcardType() {
        TypeTokenTest.assertEquals((Object)Types.subtypeOf(Object.class), (Object)TypeToken.of((Type)Types.subtypeOf(Object[].class)).getComponentType().getType());
        TypeTokenTest.assertEquals((Object)Types.subtypeOf(Object[].class), (Object)Types.newArrayType((Type)TypeToken.of((Type)Types.subtypeOf(Object[].class)).getComponentType().getType()));
        TypeTokenTest.assertEquals(Integer.TYPE, (Object)TypeToken.of((Type)Types.subtypeOf(int[].class)).getComponentType().getType());
        TypeTokenTest.assertNull((Object)TypeToken.of((Type)Types.subtypeOf(Object.class)).getComponentType());
        TypeTokenTest.assertNull((Object)TypeToken.of((Type)Types.supertypeOf(Object[].class)).getComponentType());
    }

    public void testImplicitUpperBoundForWildcards() {
        TypeTokenTest.assertAssignable(new TypeToken<NumberList<? extends Number>>(){}, new TypeToken<NumberList<?>>(){});
        TypeTokenTest.assertAssignable(new TypeToken<NumberList<? super Integer>>(){}, new TypeToken<NumberList<?>>(){});
    }

    public <T extends Readable & Appendable> void testMultiBound() {
        TypeTokenTest.assertAssignable(new TypeToken<List<T>>(){}, new TypeToken<List<? extends Readable>>(){});
        TypeTokenTest.assertAssignable(new TypeToken<List<T>>(){}, new TypeToken<List<? extends Appendable>>(){});
    }

    public void testToGenericType() {
        TypeTokenTest.assertEquals((Object)TypeToken.of(String.class), (Object)TypeToken.toGenericType(String.class));
        TypeTokenTest.assertEquals((Object)new TypeToken<int[]>(){}, (Object)TypeToken.toGenericType(int[].class));
        TypeToken genericType = TypeToken.toGenericType(Iterable.class);
        TypeTokenTest.assertEquals(Iterable.class, (Object)genericType.getRawType());
        TypeTokenTest.assertEquals((Object)Types.newParameterizedType(Iterable.class, (Type[])new Type[]{Iterable.class.getTypeParameters()[0]}), (Object)genericType.getType());
    }

    public void testGetSupertype_withTypeVariable() {
        ParameterizedType expectedType = Types.newParameterizedType(Iterable.class, (Type[])new Type[]{Types.newParameterizedType(List.class, (Type[])new Type[]{ListIterable.class.getTypeParameters()[0]})});
        TypeTokenTest.assertEquals((Object)expectedType, (Object)TypeToken.of(ListIterable.class).getSupertype(Iterable.class).getType());
    }

    public <A, T extends Number> void testGetSupertype_typeVariableWithMultipleBounds() {
        TypeTokenTest.assertEquals(Number.class, (Object)new TypeToken<T>(((Object)((Object)this)).getClass()){}.getSupertype(Number.class).getType());
        TypeTokenTest.assertEquals((Object)new TypeToken<Iterable<A>>(){}, (Object)new TypeToken<T>(((Object)((Object)this)).getClass()){}.getSupertype(Iterable.class));
    }

    public void testGetSupertype_withoutTypeVariable() {
        ParameterizedType expectedType = Types.newParameterizedType(Iterable.class, (Type[])new Type[]{Types.newParameterizedType(List.class, (Type[])new Type[]{String.class})});
        TypeTokenTest.assertEquals((Object)expectedType, (Object)TypeToken.of(StringListIterable.class).getSupertype(Iterable.class).getType());
    }

    public void testGetSupertype_chained() {
        TypeToken listIterableType = TypeToken.of(StringListIterable.class).getSupertype(ListIterable.class);
        ParameterizedType expectedType = Types.newParameterizedType(Iterable.class, (Type[])new Type[]{Types.newParameterizedType(List.class, (Type[])new Type[]{String.class})});
        TypeTokenTest.assertEquals((Object)expectedType, (Object)listIterableType.getSupertype(Iterable.class).getType());
    }

    public void testGetSupertype_withArray() {
        TypeTokenTest.assertEquals((Object)new TypeToken<Iterable<List<String>>[]>(){}, (Object)TypeToken.of(StringListIterable[].class).getSupertype(Iterable[].class));
        TypeTokenTest.assertEquals(int[].class, (Object)TypeToken.of(int[].class).getSupertype(int[].class).getType());
        TypeTokenTest.assertEquals(Object.class, (Object)TypeToken.of(int[].class).getSupertype(Object.class).getType());
        TypeTokenTest.assertEquals(int[][].class, (Object)TypeToken.of(int[][].class).getSupertype(int[][].class).getType());
        TypeTokenTest.assertEquals(Object[].class, (Object)TypeToken.of(String[].class).getSupertype(Object[].class).getType());
        TypeTokenTest.assertEquals(Object.class, (Object)TypeToken.of(String[].class).getSupertype(Object.class).getType());
    }

    public void testGetSupertype_fromWildcard() {
        TypeToken type = TypeToken.of((Type)Types.subtypeOf((Type)new TypeToken<List<String>>(){}.getType()));
        TypeTokenTest.assertEquals((Object)new TypeToken<Iterable<String>>(){}, (Object)type.getSupertype(Iterable.class));
    }

    public <T extends Iterable<String>> void testGetSupertype_fromTypeVariable() {
        TypeToken typeVariableToken = TypeToken.of((Type)new TypeCapture<T>(){}.capture());
        TypeTokenTest.assertEquals((Object)new TypeToken<Iterable<String>>(){}, (Object)typeVariableToken.getSupertype(Iterable.class));
    }

    public void testGetSupertype_fromRawClass() {
        TypeTokenTest.assertEquals((Object)Types.newParameterizedType(Iterable.class, (Type[])new Type[]{List.class.getTypeParameters()[0]}), (Object)new TypeToken<List>(){}.getSupertype(Iterable.class).getType());
    }

    public void testGetSupertype_notSupertype() {
        try {
            new TypeToken<List<String>>(){}.getSupertype(String.class);
            TypeTokenTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetSupertype_fromArray() {
        TypeTokenTest.assertEquals((Object)new TypeToken<Iterable<String>[]>(){}, (Object)new TypeToken<List<String>[]>(){}.getSupertype(Iterable[].class));
    }

    public void testGetSupertype_fullyGenericType() {
        ParameterizedType expectedType = Types.newParameterizedType(Map.class, (Type[])new Type[]{ListMap.class.getTypeParameters()[0], Types.newParameterizedType(List.class, (Type[])new Type[]{ListMap.class.getTypeParameters()[1]})});
        TypeTokenTest.assertEquals((Object)expectedType, (Object)TypeToken.of(ListMap.class).getSupertype(Map.class).getType());
    }

    public void testGetSupertype_fullySpecializedType() {
        Type expectedType = new TypeToken<Map<String, List<Object>>>(){}.getType();
        TypeTokenTest.assertEquals((Object)expectedType, (Object)new TypeToken<ListMap<String, Object>>(){}.getSupertype(Map.class).getType());
    }

    public <V> void testGetSupertype_partiallySpecializedType() {
        Type expectedType = new TypeToken<Map<String, List<V>>>(){}.getType();
        TypeTokenTest.assertEquals((Object)expectedType, (Object)new TypeToken<StringListMap<V>>(){}.getSupertype(Map.class).getType());
    }

    public void testGetSubtype_withTypeVariable() {
        TypeTokenTest.assertEquals((Object)new TypeToken<ListIterable<String>>(){}, (Object)new TypeToken<Iterable<List<String>>>(){}.getSubtype(ListIterable.class));
        TypeTokenTest.assertEquals((Object)new TypeToken<ListArrayIterable<String>>(){}, (Object)new TypeToken<Iterable<List<String>[]>>(){}.getSubtype(ListArrayIterable.class));
        TypeTokenTest.assertEquals((Object)new TypeToken<ListArrayIterable<String>[]>(){}, (Object)new TypeToken<Iterable<List<String>[]>[]>(){}.getSubtype(ListArrayIterable[].class));
    }

    public void testGetSubtype_withoutTypeVariable() {
        TypeTokenTest.assertEquals(StringListIterable.class, (Object)TypeToken.of(Iterable.class).getSubtype(StringListIterable.class).getType());
        TypeTokenTest.assertEquals(StringListIterable[].class, (Object)TypeToken.of(Iterable[].class).getSubtype(StringListIterable[].class).getType());
        TypeTokenTest.assertEquals((Object)TypeToken.of(StringListArrayIterable.class), (Object)new TypeToken<Iterable<List<String>>>(){}.getSubtype(StringListArrayIterable.class));
        TypeTokenTest.assertEquals((Object)TypeToken.of(StringListArrayIterable[].class), (Object)new TypeToken<Iterable<List<String>>[]>(){}.getSubtype(StringListArrayIterable[].class));
    }

    public void testGetSubtype_withArray() {
        TypeTokenTest.assertEquals((Object)TypeToken.of(StringListIterable[].class), (Object)TypeToken.of(Iterable[].class).getSubtype(StringListIterable[].class));
        TypeTokenTest.assertEquals((Object)TypeToken.of(String[].class), (Object)TypeToken.of(Object[].class).getSubtype(String[].class));
        TypeTokenTest.assertEquals((Object)TypeToken.of(int[].class), (Object)TypeToken.of(Object.class).getSubtype(int[].class));
    }

    public void testGetSubtype_fromWildcard() {
        TypeToken type = TypeToken.of((Type)Types.supertypeOf((Type)new TypeToken<Iterable<String>>(){}.getType()));
        TypeTokenTest.assertEquals((Object)new TypeToken<List<String>>(){}, (Object)type.getSubtype(List.class));
    }

    public void testGetSubtype_fromWildcard_lowerBoundNotSupertype() {
        TypeToken type = TypeToken.of((Type)Types.supertypeOf((Type)new TypeToken<ImmutableList<String>>(){}.getType()));
        try {
            type.getSubtype(List.class);
            TypeTokenTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetSubtype_fromWildcard_upperBounded() {
        TypeToken type = TypeToken.of((Type)Types.subtypeOf((Type)new TypeToken<Iterable<String>>(){}.getType()));
        try {
            type.getSubtype(Iterable.class);
            TypeTokenTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public <T extends Iterable<String>> void testGetSubtype_fromTypeVariable() {
        try {
            TypeToken.of((Type)new TypeCapture<T>(){}.capture()).getSubtype(List.class);
            TypeTokenTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetSubtype_fromRawClass() {
        TypeTokenTest.assertEquals(List.class, (Object)new TypeToken<Iterable>(){}.getSubtype(List.class).getType());
    }

    public void testGetSubtype_fromArray() {
        TypeTokenTest.assertEquals((Object)new TypeToken<List<String>[]>(){}, (Object)new TypeToken<Iterable<String>[]>(){}.getSubtype(List[].class));
    }

    public void testGetSubtype_toWildcard() {
        class TwoTypeArgs<K, V> {
            TwoTypeArgs() {
            }
        }
        TypeToken superType = new TypeToken<TwoTypeArgs<?, ?>>(){};
        class StringForFirstTypeArg<V>
        extends TwoTypeArgs<String, V> {
            StringForFirstTypeArg() {
            }
        }
        TypeToken<StringForFirstTypeArg<String>> subType = new TypeToken<StringForFirstTypeArg<String>>(){};
        TypeTokenTest.assertTrue((boolean)subType.isSubtypeOf(superType));
        TypeTokenTest.assertEquals((Object)new TypeToken<StringForFirstTypeArg<?>>(){}, (Object)superType.getSubtype(subType.getRawType()));
    }

    public void testGetSubtype_innerTypeOfGenericClassTranslatesOwnerTypeVars() {
        TypeToken superType = new TypeToken<TwoTypeArgs.InnerType<?, ?>>(){};
        TypeToken<StringForFirstTypeArg.StringInnerType<Long>> subType = new TypeToken<StringForFirstTypeArg.StringInnerType<Long>>(){};
        TypeTokenTest.assertTrue((boolean)subType.isSubtypeOf(superType));
        ParameterizedType actualSubType = (ParameterizedType)superType.getSubtype(subType.getRawType()).getType();
        TypeTokenTest.assertEquals(StringForFirstTypeArg.StringInnerType.class, (Object)actualSubType.getRawType());
        Truth.assertThat((Object)actualSubType.getActualTypeArguments()[0]).isInstanceOf(WildcardType.class);
        ParameterizedType actualOwnerType = (ParameterizedType)actualSubType.getOwnerType();
        TypeTokenTest.assertEquals(StringForFirstTypeArg.class, (Object)actualOwnerType.getRawType());
    }

    public void testGetSubtype_outerTypeVarTranslatesInnerTypeVar() {
        class StringForFirstTypeArg<V>
        extends 2TwoTypeArgs<String, V> {
            StringForFirstTypeArg() {
                class TwoTypeArgs<K, V> {
                    TwoTypeArgs() {
                    }
                }
            }
        }
        TypeToken type = new TypeToken<StringForFirstTypeArg<List<?>>>(){};
        class OuterTypeVar<V>
        extends StringForFirstTypeArg<List<V>> {
            OuterTypeVar() {
            }
        }
        TypeTokenTest.assertEquals((Object)new TypeToken<OuterTypeVar<?>>(){}, (Object)type.getSubtype(OuterTypeVar.class));
    }

    public void testGetSubtype_toWildcardWithBounds() {
        class TwoTypeArgs<K, V> {
            TwoTypeArgs() {
            }
        }
        TypeToken superType = new TypeToken<TwoTypeArgs<?, ? extends Number>>(){};
        class StringForFirstTypeArg<V>
        extends TwoTypeArgs<String, V> {
            StringForFirstTypeArg() {
            }
        }
        TypeToken<StringForFirstTypeArg<Integer>> subType = new TypeToken<StringForFirstTypeArg<Integer>>(){};
        TypeTokenTest.assertTrue((boolean)subType.isSubtypeOf(superType));
        TypeToken unused = superType.getSubtype(subType.getRawType());
    }

    public void testGetSubtype_baseClassWithNoTypeArgs() {
        TypeToken<Base> superType = new TypeToken<Base>(){};
        TypeToken<SingleGenericExtendsBase<String>> subType = new TypeToken<SingleGenericExtendsBase<String>>(){};
        TypeTokenTest.assertTrue((boolean)subType.isSubtypeOf((TypeToken)superType));
        class SingleGenericExtendsBase<T>
        extends Base {
            SingleGenericExtendsBase() {
            }
        }
        TypeTokenTest.assertEquals((Object)TypeToken.of(SingleGenericExtendsBase.class), (Object)superType.getSubtype(subType.getRawType()));
    }

    public void testGetSubtype_baseClassWithLessTypeArgs() {
        class SingleGenericExtendsBase<T>
        extends Base {
            SingleGenericExtendsBase() {
            }
        }
        TypeToken superType = new TypeToken<SingleGenericExtendsBase<?>>(){};
        TypeToken<DoubleGenericExtendsSingleGeneric<String, Integer>> subType = new TypeToken<DoubleGenericExtendsSingleGeneric<String, Integer>>(){};
        TypeTokenTest.assertTrue((boolean)subType.isSubtypeOf(superType));
        ParameterizedType actualSubType = (ParameterizedType)superType.getSubtype(subType.getRawType()).getType();
        class DoubleGenericExtendsSingleGeneric<T1, TUnused>
        extends SingleGenericExtendsBase<T1> {
            DoubleGenericExtendsSingleGeneric() {
            }
        }
        TypeTokenTest.assertEquals(DoubleGenericExtendsSingleGeneric.class, (Object)actualSubType.getRawType());
        Truth.assertThat((Object)actualSubType.getActualTypeArguments()[0]).isInstanceOf(WildcardType.class);
    }

    public <T> void testGetSubtype_manyGenericArgs() {
        class FourTypeArgs<T1, T2, T3, T4> {
            FourTypeArgs() {
            }
        }
        TypeToken superType = new TypeToken<FourTypeArgs<T, Integer, ?, ?>>(){};
        class ThreeTypeArgs<T1, T2, T3>
        extends FourTypeArgs<T1, T2, T3, String> {
            ThreeTypeArgs() {
            }
        }
        TypeToken subType = new TypeToken<ThreeTypeArgs<T, Integer, String>>(){};
        TypeTokenTest.assertTrue((boolean)subType.isSubtypeOf(superType));
        TypeTokenTest.assertEquals((Object)new TypeToken<ThreeTypeArgs<T, Integer, ?>>(){}, (Object)superType.getSubtype(subType.getRawType()));
    }

    public void testGetSubtype_recursiveTypeBoundInSubTypeTranslatedAsIs() {
        ParameterizedType subtype = (ParameterizedType)new TypeToken<1BaseWithTypeVar<List<?>>>(){}.getSubtype(1Outer.Sub.class).getType();
        TypeTokenTest.assertEquals(1Outer.Sub.class, (Object)subtype.getRawType());
        Truth.assertThat((Object)subtype.getActualTypeArguments()[0]).isInstanceOf(WildcardType.class);
        ParameterizedType owner = (ParameterizedType)subtype.getOwnerType();
        class Outer<O> {
            Outer() {
            }

            class 1Outer.Sub2<Y extends 1Outer.Sub2<Y>>
            extends 1BaseWithTypeVar<List<Y>> {
                1Outer.Sub2() {
                    class BaseWithTypeVar<T> {
                        BaseWithTypeVar() {
                        }
                    }
                }
            }

            class 1Outer.Sub<X>
            extends 1BaseWithTypeVar<List<X>> {
                1Outer.Sub() {
                }
            }
        }
        TypeTokenTest.assertEquals(Outer.class, (Object)owner.getRawType());
        TypeToken unused = new TypeToken<1BaseWithTypeVar<List<?>>>(){}.getSubtype(1Outer.Sub2.class);
    }

    public void testGetSubtype_subtypeSameAsDeclaringType() throws Exception {
        class SubBar<T>
        extends 1Bar<T> {
            1Bar<T> delegate;

            SubBar() {
                class Bar<T> {
                    Bar() {
                    }
                }
            }

            TypeToken<SubBar<T>> fieldTypeAsSubBar() {
                return new TypeToken<SubBar<T>>(){};
            }
        }
        Field delegateField = SubBar.class.getDeclaredField("delegate");
        TypeToken barType = TypeToken.of((Type)delegateField.getGenericType());
        Truth.assertThat((Object)barType.getSubtype(SubBar.class)).isEqualTo(new SubBar().fieldTypeAsSubBar());
    }

    public <T> void testWhere_circleRejected() {
        TypeToken type = new TypeToken<List<T>>(){};
        try {
            type.where(new TypeParameter<T>(){}, TypeToken.of((Type)new TypeCapture<T>(){}.capture()));
            TypeTokenTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testWhere() {
        TypeTokenTest.assertEquals((Object)new TypeToken<Map<String, Integer>>(){}, TypeTokenTest.mapOf(String.class, Integer.class));
        TypeTokenTest.assertEquals((Object)new TypeToken<int[]>(){}, TypeTokenTest.arrayOf(Integer.TYPE));
        TypeTokenTest.assertEquals(int[].class, (Object)TypeTokenTest.arrayOf(Integer.TYPE).getRawType());
    }

    public void testWildcardCaptured_methodParameter_upperBound() throws Exception {
        TypeToken type = new TypeToken<Holder<?>>(){};
        TypeToken parameterType = type.resolveType(Holder.class.getDeclaredMethod("setList", List.class).getGenericParameterTypes()[0]);
        TypeTokenTest.assertEquals(List.class, (Object)parameterType.getRawType());
        TypeTokenTest.assertFalse((String)parameterType.getType().toString(), (boolean)parameterType.isSupertypeOf((TypeToken)new TypeToken<List<Integer>>(){}));
    }

    public void testWildcardCaptured_field_upperBound() throws Exception {
        TypeToken type = new TypeToken<Holder<?>>(){};
        TypeToken matrixType = type.resolveType(Holder.class.getDeclaredField("matrix").getGenericType());
        TypeTokenTest.assertEquals(List[].class, (Object)matrixType.getRawType());
        Truth.assertThat((Object)matrixType.getType()).isNotEqualTo((Object)new TypeToken<List<?>[]>(){}.getType());
    }

    public void testArrayClassPreserved() {
        TypeTokenTest.assertEquals(int[].class, (Object)TypeToken.of(int[].class).getType());
        TypeTokenTest.assertEquals(int[][].class, (Object)TypeToken.of(int[][].class).getType());
        TypeTokenTest.assertEquals(String[].class, (Object)TypeToken.of(String[].class).getType());
        TypeTokenTest.assertEquals(Integer.class, (Object)new TypeToken<Integer>(){}.getType());
        TypeTokenTest.assertEquals(Integer.class, (Object)TypeToken.of(Integer.class).getType());
    }

    public void testMethod_getOwnerType() throws NoSuchMethodException {
        Method sizeMethod = List.class.getMethod("size", new Class[0]);
        TypeTokenTest.assertEquals((Object)TypeToken.of(List.class), (Object)TypeToken.of(List.class).method(sizeMethod).getOwnerType());
        TypeTokenTest.assertEquals((Object)new TypeToken<List<String>>(){}, (Object)new TypeToken<List<String>>(){}.method(sizeMethod).getOwnerType());
    }

    public void testMethod_notDeclaredByType() throws NoSuchMethodException {
        Method sizeMethod = Map.class.getMethod("size", new Class[0]);
        try {
            TypeToken.of(List.class).method(sizeMethod);
            TypeTokenTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMethod_declaredBySuperclass() throws Exception {
        Method toStringMethod = Object.class.getMethod("toString", new Class[0]);
        ImmutableList list = ImmutableList.of((Object)"foo");
        TypeTokenTest.assertEquals((Object)list.toString(), (Object)TypeToken.of(List.class).method(toStringMethod).invoke((Object)list, new Object[0]));
    }

    public <T extends Number> void testMethod_returnType_resolvedAgainstTypeBound() throws NoSuchMethodException {
        Method getMethod = List.class.getMethod("get", Integer.TYPE);
        Invokable invokable = new TypeToken<T>(((Object)((Object)this)).getClass()){}.method(getMethod).returning(String.class);
        TypeTokenTest.assertEquals((Object)TypeToken.of(String.class), (Object)invokable.getReturnType());
    }

    public <T extends List<String>> void testMethod_parameterTypes() throws NoSuchMethodException {
        Method setMethod = List.class.getMethod("set", Integer.TYPE, Object.class);
        Invokable invokable = new TypeToken<T>(((Object)((Object)this)).getClass()){}.method(setMethod);
        ImmutableList params = invokable.getParameters();
        TypeTokenTest.assertEquals((int)2, (int)params.size());
        TypeTokenTest.assertEquals((Object)TypeToken.of(Integer.TYPE), (Object)((Parameter)params.get(0)).getType());
        TypeTokenTest.assertEquals((Object)TypeToken.of(String.class), (Object)((Parameter)params.get(1)).getType());
    }

    public void testMethod_equals() throws NoSuchMethodException {
        Method getMethod = List.class.getMethod("get", Integer.TYPE);
        Method setMethod = List.class.getMethod("set", Integer.TYPE, Object.class);
        new EqualsTester().addEqualityGroup(new Object[]{Invokable.from((Method)getMethod), Invokable.from((Method)getMethod)}).addEqualityGroup(new Object[]{Invokable.from((Method)setMethod)}).addEqualityGroup(new Object[]{new TypeToken<List<Integer>>(){}.method(getMethod)}).addEqualityGroup(new Object[]{new TypeToken<List<String>>(){}.method(getMethod)}).addEqualityGroup(new Object[]{new TypeToken<List<Integer>>(){}.method(setMethod)}).addEqualityGroup(new Object[]{new TypeToken<List<String>>(){}.method(setMethod)}).testEquals();
    }

    public <T extends Loser<AssertionError>> void testMethod_exceptionTypes() throws NoSuchMethodException {
        Method failMethod = Loser.class.getMethod("lose", new Class[0]);
        Invokable invokable = new TypeToken<T>(((Object)((Object)this)).getClass()){}.method(failMethod);
        Truth.assertThat((Iterable)invokable.getExceptionTypes()).contains((Object)TypeToken.of(AssertionError.class));
    }

    public void testConstructor_getOwnerType() throws NoSuchMethodException {
        Constructor constructor = ArrayList.class.getConstructor(new Class[0]);
        TypeTokenTest.assertEquals((Object)TypeToken.of(ArrayList.class), (Object)TypeToken.of(ArrayList.class).constructor(constructor).getOwnerType());
        TypeTokenTest.assertEquals((Object)new TypeToken<ArrayList<String>>(){}, (Object)new TypeToken<ArrayList<String>>(){}.constructor(constructor).getOwnerType());
    }

    public void testConstructor_notDeclaredByType() throws NoSuchMethodException {
        Constructor constructor = String.class.getConstructor(new Class[0]);
        try {
            TypeToken.of(Object.class).constructor(constructor);
            TypeTokenTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor_declaredBySuperclass() throws NoSuchMethodException {
        Constructor constructor = Object.class.getConstructor(new Class[0]);
        try {
            TypeToken.of(String.class).constructor(constructor);
            TypeTokenTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor_equals() throws NoSuchMethodException {
        Constructor defaultConstructor = ArrayList.class.getConstructor(new Class[0]);
        Constructor oneArgConstructor = ArrayList.class.getConstructor(Integer.TYPE);
        new EqualsTester().addEqualityGroup(new Object[]{Invokable.from(defaultConstructor), Invokable.from(defaultConstructor)}).addEqualityGroup(new Object[]{Invokable.from(oneArgConstructor)}).addEqualityGroup(new Object[]{new TypeToken<ArrayList<Integer>>(){}.constructor(defaultConstructor)}).addEqualityGroup(new Object[]{new TypeToken<ArrayList<String>>(){}.constructor(defaultConstructor)}).addEqualityGroup(new Object[]{new TypeToken<ArrayList<Integer>>(){}.constructor(oneArgConstructor)}).addEqualityGroup(new Object[]{new TypeToken<ArrayList<String>>(){}.constructor(oneArgConstructor)}).testEquals();
    }

    public <T extends Container<String>> void testConstructor_parameterTypes() throws NoSuchMethodException {
        Constructor constructor = Container.class.getConstructor(Object.class);
        Invokable invokable = new TypeToken<T>(((Object)((Object)this)).getClass()){}.constructor(constructor);
        ImmutableList params = invokable.getParameters();
        TypeTokenTest.assertEquals((int)1, (int)params.size());
        TypeTokenTest.assertEquals((Object)TypeToken.of(String.class), (Object)((Parameter)params.get(0)).getType());
    }

    public <T extends CannotConstruct<AssertionError>> void testConstructor_exceptionTypes() throws NoSuchMethodException {
        Constructor constructor = CannotConstruct.class.getConstructor(new Class[0]);
        Invokable invokable = new TypeToken<T>(((Object)((Object)this)).getClass()){}.constructor(constructor);
        Truth.assertThat((Iterable)invokable.getExceptionTypes()).contains((Object)TypeToken.of(AssertionError.class));
    }

    public void testRejectTypeVariable_class() {
        TypeTokenTest.assertNoTypeVariable(String.class);
        TypeTokenTest.assertNoTypeVariable(String[].class);
        TypeTokenTest.assertNoTypeVariable(int[].class);
    }

    public void testRejectTypeVariable_parameterizedType() {
        TypeTokenTest.assertNoTypeVariable(new TypeCapture<Iterable<String>>(){}.capture());
    }

    public void testRejectTypeVariable_wildcardType() {
        TypeTokenTest.assertNoTypeVariable(new TypeCapture<Iterable<? extends String>>(){}.capture());
        TypeTokenTest.assertNoTypeVariable(new TypeCapture<Iterable<? super String>>(){}.capture());
    }

    public void testRejectTypeVariable_genericArrayType() {
        TypeTokenTest.assertNoTypeVariable(new TypeCapture<Iterable<? extends String>[]>(){}.capture());
    }

    public <T> void testRejectTypeVariable_withTypeVariable() {
        TypeTokenTest.assertHasTypeVariable(new TypeCapture<T>(){}.capture());
        TypeTokenTest.assertHasTypeVariable(new TypeCapture<T[]>(){}.capture());
        TypeTokenTest.assertHasTypeVariable(new TypeCapture<Iterable<T>>(){}.capture());
        TypeTokenTest.assertHasTypeVariable(new TypeCapture<Map<String, T>>(){}.capture());
        TypeTokenTest.assertHasTypeVariable(new TypeCapture<Map<String, ? extends T>>(){}.capture());
        TypeTokenTest.assertHasTypeVariable(new TypeCapture<Map<String, ? super T[]>>(){}.capture());
    }

    public <T> void testRejectTypeVariable_withOwnerType() {
        TypeTokenTest.assertHasTypeVariable(new From().new From.To().type());
        TypeTokenTest.assertHasTypeVariable(new From().new From.To().type());
        TypeTokenTest.assertHasTypeVariable(new From().new From.To().type());
        TypeTokenTest.assertHasTypeVariable(new From<Integer>(){}.new From.To().type());
        TypeTokenTest.assertHasTypeVariable(new From<T>(){}.new From.To().type());
        TypeTokenTest.assertNoTypeVariable(new From.To<String>(new From()){}.type());
        TypeTokenTest.assertHasTypeVariable(new From.To<T>(new From()){}.type());
        TypeTokenTest.assertHasTypeVariable(new From.To<String>(new From()){}.type());
        TypeTokenTest.assertHasTypeVariable(new From.To<String>(new From<T>(){}){}.type());
        TypeTokenTest.assertNoTypeVariable(new From.To<String>(new From<Integer>(){}){}.type());
        TypeTokenTest.assertHasTypeVariable(new From.To<T>(new From<Integer>(){}){}.type());
    }

    private static void assertHasTypeVariable(Type type) {
        try {
            TypeToken.of((Type)type).rejectTypeVariables();
            TypeTokenTest.fail((String)"Should contain TypeVariable");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static void assertNoTypeVariable(Type type) {
        TypeToken.of((Type)type).rejectTypeVariables();
    }

    public void testRawTypes() {
        RawTypeConsistencyTester.verifyConsitentRawType();
        TypeTokenTest.assertEquals(Object.class, (Object)TypeToken.of((Type)Types.subtypeOf(Object.class)).getRawType());
        TypeTokenTest.assertEquals(CharSequence.class, (Object)TypeToken.of((Type)Types.subtypeOf(CharSequence.class)).getRawType());
        TypeTokenTest.assertEquals(Object.class, (Object)TypeToken.of((Type)Types.supertypeOf(CharSequence.class)).getRawType());
    }

    public void testTypeResolution() {
        TypeTokenTest.assertEquals(String.class, (Object)new IKnowMyType<String>(){}.type().getType());
        TypeTokenTest.assertEquals((Object)new TypeToken<Map<String, Integer>>(){}, new IKnowMyType<Map<String, Integer>>(){}.type());
    }

    public <A extends Iterable<? extends String>, B extends A> void testSerializable() {
        TypeTokenTest.reserialize(TypeToken.of(String.class));
        TypeTokenTest.reserialize(TypeToken.of(String.class).getTypes());
        TypeTokenTest.reserialize(TypeToken.of(String.class).getTypes().classes());
        TypeTokenTest.reserialize(TypeToken.of(String.class).getTypes().interfaces());
        TypeTokenTest.reserialize(TypeToken.of(String.class).getTypes().rawTypes());
        TypeTokenTest.reserialize(TypeToken.of(String.class).getTypes().classes().rawTypes());
        TypeTokenTest.reserialize(TypeToken.of(String.class).getTypes().interfaces().rawTypes());
        TypeTokenTest.reserialize(new TypeToken<int[]>(){});
        TypeTokenTest.reserialize(new TypeToken<Map<String, Integer>>(){});
        TypeTokenTest.reserialize(new IKnowMyType<Map<? super String, ? extends int[]>>(){}.type());
        TypeTokenTest.reserialize(TypeToken.of((Type)new TypeCapture<B>(){}.capture()).getTypes().rawTypes());
        try {
            SerializableTester.reserialize((Object)TypeToken.of((Type)new TypeCapture<B>(){}.capture()));
            TypeTokenTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public <A> void testSerializable_typeVariableNotSupported() {
        try {
            new ITryToSerializeMyTypeVariable().go();
            TypeTokenTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @CanIgnoreReturnValue
    private static <T> T reserialize(T object) {
        Object copy = SerializableTester.reserialize(object);
        new EqualsTester().addEqualityGroup(new Object[]{object, copy}).testEquals();
        return (T)copy;
    }

    public void testTypeResolutionAfterReserialized() {
        TypeTokenTest.reserialize(new TypeToken<String>(){});
        TypeTokenTest.reserialize(new TypeToken<Map<String, Integer>>(){});
        TypeToken reserialized = TypeTokenTest.reserialize(new TypeToken<Map<String, Integer>>(){});
        TypeTokenTest.assertEquals((Object)reserialized, TypeTokenTest.substitute(reserialized, String.class));
    }

    private static <T, X> TypeToken<T> substitute(TypeToken<T> type, Class<X> arg) {
        return type.where(new TypeParameter<X>(){}, arg);
    }

    public void testDespiteGenericSignatureFormatError() {
        ImmutableSet unused = ImmutableSet.copyOf((Collection)TypeToken.of(ToReproduceGenericSignatureFormatError.SubOuter.SubInner.class).getTypes().rawTypes());
    }

    public <A, B> void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{TypeToken.of(String.class), TypeToken.of(String.class), new Entry<String, Integer>(){}.keyType(), new Entry<Integer, String>(){}.valueType(), new TypeToken<String>(){}, new TypeToken<String>(){}}).addEqualityGroup(new Object[]{TypeToken.of(Integer.class), new TypeToken<Integer>(){}, new Entry<Integer, String>(){}.keyType(), new Entry<String, Integer>(){}.valueType()}).addEqualityGroup(new Object[]{new TypeToken<List<String>>(){}, new TypeToken<List<String>>(){}}).addEqualityGroup(new Object[]{new TypeToken<List<?>>(){}, new TypeToken<List<?>>(){}}).addEqualityGroup(new Object[]{new TypeToken<Map<A, ?>>(){}, new TypeToken<Map<A, ?>>(){}}).addEqualityGroup(new Object[]{new TypeToken<Map<B, ?>>(){}}).addEqualityGroup(new Object[]{TypeToken.of((Type)new TypeCapture<A>(){}.capture()), TypeToken.of((Type)new TypeCapture<A>(){}.capture())}).addEqualityGroup(new Object[]{TypeToken.of((Type)new TypeCapture<B>(){}.capture())}).testEquals();
    }

    public <T> void testToString() {
        TypeTokenTest.assertEquals((String)String.class.getName(), (String)new TypeToken<String>(){}.toString());
        TypeTokenTest.assertEquals((String)"T", (String)TypeToken.of((Type)new TypeCapture<T>(){}.capture()).toString());
        TypeTokenTest.assertEquals((String)"java.lang.String", (String)new Entry<String, Integer>(){}.keyType().toString());
    }

    private static <K, V> TypeToken<Map<K, V>> mapOf(Class<K> keyType, Class<V> valueType) {
        return new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType);
    }

    private static <T> TypeToken<T[]> arrayOf(Class<T> componentType) {
        return new TypeToken<T[]>(){}.where(new TypeParameter<T>(){}, componentType);
    }

    public <T> void testNulls() {
        new NullPointerTester().testAllPublicStaticMethods(TypeToken.class);
        new NullPointerTester().setDefault(TypeParameter.class, (Object)new TypeParameter<T>(){}).testAllPublicInstanceMethods((Object)TypeToken.of(String.class));
    }

    private static void assertAssignable(TypeToken<?> from, TypeToken<?> to) {
        TypeTokenTest.assertTrue((String)(from.getType() + " is expected to be assignable to " + to.getType()), (boolean)to.isSupertypeOf(from));
        TypeTokenTest.assertTrue((String)(to.getType() + " is expected to be a supertype of " + from.getType()), (boolean)to.isSupertypeOf(from));
        TypeTokenTest.assertTrue((String)(from.getType() + " is expected to be a subtype of " + to.getType()), (boolean)from.isSubtypeOf(to));
    }

    private static void assertNotAssignable(TypeToken<?> from, TypeToken<?> to) {
        TypeTokenTest.assertFalse((String)(from.getType() + " shouldn't be assignable to " + to.getType()), (boolean)to.isSupertypeOf(from));
        TypeTokenTest.assertFalse((String)(to.getType() + " shouldn't be a supertype of " + from.getType()), (boolean)to.isSupertypeOf(from));
        TypeTokenTest.assertFalse((String)(from.getType() + " shouldn't be a subtype of " + to.getType()), (boolean)from.isSubtypeOf(to));
    }

    private static void assertHasArrayInterfaces(TypeToken<?> arrayType) {
        TypeTokenTest.assertEquals(TypeTokenTest.arrayInterfaces(), (Object)ImmutableSet.copyOf((Collection)arrayType.getGenericInterfaces()));
    }

    private static ImmutableSet<TypeToken<?>> arrayInterfaces() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Class<?> interfaceType : Object[].class.getInterfaces()) {
            builder.add((Object)TypeToken.of(interfaceType));
        }
        return builder.build();
    }

    private static void assertIsPrimitive(TypeToken<?> type) {
        TypeTokenTest.assertTrue((boolean)type.isPrimitive());
        TypeTokenTest.assertNotWrapper(type);
        TypeTokenTest.assertEquals((Object)TypeToken.of((Class)Primitives.wrap((Class)((Class)type.getType()))), (Object)type.wrap());
    }

    private static void assertNotPrimitive(TypeToken<?> type) {
        TypeTokenTest.assertFalse((boolean)type.isPrimitive());
        TypeTokenTest.assertSame(type, (Object)type.wrap());
    }

    private static void assertIsWrapper(TypeToken<?> type) {
        TypeTokenTest.assertNotPrimitive(type);
        TypeTokenTest.assertEquals((Object)TypeToken.of((Class)Primitives.unwrap((Class)((Class)type.getType()))), (Object)type.unwrap());
    }

    private static void assertNotWrapper(TypeToken<?> type) {
        TypeTokenTest.assertSame(type, (Object)type.unwrap());
    }

    private static void assertNotPrimitiveNorWrapper(TypeToken<?> type) {
        TypeTokenTest.assertNotPrimitive(type);
        TypeTokenTest.assertNotWrapper(type);
    }

    private static IterableSubject makeUnmodifiable(Collection<?> actual) {
        return Truth.assertThat(Collections.unmodifiableCollection(actual));
    }

    private static class Sub
    extends Base {
        private Sub() {
        }
    }

    private static class Base
    implements BaseInterface {
        private Base() {
        }
    }

    private static interface BaseInterface {
    }

    private static class Assignability<From, To> {
        private Assignability() {
        }

        boolean isAssignable() {
            return new TypeToken<To>(this.getClass()){}.isSupertypeOf(new TypeToken<From>(this.getClass()){});
        }

        static <From, To> Assignability<From, To> of() {
            return new Assignability<From, To>();
        }
    }

    private static abstract class Entry<K, V> {
        private Entry() {
        }

        TypeToken<K> keyType() {
            return new TypeToken<K>(this.getClass()){};
        }

        TypeToken<V> valueType() {
            return new TypeToken<V>(this.getClass()){};
        }
    }

    private static abstract class ToReproduceGenericSignatureFormatError<V> {
        private ToReproduceGenericSignatureFormatError() {
        }

        private abstract class SubOuter
        extends BaseOuter {
            private SubOuter() {
            }

            /*
             * Signature claims super is com.google.common.reflect.TypeTokenTest$ToReproduceGenericSignatureFormatError$BaseOuter.BaseInner, not com.google.common.reflect.TypeTokenTest$ToReproduceGenericSignatureFormatError$BaseOuter$BaseInner - discarding signature.
             */
            private abstract class SubInner
            extends BaseOuter.BaseInner {
                private SubInner() {
                }
            }
        }

        private abstract class BaseOuter {
            private BaseOuter() {
            }

            abstract class BaseInner {
                BaseInner() {
                }
            }
        }
    }

    private static class ITryToSerializeMyTypeVariable<T> {
        private ITryToSerializeMyTypeVariable() {
        }

        void go() {
            SerializableTester.reserialize((Object)TypeToken.of((Type)new TypeCapture<T>(){}.capture()));
        }
    }

    private static abstract class IKnowMyType<T> {
        private IKnowMyType() {
        }

        TypeToken<T> type() {
            return new TypeToken<T>(this.getClass()){};
        }
    }

    private static abstract class RawTypeConsistencyTester<T extends Enum<T>> {
        private RawTypeConsistencyTester() {
        }

        abstract T returningT();

        abstract void acceptT(T var1);

        abstract <X extends T> X returningX();

        abstract <X> void acceptX(X var1);

        abstract <T2 extends Enum<T2>> T2 returningT2();

        abstract <T2 extends CharSequence & Iterable<T2>> void acceptT2(T2 var1);

        static void verifyConsitentRawType() {
            for (Method method : RawTypeConsistencyTester.class.getDeclaredMethods()) {
                Assert.assertEquals(method.getReturnType(), (Object)TypeToken.of((Type)method.getGenericReturnType()).getRawType());
                for (int i = 0; i < method.getParameterTypes().length; ++i) {
                    Assert.assertEquals(method.getParameterTypes()[i], (Object)TypeToken.of((Type)method.getGenericParameterTypes()[i]).getRawType());
                }
            }
        }
    }

    private static class From<K> {
        private From() {
        }

        class To<V> {
            To() {
            }

            Type type() {
                return new TypeToken<To<V>>(this.getClass()){}.getType();
            }
        }
    }

    private static class CannotConstruct<E extends Throwable> {
    }

    private static class Container<T> {
        public Container(T data) {
        }
    }

    private static interface Loser<E extends Throwable> {
        public void lose() throws E;
    }

    private static class Holder<T> {
        T element;
        List<T> list;
        List<T>[] matrix;

        private Holder() {
        }

        void setList(List<T> list) {
            this.list = list;
        }
    }

    private static class StringForFirstTypeArg<V>
    extends TwoTypeArgs<String, V> {
        private StringForFirstTypeArg() {
        }

        class StringInnerType<V2>
        extends TwoTypeArgs.InnerType<String, V2> {
            StringInnerType() {
            }
        }
    }

    private static class TwoTypeArgs<K, V> {
        private TwoTypeArgs() {
        }

        class InnerType<K2, V2> {
            InnerType() {
            }
        }
    }

    private static interface StringListMap<V>
    extends ListMap<String, V> {
    }

    private static interface ListMap<K, V>
    extends Map<K, List<V>> {
    }

    private static interface StringListArrayIterable
    extends ListIterable<String> {
    }

    private static interface ListArrayIterable<T>
    extends Iterable<List<T>[]> {
    }

    private static interface StringListIterable
    extends ListIterable<String> {
    }

    private static interface ListIterable<T>
    extends Iterable<List<T>> {
    }

    private static interface NumberList<T extends Number> {
    }

    private static class ConcreteSI
    extends Fourth<String, Integer> {
        private ConcreteSI() {
        }
    }

    private static class ConcreteIS
    extends Fourth<Integer, String> {
        private ConcreteIS() {
        }
    }

    private static abstract class Fourth<T, D>
    extends Third<D, T> {
        private Fourth() {
        }
    }

    private static abstract class Third<T, D>
    extends Second<T> {
        private Third() {
        }
    }

    private static abstract class Second<D>
    extends First<D> {
        private Second() {
        }
    }

    private static abstract class First<T> {
        private First() {
        }
    }

    private static abstract class Implementation<K, V>
    implements Iterable<V>,
    Map<K, V> {
        private Implementation() {
        }
    }

    private static final class NoInterface {
        private NoInterface() {
        }
    }

    private static class Class1
    implements Interface1 {
        private Class1() {
        }
    }

    private static interface Interface12
    extends Interface1,
    Interface2 {
    }

    private static interface Interface3<T>
    extends Iterable<T> {
    }

    private static interface Interface2 {
    }

    private static interface Interface1 {
    }

    private static abstract class IntegerList
    implements List<Integer> {
        private IntegerList() {
        }
    }

    private static abstract class StringList
    implements List<String> {
        private StringList() {
        }
    }
}

