/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.reflect.TypeCapture;
import com.google.common.reflect.TypeVisitor;
import com.google.common.reflect.Types;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.EnumSet;
import junit.framework.TestCase;

public class TypeVisitorTest
extends TestCase {
    public void testVisitNull() {
        new BaseTypeVisitor().visit(new Type[]{((ParameterizedType)ArrayList.class.getGenericSuperclass()).getOwnerType()});
    }

    public void testVisitClass() {
        TypeVisitorTest.assertVisited(String.class);
        new BaseTypeVisitor(){

            @Override
            void visitClass(Class<?> t) {
            }
        }.visit(new Type[]{String.class});
    }

    public <T> void testVisitTypeVariable() {
        Type type = new TypeCapture<T>(){}.capture();
        TypeVisitorTest.assertVisited(type);
        new BaseTypeVisitor(){

            @Override
            void visitTypeVariable(TypeVariable<?> t) {
            }
        }.visit(new Type[]{type});
    }

    public void testVisitWildcardType() {
        WildcardType type = Types.subtypeOf(String.class);
        TypeVisitorTest.assertVisited(type);
        new BaseTypeVisitor(){

            @Override
            void visitWildcardType(WildcardType t) {
            }
        }.visit(new Type[]{type});
    }

    public <T> void testVisitGenericArrayType() {
        Type type = new TypeCapture<T[]>(){}.capture();
        TypeVisitorTest.assertVisited(type);
        new BaseTypeVisitor(){

            @Override
            void visitGenericArrayType(GenericArrayType t) {
            }
        }.visit(new Type[]{type});
    }

    public <T> void testVisitParameterizedType() {
        Type type = new TypeCapture<Iterable<T>>(){}.capture();
        TypeVisitorTest.assertVisited(type);
        new BaseTypeVisitor(){

            @Override
            void visitParameterizedType(ParameterizedType t) {
            }
        }.visit(new Type[]{type});
    }

    public <E extends Enum<E>> void testVisitRecursiveTypeBounds() {
        Type type = new TypeCapture<EnumSet<E>>(){}.capture();
        TypeVisitorTest.assertVisited(type);
        new BaseTypeVisitor(){

            @Override
            void visitParameterizedType(ParameterizedType t) {
                this.visit(t.getActualTypeArguments());
            }

            @Override
            void visitTypeVariable(TypeVariable<?> t) {
                this.visit(t.getBounds());
            }
        }.visit(new Type[]{type});
    }

    private static void assertVisited(Type type) {
        BaseTypeVisitor visitor = new BaseTypeVisitor();
        try {
            visitor.visit(new Type[]{type});
            TypeVisitorTest.fail((String)"Type not visited");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            visitor.visit(new Type[]{type});
            TypeVisitorTest.fail((String)"Type not visited");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private static class BaseTypeVisitor
    extends TypeVisitor {
        private BaseTypeVisitor() {
        }

        void visitTypeVariable(TypeVariable<?> t) {
            throw new UnsupportedOperationException();
        }

        void visitWildcardType(WildcardType t) {
            throw new UnsupportedOperationException();
        }

        void visitParameterizedType(ParameterizedType t) {
            throw new UnsupportedOperationException();
        }

        void visitClass(Class<?> t) {
            throw new UnsupportedOperationException();
        }

        void visitGenericArrayType(GenericArrayType t) {
            throw new UnsupportedOperationException();
        }
    }
}

