/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Joiner;
import com.google.common.util.concurrent.CycleDetectingLockFactory;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import junit.framework.TestCase;

public class CycleDetectingLockFactoryTest
extends TestCase {
    private ReentrantLock lockA;
    private ReentrantLock lockB;
    private ReentrantLock lockC;
    private ReentrantReadWriteLock.ReadLock readLockA;
    private ReentrantReadWriteLock.ReadLock readLockB;
    private ReentrantReadWriteLock.ReadLock readLockC;
    private ReentrantReadWriteLock.WriteLock writeLockA;
    private ReentrantReadWriteLock.WriteLock writeLockB;
    private ReentrantReadWriteLock.WriteLock writeLockC;
    private ReentrantLock lock1;
    private ReentrantLock lock2;
    private ReentrantLock lock3;
    private ReentrantLock lock01;
    private ReentrantLock lock02;
    private ReentrantLock lock03;

    protected void setUp() throws Exception {
        super.setUp();
        CycleDetectingLockFactory factory = CycleDetectingLockFactory.newInstance((CycleDetectingLockFactory.Policy)CycleDetectingLockFactory.Policies.THROW);
        this.lockA = factory.newReentrantLock("LockA");
        this.lockB = factory.newReentrantLock("LockB");
        this.lockC = factory.newReentrantLock("LockC");
        ReentrantReadWriteLock readWriteLockA = factory.newReentrantReadWriteLock("ReadWriteA");
        ReentrantReadWriteLock readWriteLockB = factory.newReentrantReadWriteLock("ReadWriteB");
        ReentrantReadWriteLock readWriteLockC = factory.newReentrantReadWriteLock("ReadWriteC");
        this.readLockA = readWriteLockA.readLock();
        this.readLockB = readWriteLockB.readLock();
        this.readLockC = readWriteLockC.readLock();
        this.writeLockA = readWriteLockA.writeLock();
        this.writeLockB = readWriteLockB.writeLock();
        this.writeLockC = readWriteLockC.writeLock();
        CycleDetectingLockFactory.WithExplicitOrdering<MyOrder> factory2 = this.newInstanceWithExplicitOrdering(MyOrder.class, (CycleDetectingLockFactory.Policy)CycleDetectingLockFactory.Policies.THROW);
        this.lock1 = factory2.newReentrantLock((Enum)MyOrder.FIRST);
        this.lock2 = factory2.newReentrantLock((Enum)MyOrder.SECOND);
        this.lock3 = factory2.newReentrantLock((Enum)MyOrder.THIRD);
        CycleDetectingLockFactory.WithExplicitOrdering<OtherOrder> factory3 = this.newInstanceWithExplicitOrdering(OtherOrder.class, (CycleDetectingLockFactory.Policy)CycleDetectingLockFactory.Policies.THROW);
        this.lock01 = factory3.newReentrantLock((Enum)OtherOrder.FIRST);
        this.lock02 = factory3.newReentrantLock((Enum)OtherOrder.SECOND);
        this.lock03 = factory3.newReentrantLock((Enum)OtherOrder.THIRD);
    }

    private <E extends Enum<E>> CycleDetectingLockFactory.WithExplicitOrdering<E> newInstanceWithExplicitOrdering(Class<E> enumClass, CycleDetectingLockFactory.Policy policy) {
        return new CycleDetectingLockFactory.WithExplicitOrdering(policy, CycleDetectingLockFactory.createNodes(enumClass));
    }

    public void testDeadlock_twoLocks() {
        this.lockA.lock();
        this.lockB.lock();
        this.lockA.unlock();
        this.lockB.unlock();
        CycleDetectingLockFactory.PotentialDeadlockException firstException = null;
        this.lockB.lock();
        try {
            this.lockA.lock();
            CycleDetectingLockFactoryTest.fail((String)"Expected PotentialDeadlockException");
        }
        catch (CycleDetectingLockFactory.PotentialDeadlockException expected) {
            this.checkMessage((IllegalStateException)((Object)expected), "LockB -> LockA", "LockA -> LockB");
            firstException = expected;
        }
        try {
            this.lockA.lock();
            CycleDetectingLockFactoryTest.fail((String)"Expected PotentialDeadlockException");
        }
        catch (CycleDetectingLockFactory.PotentialDeadlockException expected) {
            this.checkMessage((IllegalStateException)((Object)expected), "LockB -> LockA", "LockA -> LockB");
            CycleDetectingLockFactoryTest.assertSame((Object)firstException.getCause(), (Object)expected.getCause());
        }
        this.lockB.unlock();
        this.lockA.lock();
    }

    public void testDeadlock_threeLocks() {
        this.lockA.lock();
        this.lockB.lock();
        this.lockB.unlock();
        this.lockA.unlock();
        this.lockB.lock();
        this.lockC.lock();
        this.lockB.unlock();
        try {
            this.lockA.lock();
            CycleDetectingLockFactoryTest.fail((String)"Expected PotentialDeadlockException");
        }
        catch (CycleDetectingLockFactory.PotentialDeadlockException expected) {
            this.checkMessage((IllegalStateException)((Object)expected), "LockC -> LockA", "LockB -> LockC", "LockA -> LockB");
        }
    }

    public void testReentrancy_noDeadlock() {
        this.lockA.lock();
        this.lockB.lock();
        this.lockA.lock();
    }

    public void testExplicitOrdering_noViolations() {
        this.lock1.lock();
        this.lock3.lock();
        this.lock3.unlock();
        this.lock2.lock();
        this.lock3.lock();
    }

    public void testExplicitOrdering_violations() {
        this.lock3.lock();
        try {
            this.lock2.lock();
            CycleDetectingLockFactoryTest.fail((String)"Expected PotentialDeadlockException");
        }
        catch (CycleDetectingLockFactory.PotentialDeadlockException expected) {
            this.checkMessage((IllegalStateException)((Object)expected), "MyOrder.THIRD -> MyOrder.SECOND");
        }
        try {
            this.lock1.lock();
            CycleDetectingLockFactoryTest.fail((String)"Expected PotentialDeadlockException");
        }
        catch (CycleDetectingLockFactory.PotentialDeadlockException expected) {
            this.checkMessage((IllegalStateException)((Object)expected), "MyOrder.THIRD -> MyOrder.FIRST");
        }
        this.lock3.unlock();
        this.lock2.lock();
        try {
            this.lock1.lock();
            CycleDetectingLockFactoryTest.fail((String)"Expected PotentialDeadlockException");
        }
        catch (CycleDetectingLockFactory.PotentialDeadlockException expected) {
            this.checkMessage((IllegalStateException)((Object)expected), "MyOrder.SECOND -> MyOrder.FIRST");
        }
    }

    public void testDifferentOrderings_noViolations() {
        this.lock3.lock();
        this.lock01.lock();
    }

    public void testExplicitOrderings_generalCycleDetection() {
        this.lock3.lock();
        this.lock01.lock();
        this.lock3.unlock();
        try {
            this.lock3.lock();
            CycleDetectingLockFactoryTest.fail((String)"Expected PotentialDeadlockException");
        }
        catch (CycleDetectingLockFactory.PotentialDeadlockException expected) {
            this.checkMessage((IllegalStateException)((Object)expected), "OtherOrder.FIRST -> MyOrder.THIRD", "MyOrder.THIRD -> OtherOrder.FIRST");
        }
        this.lockA.lock();
        this.lock01.unlock();
        this.lockB.lock();
        this.lockA.unlock();
        try {
            this.lock01.lock();
            CycleDetectingLockFactoryTest.fail((String)"Expected PotentialDeadlockException");
        }
        catch (CycleDetectingLockFactory.PotentialDeadlockException expected) {
            this.checkMessage((IllegalStateException)((Object)expected), "LockB -> OtherOrder.FIRST", "LockA -> LockB", "OtherOrder.FIRST -> LockA");
        }
    }

    public void testExplicitOrdering_cycleWithUnorderedLock() {
        ReentrantLock myLock = CycleDetectingLockFactory.newInstance((CycleDetectingLockFactory.Policy)CycleDetectingLockFactory.Policies.THROW).newReentrantLock("MyLock");
        this.lock03.lock();
        myLock.lock();
        this.lock03.unlock();
        try {
            this.lock01.lock();
            CycleDetectingLockFactoryTest.fail((String)"Expected PotentialDeadlockException");
        }
        catch (CycleDetectingLockFactory.PotentialDeadlockException expected) {
            this.checkMessage((IllegalStateException)((Object)expected), "MyLock -> OtherOrder.FIRST", "OtherOrder.THIRD -> MyLock", "OtherOrder.FIRST -> OtherOrder.THIRD");
        }
    }

    public void testExplicitOrdering_reentrantAcquisition() {
        CycleDetectingLockFactory.WithExplicitOrdering<OtherOrder> factory = this.newInstanceWithExplicitOrdering(OtherOrder.class, (CycleDetectingLockFactory.Policy)CycleDetectingLockFactory.Policies.THROW);
        ReentrantReadWriteLock.ReadLock lockA = factory.newReentrantReadWriteLock((Enum)OtherOrder.FIRST).readLock();
        ReentrantLock lockB = factory.newReentrantLock((Enum)OtherOrder.SECOND);
        lockA.lock();
        lockA.lock();
        lockB.lock();
        lockB.lock();
        lockA.unlock();
        lockA.unlock();
        lockB.unlock();
        lockB.unlock();
    }

    public void testExplicitOrdering_acquiringMultipleLocksWithSameRank() {
        CycleDetectingLockFactory.WithExplicitOrdering<OtherOrder> factory = this.newInstanceWithExplicitOrdering(OtherOrder.class, (CycleDetectingLockFactory.Policy)CycleDetectingLockFactory.Policies.THROW);
        ReentrantLock lockA = factory.newReentrantLock((Enum)OtherOrder.FIRST);
        ReentrantReadWriteLock.ReadLock lockB = factory.newReentrantReadWriteLock((Enum)OtherOrder.FIRST).readLock();
        lockA.lock();
        try {
            lockB.lock();
            CycleDetectingLockFactoryTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        lockA.unlock();
        lockB.lock();
    }

    public void testReadLock_deadlock() {
        this.readLockA.lock();
        this.lockB.lock();
        this.lockB.unlock();
        this.readLockA.unlock();
        this.lockB.lock();
        try {
            this.readLockA.lock();
            CycleDetectingLockFactoryTest.fail((String)"Expected PotentialDeadlockException");
        }
        catch (CycleDetectingLockFactory.PotentialDeadlockException expected) {
            this.checkMessage((IllegalStateException)((Object)expected), "LockB -> ReadWriteA", "ReadWriteA -> LockB");
        }
    }

    public void testReadLock_transitive() {
        this.readLockA.lock();
        this.lockB.lock();
        this.lockB.unlock();
        this.readLockA.unlock();
        this.lockB.lock();
        this.readLockC.lock();
        this.lockB.unlock();
        this.readLockC.unlock();
        this.readLockC.lock();
        try {
            this.readLockA.lock();
            CycleDetectingLockFactoryTest.fail((String)"Expected PotentialDeadlockException");
        }
        catch (CycleDetectingLockFactory.PotentialDeadlockException expected) {
            this.checkMessage((IllegalStateException)((Object)expected), "ReadWriteC -> ReadWriteA", "LockB -> ReadWriteC", "ReadWriteA -> LockB");
        }
    }

    public void testWriteLock_threeLockDeadLock() {
        this.writeLockA.lock();
        this.writeLockB.lock();
        this.writeLockB.unlock();
        this.writeLockA.unlock();
        this.writeLockB.lock();
        this.writeLockC.lock();
        this.writeLockB.unlock();
        try {
            this.writeLockA.lock();
            CycleDetectingLockFactoryTest.fail((String)"Expected PotentialDeadlockException");
        }
        catch (CycleDetectingLockFactory.PotentialDeadlockException expected) {
            this.checkMessage((IllegalStateException)((Object)expected), "ReadWriteC -> ReadWriteA", "ReadWriteB -> ReadWriteC", "ReadWriteA -> ReadWriteB");
        }
    }

    public void testWriteToReadLockDowngrading() {
        this.writeLockA.lock();
        this.readLockA.lock();
        this.writeLockA.unlock();
        this.lockB.lock();
        this.readLockA.unlock();
        try {
            this.writeLockA.lock();
            CycleDetectingLockFactoryTest.fail((String)"Expected PotentialDeadlockException");
        }
        catch (CycleDetectingLockFactory.PotentialDeadlockException expected) {
            this.checkMessage((IllegalStateException)((Object)expected), "LockB -> ReadWriteA", "ReadWriteA -> LockB");
        }
    }

    public void testReadWriteLockDeadlock() {
        this.writeLockA.lock();
        this.lockB.lock();
        this.writeLockA.unlock();
        this.lockB.unlock();
        this.lockB.lock();
        try {
            this.readLockA.lock();
            CycleDetectingLockFactoryTest.fail((String)"Expected PotentialDeadlockException");
        }
        catch (CycleDetectingLockFactory.PotentialDeadlockException expected) {
            this.checkMessage((IllegalStateException)((Object)expected), "LockB -> ReadWriteA", "ReadWriteA -> LockB");
        }
    }

    public void testReadWriteLockDeadlock_transitive() {
        this.readLockA.lock();
        this.lockB.lock();
        this.readLockA.unlock();
        this.lockB.unlock();
        this.lockB.lock();
        this.lockC.lock();
        this.lockB.unlock();
        this.lockC.unlock();
        this.lockC.lock();
        try {
            this.writeLockA.lock();
            CycleDetectingLockFactoryTest.fail((String)"Expected PotentialDeadlockException");
        }
        catch (CycleDetectingLockFactory.PotentialDeadlockException expected) {
            this.checkMessage((IllegalStateException)((Object)expected), "LockC -> ReadWriteA", "LockB -> LockC", "ReadWriteA -> LockB");
        }
    }

    public void testReadWriteLockDeadlock_treatedEquivalently() {
        this.readLockA.lock();
        this.writeLockB.lock();
        this.readLockA.unlock();
        this.writeLockB.unlock();
        this.readLockB.lock();
        try {
            this.writeLockA.lock();
            CycleDetectingLockFactoryTest.fail((String)"Expected PotentialDeadlockException");
        }
        catch (CycleDetectingLockFactory.PotentialDeadlockException expected) {
            this.checkMessage((IllegalStateException)((Object)expected), "ReadWriteB -> ReadWriteA", "ReadWriteA -> ReadWriteB");
        }
    }

    public void testDifferentLockFactories() {
        CycleDetectingLockFactory otherFactory = CycleDetectingLockFactory.newInstance((CycleDetectingLockFactory.Policy)CycleDetectingLockFactory.Policies.WARN);
        ReentrantLock lockD = otherFactory.newReentrantLock("LockD");
        this.lockA.lock();
        lockD.lock();
        this.lockA.unlock();
        lockD.unlock();
        lockD.lock();
        try {
            this.lockA.lock();
            CycleDetectingLockFactoryTest.fail((String)"Expected PotentialDeadlockException");
        }
        catch (CycleDetectingLockFactory.PotentialDeadlockException expected) {
            this.checkMessage((IllegalStateException)((Object)expected), "LockD -> LockA", "LockA -> LockD");
        }
    }

    public void testDifferentLockFactories_policyExecution() {
        CycleDetectingLockFactory otherFactory = CycleDetectingLockFactory.newInstance((CycleDetectingLockFactory.Policy)CycleDetectingLockFactory.Policies.WARN);
        ReentrantLock lockD = otherFactory.newReentrantLock("LockD");
        lockD.lock();
        this.lockA.lock();
        this.lockA.unlock();
        lockD.unlock();
        this.lockA.lock();
        lockD.lock();
    }

    public void testReentrantLock_tryLock() throws Exception {
        LockingThread thread = new LockingThread(this.lockA);
        thread.start();
        thread.waitUntilHoldingLock();
        CycleDetectingLockFactoryTest.assertFalse((boolean)this.lockA.tryLock());
        thread.releaseLockAndFinish();
        CycleDetectingLockFactoryTest.assertTrue((boolean)this.lockA.tryLock());
    }

    public void testReentrantWriteLock_tryLock() throws Exception {
        LockingThread thread = new LockingThread(this.writeLockA);
        thread.start();
        thread.waitUntilHoldingLock();
        CycleDetectingLockFactoryTest.assertFalse((boolean)this.writeLockA.tryLock());
        CycleDetectingLockFactoryTest.assertFalse((boolean)this.readLockA.tryLock());
        thread.releaseLockAndFinish();
        CycleDetectingLockFactoryTest.assertTrue((boolean)this.writeLockA.tryLock());
        CycleDetectingLockFactoryTest.assertTrue((boolean)this.readLockA.tryLock());
    }

    public void testReentrantReadLock_tryLock() throws Exception {
        LockingThread thread = new LockingThread(this.readLockA);
        thread.start();
        thread.waitUntilHoldingLock();
        CycleDetectingLockFactoryTest.assertFalse((boolean)this.writeLockA.tryLock());
        CycleDetectingLockFactoryTest.assertTrue((boolean)this.readLockA.tryLock());
        this.readLockA.unlock();
        thread.releaseLockAndFinish();
        CycleDetectingLockFactoryTest.assertTrue((boolean)this.writeLockA.tryLock());
        CycleDetectingLockFactoryTest.assertTrue((boolean)this.readLockA.tryLock());
    }

    public void testReentrantReadWriteLock_implDoesNotExposeShadowedLocks() {
        CycleDetectingLockFactoryTest.assertEquals((String)"Unexpected number of public methods in ReentrantReadWriteLock. The correctness of CycleDetectingReentrantReadWriteLock depends on the fact that the shadowed ReadLock and WriteLock are never used or exposed by the superclass implementation. If the implementation has changed, the code must be re-inspected to ensure that the assumption is still valid.", (int)24, (int)ReentrantReadWriteLock.class.getMethods().length);
    }

    private void checkMessage(IllegalStateException exception, String ... expectedLockCycle) {
        String regex = Joiner.on((String)"\\b.*\\b").join((Object[])expectedLockCycle);
        CycleDetectingLockFactoryTest.assertContainsRegex(regex, exception.getMessage());
    }

    private static void assertContainsRegex(String expectedRegex, String actual) {
        Pattern pattern = Pattern.compile(expectedRegex);
        Matcher matcher = pattern.matcher(actual);
        if (!matcher.find()) {
            String actualDesc = actual == null ? "null" : '<' + actual + '>';
            CycleDetectingLockFactoryTest.fail((String)("expected to contain regex:<" + expectedRegex + "> but was:" + actualDesc));
        }
    }

    private static enum OtherOrder {
        FIRST,
        SECOND,
        THIRD;

    }

    private static enum MyOrder {
        FIRST,
        SECOND,
        THIRD;

    }

    private static class LockingThread
    extends Thread {
        final CountDownLatch locked = new CountDownLatch(1);
        final CountDownLatch finishLatch = new CountDownLatch(1);
        final Lock lock;

        LockingThread(Lock lock) {
            this.lock = lock;
        }

        @Override
        public void run() {
            this.lock.lock();
            try {
                this.locked.countDown();
                this.finishLatch.await(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                Assert.fail((String)e.toString());
            }
            finally {
                this.lock.unlock();
            }
        }

        void waitUntilHoldingLock() throws InterruptedException {
            this.locked.await(1L, TimeUnit.MINUTES);
        }

        void releaseLockAndFinish() throws InterruptedException {
            this.finishLatch.countDown();
            this.join(10000L);
            Assert.assertFalse((boolean)this.isAlive());
        }
    }
}

