/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.mockito.Mockito;

@GwtCompatible(emulated=true)
public class FutureCallbackTest
extends TestCase {
    public void testSameThreadSuccess() {
        SettableFuture f = SettableFuture.create();
        MockCallback callback = new MockCallback("foo");
        Futures.addCallback((ListenableFuture)f, (FutureCallback)callback);
        f.set((Object)"foo");
    }

    public void testExecutorSuccess() {
        CountingSameThreadExecutor ex = new CountingSameThreadExecutor();
        SettableFuture f = SettableFuture.create();
        MockCallback callback = new MockCallback("foo");
        Futures.addCallback((ListenableFuture)f, (FutureCallback)callback, (Executor)ex);
        f.set((Object)"foo");
        FutureCallbackTest.assertEquals((int)1, (int)ex.runCount);
    }

    public void testSameThreadExecutionException() {
        SettableFuture f = SettableFuture.create();
        IllegalArgumentException e = new IllegalArgumentException("foo not found");
        MockCallback callback = new MockCallback(e);
        Futures.addCallback((ListenableFuture)f, (FutureCallback)callback);
        f.setException((Throwable)e);
    }

    public void testCancel() {
        SettableFuture f = SettableFuture.create();
        FutureCallback<String> callback = new FutureCallback<String>(){
            private boolean called = false;

            public void onSuccess(String result) {
                Assert.fail((String)"Was not expecting onSuccess() to be called.");
            }

            public synchronized void onFailure(Throwable t) {
                Assert.assertFalse((boolean)this.called);
                Truth.assertThat((Throwable)t).isInstanceOf(CancellationException.class);
                this.called = true;
            }
        };
        Futures.addCallback((ListenableFuture)f, (FutureCallback)callback);
        f.cancel(true);
    }

    public void testThrowErrorFromGet() {
        AssertionError error = new AssertionError((Object)"ASSERT!");
        ListenableFuture f = ThrowingFuture.throwingError((Error)((Object)error));
        MockCallback callback = new MockCallback((Throwable)((Object)error));
        Futures.addCallback(f, (FutureCallback)callback);
    }

    public void testRuntimeExeceptionFromGet() {
        IllegalArgumentException e = new IllegalArgumentException("foo not found");
        ListenableFuture f = ThrowingFuture.throwingRuntimeException(e);
        MockCallback callback = new MockCallback(e);
        Futures.addCallback(f, (FutureCallback)callback);
    }

    @GwtIncompatible
    public void testOnSuccessThrowsRuntimeException() throws Exception {
        RuntimeException exception = new RuntimeException();
        String result = "result";
        SettableFuture future = SettableFuture.create();
        FutureCallback callback = (FutureCallback)Mockito.mock(FutureCallback.class);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)callback);
        ((FutureCallback)Mockito.doThrow((Throwable)exception).when((Object)callback)).onSuccess((Object)result);
        future.set((Object)result);
        FutureCallbackTest.assertEquals((String)result, (String)((String)future.get()));
        ((FutureCallback)Mockito.verify((Object)callback)).onSuccess((Object)result);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callback});
    }

    @GwtIncompatible
    public void testOnSuccessThrowsError() throws Exception {
        class TestError
        extends Error {
            TestError() {
            }
        }
        TestError error = new TestError();
        String result = "result";
        SettableFuture future = SettableFuture.create();
        FutureCallback callback = (FutureCallback)Mockito.mock(FutureCallback.class);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)callback);
        ((FutureCallback)Mockito.doThrow((Throwable)error).when((Object)callback)).onSuccess((Object)result);
        try {
            future.set((Object)result);
            FutureCallbackTest.fail((String)"Should have thrown");
        }
        catch (TestError e) {
            FutureCallbackTest.assertSame((Object)error, (Object)e);
        }
        FutureCallbackTest.assertEquals((String)result, (String)((String)future.get()));
        ((FutureCallback)Mockito.verify((Object)callback)).onSuccess((Object)result);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callback});
    }

    public void testWildcardFuture() {
        SettableFuture settable;
        SettableFuture f = settable = SettableFuture.create();
        FutureCallback<Object> callback = new FutureCallback<Object>(){

            public void onSuccess(Object result) {
            }

            public void onFailure(Throwable t) {
            }
        };
        Futures.addCallback((ListenableFuture)f, (FutureCallback)callback);
    }

    private final class MockCallback
    implements FutureCallback<String> {
        @Nullable
        private String value = null;
        @Nullable
        private Throwable failure = null;
        private boolean wasCalled = false;

        MockCallback(String expectedValue) {
            this.value = expectedValue;
        }

        public MockCallback(Throwable expectedFailure) {
            this.failure = expectedFailure;
        }

        public synchronized void onSuccess(String result) {
            Assert.assertFalse((boolean)this.wasCalled);
            this.wasCalled = true;
            Assert.assertEquals((String)this.value, (String)result);
        }

        public synchronized void onFailure(Throwable t) {
            Assert.assertFalse((boolean)this.wasCalled);
            this.wasCalled = true;
            Assert.assertEquals((Object)this.failure, (Object)t);
        }
    }

    private static class ThrowingFuture<V>
    implements ListenableFuture<V> {
        private final Error error;
        private final RuntimeException runtime;

        public static <V> ListenableFuture<V> throwingError(Error error) {
            return new ThrowingFuture<V>(error);
        }

        public static <V> ListenableFuture<V> throwingRuntimeException(RuntimeException e) {
            return new ThrowingFuture<V>(e);
        }

        private ThrowingFuture(Error error) {
            this.error = (Error)Preconditions.checkNotNull((Object)error);
            this.runtime = null;
        }

        public ThrowingFuture(RuntimeException e) {
            this.runtime = (RuntimeException)Preconditions.checkNotNull((Object)e);
            this.error = null;
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isDone() {
            return true;
        }

        public V get() {
            this.throwOnGet();
            throw new AssertionError((Object)"Unreachable");
        }

        public V get(long timeout, TimeUnit unit) {
            this.throwOnGet();
            throw new AssertionError((Object)"Unreachable");
        }

        public void addListener(Runnable listener, Executor executor) {
            executor.execute(listener);
        }

        private void throwOnGet() {
            if (this.error != null) {
                throw this.error;
            }
            throw this.runtime;
        }
    }

    private class CountingSameThreadExecutor
    implements Executor {
        int runCount = 0;

        private CountingSameThreadExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
            ++this.runCount;
        }
    }
}

