/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.util.concurrent.AbstractChainedListenableFutureTest;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;

public class FuturesTransformAsyncTest
extends AbstractChainedListenableFutureTest<String> {
    protected static final int SLOW_OUTPUT_VALID_INPUT_DATA = 2;
    protected static final int SLOW_FUNC_VALID_INPUT_DATA = 3;
    private static final String RESULT_DATA = "SUCCESS";
    private SettableFuture<String> outputFuture;
    private CountDownLatch funcIsWaitingLatch;
    private CountDownLatch funcCompletionLatch;

    @Override
    protected ListenableFuture<String> buildChainingFuture(ListenableFuture<Integer> inputFuture) {
        this.outputFuture = SettableFuture.create();
        this.funcIsWaitingLatch = new CountDownLatch(1);
        this.funcCompletionLatch = new CountDownLatch(1);
        return Futures.transformAsync(inputFuture, (AsyncFunction)new ChainingFunction());
    }

    @Override
    protected String getSuccessfulResult() {
        return RESULT_DATA;
    }

    public void testFutureGetThrowsFunctionException() throws Exception {
        this.inputFuture.set((Object)-1);
        this.listener.assertException((Throwable)EXCEPTION);
    }

    public void testFutureGetThrowsCancellationIfInputCancelled() throws Exception {
        this.inputFuture.cancel(true);
        try {
            this.resultFuture.get();
            FuturesTransformAsyncTest.fail((String)"Result future must throw CancellationException if input future is cancelled.");
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void testFutureGetThrowsCancellationIfOutputCancelled() throws Exception {
        this.inputFuture.set((Object)2);
        this.outputFuture.cancel(true);
        try {
            this.resultFuture.get();
            FuturesTransformAsyncTest.fail((String)"Result future must throw CancellationException if function output future is cancelled.");
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void testFutureCancelBeforeInputCompletion() throws Exception {
        FuturesTransformAsyncTest.assertTrue((boolean)this.resultFuture.cancel(true));
        FuturesTransformAsyncTest.assertTrue((boolean)this.resultFuture.isCancelled());
        FuturesTransformAsyncTest.assertTrue((boolean)this.inputFuture.isCancelled());
        FuturesTransformAsyncTest.assertFalse((boolean)this.outputFuture.isCancelled());
        try {
            this.resultFuture.get();
            FuturesTransformAsyncTest.fail((String)"Result future is cancelled and should have thrown a CancellationException");
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void testFutureCancellableBeforeOutputCompletion() throws Exception {
        this.inputFuture.set((Object)2);
        FuturesTransformAsyncTest.assertTrue((boolean)this.resultFuture.cancel(true));
        FuturesTransformAsyncTest.assertTrue((boolean)this.resultFuture.isCancelled());
        FuturesTransformAsyncTest.assertFalse((boolean)this.inputFuture.isCancelled());
        FuturesTransformAsyncTest.assertTrue((boolean)this.outputFuture.isCancelled());
        try {
            this.resultFuture.get();
            FuturesTransformAsyncTest.fail((String)"Result future is cancelled and should have thrown a CancellationException");
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void testFutureCancellableBeforeFunctionCompletion() throws Exception {
        new Thread(){

            @Override
            public void run() {
                FuturesTransformAsyncTest.this.inputFuture.set((Object)3);
            }
        }.start();
        this.funcIsWaitingLatch.await();
        FuturesTransformAsyncTest.assertTrue((boolean)this.resultFuture.cancel(true));
        FuturesTransformAsyncTest.assertTrue((boolean)this.resultFuture.isCancelled());
        FuturesTransformAsyncTest.assertFalse((boolean)this.inputFuture.isCancelled());
        FuturesTransformAsyncTest.assertFalse((boolean)this.outputFuture.isCancelled());
        try {
            this.resultFuture.get();
            FuturesTransformAsyncTest.fail((String)"Result future is cancelled and should have thrown a CancellationException");
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        this.funcCompletionLatch.countDown();
        try {
            this.outputFuture.get();
            FuturesTransformAsyncTest.fail((String)"The function output future is cancelled and should have thrown a CancellationException");
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void testFutureCancelAfterCompletion() throws Exception {
        this.inputFuture.set((Object)1);
        FuturesTransformAsyncTest.assertFalse((boolean)this.resultFuture.cancel(true));
        FuturesTransformAsyncTest.assertFalse((boolean)this.resultFuture.isCancelled());
        FuturesTransformAsyncTest.assertFalse((boolean)this.inputFuture.isCancelled());
        FuturesTransformAsyncTest.assertFalse((boolean)this.outputFuture.isCancelled());
        FuturesTransformAsyncTest.assertEquals((String)RESULT_DATA, (String)((String)this.resultFuture.get()));
    }

    public void testFutureGetThrowsRuntimeException() throws Exception {
        BadFuture badInput = new BadFuture((ListenableFuture<Integer>)Futures.immediateFuture((Object)20));
        ListenableFuture<String> chain = this.buildChainingFuture((ListenableFuture<Integer>)badInput);
        try {
            chain.get();
            FuturesTransformAsyncTest.fail((String)"Future.get must throw an exception when the input future fails.");
        }
        catch (ExecutionException e) {
            FuturesTransformAsyncTest.assertSame(RuntimeException.class, e.getCause().getClass());
        }
    }

    public static class BadFuture
    extends ForwardingListenableFuture.SimpleForwardingListenableFuture<Integer> {
        protected BadFuture(ListenableFuture<Integer> delegate) {
            super(delegate);
        }

        public Integer get() {
            throw new RuntimeException("Oops");
        }
    }

    private class ChainingFunction
    implements AsyncFunction<Integer, String> {
        private ChainingFunction() {
        }

        public ListenableFuture<String> apply(Integer input) {
            switch (input) {
                case 1: {
                    FuturesTransformAsyncTest.this.outputFuture.set((Object)FuturesTransformAsyncTest.RESULT_DATA);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    FuturesTransformAsyncTest.this.funcIsWaitingLatch.countDown();
                    Uninterruptibles.awaitUninterruptibly((CountDownLatch)FuturesTransformAsyncTest.this.funcCompletionLatch);
                    break;
                }
                default: {
                    throw new UndeclaredThrowableException(AbstractChainedListenableFutureTest.EXCEPTION);
                }
            }
            return FuturesTransformAsyncTest.this.outputFuture;
        }
    }
}

