/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.SerializingExecutor;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import junit.framework.TestCase;

public class SerializingExecutorTest
extends TestCase {
    private FakeExecutor fakePool;
    private SerializingExecutor e;

    public void setUp() {
        this.fakePool = new FakeExecutor();
        this.e = new SerializingExecutor((Executor)this.fakePool);
    }

    public void testSerializingNullExecutor_fails() {
        try {
            new SerializingExecutor(null);
            SerializingExecutorTest.fail((String)"Should have failed with NullPointerException.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBasics() {
        final AtomicInteger totalCalls = new AtomicInteger();
        Runnable intCounter = new Runnable(){

            @Override
            public void run() {
                totalCalls.incrementAndGet();
                Assert.assertFalse((boolean)SerializingExecutorTest.this.fakePool.hasNext());
            }
        };
        SerializingExecutorTest.assertFalse((boolean)this.fakePool.hasNext());
        this.e.execute(intCounter);
        SerializingExecutorTest.assertTrue((boolean)this.fakePool.hasNext());
        this.e.execute(intCounter);
        SerializingExecutorTest.assertEquals((int)0, (int)totalCalls.get());
        this.fakePool.runAll();
        SerializingExecutorTest.assertEquals((int)2, (int)totalCalls.get());
        SerializingExecutorTest.assertFalse((boolean)this.fakePool.hasNext());
        this.e.execute(intCounter);
        this.e.execute(intCounter);
        this.e.execute(intCounter);
        SerializingExecutorTest.assertEquals((int)2, (int)totalCalls.get());
        this.fakePool.runAll();
        SerializingExecutorTest.assertEquals((int)5, (int)totalCalls.get());
        SerializingExecutorTest.assertFalse((boolean)this.fakePool.hasNext());
    }

    public void testSuspend() {
        final AtomicInteger totalCalls = new AtomicInteger();
        Runnable suspender = new Runnable(){

            @Override
            public void run() {
                totalCalls.incrementAndGet();
                SerializingExecutorTest.this.e.suspend();
            }
        };
        SerializingExecutorTest.assertFalse((boolean)this.fakePool.hasNext());
        this.e.execute(suspender);
        SerializingExecutorTest.assertTrue((boolean)this.fakePool.hasNext());
        this.e.execute(suspender);
        this.fakePool.runAll();
        SerializingExecutorTest.assertEquals((int)1, (int)totalCalls.get());
        SerializingExecutorTest.assertFalse((boolean)this.fakePool.hasNext());
        this.e.execute(suspender);
        SerializingExecutorTest.assertFalse((boolean)this.fakePool.hasNext());
        this.e.resume();
        SerializingExecutorTest.assertTrue((boolean)this.fakePool.hasNext());
        this.fakePool.runAll();
        SerializingExecutorTest.assertEquals((int)2, (int)totalCalls.get());
        SerializingExecutorTest.assertFalse((boolean)this.fakePool.hasNext());
        this.e.suspend();
        this.e.resume();
        SerializingExecutorTest.assertFalse((boolean)this.fakePool.hasNext());
        this.e.resume();
        SerializingExecutorTest.assertTrue((boolean)this.fakePool.hasNext());
        this.fakePool.runAll();
        SerializingExecutorTest.assertEquals((int)3, (int)totalCalls.get());
    }

    public void testOrdering() {
        final ArrayList callOrder = Lists.newArrayList();
        class FakeOp
        implements Runnable {
            final int op;

            FakeOp(int op) {
                this.op = op;
            }

            @Override
            public void run() {
                callOrder.add(this.op);
            }
        }
        this.e.execute((Runnable)new FakeOp(0));
        this.e.execute((Runnable)new FakeOp(1));
        this.e.execute((Runnable)new FakeOp(2));
        this.fakePool.runAll();
        SerializingExecutorTest.assertEquals((Object)ImmutableList.of((Object)0, (Object)1, (Object)2), (Object)callOrder);
    }

    public void testPrependContinuation() {
        final ArrayList callOrder = Lists.newArrayList();
        class FakeOp
        implements Runnable {
            final int op;

            FakeOp(int op) {
                this.op = op;
            }

            @Override
            public void run() {
                callOrder.add(this.op);
            }
        }
        this.e.execute((Runnable)new FakeOp(1));
        this.e.execute((Runnable)new FakeOp(2));
        this.e.executeFirst((Runnable)new FakeOp(0));
        this.fakePool.runAll();
        SerializingExecutorTest.assertEquals((Object)ImmutableList.of((Object)0, (Object)1, (Object)2), (Object)callOrder);
    }

    public void testRuntimeException_doesNotStopExecution() {
        final AtomicInteger numCalls = new AtomicInteger();
        Runnable runMe = new Runnable(){

            @Override
            public void run() {
                numCalls.incrementAndGet();
                throw new RuntimeException("FAKE EXCEPTION!");
            }
        };
        this.e.execute(runMe);
        this.e.execute(runMe);
        this.fakePool.runAll();
        SerializingExecutorTest.assertEquals((int)2, (int)numCalls.get());
    }

    public void testInterrupt_doesNotStopExecution() {
        final AtomicInteger numCalls = new AtomicInteger();
        Runnable runMe = new Runnable(){

            @Override
            public void run() {
                numCalls.incrementAndGet();
            }
        };
        Thread.currentThread().interrupt();
        this.e.execute(runMe);
        this.e.execute(runMe);
        this.fakePool.runAll();
        SerializingExecutorTest.assertEquals((int)2, (int)numCalls.get());
        SerializingExecutorTest.assertTrue((boolean)Thread.interrupted());
    }

    public void testDelegateRejection() {
        final AtomicInteger numCalls = new AtomicInteger();
        final AtomicBoolean reject = new AtomicBoolean(true);
        SerializingExecutor executor = new SerializingExecutor(new Executor(){

            @Override
            public void execute(Runnable r) {
                if (reject.get()) {
                    throw new RejectedExecutionException();
                }
                r.run();
            }
        });
        Runnable task = new Runnable(){

            @Override
            public void run() {
                numCalls.incrementAndGet();
            }
        };
        try {
            executor.execute(task);
            SerializingExecutorTest.fail();
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        SerializingExecutorTest.assertEquals((int)0, (int)numCalls.get());
        reject.set(false);
        executor.execute(task);
        SerializingExecutorTest.assertEquals((int)2, (int)numCalls.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTaskThrowsError() throws Exception {
        final CyclicBarrier barrier = new CyclicBarrier(2);
        ExecutorService service = Executors.newSingleThreadExecutor();
        try {
            SerializingExecutor executor = new SerializingExecutor((Executor)service);
            Runnable errorTask = new Runnable(){

                @Override
                public void run() {
                    class MyError
                    extends Error {
                        MyError() {
                        }
                    }
                    throw new MyError();
                }
            };
            Runnable barrierTask = new Runnable(){

                @Override
                public void run() {
                    try {
                        barrier.await();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            executor.execute(errorTask);
            service.execute(barrierTask);
            barrier.await(10L, TimeUnit.SECONDS);
            executor.execute(barrierTask);
            barrier.await(10L, TimeUnit.SECONDS);
        }
        finally {
            service.shutdown();
        }
    }

    private static class FakeExecutor
    implements Executor {
        Queue<Runnable> tasks = Queues.newArrayDeque();

        private FakeExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            this.tasks.add(command);
        }

        boolean hasNext() {
            return !this.tasks.isEmpty();
        }

        void runNext() {
            Assert.assertTrue((String)"expected at least one task to run", (boolean)this.hasNext());
            this.tasks.remove().run();
        }

        void runAll() {
            while (this.hasNext()) {
                this.runNext();
            }
        }
    }
}

