/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.TestLogHandler;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.google.common.util.concurrent.AbstractService;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.ServiceManager;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import junit.framework.TestCase;

public class ServiceManagerTest
extends TestCase {
    public void testServiceStartupTimes() {
        NoOpDelayedService a = new NoOpDelayedService(150L);
        NoOpDelayedService b = new NoOpDelayedService(353L);
        ServiceManager serviceManager = new ServiceManager(Arrays.asList(new Service[]{a, b}));
        serviceManager.startAsync().awaitHealthy();
        ImmutableMap startupTimes = serviceManager.startupTimes();
        ServiceManagerTest.assertEquals((int)2, (int)startupTimes.size());
        ServiceManagerTest.assertTrue(((Long)startupTimes.get((Object)a) >= 150L ? 1 : 0) != 0);
        ServiceManagerTest.assertTrue(((Long)startupTimes.get((Object)b) >= 353L ? 1 : 0) != 0);
    }

    public void testServiceStartupTimes_selfStartingServices() {
        NoOpDelayedService b = new NoOpDelayedService(353L){

            @Override
            protected void doStart() {
                super.doStart();
                Uninterruptibles.sleepUninterruptibly((long)150L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        };
        NoOpDelayedService a = new NoOpDelayedService(150L, (Service)b){
            final /* synthetic */ Service val$b;
            {
                this.val$b = service;
                super(delay);
            }

            @Override
            protected void doStart() {
                this.val$b.startAsync();
                super.doStart();
            }
        };
        ServiceManager serviceManager = new ServiceManager(Arrays.asList(new Service[]{a, b}));
        serviceManager.startAsync().awaitHealthy();
        ImmutableMap startupTimes = serviceManager.startupTimes();
        ServiceManagerTest.assertEquals((int)2, (int)startupTimes.size());
        ServiceManagerTest.assertTrue(((Long)startupTimes.get((Object)a) >= 150L ? 1 : 0) != 0);
        Truth.assertThat((Long)((Long)startupTimes.get((Object)b))).isNotNull();
    }

    public void testServiceStartStop() {
        NoOpService a = new NoOpService();
        NoOpService b = new NoOpService();
        ServiceManager manager = new ServiceManager(Arrays.asList(new Service[]{a, b}));
        RecordingListener listener = new RecordingListener();
        manager.addListener((ServiceManager.Listener)listener);
        ServiceManagerTest.assertState(manager, Service.State.NEW, new Service[]{a, b});
        ServiceManagerTest.assertFalse((boolean)manager.isHealthy());
        manager.startAsync().awaitHealthy();
        ServiceManagerTest.assertState(manager, Service.State.RUNNING, new Service[]{a, b});
        ServiceManagerTest.assertTrue((boolean)manager.isHealthy());
        ServiceManagerTest.assertTrue((boolean)listener.healthyCalled);
        ServiceManagerTest.assertFalse((boolean)listener.stoppedCalled);
        ServiceManagerTest.assertTrue((boolean)listener.failedServices.isEmpty());
        manager.stopAsync().awaitStopped();
        ServiceManagerTest.assertState(manager, Service.State.TERMINATED, new Service[]{a, b});
        ServiceManagerTest.assertFalse((boolean)manager.isHealthy());
        ServiceManagerTest.assertTrue((boolean)listener.stoppedCalled);
        ServiceManagerTest.assertTrue((boolean)listener.failedServices.isEmpty());
    }

    public void testFailStart() throws Exception {
        NoOpService a = new NoOpService();
        FailStartService b = new FailStartService();
        NoOpService c = new NoOpService();
        FailStartService d = new FailStartService();
        NoOpService e = new NoOpService();
        ServiceManager manager = new ServiceManager(Arrays.asList(new Service[]{a, b, c, d, e}));
        RecordingListener listener = new RecordingListener();
        manager.addListener((ServiceManager.Listener)listener);
        ServiceManagerTest.assertState(manager, Service.State.NEW, new Service[]{a, b, c, d, e});
        try {
            manager.startAsync().awaitHealthy();
            ServiceManagerTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ServiceManagerTest.assertFalse((boolean)listener.healthyCalled);
        ServiceManagerTest.assertState(manager, Service.State.RUNNING, new Service[]{a, c, e});
        ServiceManagerTest.assertEquals((Object)ImmutableSet.of((Object)((Object)b), (Object)((Object)d)), listener.failedServices);
        ServiceManagerTest.assertState(manager, Service.State.FAILED, new Service[]{b, d});
        ServiceManagerTest.assertFalse((boolean)manager.isHealthy());
        manager.stopAsync().awaitStopped();
        ServiceManagerTest.assertFalse((boolean)manager.isHealthy());
        ServiceManagerTest.assertFalse((boolean)listener.healthyCalled);
        ServiceManagerTest.assertTrue((boolean)listener.stoppedCalled);
    }

    public void testFailRun() throws Exception {
        NoOpService a = new NoOpService();
        FailRunService b = new FailRunService();
        ServiceManager manager = new ServiceManager(Arrays.asList(new Service[]{a, b}));
        RecordingListener listener = new RecordingListener();
        manager.addListener((ServiceManager.Listener)listener);
        ServiceManagerTest.assertState(manager, Service.State.NEW, new Service[]{a, b});
        try {
            manager.startAsync().awaitHealthy();
            ServiceManagerTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ServiceManagerTest.assertTrue((boolean)listener.healthyCalled);
        ServiceManagerTest.assertEquals((Object)ImmutableSet.of((Object)((Object)b)), listener.failedServices);
        manager.stopAsync().awaitStopped();
        ServiceManagerTest.assertState(manager, Service.State.FAILED, new Service[]{b});
        ServiceManagerTest.assertState(manager, Service.State.TERMINATED, new Service[]{a});
        ServiceManagerTest.assertTrue((boolean)listener.stoppedCalled);
    }

    public void testFailStop() throws Exception {
        NoOpService a = new NoOpService();
        FailStopService b = new FailStopService();
        NoOpService c = new NoOpService();
        ServiceManager manager = new ServiceManager(Arrays.asList(new Service[]{a, b, c}));
        RecordingListener listener = new RecordingListener();
        manager.addListener((ServiceManager.Listener)listener);
        manager.startAsync().awaitHealthy();
        ServiceManagerTest.assertTrue((boolean)listener.healthyCalled);
        ServiceManagerTest.assertFalse((boolean)listener.stoppedCalled);
        manager.stopAsync().awaitStopped();
        ServiceManagerTest.assertTrue((boolean)listener.stoppedCalled);
        ServiceManagerTest.assertEquals((Object)ImmutableSet.of((Object)((Object)b)), listener.failedServices);
        ServiceManagerTest.assertState(manager, Service.State.FAILED, new Service[]{b});
        ServiceManagerTest.assertState(manager, Service.State.TERMINATED, new Service[]{a, c});
    }

    public void testToString() throws Exception {
        NoOpService a = new NoOpService();
        FailStartService b = new FailStartService();
        ServiceManager manager = new ServiceManager(Arrays.asList(new Service[]{a, b}));
        String toString = manager.toString();
        Truth.assertThat((String)toString).contains((CharSequence)"NoOpService");
        Truth.assertThat((String)toString).contains((CharSequence)"FailStartService");
    }

    public void testTimeouts() throws Exception {
        NoOpDelayedService a = new NoOpDelayedService(50L);
        ServiceManager manager = new ServiceManager(Arrays.asList(new Service[]{a}));
        manager.startAsync();
        try {
            manager.awaitHealthy(1L, TimeUnit.MILLISECONDS);
            ServiceManagerTest.fail();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        manager.awaitHealthy(100L, TimeUnit.MILLISECONDS);
        manager.stopAsync();
        try {
            manager.awaitStopped(1L, TimeUnit.MILLISECONDS);
            ServiceManagerTest.fail();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        manager.awaitStopped(100L, TimeUnit.MILLISECONDS);
    }

    public void testSingleFailedServiceCallsStopped() {
        FailStartService a = new FailStartService();
        ServiceManager manager = new ServiceManager(Arrays.asList(new Service[]{a}));
        RecordingListener listener = new RecordingListener();
        manager.addListener((ServiceManager.Listener)listener);
        try {
            manager.startAsync().awaitHealthy();
            ServiceManagerTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ServiceManagerTest.assertTrue((boolean)listener.stoppedCalled);
    }

    public void testFailStart_singleServiceCallsHealthy() {
        FailStartService a = new FailStartService();
        ServiceManager manager = new ServiceManager(Arrays.asList(new Service[]{a}));
        RecordingListener listener = new RecordingListener();
        manager.addListener((ServiceManager.Listener)listener);
        try {
            manager.startAsync().awaitHealthy();
            ServiceManagerTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ServiceManagerTest.assertFalse((boolean)listener.healthyCalled);
    }

    public void testFailStart_stopOthers() throws TimeoutException {
        FailStartService a = new FailStartService();
        NoOpService b = new NoOpService();
        final ServiceManager manager = new ServiceManager(Arrays.asList(new Service[]{a, b}));
        manager.addListener(new ServiceManager.Listener(){

            public void failure(Service service) {
                manager.stopAsync();
            }
        });
        manager.startAsync();
        manager.awaitStopped(10L, TimeUnit.MILLISECONDS);
    }

    private static void assertState(ServiceManager manager, Service.State state, Service ... services) {
        ImmutableCollection managerServices = manager.servicesByState().get((Object)state);
        for (Service service : services) {
            ServiceManagerTest.assertEquals((String)service.toString(), (Object)state, (Object)service.state());
            ServiceManagerTest.assertEquals((String)service.toString(), (boolean)service.isRunning(), (state == Service.State.RUNNING ? 1 : 0) != 0);
            ServiceManagerTest.assertTrue((String)(managerServices + " should contain " + service), (boolean)managerServices.contains(service));
        }
    }

    public void testEmptyServiceManager() {
        Logger logger = Logger.getLogger(ServiceManager.class.getName());
        logger.setLevel(Level.FINEST);
        TestLogHandler logHandler = new TestLogHandler();
        logger.addHandler((Handler)logHandler);
        ServiceManager manager = new ServiceManager(Arrays.asList(new Service[0]));
        RecordingListener listener = new RecordingListener();
        manager.addListener((ServiceManager.Listener)listener);
        manager.startAsync().awaitHealthy();
        ServiceManagerTest.assertTrue((boolean)manager.isHealthy());
        ServiceManagerTest.assertTrue((boolean)listener.healthyCalled);
        ServiceManagerTest.assertFalse((boolean)listener.stoppedCalled);
        ServiceManagerTest.assertTrue((boolean)listener.failedServices.isEmpty());
        manager.stopAsync().awaitStopped();
        ServiceManagerTest.assertFalse((boolean)manager.isHealthy());
        ServiceManagerTest.assertTrue((boolean)listener.stoppedCalled);
        ServiceManagerTest.assertTrue((boolean)listener.failedServices.isEmpty());
        ServiceManagerTest.assertEquals((String)"ServiceManager{services=[]}", (String)manager.toString());
        ServiceManagerTest.assertTrue((boolean)manager.servicesByState().isEmpty());
        ServiceManagerTest.assertTrue((boolean)manager.startupTimes().isEmpty());
        Formatter logFormatter = new Formatter(){

            @Override
            public String format(LogRecord record) {
                return this.formatMessage(record);
            }
        };
        for (LogRecord record : logHandler.getStoredLogRecords()) {
            Truth.assertThat((String)logFormatter.format(record)).doesNotContain((CharSequence)"NoOpService");
        }
    }

    public void testListenerDeadlock() throws InterruptedException {
        final CountDownLatch failEnter = new CountDownLatch(1);
        final CountDownLatch failLeave = new CountDownLatch(1);
        final CountDownLatch afterStarted = new CountDownLatch(1);
        AbstractService failRunService = new AbstractService(){

            protected void doStart() {
                new Thread(){

                    @Override
                    public void run() {
                        this.notifyStarted();
                        Uninterruptibles.awaitUninterruptibly((CountDownLatch)afterStarted);
                        this.notifyFailed(new Exception("boom"));
                    }
                }.start();
            }

            protected void doStop() {
                this.notifyStopped();
            }
        };
        final ServiceManager manager = new ServiceManager(Arrays.asList(new Service[]{failRunService, new NoOpService()}));
        manager.addListener(new ServiceManager.Listener(){

            public void failure(Service service) {
                failEnter.countDown();
                Uninterruptibles.awaitUninterruptibly((CountDownLatch)failLeave);
            }
        });
        manager.startAsync();
        afterStarted.countDown();
        failEnter.await();
        ServiceManagerTest.assertFalse((String)"State should be updated before calling listeners", (boolean)manager.isHealthy());
        Thread stoppingThread = new Thread(){

            @Override
            public void run() {
                manager.stopAsync().awaitStopped();
            }
        };
        stoppingThread.start();
        stoppingThread.join(1000L);
        ServiceManagerTest.assertFalse((String)"stopAsync has deadlocked!.", (boolean)stoppingThread.isAlive());
        failLeave.countDown();
    }

    public void testPartiallyConstructedManager() {
        Logger logger = Logger.getLogger("global");
        logger.setLevel(Level.FINEST);
        TestLogHandler logHandler = new TestLogHandler();
        logger.addHandler((Handler)logHandler);
        NoOpService service = new NoOpService();
        service.startAsync();
        try {
            new ServiceManager(Arrays.asList(service));
            ServiceManagerTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        service.stopAsync();
        ServiceManagerTest.assertEquals((int)0, (int)logHandler.getStoredLogRecords().size());
    }

    public void testPartiallyConstructedManager_transitionAfterAddListenerBeforeStateIsReady() {
        final NoOpService service1 = new NoOpService();
        Service service2 = new Service(){
            final NoOpService delegate = new NoOpService();

            public final void addListener(Service.Listener listener, Executor executor) {
                service1.startAsync();
                this.delegate.addListener(listener, executor);
            }

            public final Service startAsync() {
                return this.delegate.startAsync();
            }

            public final Service stopAsync() {
                return this.delegate.stopAsync();
            }

            public final void awaitRunning() {
                this.delegate.awaitRunning();
            }

            public final void awaitRunning(long timeout, TimeUnit unit) throws TimeoutException {
                this.delegate.awaitRunning(timeout, unit);
            }

            public final void awaitTerminated() {
                this.delegate.awaitTerminated();
            }

            public final void awaitTerminated(long timeout, TimeUnit unit) throws TimeoutException {
                this.delegate.awaitTerminated(timeout, unit);
            }

            public final boolean isRunning() {
                return this.delegate.isRunning();
            }

            public final Service.State state() {
                return this.delegate.state();
            }

            public final Throwable failureCause() {
                return this.delegate.failureCause();
            }
        };
        try {
            new ServiceManager(Arrays.asList(new Service[]{service1, service2}));
            ServiceManagerTest.fail();
        }
        catch (IllegalArgumentException expected) {
            Truth.assertThat((String)expected.getMessage()).contains((CharSequence)"started transitioning asynchronously");
        }
    }

    public void testTransitionRace() throws TimeoutException {
        for (int k = 0; k < 1000; ++k) {
            ArrayList services = Lists.newArrayList();
            for (int i = 0; i < 5; ++i) {
                services.add(new SnappyShutdownService(i));
            }
            ServiceManager manager = new ServiceManager((Iterable)services);
            manager.startAsync().awaitHealthy();
            manager.stopAsync().awaitStopped(1L, TimeUnit.SECONDS);
        }
    }

    public void testNulls() {
        ServiceManager manager = new ServiceManager(Arrays.asList(new Service[0]));
        new NullPointerTester().setDefault(ServiceManager.Listener.class, (Object)new RecordingListener()).testAllPublicInstanceMethods((Object)manager);
    }

    private static final class RecordingListener
    extends ServiceManager.Listener {
        volatile boolean healthyCalled;
        volatile boolean stoppedCalled;
        final Set<Service> failedServices = Sets.newConcurrentHashSet();

        private RecordingListener() {
        }

        public void healthy() {
            this.healthyCalled = true;
        }

        public void stopped() {
            this.stoppedCalled = true;
        }

        public void failure(Service service) {
            this.failedServices.add(service);
        }
    }

    private static class SnappyShutdownService
    extends AbstractExecutionThreadService {
        final int index;
        final CountDownLatch latch = new CountDownLatch(1);

        SnappyShutdownService(int index) {
            this.index = index;
        }

        protected void run() throws Exception {
            this.latch.await();
        }

        protected void triggerShutdown() {
            this.latch.countDown();
        }

        protected String serviceName() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.index + "]";
        }
    }

    private static class FailStopService
    extends NoOpService {
        private FailStopService() {
        }

        @Override
        protected void doStop() {
            this.notifyFailed(new IllegalStateException("stop failure"));
        }
    }

    private static class FailRunService
    extends NoOpService {
        private FailRunService() {
        }

        @Override
        protected void doStart() {
            super.doStart();
            this.notifyFailed(new IllegalStateException("run failure"));
        }
    }

    private static class FailStartService
    extends NoOpService {
        private FailStartService() {
        }

        @Override
        protected void doStart() {
            this.notifyFailed(new IllegalStateException("start failure"));
        }
    }

    private static class NoOpDelayedService
    extends NoOpService {
        private long delay;

        public NoOpDelayedService(long delay) {
            this.delay = delay;
        }

        @Override
        protected void doStart() {
            new Thread(){

                @Override
                public void run() {
                    Uninterruptibles.sleepUninterruptibly((long)NoOpDelayedService.this.delay, (TimeUnit)TimeUnit.MILLISECONDS);
                    NoOpDelayedService.this.notifyStarted();
                }
            }.start();
        }

        @Override
        protected void doStop() {
            new Thread(){

                @Override
                public void run() {
                    Uninterruptibles.sleepUninterruptibly((long)NoOpDelayedService.this.delay, (TimeUnit)TimeUnit.MILLISECONDS);
                    NoOpDelayedService.this.notifyStopped();
                }
            }.start();
        }
    }

    private static class NoOpService
    extends AbstractService {
        private NoOpService() {
        }

        protected void doStart() {
            this.notifyStarted();
        }

        protected void doStop() {
            this.notifyStopped();
        }
    }
}

