/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.tools.apichecker;

import com.google.gwt.tools.apichecker.ApiElement;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ApiChange
implements Comparable<ApiChange> {
    private static Map<String, Status> cache = new HashMap<String, Status>();
    private ApiElement element = null;
    private String message = null;
    private Status status = null;
    private String stringRepresentation = null;
    private String stringRepresentationWithoutMessage = null;

    public static boolean contains(String str) {
        return cache.get(str) != null;
    }

    public ApiChange(ApiElement element, Status status) {
        this(element, status, null);
    }

    public ApiChange(ApiElement element, Status status, String message) {
        this.element = element;
        this.status = status;
        this.message = message;
    }

    @Override
    public int compareTo(ApiChange arg0) {
        return this.toString().compareTo(arg0.toString());
    }

    public boolean equals(Object o) {
        if (!(o instanceof ApiChange)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public ApiElement getApiElement() {
        return this.element;
    }

    public String getMessage() {
        return this.message;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getStringRepresentationWithoutMessage() {
        if (this.stringRepresentationWithoutMessage == null) {
            this.stringRepresentationWithoutMessage = this.element.getRelativeSignature() + " " + this.status.name();
        }
        return this.stringRepresentationWithoutMessage;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int hashCodeForDuplication() {
        return this.element.hashCode() * 31 + this.status.hashCode() * 23 + (this.message == null ? 0 : this.message.hashCode());
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            this.stringRepresentation = this.getStringRepresentationWithoutMessage() + (this.message == null ? "" : " " + this.message);
        }
        return this.stringRepresentation;
    }

    static {
        for (Status tempStatus : Status.values()) {
            cache.put(tempStatus.name(), tempStatus);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Status {
        ABSTRACT_ADDED,
        ATTRIBUTES_CHANGED_WARNING,
        COMPATIBLE,
        COMPATIBLE_WITH,
        EXCEPTION_TYPE_ERROR,
        FINAL_ADDED,
        MISSING,
        NONABSTRACT_CLASS_MADE_INTERFACE,
        OVERLOADED_METHOD_CALL,
        OVERRIDABLE_METHOD_ARGUMENT_TYPE_CHANGE,
        OVERRIDABLE_METHOD_EXCEPTION_TYPE_CHANGE,
        OVERRIDABLE_METHOD_RETURN_TYPE_CHANGE,
        RETURN_TYPE_ERROR,
        STATIC_ADDED,
        STATIC_REMOVED,
        SUBCLASSABLE_API_CLASS_MADE_INTERFACE,
        SUBCLASSABLE_API_INTERFACE_MADE_CLASS;

    }
}

