/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.tools.apichecker;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JConstructor;
import com.google.gwt.core.ext.typeinfo.JPackage;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dev.javac.CompilationUnit;
import com.google.gwt.dev.javac.CompilationUnitInvalidator;
import com.google.gwt.dev.javac.JdtCompiler;
import com.google.gwt.dev.javac.TypeOracleMediator;
import com.google.gwt.tools.apichecker.ApiPackage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApiContainer {
    private final Map<JClassType, Boolean> apiClassCache = new HashMap<JClassType, Boolean>();
    private final Map<String, ApiPackage> apiPackages = new HashMap<String, ApiPackage>();
    private final Set<String> excludedPackages;
    private final TreeLogger logger;
    private final String name;
    private final TypeOracle typeOracle;

    ApiContainer(String name, Set<CompilationUnit> units, Set<String> excludedPackages, TreeLogger logger) throws UnableToCompleteException {
        this.name = name;
        this.logger = logger;
        logger.log(TreeLogger.INFO, "name = " + name + ", units.size = " + units.size(), null);
        try {
            this.typeOracle = this.getTypeOracleFromCompilationUnits(units);
        }
        catch (FileNotFoundException e2) {
            System.err.println("Do you have a reference version of the API checked out?");
            throw new IllegalArgumentException(e2);
        }
        catch (IOException e3) {
            throw new IllegalArgumentException(e3);
        }
        catch (NotFoundException e4) {
            logger.log(TreeLogger.ERROR, "logged a NotFoundException", (Throwable)e4);
            throw new UnableToCompleteException();
        }
        this.excludedPackages = excludedPackages;
        this.initializeApiPackages();
    }

    public String getApiAsString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Api: " + this.name + ", size = " + this.apiPackages.size() + "\n\n");
        ArrayList<ApiPackage> sortedApiPackages = new ArrayList<ApiPackage>(this.apiPackages.values());
        Collections.sort(sortedApiPackages);
        for (ApiPackage apiPackage : sortedApiPackages) {
            sb.append(apiPackage.getApiAsString());
        }
        return sb.toString();
    }

    ApiPackage getApiPackage(String packageName) {
        return this.apiPackages.get(packageName);
    }

    HashSet<String> getApiPackageNames() {
        return new HashSet<String>(this.apiPackages.keySet());
    }

    Set<ApiPackage> getApiPackagesBySet(Set<String> names) {
        HashSet<ApiPackage> ret = new HashSet<ApiPackage>();
        for (String packageName : names) {
            ret.add(this.apiPackages.get(packageName));
        }
        return ret;
    }

    TreeLogger getLogger() {
        return this.logger;
    }

    String getName() {
        return this.name;
    }

    boolean isApiClass(JClassType classType) {
        Boolean ret = this.apiClassCache.get(classType);
        if (ret != null) {
            return ret;
        }
        this.apiClassCache.put(classType, Boolean.FALSE);
        boolean bool = this.computeIsApiClass(classType);
        if (bool) {
            this.apiClassCache.put(classType, Boolean.TRUE);
        } else {
            this.apiClassCache.put(classType, Boolean.FALSE);
        }
        return bool;
    }

    boolean isInstantiableApiClass(JClassType classType) {
        return !classType.isAbstract() && this.isApiClass(classType) && this.hasPublicOrProtectedConstructor(classType);
    }

    boolean isNotsubclassableApiClass(JClassType classType) {
        return this.isApiClass(classType) && !this.isSubclassable(classType);
    }

    boolean isSubclassableApiClass(JClassType classType) {
        return this.isApiClass(classType) && this.isSubclassable(classType);
    }

    private boolean computeIsApiClass(JClassType classType) {
        if (this.excludedPackages.contains(classType.getPackage().getName())) {
            return false;
        }
        if (this.isPublicOuterClass(classType)) {
            return true;
        }
        if (!classType.isMemberType()) {
            return false;
        }
        JClassType enclosingType = classType.getEnclosingType();
        if (classType.isPublic()) {
            return this.isApiClass(enclosingType) || this.isAnySubtypeAnApiClass(enclosingType);
        }
        if (classType.isProtected()) {
            return this.isSubclassableApiClass(enclosingType) || this.isAnySubtypeASubclassableApiClass(enclosingType);
        }
        return false;
    }

    private TypeOracle getTypeOracleFromCompilationUnits(Set<CompilationUnit> units) throws NotFoundException, IOException, UnableToCompleteException {
        JdtCompiler.compile(units);
        if (CompilationUnitInvalidator.invalidateUnitsWithErrors((TreeLogger)this.logger, units)) {
            this.logger.log(TreeLogger.ERROR, "Unable to build typeOracle for " + this.getName());
            throw new UnableToCompleteException();
        }
        TypeOracleMediator mediator = new TypeOracleMediator();
        mediator.refresh(this.logger, units);
        this.logger.log(TreeLogger.INFO, "API " + this.name + ", Finished with building typeOracle, added " + units.size() + " files", null);
        return mediator.getTypeOracle();
    }

    private boolean hasPublicOrProtectedConstructor(JClassType classType) {
        JConstructor[] constructors;
        for (JConstructor constructor : constructors = classType.getConstructors()) {
            if (!constructor.isPublic() && !constructor.isProtected()) continue;
            return true;
        }
        return false;
    }

    private void initializeApiPackages() {
        HashSet<JPackage> allPackages = new HashSet<JPackage>(Arrays.asList(this.typeOracle.getPackages()));
        HashSet<String> packagesNotAdded = new HashSet<String>();
        for (JPackage packageObject : allPackages) {
            if (this.isApiPackage(packageObject)) {
                ApiPackage apiPackageObj = new ApiPackage(packageObject, this);
                this.apiPackages.put(apiPackageObj.getName(), apiPackageObj);
                continue;
            }
            packagesNotAdded.add(packageObject.toString());
        }
        if (packagesNotAdded.size() > 0) {
            this.logger.log(TreeLogger.DEBUG, "API " + this.name + ": not added " + packagesNotAdded.size() + " packages: " + packagesNotAdded, null);
        }
        if (this.apiPackages.size() > 0) {
            this.logger.log(TreeLogger.INFO, "API " + this.name + " " + this.apiPackages.size() + " Api packages: " + this.apiPackages.keySet(), null);
        }
    }

    private boolean isAnySubtypeAnApiClass(JClassType classType) {
        JClassType[] subTypes;
        for (JClassType tempType : subTypes = classType.getSubtypes()) {
            if (!this.isApiClass(tempType)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnySubtypeASubclassableApiClass(JClassType classType) {
        JClassType[] subTypes;
        for (JClassType tempType : subTypes = classType.getSubtypes()) {
            if (!this.isSubclassableApiClass(tempType)) continue;
            return true;
        }
        return false;
    }

    private boolean isApiPackage(JPackage packageObject) {
        JClassType[] classTypes;
        for (JClassType classType : classTypes = packageObject.getTypes()) {
            if (!this.isPublicOuterClass(classType)) continue;
            return true;
        }
        return false;
    }

    private boolean isPublicOuterClass(JClassType classType) {
        return classType.isPublic() && !classType.isMemberType();
    }

    private boolean isSubclassable(JClassType classType) {
        return !classType.isFinal() && this.hasPublicOrProtectedConstructor(classType);
    }
}

