/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.tools.apichecker;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JConstructor;
import com.google.gwt.core.ext.typeinfo.JPackage;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dev.CompilerContext;
import com.google.gwt.dev.javac.CompilationProblemReporter;
import com.google.gwt.dev.javac.CompilationUnit;
import com.google.gwt.dev.javac.CompilationUnitBuilder;
import com.google.gwt.dev.javac.CompilationUnitTypeOracleUpdater;
import com.google.gwt.dev.javac.JdtCompiler;
import com.google.gwt.dev.resource.Resource;
import com.google.gwt.dev.util.arg.SourceLevel;
import com.google.gwt.tools.apichecker.ApiPackage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ApiContainer {
    private final Map<JClassType, Boolean> apiClassCache = new HashMap<JClassType, Boolean>();
    private final Map<String, ApiPackage> apiPackages = new HashMap<String, ApiPackage>();
    private final CompilerContext compilerContext = new CompilerContext();
    private final Set<String> excludedPackages;
    private final TreeLogger logger;
    private final String name;
    private final TypeOracle typeOracle;

    ApiContainer(String name, Set<Resource> resources, Set<String> excludedPackages, TreeLogger logger) throws UnableToCompleteException {
        this(name, resources, excludedPackages, logger, null);
    }

    ApiContainer(String name, Set<Resource> resources, Set<String> excludedPackages, TreeLogger logger, SourceLevel sourceLevel) throws UnableToCompleteException {
        this.name = name;
        this.logger = logger;
        logger.log(TreeLogger.INFO, "name = " + name + ", builders.size = " + resources.size(), null);
        this.compilerContext.getOptions().setSourceLevel(sourceLevel == null ? SourceLevel.DEFAULT_SOURCE_LEVEL : sourceLevel);
        this.typeOracle = this.createTypeOracle(resources);
        this.excludedPackages = excludedPackages;
        this.initializeApiPackages();
    }

    public String getApiAsString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Api: " + this.name + ", size = " + this.apiPackages.size() + "\n\n");
        ArrayList<ApiPackage> sortedApiPackages = new ArrayList<ApiPackage>(this.apiPackages.values());
        Collections.sort(sortedApiPackages);
        for (ApiPackage apiPackage : sortedApiPackages) {
            sb.append(apiPackage.getApiAsString());
        }
        return sb.toString();
    }

    ApiPackage getApiPackage(String packageName) {
        return this.apiPackages.get(packageName);
    }

    HashSet<String> getApiPackageNames() {
        return new HashSet<String>(this.apiPackages.keySet());
    }

    Set<ApiPackage> getApiPackagesBySet(Set<String> names) {
        HashSet<ApiPackage> ret = new HashSet<ApiPackage>();
        for (String packageName : names) {
            ret.add(this.apiPackages.get(packageName));
        }
        return ret;
    }

    TreeLogger getLogger() {
        return this.logger;
    }

    String getName() {
        return this.name;
    }

    boolean isApiClass(JClassType classType) {
        Boolean ret = this.apiClassCache.get(classType);
        if (ret != null) {
            return ret;
        }
        this.apiClassCache.put(classType, Boolean.FALSE);
        boolean bool = this.computeIsApiClass(classType);
        if (bool) {
            this.apiClassCache.put(classType, Boolean.TRUE);
        } else {
            this.apiClassCache.put(classType, Boolean.FALSE);
        }
        return bool;
    }

    boolean isInstantiableApiClass(JClassType classType) {
        return !classType.isAbstract() && this.isApiClass(classType) && this.hasPublicOrProtectedConstructor(classType);
    }

    boolean isNotsubclassableApiClass(JClassType classType) {
        return this.isApiClass(classType) && !this.isSubclassable(classType);
    }

    boolean isSubclassableApiClass(JClassType classType) {
        return this.isApiClass(classType) && this.isSubclassable(classType);
    }

    private boolean computeIsApiClass(JClassType classType) {
        if (this.excludedPackages.contains(classType.getPackage().getName())) {
            return false;
        }
        if (this.isPublicOuterClass(classType)) {
            return true;
        }
        if (!classType.isMemberType()) {
            return false;
        }
        JClassType enclosingType = classType.getEnclosingType();
        if (classType.isPublic()) {
            return this.isApiClass(enclosingType) || this.isAnySubtypeAnApiClass(enclosingType);
        }
        if (classType.isProtected()) {
            return this.isSubclassableApiClass(enclosingType) || this.isAnySubtypeASubclassableApiClass(enclosingType);
        }
        return false;
    }

    private TypeOracle createTypeOracle(Set<Resource> resources) throws UnableToCompleteException {
        ArrayList<CompilationUnitBuilder> builders = new ArrayList<CompilationUnitBuilder>();
        for (Resource resource : resources) {
            CompilationUnitBuilder builder = CompilationUnitBuilder.create((Resource)resource);
            builders.add(builder);
        }
        List units = JdtCompiler.compile((TreeLogger)this.logger, (CompilerContext)this.compilerContext, builders);
        boolean anyError = false;
        TreeLogger branch = this.logger.branch(TreeLogger.TRACE, "Checking for compile errors");
        for (CompilationUnit unit : units) {
            CompilationProblemReporter.reportErrors((TreeLogger)branch, (CompilationUnit)unit, (boolean)false);
            anyError |= unit.isError();
        }
        if (anyError) {
            this.logger.log(TreeLogger.ERROR, "Unable to build typeOracle for " + this.getName());
            throw new UnableToCompleteException();
        }
        CompilationUnitTypeOracleUpdater typeOracleBuilder = new CompilationUnitTypeOracleUpdater(new com.google.gwt.dev.javac.typemodel.TypeOracle());
        typeOracleBuilder.addNewUnits(this.logger, (Collection)units);
        this.logger.log(TreeLogger.INFO, "API " + this.name + ", Finished with building typeOracle, added " + units.size() + " files", null);
        return typeOracleBuilder.getTypeOracle();
    }

    private boolean hasPublicOrProtectedConstructor(JClassType classType) {
        JConstructor[] constructors;
        for (JConstructor constructor : constructors = classType.getConstructors()) {
            if (!constructor.isPublic() && !constructor.isProtected()) continue;
            return true;
        }
        return false;
    }

    private void initializeApiPackages() {
        HashSet<JPackage> allPackages = new HashSet<JPackage>(Arrays.asList(this.typeOracle.getPackages()));
        HashSet<String> packagesNotAdded = new HashSet<String>();
        for (JPackage packageObject : allPackages) {
            if (this.isApiPackage(packageObject)) {
                ApiPackage apiPackageObj = new ApiPackage(packageObject, this);
                this.apiPackages.put(apiPackageObj.getName(), apiPackageObj);
                continue;
            }
            packagesNotAdded.add(packageObject.toString());
        }
        if (packagesNotAdded.size() > 0) {
            this.logger.log(TreeLogger.DEBUG, "API " + this.name + ": not added " + packagesNotAdded.size() + " packages: " + packagesNotAdded, null);
        }
        if (this.apiPackages.size() > 0) {
            this.logger.log(TreeLogger.INFO, "API " + this.name + " " + this.apiPackages.size() + " Api packages: " + this.apiPackages.keySet(), null);
        }
    }

    private boolean isAnySubtypeAnApiClass(JClassType classType) {
        JClassType[] subTypes;
        for (JClassType tempType : subTypes = classType.getSubtypes()) {
            if (!this.isApiClass(tempType)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnySubtypeASubclassableApiClass(JClassType classType) {
        JClassType[] subTypes;
        for (JClassType tempType : subTypes = classType.getSubtypes()) {
            if (!this.isSubclassableApiClass(tempType)) continue;
            return true;
        }
        return false;
    }

    private boolean isApiPackage(JPackage packageObject) {
        JClassType[] classTypes;
        if (this.excludedPackages.contains(packageObject.getName())) {
            return false;
        }
        for (JClassType classType : classTypes = packageObject.getTypes()) {
            if (!this.isPublicOuterClass(classType)) continue;
            return true;
        }
        return false;
    }

    private boolean isPublicOuterClass(JClassType classType) {
        return classType.isPublic() && !classType.isMemberType();
    }

    private boolean isSubclassable(JClassType classType) {
        return !classType.isFinal() && this.hasPublicOrProtectedConstructor(classType);
    }
}

