/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.benchmarks.viewer.server;

import com.google.gwt.benchmarks.viewer.client.Report;
import com.google.gwt.benchmarks.viewer.client.ReportSummary;
import com.google.gwt.benchmarks.viewer.server.ReportDatabase;
import com.google.gwt.benchmarks.viewer.server.ReportXml;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ReportDatabase {
    private static ReportDatabase database = new ReportDatabase();
    private static final int UPDATE_DURATION_MILLIS = 30000;
    private long lastUpdateMillis = -1L;
    private final String reportPath;
    private Map<String, ReportEntry> reports = new HashMap();
    private Object reportsLock = new Object();
    private Object updateLock = new Object();
    private boolean updating = false;

    public static ReportDatabase getInstance() {
        return database;
    }

    private static String getReportId(File f) {
        return f.getName();
    }

    private ReportDatabase() throws BadPathException {
        String path = System.getProperty("com.google.gwt.junit.reportPath");
        if (path == null || path.trim().equals("")) {
            path = System.getProperty("user.dir");
        }
        this.reportPath = path;
        if (!new File(this.reportPath).exists()) {
            throw new BadPathException(this.reportPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Report getReport(String reportId) {
        Object object = this.reportsLock;
        synchronized (object) {
            ReportEntry entry = (ReportEntry)this.reports.get(reportId);
            return entry == null ? null : ReportEntry.access$000((ReportEntry)entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReportSummary> getReportSummaries() {
        boolean update = false;
        Object object = this.updateLock;
        synchronized (object) {
            long currentTime;
            if (!this.updating && (currentTime = System.currentTimeMillis()) > this.lastUpdateMillis + 30000L) {
                this.updating = true;
                update = true;
            }
        }
        if (update) {
            this.updateReports();
        }
        object = this.reportsLock;
        synchronized (object) {
            ArrayList<ReportSummary> summaries = new ArrayList<ReportSummary>(this.reports.size());
            for (ReportEntry entry : this.reports.values()) {
                summaries.add(ReportEntry.access$100((ReportEntry)entry));
            }
            return summaries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateReports() {
        File path = new File(this.reportPath);
        File[] files = path.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
        HashMap<String, ReportEntry> filesToUpdate = new HashMap<String, ReportEntry>();
        HashMap<String, ReportFile> filesById = new HashMap<String, ReportFile>();
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            filesById.put(ReportDatabase.getReportId((File)f), new ReportFile(f));
        }
        Object i = this.reportsLock;
        synchronized (i) {
            for (int i2 = 0; i2 < files.length; ++i2) {
                File file = files[i2];
                String reportId = ReportDatabase.getReportId((File)file);
                ReportEntry entry = (ReportEntry)this.reports.get(reportId);
                if (entry != null && ReportEntry.access$200((ReportEntry)entry) >= file.lastModified()) continue;
                filesToUpdate.put(reportId, null);
            }
            Iterator it = this.reports.keySet().iterator();
            while (it.hasNext()) {
                if (filesById.get(it.next()) != null) continue;
                it.remove();
            }
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            for (String id : filesToUpdate.keySet()) {
                ReportFile reportFile = (ReportFile)filesById.get(id);
                String filePath = reportFile.file.getAbsolutePath();
                Document doc = builder.parse(filePath);
                Report report = ReportXml.fromXml((Element)doc.getDocumentElement());
                report.setId(id);
                ReportSummary summary = report.getSummary();
                long lastModified = new File(filePath).lastModified();
                filesToUpdate.put(id, new ReportEntry(report, summary, lastModified));
            }
            Object object = this.reportsLock;
            synchronized (object) {
                for (String id : filesToUpdate.keySet()) {
                    this.reports.put(id, filesToUpdate.get(id));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Object object = this.updateLock;
        synchronized (object) {
            this.updating = false;
            this.lastUpdateMillis = System.currentTimeMillis();
        }
    }
}

