/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.parsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.uibinder.parsers.ElementParser;
import com.google.gwt.uibinder.parsers.HtmlInterpreter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import java.util.HashSet;
import java.util.Set;

public class CustomButtonParser
implements ElementParser {
    private static final Set<String> faceNames = new HashSet<String>();
    private static final Object IMAGE_CLASS = "com.google.gwt.user.client.ui.Image";

    public void parse(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        for (XMLElement child : elem.consumeChildElements()) {
            HtmlInterpreter interpreter;
            String innerHtml;
            String ns = child.getNamespaceUri();
            String faceName = child.getLocalName();
            if (!ns.equals(elem.getNamespaceUri())) {
                writer.die("Invalid CustomButton child namespace: " + ns);
            }
            if (!faceNames.contains(faceName)) {
                writer.die("Invalid CustomButton face: " + faceName);
            }
            if ((innerHtml = child.consumeInnerHtml((XMLElement.Interpreter)(interpreter = HtmlInterpreter.newInterpreterForUiObject(writer, fieldName))).trim()).length() > 0) {
                writer.addStatement("%1$s.get%2$s().setHTML(\"%3$s\");", new Object[]{fieldName, faceName, innerHtml});
            }
            if (child.hasAttribute("html")) {
                String html = child.consumeAttribute("html");
                writer.addStatement("%1$s.get%2$s().setHTML(\"%3$s\");", new Object[]{fieldName, faceName, html});
            }
            if (child.hasAttribute("text")) {
                String text = child.consumeAttribute("text");
                writer.addStatement("%1$s.get%2$s().setText(\"%3$s\");", new Object[]{fieldName, faceName, text});
            }
            if (!child.hasAttribute("image")) continue;
            String image = child.consumeAttribute("image");
            writer.addStatement("%1$s.get%2$s().setImage(new %3$s(\"%4$s\"));", new Object[]{fieldName, faceName, IMAGE_CLASS, image});
        }
    }

    static {
        faceNames.add("UpFace");
        faceNames.add("DownFace");
        faceNames.add("UpHoveringFace");
        faceNames.add("DownHoveringFace");
        faceNames.add("UpDisabledFace");
        faceNames.add("DownDisabledFace");
    }
}

