/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.parsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.uibinder.parsers.AttributeParser;
import com.google.gwt.uibinder.parsers.FieldReferenceConverter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;

public class SimpleAttributeParser
implements AttributeParser {
    public String parse(String value, UiBinderWriter writer) throws UnableToCompleteException {
        try {
            return new FieldReferenceConverter(new FieldReferenceDelegate()).convert(value);
        }
        catch (FieldReferenceConverter.IllegalFieldReferenceException e) {
            writer.die("Bad field reference: \"%s\"", new Object[]{value});
            return null;
        }
    }

    static class FieldReferenceDelegate
    implements FieldReferenceConverter.Delegate {
        boolean sawFragment = false;
        boolean sawReference = false;

        FieldReferenceDelegate() {
        }

        public String handleFragment(String fragment) throws FieldReferenceConverter.IllegalFieldReferenceException {
            if (fragment.length() > 0) {
                this.assertOnly();
                this.sawFragment = true;
            }
            return fragment;
        }

        public String handleReference(String reference) throws FieldReferenceConverter.IllegalFieldReferenceException {
            this.assertOnly();
            this.sawReference = true;
            return reference;
        }

        private void assertOnly() {
            if (this.sawFragment || this.sawReference) {
                throw new FieldReferenceConverter.IllegalFieldReferenceException();
            }
        }
    }
}

