/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.parsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.uibinder.parsers.ElementParser;
import com.google.gwt.uibinder.parsers.HtmlInterpreter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;

public class UIObjectParser
implements ElementParser {
    private static final String ATTRIBUTE_DEBUG_ID = "debugId";
    private static final String ATTRIBUTE_ADD_STYLE_NAMES = "addStyleNames";
    private static final String ATTRIBUTE_ADD_STYLE_DEPENDENT_NAMES = "addStyleDependentNames";

    public void parse(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        this.addCustomAttribute(elem, fieldName, writer, "ensureDebugId", ATTRIBUTE_DEBUG_ID, false);
        this.addCustomAttribute(elem, fieldName, writer, "addStyleName", ATTRIBUTE_ADD_STYLE_NAMES, true);
        this.addCustomAttribute(elem, fieldName, writer, "addStyleDependentName", ATTRIBUTE_ADD_STYLE_DEPENDENT_NAMES, true);
        HtmlInterpreter interpreter = HtmlInterpreter.newInterpreterForUiObject(writer, fieldName);
        String html = elem.consumeInnerHtml((XMLElement.Interpreter)interpreter);
        if (html.trim().length() > 0) {
            writer.setFieldInitializer(fieldName, String.format("new DomHolder(UiBinderUtil.fromHtml(\"%s\"))", html));
        }
    }

    private void addCustomAttribute(XMLElement elem, String fieldName, UiBinderWriter writer, String targetSetterMethod, String attribute, boolean isMultiValue) throws UnableToCompleteException {
        String attributeValue = null;
        if (elem.hasAttribute(attribute)) {
            attributeValue = elem.consumeAttribute(attribute);
            if ("".equals(attributeValue)) {
                writer.die("In %s, value for attribute %s cannot be empty", new Object[]{elem, attribute});
            }
            if (isMultiValue && attributeValue.contains(",")) {
                String[] values;
                for (String value : values = attributeValue.split(",")) {
                    if ("".equals(value = value.trim())) {
                        writer.die("In %s, value for attribute %s cannot be empty", new Object[]{elem, attribute});
                    }
                    writer.addStatement("%1$s.%2$s(\"%3$s\");", new Object[]{fieldName, targetSetterMethod, value});
                }
            } else {
                writer.addStatement("%1$s.%2$s(\"%3$s\");", new Object[]{fieldName, targetSetterMethod, attributeValue});
            }
        }
    }
}

