/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.layout.client.Layout;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresLayout;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;

public class DockLayoutPanel
extends ComplexPanel
implements RequiresLayout,
RequiresResize,
ProvidesResize {
    private final Style.Unit unit;
    private Widget center;
    private final Layout layout;

    public DockLayoutPanel(Style.Unit unit) {
        this.unit = unit;
        this.setElement(Document.get().createDivElement());
        this.layout = new Layout(this.getElement());
    }

    public void add(Widget widget) {
        this.insert(widget, Direction.CENTER, 0.0, null);
    }

    public void addEast(Widget widget, double size) {
        this.insert(widget, Direction.EAST, size, null);
    }

    public void addNorth(Widget widget, double size) {
        this.insert(widget, Direction.NORTH, size, null);
    }

    public void addSouth(Widget widget, double size) {
        this.insert(widget, Direction.SOUTH, size, null);
    }

    public void addWest(Widget widget, double size) {
        this.insert(widget, Direction.WEST, size, null);
    }

    public Element getContainerElementFor(Widget widget) {
        this.assertIsChild(widget);
        return ((LayoutData)widget.getLayoutData()).layer.getContainerElement();
    }

    public Direction getWidgetDirection(Widget w) {
        if (w.getParent() != this) {
            return null;
        }
        return ((LayoutData)w.getLayoutData()).direction;
    }

    public void insertEast(Widget widget, double size, Widget before) {
        this.insert(widget, Direction.EAST, size, before);
    }

    public void insertNorth(Widget widget, double size, Widget before) {
        this.insert(widget, Direction.NORTH, size, before);
    }

    public void insertSouth(Widget widget, double size, Widget before) {
        this.insert(widget, Direction.SOUTH, size, before);
    }

    public void insertWest(Widget widget, double size, Widget before) {
        this.insert(widget, Direction.WEST, size, before);
    }

    public void layout() {
        this.layout(0);
    }

    public void layout(int duration) {
        this.layout(0, null);
    }

    public void layout(int duration, final Layout.AnimationCallback callback) {
        int left = 0;
        int top = 0;
        int right = 0;
        int bottom = 0;
        for (Widget child : this.getChildren()) {
            LayoutData data = (LayoutData)child.getLayoutData();
            Layout.Layer layer = data.layer;
            switch (data.direction) {
                case NORTH: {
                    layer.setLeftRight(left, this.unit, right, this.unit);
                    layer.setTopHeight(top, this.unit, data.size, this.unit);
                    top = (int)((double)top + data.size);
                    break;
                }
                case SOUTH: {
                    layer.setLeftRight(left, this.unit, right, this.unit);
                    layer.setBottomHeight(bottom, this.unit, data.size, this.unit);
                    bottom = (int)((double)bottom + data.size);
                    break;
                }
                case WEST: {
                    layer.setTopBottom(top, this.unit, bottom, this.unit);
                    layer.setLeftWidth(left, this.unit, data.size, this.unit);
                    left = (int)((double)left + data.size);
                    break;
                }
                case EAST: {
                    layer.setTopBottom(top, this.unit, bottom, this.unit);
                    layer.setRightWidth(right, this.unit, data.size, this.unit);
                    right = (int)((double)right + data.size);
                    break;
                }
                case CENTER: {
                    layer.setLeftRight(left, this.unit, right, this.unit);
                    layer.setTopBottom(top, this.unit, bottom, this.unit);
                }
            }
        }
        this.layout.layout(duration, new Layout.AnimationCallback(){

            public void onAnimationComplete() {
                for (Widget child : DockLayoutPanel.this.getChildren()) {
                    LayoutData data = (LayoutData)child.getLayoutData();
                    if (data.size != data.oldSize) {
                        data.oldSize = data.size;
                        if (child instanceof RequiresResize) {
                            ((RequiresResize)((Object)child)).onResize();
                        }
                    }
                    if (callback == null) continue;
                    callback.onAnimationComplete();
                }
            }

            public void onLayout(Layout.Layer layer, double progress) {
                Widget child = (Widget)layer.getUserObject();
                if (child instanceof RequiresResize) {
                    ((RequiresResize)((Object)child)).onResize();
                }
                if (callback != null) {
                    callback.onLayout(layer, progress);
                }
            }
        });
    }

    public void onResize() {
        for (Widget child : this.getChildren()) {
            if (!(child instanceof RequiresResize)) continue;
            ((RequiresResize)((Object)child)).onResize();
        }
    }

    public boolean remove(Widget w) {
        boolean removed = super.remove(w);
        if (removed) {
            if (w == this.center) {
                this.center = null;
            }
            LayoutData data = (LayoutData)w.getLayoutData();
            this.layout.removeChild(data.layer);
        }
        return removed;
    }

    protected Widget getCenter() {
        return this.center;
    }

    protected Style.Unit getUnit() {
        return this.unit;
    }

    protected void insert(Widget widget, Direction direction, double size, Widget before) {
        this.assertIsChild(before);
        if (before == null) {
            assert (this.center == null) : "No widget may be added after the CENTER widget";
        } else assert (direction != Direction.CENTER) : "A CENTER widget must always be added last";
        widget.removeFromParent();
        this.getChildren().add(widget);
        if (direction == Direction.CENTER) {
            this.center = widget;
        }
        Layout.Layer layer = this.layout.attachChild(widget.getElement(), before != null ? before.getElement() : null, widget);
        LayoutData data = new LayoutData(direction, size, layer);
        widget.setLayoutData(data);
        this.adopt(widget);
    }

    protected void onLoad() {
        this.layout.onAttach();
    }

    protected void onUnload() {
        this.layout.onDetach();
    }

    private void assertIsChild(Widget widget) {
        assert (widget == null || widget.getParent() == this) : "The specified widget is not a child of this panel";
    }

    protected static class LayoutData {
        public Direction direction;
        public double oldSize;
        public double size;
        public double originalSize;
        public boolean hidden;
        public Layout.Layer layer;

        public LayoutData(Direction direction, double size, Layout.Layer layer) {
            this.direction = direction;
            this.size = size;
            this.layer = layer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        NORTH,
        EAST,
        SOUTH,
        WEST,
        CENTER,
        LINE_START,
        LINE_END;

    }
}

