/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.ext;

import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.SelectionProperty;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JPackage;
import com.google.gwt.dev.resource.Resource;
import com.google.gwt.dev.resource.ResourceOracle;
import com.google.gwt.dev.util.collect.Maps;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.ext.DefaultExtensions;
import com.google.gwt.resources.ext.ResourceContext;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ResourceGeneratorUtil {
    private static Map<String, File> namedFiles = Maps.create();
    private static final String[] DEPRECATED_ANNOTATION_NAMES = new String[]{"com.google.gwt.libideas.resources.client.ImmutableResourceBundle$Resource", "com.google.gwt.user.client.ui.ImageBundle$Resource"};
    private static final List<Class<? extends Annotation>> DEPRECATED_ANNOTATION_CLASSES;

    public static void addNamedFile(String resourceName, File file) {
        assert (resourceName != null) : "resourceName";
        assert (file != null) : "file";
        assert (file.isFile() && file.canRead()) : "file does not exist or cannot be read";
        namedFiles = Maps.put(namedFiles, (Object)resourceName, (Object)file);
    }

    public static String baseName(URL resource) {
        String path = resource.getPath();
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static URL[] findResources(TreeLogger logger, ClassLoader classLoader, ResourceContext context, JMethod method, String[] defaultSuffixes) throws UnableToCompleteException {
        return ResourceGeneratorUtil.findResources(logger, new Locator[]{new ClassLoaderLocator(classLoader)}, context, method, defaultSuffixes);
    }

    public static URL[] findResources(TreeLogger logger, ResourceContext context, JMethod method) throws UnableToCompleteException {
        JClassType returnType = method.getReturnType().isClassOrInterface();
        assert (returnType != null);
        DefaultExtensions annotation = (DefaultExtensions)returnType.findAnnotationInTypeHierarchy(DefaultExtensions.class);
        String[] extensions = annotation != null ? annotation.value() : new String[]{};
        return ResourceGeneratorUtil.findResources(logger, context, method, extensions);
    }

    public static URL[] findResources(TreeLogger logger, ResourceContext context, JMethod method, String[] defaultSuffixes) throws UnableToCompleteException {
        Locator[] locators = new Locator[]{FileLocator.INSTANCE, new ResourceOracleLocator(context.getGeneratorContext().getResourcesOracle()), new ClassLoaderLocator(Thread.currentThread().getContextClassLoader())};
        URL[] toReturn = ResourceGeneratorUtil.findResources(logger, locators, context, method, defaultSuffixes);
        return toReturn;
    }

    private static void checkForDeprecatedAnnotations(TreeLogger logger, JMethod method) {
        for (Class<? extends Annotation> annotationClass : DEPRECATED_ANNOTATION_CLASSES) {
            if (!method.isAnnotationPresent(annotationClass)) continue;
            logger.log(TreeLogger.WARN, "Deprecated annotation used; expecting " + ClientBundle.Source.class.getCanonicalName() + " but found " + annotationClass.getName() + " instead.  It is likely " + "that undesired operation will occur.");
        }
    }

    private static URL[] findResources(TreeLogger logger, Locator[] locators, ResourceContext context, JMethod method, String[] defaultSuffixes) throws UnableToCompleteException {
        URL[] toReturn;
        String locale;
        logger = logger.branch(TreeLogger.DEBUG, "Finding resources");
        try {
            PropertyOracle oracle = context.getGeneratorContext().getPropertyOracle();
            SelectionProperty prop = oracle.getSelectionProperty(logger, "locale");
            locale = prop.getCurrentValue();
        }
        catch (BadPropertyValueException e) {
            locale = null;
        }
        ResourceGeneratorUtil.checkForDeprecatedAnnotations(logger, method);
        boolean error = false;
        ClientBundle.Source resourceAnnotation = (ClientBundle.Source)method.getAnnotation(ClientBundle.Source.class);
        if (resourceAnnotation == null) {
            if (defaultSuffixes != null) {
                for (String extension : defaultSuffixes) {
                    logger.log(TreeLogger.SPAM, "Trying default extension " + extension);
                    for (Locator locator : locators) {
                        URL resourceUrl = ResourceGeneratorUtil.tryFindResource(locator, ResourceGeneratorUtil.getPathRelativeToPackage(method.getEnclosingType().getPackage(), method.getName() + extension), locale);
                        if (resourceUrl == null) continue;
                        return new URL[]{resourceUrl};
                    }
                }
            }
            logger.log(TreeLogger.ERROR, "No " + ClientBundle.Source.class.getName() + " annotation and no resources found with default extensions");
            toReturn = null;
            error = true;
        } else {
            String[] resources = resourceAnnotation.value();
            toReturn = new URL[resources.length];
            int tagIndex = 0;
            for (String resource : resources) {
                URL resourceURL = null;
                for (Locator locator : locators) {
                    resourceURL = ResourceGeneratorUtil.tryFindResource(locator, ResourceGeneratorUtil.getPathRelativeToPackage(method.getEnclosingType().getPackage(), resource), locale);
                    if (resourceURL == null) {
                        resourceURL = ResourceGeneratorUtil.tryFindResource(locator, resource, locale);
                    }
                    if (resourceURL != null) break;
                }
                if (resourceURL == null) {
                    error = true;
                    logger.log(TreeLogger.ERROR, "Resource " + resource + " not found. Is the name specified as Class.getResource()" + " would expect?");
                }
                toReturn[tagIndex++] = resourceURL;
            }
        }
        if (error) {
            throw new UnableToCompleteException();
        }
        return toReturn;
    }

    private static String getPathRelativeToPackage(JPackage pkg, String path) {
        return pkg.getName().replace('.', '/') + '/' + path;
    }

    private static URL tryFindResource(Locator locator, String resourceName, String locale) {
        URL toReturn = null;
        if (locale != null) {
            String[] localeSegments = locale.split("_");
            int lastDot = resourceName.lastIndexOf(".");
            String prefix = lastDot == -1 ? resourceName : resourceName.substring(0, lastDot);
            String extension = lastDot == -1 ? "" : resourceName.substring(lastDot);
            for (int i = localeSegments.length - 1; i >= -1; --i) {
                String localeInsert = "";
                for (int j = 0; j <= i; ++j) {
                    localeInsert = localeInsert + "_" + localeSegments[j];
                }
                toReturn = locator.locate(prefix + localeInsert + extension);
                if (toReturn == null) {
                    continue;
                }
                break;
            }
        } else {
            toReturn = locator.locate(resourceName);
        }
        return toReturn;
    }

    private ResourceGeneratorUtil() {
    }

    static {
        ArrayList<Class<Annotation>> classes = new ArrayList<Class<Annotation>>(DEPRECATED_ANNOTATION_NAMES.length);
        for (String name : DEPRECATED_ANNOTATION_NAMES) {
            try {
                Class<?> maybeAnnotation = Class.forName(name, false, ResourceGeneratorUtil.class.getClassLoader());
                Class<Annotation> annotationClass = maybeAnnotation.asSubclass(Annotation.class);
                classes.add(annotationClass);
            }
            catch (ClassCastException e) {
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        DEPRECATED_ANNOTATION_CLASSES = classes.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(classes);
    }

    private static class ResourceOracleLocator
    implements Locator {
        private final Map<String, Resource> resourceMap;

        public ResourceOracleLocator(ResourceOracle oracle) {
            this.resourceMap = oracle.getResourceMap();
        }

        public URL locate(String resourceName) {
            Resource r = this.resourceMap.get(resourceName);
            return r == null ? null : r.getURL();
        }
    }

    private static interface Locator {
        public URL locate(String var1);
    }

    private static class FileLocator
    implements Locator {
        public static final FileLocator INSTANCE = new FileLocator();

        private FileLocator() {
        }

        public URL locate(String resourceName) {
            File f = (File)namedFiles.get(resourceName);
            if (f != null && f.isFile() && f.canRead()) {
                try {
                    return f.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Unable to make a URL for file " + f.getName());
                }
            }
            return null;
        }
    }

    private static class ClassLoaderLocator
    implements Locator {
        private final ClassLoader classLoader;

        public ClassLoaderLocator(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public URL locate(String resourceName) {
            return this.classLoader.getResource(resourceName);
        }
    }
}

