/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.attributeparsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FieldReferenceConverter {
    private static final Pattern BRACES = Pattern.compile("[{]([^}]*)[}]");
    private static final Pattern LEGAL_FIRST_CHAR = Pattern.compile("^[$_a-zA-Z].*");
    private final Delegate delegate;

    public static boolean hasFieldReferences(String string) {
        Telltale telltale = new Telltale();
        new FieldReferenceConverter(telltale).convert(string);
        return telltale.hasComputed();
    }

    public FieldReferenceConverter(Delegate delegate) {
        this.delegate = delegate;
    }

    public String convert(String in) {
        StringBuilder b = new StringBuilder();
        int nextFindStart = 0;
        int lastMatchEnd = 0;
        Matcher m = BRACES.matcher(in);
        while (m.find(nextFindStart)) {
            String fieldReference = m.group(1);
            if (!this.legalFirstCharacter(fieldReference)) {
                nextFindStart = m.start() + 2;
                continue;
            }
            String precedingFragment = in.substring(lastMatchEnd, m.start());
            precedingFragment = this.handleFragment(precedingFragment);
            b.append(precedingFragment);
            fieldReference = this.expandDots(fieldReference);
            b.append(this.delegate.handleReference(fieldReference));
            nextFindStart = lastMatchEnd = m.end();
        }
        b.append(this.handleFragment(in.substring(lastMatchEnd)));
        return b.toString();
    }

    private String expandDots(String value) {
        String[] segments;
        StringBuilder b = new StringBuilder();
        for (String segment : segments = value.split("[.]")) {
            if (b.length() == 0) {
                b.append(segment);
                continue;
            }
            b.append(".").append(segment).append("()");
        }
        return b.toString();
    }

    private String handleFragment(String fragment) {
        fragment = fragment.replace("{{", "{");
        return this.delegate.handleFragment(fragment);
    }

    private boolean legalFirstCharacter(String fieldReference) {
        return LEGAL_FIRST_CHAR.matcher(fieldReference).matches();
    }

    private static final class Telltale
    implements Delegate {
        boolean hasComputed = false;

        private Telltale() {
        }

        public String handleFragment(String fragment) {
            return fragment;
        }

        public String handleReference(String reference) {
            this.hasComputed = true;
            return reference;
        }

        public boolean hasComputed() {
            return this.hasComputed;
        }
    }

    public static interface Delegate {
        public String handleFragment(String var1) throws IllegalFieldReferenceException;

        public String handleReference(String var1) throws IllegalFieldReferenceException;
    }

    public static class IllegalFieldReferenceException
    extends RuntimeException {
    }
}

