/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.cell.client;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.HasCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeCell<C>
extends AbstractCell<C> {
    private List<HasCell<C, ?>> hasCells = new ArrayList();

    public void addHasCell(HasCell<C, ?> hasCell) {
        this.hasCells.add(hasCell);
    }

    @Override
    public boolean consumesEvents() {
        for (HasCell<C, ?> hasCell : this.hasCells) {
            if (!hasCell.getCell().consumesEvents()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean dependsOnSelection() {
        for (HasCell<C, ?> hasCell : this.hasCells) {
            if (!hasCell.getCell().dependsOnSelection()) continue;
            return true;
        }
        return false;
    }

    public void insertHasCell(int index, HasCell<C, ?> hasCell) {
        this.hasCells.add(index, hasCell);
    }

    @Override
    public Object onBrowserEvent(Element parent, C value, Object viewData, NativeEvent event, ValueUpdater<C> valueUpdater) {
        int index = 0;
        Element target = (Element)event.getEventTarget().cast();
        for (Element wrapper = parent.getFirstChildElement(); wrapper != null; wrapper = wrapper.getNextSiblingElement()) {
            if (wrapper.isOrHasChild(target)) {
                return this.onBrowserEventImpl(wrapper, value, viewData, event, valueUpdater, this.hasCells.get(index));
            }
            ++index;
        }
        return viewData;
    }

    public void removeHasCell(HasCell<C, ?> hasCell) {
        this.hasCells.remove(hasCell);
    }

    @Override
    public void render(C value, Object viewData, StringBuilder sb) {
        for (HasCell<C, ?> hasCell : this.hasCells) {
            this.render(value, viewData, sb, hasCell);
        }
    }

    @Override
    public void setValue(Element parent, C object, Object viewData) {
        for (HasCell<C, ?> hasCell : this.hasCells) {
            this.setValueImpl(parent, object, viewData, hasCell);
        }
    }

    protected <X> void render(C value, Object viewData, StringBuilder sb, HasCell<C, X> hasCell) {
        Cell<X> cell = hasCell.getCell();
        sb.append("<span>");
        cell.render(hasCell.getValue(value), viewData, sb);
        sb.append("</span>");
    }

    private <X> Object onBrowserEventImpl(Element parent, final C object, Object viewData, NativeEvent event, final ValueUpdater<C> valueUpdater, HasCell<C, X> hasCell) {
        ValueUpdater tempUpdater = null;
        final FieldUpdater<C, X> fieldUpdater = hasCell.getFieldUpdater();
        if (fieldUpdater != null) {
            tempUpdater = new ValueUpdater<X>(){

                @Override
                public void update(X value) {
                    fieldUpdater.update(-1, object, value);
                    if (valueUpdater != null) {
                        valueUpdater.update(object);
                    }
                }
            };
        }
        Cell<X> cell = hasCell.getCell();
        return cell.onBrowserEvent(parent, hasCell.getValue(object), viewData, event, tempUpdater);
    }

    private <X> void setValueImpl(Element parent, C object, Object viewData, HasCell<C, X> hasCell) {
        hasCell.getCell().setValue(parent, hasCell.getValue(object), viewData);
    }
}

