/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.cell.client;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.datepicker.client.DatePicker;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatePickerCell
extends AbstractCell<Date> {
    private static final int ESCAPE = 27;
    private final DatePicker datePicker;
    private final DateTimeFormat format;
    private int offsetX = 10;
    private int offsetY = 10;
    private PopupPanel panel;
    private ValueUpdater<Date> valueUpdater;

    public DatePickerCell() {
        this(DateTimeFormat.getFullDateFormat());
    }

    public DatePickerCell(DateTimeFormat format) {
        this.format = format;
        this.datePicker = new DatePicker();
        this.panel = new PopupPanel(true, true){

            protected void onPreviewNativeEvent(Event.NativePreviewEvent event) {
                if (512 == event.getTypeInt() && event.getNativeEvent().getKeyCode() == 27) {
                    DatePickerCell.this.panel.hide();
                }
            }
        };
        this.panel.add(this.datePicker);
        this.datePicker.addValueChangeHandler(new ValueChangeHandler<Date>(){

            @Override
            public void onValueChange(ValueChangeEvent<Date> event) {
                DatePickerCell.this.panel.hide();
                DatePickerCell.this.valueUpdater.update(event.getValue());
            }
        });
    }

    @Override
    public Object onBrowserEvent(final Element parent, Date value, Object viewData, NativeEvent event, ValueUpdater<Date> valueUpdater) {
        if (event.getType().equals("click")) {
            this.valueUpdater = valueUpdater;
            this.datePicker.setCurrentMonth(value);
            this.datePicker.setValue(value);
            this.panel.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

                public void setPosition(int offsetWidth, int offsetHeight) {
                    DatePickerCell.this.panel.setPopupPosition(parent.getAbsoluteLeft() + DatePickerCell.this.offsetX, parent.getAbsoluteTop() + DatePickerCell.this.offsetY);
                }
            });
        }
        return viewData;
    }

    @Override
    public void render(Date value, Object viewData, StringBuilder sb) {
        if (value != null) {
            sb.append(this.format.format(value));
        }
    }
}

