/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JAbstractMethod;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JParameter;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.rebind.MortalLogger;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLAttribute;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.uibinder.rebind.messages.AttributeMessage;
import com.google.gwt.uibinder.rebind.model.OwnerFieldClass;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanParser
implements ElementParser {
    @Override
    public void parse(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        HashMap<String, String> setterValues = new HashMap<String, String>();
        Map<String, String> localizedValues = this.fetchLocalizedAttributeValues(elem, writer);
        HashMap<String, String> requiredValues = new HashMap<String, String>();
        HashMap<String, JType> unfilledRequiredParams = new HashMap<String, JType>();
        OwnerFieldClass ownerFieldClass = OwnerFieldClass.getFieldClass((JClassType)type, (MortalLogger)writer.getLogger());
        JMethod creator = writer.getOwnerClass().getUiFactoryMethod(type);
        if (creator == null) {
            creator = ownerFieldClass.getUiConstructor();
        }
        if (creator != null) {
            for (JParameter param : creator.getParameters()) {
                unfilledRequiredParams.put(param.getName(), param.getType());
            }
        }
        for (Map.Entry<String, String> property : localizedValues.entrySet()) {
            JParameter[] params;
            String key = property.getKey();
            String value = property.getValue();
            JType paramType = (JType)unfilledRequiredParams.get(key);
            if (paramType != null) {
                if (!this.isString(writer, paramType)) {
                    writer.die(elem, "In %s, cannot apply message attribute to non-string constructor argument %s.", new Object[]{paramType.getSimpleSourceName(), key});
                }
                requiredValues.put(key, value);
                unfilledRequiredParams.remove(key);
                continue;
            }
            JMethod setter = ownerFieldClass.getSetter(key);
            JParameter[] jParameterArray = params = setter == null ? null : setter.getParameters();
            if (setter == null || params.length != 1 || !this.isString(writer, params[0].getType())) {
                writer.die(elem, "No method found to apply message attribute %s", new Object[]{key});
                continue;
            }
            setterValues.put(key, value);
        }
        for (int i = elem.getAttributeCount() - 1; i >= 0; --i) {
            String n;
            String value;
            XMLAttribute attribute = elem.getAttribute(i);
            if (attribute.getName().startsWith("xmlns:")) continue;
            String propertyName = attribute.getLocalName();
            if (setterValues.keySet().contains(propertyName) || requiredValues.containsKey(propertyName)) {
                writer.die(elem, "Duplicate attribute name: %s", new Object[]{propertyName});
            }
            if (unfilledRequiredParams.keySet().contains(propertyName)) {
                JType paramType = (JType)unfilledRequiredParams.get(propertyName);
                String value2 = elem.consumeAttributeWithDefault(attribute.getName(), null, paramType);
                if (value2 == null) {
                    writer.die(elem, "Unable to parse %s as constructor argument of type %s", new Object[]{attribute, paramType.getSimpleSourceName()});
                }
                requiredValues.put(propertyName, value2);
                unfilledRequiredParams.remove(propertyName);
                continue;
            }
            JMethod setter = ownerFieldClass.getSetter(propertyName);
            if (setter == null) {
                writer.die(elem, "Class %s has no appropriate set%s() method", new Object[]{elem.getLocalName(), this.initialCap(propertyName)});
            }
            if ((value = elem.consumeAttributeWithDefault(n = attribute.getName(), null, this.getParamTypes(setter))) == null) {
                writer.die(elem, "Unable to parse %s.", new Object[]{attribute});
            }
            setterValues.put(propertyName, value);
        }
        if (!unfilledRequiredParams.isEmpty()) {
            StringBuilder b = new StringBuilder(String.format("%s missing required attribute(s):", elem));
            for (String name : unfilledRequiredParams.keySet()) {
                b.append(" ").append(name);
            }
            writer.die(elem, b.toString(), new Object[0]);
        }
        if (creator != null) {
            String[] args = this.makeArgsList(requiredValues, (JAbstractMethod)creator);
            if (creator instanceof JMethod) {
                String factoryMethod = String.format("owner.%s(%s)", creator.getName(), UiBinderWriter.asCommaSeparatedList((String[])args));
                writer.setFieldInitializer(fieldName, factoryMethod);
            } else {
                writer.setFieldInitializerAsConstructor(fieldName, type, args);
            }
        }
        for (String propertyName : setterValues.keySet()) {
            writer.addStatement("%s.set%s(%s);", new Object[]{fieldName, this.initialCap(propertyName), setterValues.get(propertyName)});
        }
    }

    private Map<String, String> fetchLocalizedAttributeValues(XMLElement elem, UiBinderWriter writer) {
        HashMap<String, String> localizedValues = new HashMap<String, String>();
        Collection attributeMessages = writer.getMessages().retrieveMessageAttributesFor(elem);
        if (attributeMessages != null) {
            for (AttributeMessage att : attributeMessages) {
                String propertyName = att.getAttribute();
                localizedValues.put(propertyName, att.getMessageUnescaped());
            }
        }
        return localizedValues;
    }

    private JType[] getParamTypes(JMethod setter) {
        JParameter[] params = setter.getParameters();
        JType[] types = new JType[params.length];
        for (int i = 0; i < params.length; ++i) {
            types[i] = params[i].getType();
        }
        return types;
    }

    private String initialCap(String propertyName) {
        return propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    }

    private boolean isString(UiBinderWriter writer, JType paramType) {
        JClassType stringType = writer.getOracle().findType(String.class.getName());
        return stringType.equals((Object)paramType);
    }

    private String[] makeArgsList(Map<String, String> valueMap, JAbstractMethod method) {
        JParameter[] params = method.getParameters();
        String[] args = new String[params.length];
        int i = 0;
        for (JParameter param : params) {
            args[i++] = valueMap.get(param.getName());
        }
        return args;
    }
}

