/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.elementparsers.TextInterpreter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;

public class DisclosurePanelParser
implements ElementParser {
    private static final String CUSTOM = "customHeader";
    private static final String HEADER = "header";
    private static final String OPEN_IMAGE = "openImage";
    private static final String CLOSED_IMAGE = "closedImage";

    public void parse(XMLElement panelElem, String panelField, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        Children children = this.findChildren(panelElem, writer);
        if (null != children.body) {
            if (!writer.isWidgetElement(children.body)) {
                writer.die(children.body, "Must be a widget", new Object[0]);
            }
            String bodyField = writer.parseElementToField(children.body);
            writer.addInitStatement("%s.add(%s);", new Object[]{panelField, bodyField});
        }
        if (null != children.customHeader) {
            XMLElement headerElement = children.customHeader.consumeSingleChildElement();
            if (!writer.isWidgetElement(headerElement)) {
                writer.die(headerElement, "Must be a widget", new Object[0]);
            }
            String headerField = writer.parseElementToField(headerElement);
            writer.addInitStatement("%s.setHeader(%s);", new Object[]{panelField, headerField});
        }
        if (null != children.header) {
            String openImage = children.header.consumeImageResourceAttribute(OPEN_IMAGE);
            String closedImage = children.header.consumeImageResourceAttribute(CLOSED_IMAGE);
            String headerText = children.header.consumeInnerTextEscapedAsHtmlStringLiteral((XMLElement.Interpreter)new TextInterpreter(writer));
            if (openImage == null ^ closedImage == null) {
                writer.die(children.header, "Both %s and %s must be specified, or neither", new Object[]{OPEN_IMAGE, CLOSED_IMAGE});
            }
            String panelTypeName = type.getQualifiedSourceName();
            if (openImage != null) {
                writer.setFieldInitializer(panelField, String.format("new %s(%s, %s, \"%s\")", panelTypeName, openImage, closedImage, headerText));
            } else {
                writer.setFieldInitializer(panelField, String.format("new %s(\"%s\")", panelTypeName, headerText));
            }
        }
    }

    private Children findChildren(final XMLElement elem, final UiBinderWriter writer) throws UnableToCompleteException {
        final Children children = new Children();
        elem.consumeChildElements((XMLElement.Interpreter)new XMLElement.Interpreter<Boolean>(){

            public Boolean interpretElement(XMLElement child) throws UnableToCompleteException {
                if (this.hasAttribute(child, DisclosurePanelParser.HEADER)) {
                    this.assertFirstHeader();
                    children.header = child;
                    return true;
                }
                if (this.hasAttribute(child, DisclosurePanelParser.CUSTOM)) {
                    this.assertFirstHeader();
                    children.customHeader = child;
                    return true;
                }
                if (null != children.body) {
                    writer.die(elem, "May have only one body element", new Object[0]);
                }
                children.body = child;
                return true;
            }

            void assertFirstHeader() throws UnableToCompleteException {
                if (null != children.header && null != children.customHeader) {
                    writer.die(elem, "May have only one %2$s:header or %2$s:customHeader", new Object[]{elem.getPrefix()});
                }
            }

            private boolean hasAttribute(XMLElement child, String attribute) {
                return this.rightNamespace(child) && child.getLocalName().equals(attribute);
            }

            private boolean rightNamespace(XMLElement child) {
                return child.getNamespaceUri().equals(elem.getNamespaceUri());
            }
        });
        return children;
    }

    private static class Children {
        XMLElement body;
        XMLElement header;
        XMLElement customHeader;

        private Children() {
        }
    }
}

