/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.elementparsers.HtmlInterpreter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;

public class TabPanelParser
implements ElementParser {
    private static final String TAG_TAB = "Tab";
    private static final String TAG_TABHTML = "TabHTML";

    public void parse(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        writer.warn(elem, "%1$s:%2$s is deprecated. Use the %1$s:TabLayoutPanel instead.", new Object[]{elem.getPrefix(), elem.getLocalName()});
        for (XMLElement child : elem.consumeChildElements()) {
            String ns = child.getNamespaceUri();
            String tagName = child.getLocalName();
            if (!ns.equals(elem.getNamespaceUri())) {
                writer.die(elem, "Invalid TabPanel child namespace: " + ns, new Object[0]);
            }
            if (!tagName.equals(TAG_TAB)) {
                writer.die(elem, "Invalid TabPanel child element: " + tagName, new Object[0]);
            }
            String tabCaption = "";
            if (child.hasAttribute("text")) {
                tabCaption = child.consumeRawAttribute("text");
            }
            String tabHTML = null;
            String childFieldName = null;
            for (XMLElement tabChild : child.consumeChildElements()) {
                if (tabChild.getLocalName().equals(TAG_TABHTML)) {
                    HtmlInterpreter interpreter = HtmlInterpreter.newInterpreterForUiObject(writer, fieldName);
                    tabHTML = tabChild.consumeInnerHtml((XMLElement.Interpreter)interpreter);
                    continue;
                }
                if (childFieldName != null) {
                    writer.die(elem, "%s may only have a single child widget", new Object[]{child});
                }
                childFieldName = writer.parseElementToField(tabChild);
            }
            if (childFieldName == null) {
                writer.die(elem, "%s must have a child widget", new Object[]{child});
            }
            if (tabHTML != null) {
                writer.addStatement("%1$s.add(%2$s, \"%3$s\", true);", new Object[]{fieldName, childFieldName, tabHTML});
                continue;
            }
            writer.addStatement("%1$s.add(%2$s, \"%3$s\");", new Object[]{fieldName, childFieldName, tabCaption});
        }
    }
}

