/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.view.client;

import com.google.gwt.view.client.ListView;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.Range;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListViewAdapter<T>
implements ProvidesKey<T> {
    private final Delegate delegate = new Delegate();
    private Set<ListView<T>> views = new HashSet<ListView<T>>();
    private ProvidesKey<T> keyProvider;

    public void addView(ListView<T> view) {
        if (this.views.contains(view)) {
            throw new IllegalStateException("ListView already added");
        }
        this.views.add(view);
        view.setDelegate(this.delegate);
        this.delegate.onRangeChanged(view);
    }

    @Override
    public Object getKey(T item) {
        return this.keyProvider == null ? item : this.keyProvider.getKey(item);
    }

    public ProvidesKey<T> getKeyProvider() {
        return this.keyProvider;
    }

    public Range[] getRanges() {
        Range[] ranges = new Range[this.views.size()];
        int i = 0;
        for (ListView<T> view : this.views) {
            ranges[i++] = view.getRange();
        }
        return ranges;
    }

    public void removeView(ListView<T> view) {
        if (!this.views.contains(view)) {
            throw new IllegalStateException("ListView not present");
        }
        this.views.remove(view);
        view.setDelegate(null);
    }

    public void setKeyProvider(ProvidesKey<T> keyProvider) {
        this.keyProvider = keyProvider;
    }

    protected abstract void onRangeChanged(ListView<T> var1);

    protected void updateDataSize(int size, boolean exact) {
        for (ListView<T> view : this.views) {
            view.setDataSize(size, exact);
        }
    }

    protected void updateViewData(int start, int length, List<T> values) {
        for (ListView<T> view : this.views) {
            this.updateViewData(view, start, length, values);
        }
    }

    protected void updateViewData(ListView<T> view, int start, int length, List<T> values) {
        int end = start + length;
        Range range = view.getRange();
        int curStart = range.getStart();
        int curLength = range.getLength();
        int curEnd = curStart + curLength;
        if (curStart < end && curEnd > start) {
            int realStart = curStart < start ? start : curStart;
            int realEnd = curEnd > end ? end : curEnd;
            int realLength = realEnd - realStart;
            List<T> realValues = values.subList(realStart - start, realStart - start + realLength);
            view.setData(realStart, realLength, realValues);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Delegate
    implements ListView.Delegate<T> {
        private Delegate() {
        }

        @Override
        public void onRangeChanged(ListView<T> view) {
            AbstractListViewAdapter.this.onRangeChanged(view);
        }
    }

    public static class DefaultRange
    implements Range,
    Serializable {
        private int length;
        private int start;

        public DefaultRange(int start, int length) {
            this.start = start;
            this.length = length;
        }

        DefaultRange() {
        }

        public int getLength() {
            return this.length;
        }

        public int getStart() {
            return this.start;
        }
    }
}

