/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Implementation of DateTimeFormatInfo for locale "ja".
 */
public class DateTimeFormatInfoImpl_ja extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] { 
        "午前",
        "午後"
    };
  }

  @Override
  public String dateFormatFull() {
    return "y年M月d日EEEE";
  }

  @Override
  public String dateFormatLong() {
    return "y年M月d日";
  }

  @Override
  public String dateFormatMedium() {
    return "yyyy/MM/dd";
  }

  @Override
  public String dateFormatShort() {
    return "yy/MM/dd";
  }

  @Override
  public String[] erasFull() {
    return new String[] { 
        "紀元前",
        "西暦"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] { 
        "紀元前",
        "西暦"
    };
  }

  @Override
  public String formatHour12Minute() {
    return "ah:mm";
  }

  @Override
  public String formatHour12MinuteSecond() {
    return "ah:mm:ss";
  }

  @Override
  public String formatHour24Minute() {
    return "H:mm";
  }

  @Override
  public String formatHour24MinuteSecond() {
    return "H:mm:ss";
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "M月d日";
  }

  @Override
  public String formatMonthFullDay() {
    return "M月d日";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "M月d日(EEEE)";
  }

  @Override
  public String formatMonthNumDay() {
    return "M/d";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "y年M月";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "y年M月d日";
  }

  @Override
  public String formatYearMonthFull() {
    return "y年M月";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "y年M月d日";
  }

  @Override
  public String formatYearMonthNum() {
    return "y/M";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "y年M月d日";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "y年M月d日(EEE)";
  }

  @Override
  public String formatYearQuarterFull() {
    return "y/QQQQ";
  }

  @Override
  public String formatYearQuarterShort() {
    return "y/Q";
  }

  @Override
  public String[] monthsFull() {
    return new String[] { 
        "1月",
        "2月",
        "3月",
        "4月",
        "5月",
        "6月",
        "7月",
        "8月",
        "9月",
        "10月",
        "11月",
        "12月"
    };
  }

  @Override
  public String[] monthsFullStandalone() {
    return monthsFull();
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] { 
        "1",
        "2",
        "3",
        "4",
        "5",
        "6",
        "7",
        "8",
        "9",
        "10",
        "11",
        "12"
    };
  }

  @Override
  public String[] monthsNarrowStandalone() {
    return monthsNarrow();
  }

  @Override
  public String[] monthsShort() {
    return new String[] { 
        "1月",
        "2月",
        "3月",
        "4月",
        "5月",
        "6月",
        "7月",
        "8月",
        "9月",
        "10月",
        "11月",
        "12月"
    };
  }

  @Override
  public String[] monthsShortStandalone() {
    return monthsShort();
  }

  @Override
  public String[] quartersFull() {
    return new String[] { 
        "第1四半期",
        "第2四半期",
        "第3四半期",
        "第4四半期"
    };
  }

  @Override
  public String timeFormatFull() {
    return "H時mm分ss秒 zzzz";
  }

  @Override
  public String timeFormatLong() {
    return "HH:mm:ss z";
  }

  @Override
  public String timeFormatMedium() {
    return "H:mm:ss";
  }

  @Override
  public String timeFormatShort() {
    return "H:mm";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] { 
        "日曜日",
        "月曜日",
        "火曜日",
        "水曜日",
        "木曜日",
        "金曜日",
        "土曜日"
    };
  }

  @Override
  public String[] weekdaysFullStandalone() {
    return weekdaysFull();
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] { 
        "日",
        "月",
        "火",
        "水",
        "木",
        "金",
        "土"
    };
  }

  @Override
  public String[] weekdaysNarrowStandalone() {
    return weekdaysNarrow();
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] { 
        "日",
        "月",
        "火",
        "水",
        "木",
        "金",
        "土"
    };
  }

  @Override
  public String[] weekdaysShortStandalone() {
    return weekdaysShort();
  }
}
