/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Implementation of DateTimeFormatInfo for locale "th".
 */
public class DateTimeFormatInfoImpl_th extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] { 
        "ก่อนเที่ยง",
        "หลังเที่ยง"
    };
  }

  @Override
  public String dateFormatFull() {
    return "EEEEที่ d MMMM G y";
  }

  @Override
  public String dateFormatLong() {
    return "d MMMM y";
  }

  @Override
  public String dateFormatMedium() {
    return "d MMM y";
  }

  @Override
  public String dateFormatShort() {
    return "d/M/yyyy";
  }

  @Override
  public String[] erasFull() {
    return new String[] { 
        "ปีก่อนคริสต์ศักราช",
        "คริสต์ศักราช"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] { 
        "ปีก่อน ค.ศ.",
        "ค.ศ."
    };
  }

  @Override
  public String formatHour12Minute() {
    return "H:mm";
  }

  @Override
  public String formatHour12MinuteSecond() {
    return "H:mm:ss";
  }

  @Override
  public String formatHour24Minute() {
    return "H:mm";
  }

  @Override
  public String formatHour24MinuteSecond() {
    return "H:mm:ss";
  }

  @Override
  public String formatMinuteSecond() {
    return "m ├'F13': s┤";
  }

  @Override
  public String formatMonthAbbrev() {
    return "MMM";
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "d ├'F3': MMM┤";
  }

  @Override
  public String formatMonthFull() {
    return "MMMM";
  }

  @Override
  public String formatMonthFullDay() {
    return "d ├'F3': MMMM┤";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "d ├'F3': MMMM┤ ├'F6': EEEE┤";
  }

  @Override
  public String formatMonthNumDay() {
    return "M ├'F7': d┤";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "y ├'F3': MMM┤";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "d MMM y";
  }

  @Override
  public String formatYearMonthFull() {
    return "y ├'F3': MMMM┤";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "d MMMM y";
  }

  @Override
  public String formatYearMonthNum() {
    return "y ├'F3': M┤";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "d/M/y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "d MMM y ├'F6': EEE┤";
  }

  @Override
  public String formatYearQuarterFull() {
    return "y ├'F2': QQQQ┤";
  }

  @Override
  public String formatYearQuarterShort() {
    return "y ├'F2': Q┤";
  }

  @Override
  public String[] monthsFull() {
    return new String[] { 
        "มกราคม",
        "กุมภาพันธ์",
        "มีนาคม",
        "เมษายน",
        "พฤษภาคม",
        "มิถุนายน",
        "กรกฎาคม",
        "สิงหาคม",
        "กันยายน",
        "ตุลาคม",
        "พฤศจิกายน",
        "ธันวาคม"
    };
  }

  @Override
  public String[] monthsFullStandalone() {
    return monthsFull();
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] { 
        "ม.ค.",
        "ก.พ.",
        "มี.ค.",
        "เม.ย.",
        "พ.ค.",
        "มิ.ย.",
        "ก.ค.",
        "ส.ค.",
        "ก.ย.",
        "ต.ค.",
        "พ.ย.",
        "ธ.ค."
    };
  }

  @Override
  public String[] monthsNarrowStandalone() {
    return monthsNarrow();
  }

  @Override
  public String[] monthsShort() {
    return new String[] { 
        "ม.ค.",
        "ก.พ.",
        "มี.ค.",
        "เม.ย.",
        "พ.ค.",
        "มิ.ย.",
        "ก.ค.",
        "ส.ค.",
        "ก.ย.",
        "ต.ค.",
        "พ.ย.",
        "ธ.ค."
    };
  }

  @Override
  public String[] monthsShortStandalone() {
    return monthsShort();
  }

  @Override
  public String[] quartersFull() {
    return new String[] { 
        "ไตรมาส 1",
        "ไตรมาส 2",
        "ไตรมาส 3",
        "ไตรมาส 4"
    };
  }

  @Override
  public String timeFormatFull() {
    return "H นาฬิกา m นาที ss วินาที zzzz";
  }

  @Override
  public String timeFormatLong() {
    return "H นาฬิกา m นาที ss วินาที z";
  }

  @Override
  public String timeFormatMedium() {
    return "H:mm:ss";
  }

  @Override
  public String timeFormatShort() {
    return "H:mm";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] { 
        "วันอาทิตย์",
        "วันจันทร์",
        "วันอังคาร",
        "วันพุธ",
        "วันพฤหัสบดี",
        "วันศุกร์",
        "วันเสาร์"
    };
  }

  @Override
  public String[] weekdaysFullStandalone() {
    return weekdaysFull();
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] { 
        "อ",
        "จ",
        "อ",
        "พ",
        "พ",
        "ศ",
        "ส"
    };
  }

  @Override
  public String[] weekdaysNarrowStandalone() {
    return weekdaysNarrow();
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] { 
        "อา.",
        "จ.",
        "อ.",
        "พ.",
        "พฤ.",
        "ศ.",
        "ส."
    };
  }

  @Override
  public String[] weekdaysShortStandalone() {
    return weekdaysShort();
  }
}
