/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;

/**
 * A table column header or footer.
 *
 * @param <H> the {#link Cell} type
 */
public abstract class Header<H> {

  private final Cell<H> cell;

  private ValueUpdater<H> updater;

  public Header(Cell<H> cell) {
    this.cell = cell;
  }

  public Cell<H> getCell() {
    return cell;
  }

  public abstract H getValue();

  public void onBrowserEvent(Element elem, NativeEvent event) {
    H value = getValue();
    cell.onBrowserEvent(elem, value, getKey(), event, updater);
  }

  public void render(StringBuilder sb) {
    cell.render(getValue(), getKey(), sb);
  }

  public void setUpdater(ValueUpdater<H> updater) {
    this.updater = updater;
  }

  /**
   * Get the key for the header value. By default, the key is the same as the
   * value. Override this method to return a custom key.
   *
   * @return the key associated with the value
   */
  protected Object getKey() {
    return getValue();
  }
}
