/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "seh" locale.
 */
public class LocalizedNamesImpl_seh extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "ZA",
        "AL",
        "DE",
        "AD",
        "AO",
        "AI",
        "AG",
        "AN",
        "AQ",
        "SA",
        "DZ",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AX",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BL",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "BV",
        "CV",
        "KH",
        "CA",
        "KZ",
        "QA",
        "CC",
        "TD",
        "CL",
        "CN",
        "CY",
        "SG",
        "CO",
        "KM",
        "CG",
        "CD",
        "KP",
        "KR",
        "CI",
        "CR",
        "CP",
        "HR",
        "CU",
        "CW",
        "CX",
        "DG",
        "DK",
        "DJ",
        "DM",
        "EA",
        "EG",
        "EH",
        "SV",
        "AE",
        "EC",
        "ER",
        "SK",
        "SI",
        "ES",
        "US",
        "EE",
        "ET",
        "EU",
        "FJ",
        "PH",
        "FI",
        "FO",
        "FR",
        "GA",
        "GM",
        "GH",
        "GE",
        "GG",
        "GI",
        "GD",
        "GR",
        "GL",
        "GS",
        "GP",
        "GU",
        "GT",
        "GY",
        "GF",
        "GN",
        "GW",
        "GQ",
        "HT",
        "HK",
        "HM",
        "NL",
        "HN",
        "HU",
        "IC",
        "YE",
        "KY",
        "CK",
        "FK",
        "MP",
        "MH",
        "NF",
        "SB",
        "TC",
        "VG",
        "VI",
        "IM",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IE",
        "IS",
        "IL",
        "IT",
        "JM",
        "JP",
        "JE",
        "JO",
        "KW",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MK",
        "MG",
        "MY",
        "MW",
        "MV",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MU",
        "MR",
        "YT",
        "ME",
        "MX",
        "MF",
        "MM",
        "FM",
        "MO",
        "MZ",
        "MD",
        "MC",
        "MN",
        "MS",
        "NA",
        "NR",
        "NP",
        "NI",
        "NE",
        "NG",
        "NU",
        "NO",
        "NC",
        "NZ",
        "OM",
        "PW",
        "PA",
        "PG",
        "PK",
        "PY",
        "PE",
        "PN",
        "PF",
        "PL",
        "PR",
        "PT",
        "QO",
        "KE",
        "KG",
        "KI",
        "GB",
        "CF",
        "DO",
        "CM",
        "CZ",
        "RE",
        "RO",
        "RS",
        "RW",
        "RU",
        "PM",
        "WS",
        "AS",
        "SM",
        "SH",
        "LC",
        "KN",
        "ST",
        "VC",
        "SN",
        "SL",
        "SC",
        "SY",
        "SJ",
        "SO",
        "LK",
        "SS",
        "SZ",
        "SD",
        "SE",
        "CH",
        "SR",
        "SX",
        "TA",
        "TJ",
        "TH",
        "TW",
        "IO",
        "PS",
        "TF",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TN",
        "TM",
        "TR",
        "TV",
        "TZ",
        "UA",
        "UG",
        "UM",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "XK",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AE", "Emirados Árabes Unidos");
    namesMap.put("AF", "Afeganistão");
    namesMap.put("AG", "Antígua e Barbuda");
    namesMap.put("AL", "Albânia");
    namesMap.put("AM", "Armênia");
    namesMap.put("AN", "Antilhas Holandesas");
    namesMap.put("AS", "Samoa Americana");
    namesMap.put("AT", "Áustria");
    namesMap.put("AU", "Austrália");
    namesMap.put("AZ", "Azerbaijão");
    namesMap.put("BA", "Bósnia-Herzegovina");
    namesMap.put("BE", "Bélgica");
    namesMap.put("BF", "Burquina Faso");
    namesMap.put("BG", "Bulgária");
    namesMap.put("BM", "Bermudas");
    namesMap.put("BO", "Bolívia");
    namesMap.put("BR", "Brasil");
    namesMap.put("BT", "Butão");
    namesMap.put("BW", "Botsuana");
    namesMap.put("CA", "Canadá");
    namesMap.put("CD", "Congo-Kinshasa");
    namesMap.put("CF", "República Centro-Africana");
    namesMap.put("CG", "Congo");
    namesMap.put("CH", "Suíça");
    namesMap.put("CI", "Costa do Marfim");
    namesMap.put("CK", "Ilhas Cook");
    namesMap.put("CM", "República dos Camarões");
    namesMap.put("CO", "Colômbia");
    namesMap.put("CV", "Cabo Verde");
    namesMap.put("CY", "Chipre");
    namesMap.put("CZ", "República Tcheca");
    namesMap.put("DE", "Alemanha");
    namesMap.put("DJ", "Djibuti");
    namesMap.put("DK", "Dinamarca");
    namesMap.put("DO", "República Dominicana");
    namesMap.put("DZ", "Argélia");
    namesMap.put("EC", "Equador");
    namesMap.put("EE", "Estônia");
    namesMap.put("EG", "Egito");
    namesMap.put("ER", "Eritréia");
    namesMap.put("ES", "Espanha");
    namesMap.put("ET", "Etiópia");
    namesMap.put("FI", "Finlândia");
    namesMap.put("FK", "Ilhas Malvinas");
    namesMap.put("FM", "Micronésia");
    namesMap.put("FR", "França");
    namesMap.put("GA", "Gabão");
    namesMap.put("GB", "Reino Unido");
    namesMap.put("GD", "Granada");
    namesMap.put("GE", "Geórgia");
    namesMap.put("GF", "Guiana Francesa");
    namesMap.put("GH", "Gana");
    namesMap.put("GL", "Groênlandia");
    namesMap.put("GM", "Gâmbia");
    namesMap.put("GN", "Guiné");
    namesMap.put("GP", "Guadalupe");
    namesMap.put("GQ", "Guiné Equatorial");
    namesMap.put("GR", "Grécia");
    namesMap.put("GW", "Guiné Bissau");
    namesMap.put("GY", "Guiana");
    namesMap.put("HR", "Croácia");
    namesMap.put("HU", "Hungria");
    namesMap.put("ID", "Indonésia");
    namesMap.put("IE", "Irlanda");
    namesMap.put("IN", "Índia");
    namesMap.put("IO", "Território Britânico do Oceano Índico");
    namesMap.put("IQ", "Iraque");
    namesMap.put("IR", "Irã");
    namesMap.put("IS", "Islândia");
    namesMap.put("IT", "Itália");
    namesMap.put("JO", "Jordânia");
    namesMap.put("JP", "Japão");
    namesMap.put("KE", "Quênia");
    namesMap.put("KG", "Quirguistão");
    namesMap.put("KH", "Camboja");
    namesMap.put("KI", "Quiribati");
    namesMap.put("KM", "Comores");
    namesMap.put("KN", "São Cristovão e Nevis");
    namesMap.put("KP", "Coréia do Norte");
    namesMap.put("KR", "Coréia do Sul");
    namesMap.put("KY", "Ilhas Caiman");
    namesMap.put("KZ", "Casaquistão");
    namesMap.put("LB", "Líbano");
    namesMap.put("LC", "Santa Lúcia");
    namesMap.put("LR", "Libéria");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Lituânia");
    namesMap.put("LU", "Luxemburgo");
    namesMap.put("LV", "Letônia");
    namesMap.put("LY", "Líbia");
    namesMap.put("MA", "Marrocos");
    namesMap.put("MC", "Mônaco");
    namesMap.put("MD", "Moldávia");
    namesMap.put("MH", "Ilhas Marshall");
    namesMap.put("MK", "Macedônia");
    namesMap.put("MM", "Mianmar");
    namesMap.put("MN", "Mongólia");
    namesMap.put("MP", "Ilhas Marianas do Norte");
    namesMap.put("MQ", "Martinica");
    namesMap.put("MR", "Mauritânia");
    namesMap.put("MU", "Maurício");
    namesMap.put("MV", "Maldivas");
    namesMap.put("MX", "México");
    namesMap.put("MY", "Malásia");
    namesMap.put("MZ", "Moçambique");
    namesMap.put("NA", "Namíbia");
    namesMap.put("NC", "Nova Caledônia");
    namesMap.put("NE", "Níger");
    namesMap.put("NF", "Ilhas Norfolk");
    namesMap.put("NG", "Nigéria");
    namesMap.put("NI", "Nicarágua");
    namesMap.put("NL", "Holanda");
    namesMap.put("NO", "Noruega");
    namesMap.put("NZ", "Nova Zelândia");
    namesMap.put("OM", "Omã");
    namesMap.put("PA", "Panamá");
    namesMap.put("PF", "Polinésia Francesa");
    namesMap.put("PG", "Papua-Nova Guiné");
    namesMap.put("PH", "Filipinas");
    namesMap.put("PK", "Paquistão");
    namesMap.put("PL", "Polônia");
    namesMap.put("PM", "Saint Pierre e Miquelon");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PR", "Porto Rico");
    namesMap.put("PS", "Território da Palestina");
    namesMap.put("PY", "Paraguai");
    namesMap.put("QA", "Catar");
    namesMap.put("RE", "Reunião");
    namesMap.put("RO", "Romênia");
    namesMap.put("RU", "Rússia");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Arábia Saudita");
    namesMap.put("SB", "Ilhas Salomão");
    namesMap.put("SD", "Sudão");
    namesMap.put("SE", "Suécia");
    namesMap.put("SG", "Cingapura");
    namesMap.put("SH", "Santa Helena");
    namesMap.put("SI", "Eslovênia");
    namesMap.put("SK", "Eslováquia");
    namesMap.put("SL", "Serra Leoa");
    namesMap.put("SO", "Somália");
    namesMap.put("ST", "São Tomé e Príncipe");
    namesMap.put("SY", "Síria");
    namesMap.put("SZ", "Suazilândia");
    namesMap.put("TC", "Ilhas Turks e Caicos");
    namesMap.put("TD", "Chade");
    namesMap.put("TH", "Tailândia");
    namesMap.put("TJ", "Tadjiquistão");
    namesMap.put("TL", "Timor Leste");
    namesMap.put("TM", "Turcomenistão");
    namesMap.put("TN", "Tunísia");
    namesMap.put("TR", "Turquia");
    namesMap.put("TT", "Trinidad e Tobago");
    namesMap.put("UA", "Ucrânia");
    namesMap.put("US", "Estados Unidos");
    namesMap.put("UY", "Uruguai");
    namesMap.put("UZ", "Uzbequistão");
    namesMap.put("VA", "Vaticano");
    namesMap.put("VC", "São Vicente e Granadinas");
    namesMap.put("VG", "Ilhas Virgens Britânicas");
    namesMap.put("VI", "Ilhas Virgens dos EUA");
    namesMap.put("VN", "Vietnã");
    namesMap.put("WF", "Wallis e Futuna");
    namesMap.put("YE", "Iêmen");
    namesMap.put("ZA", "África do Sul");
    namesMap.put("ZM", "Zâmbia");
    namesMap.put("ZW", "Zimbábue");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AE": "Emirados Árabes Unidos",
        "AF": "Afeganistão",
        "AG": "Antígua e Barbuda",
        "AL": "Albânia",
        "AM": "Armênia",
        "AN": "Antilhas Holandesas",
        "AS": "Samoa Americana",
        "AT": "Áustria",
        "AU": "Austrália",
        "AZ": "Azerbaijão",
        "BA": "Bósnia-Herzegovina",
        "BE": "Bélgica",
        "BF": "Burquina Faso",
        "BG": "Bulgária",
        "BM": "Bermudas",
        "BO": "Bolívia",
        "BR": "Brasil",
        "BT": "Butão",
        "BW": "Botsuana",
        "CA": "Canadá",
        "CD": "Congo-Kinshasa",
        "CF": "República Centro-Africana",
        "CG": "Congo",
        "CH": "Suíça",
        "CI": "Costa do Marfim",
        "CK": "Ilhas Cook",
        "CM": "República dos Camarões",
        "CO": "Colômbia",
        "CV": "Cabo Verde",
        "CY": "Chipre",
        "CZ": "República Tcheca",
        "DE": "Alemanha",
        "DJ": "Djibuti",
        "DK": "Dinamarca",
        "DO": "República Dominicana",
        "DZ": "Argélia",
        "EC": "Equador",
        "EE": "Estônia",
        "EG": "Egito",
        "ER": "Eritréia",
        "ES": "Espanha",
        "ET": "Etiópia",
        "FI": "Finlândia",
        "FK": "Ilhas Malvinas",
        "FM": "Micronésia",
        "FR": "França",
        "GA": "Gabão",
        "GB": "Reino Unido",
        "GD": "Granada",
        "GE": "Geórgia",
        "GF": "Guiana Francesa",
        "GH": "Gana",
        "GL": "Groênlandia",
        "GM": "Gâmbia",
        "GN": "Guiné",
        "GP": "Guadalupe",
        "GQ": "Guiné Equatorial",
        "GR": "Grécia",
        "GW": "Guiné Bissau",
        "GY": "Guiana",
        "HR": "Croácia",
        "HU": "Hungria",
        "ID": "Indonésia",
        "IE": "Irlanda",
        "IN": "Índia",
        "IO": "Território Britânico do Oceano Índico",
        "IQ": "Iraque",
        "IR": "Irã",
        "IS": "Islândia",
        "IT": "Itália",
        "JO": "Jordânia",
        "JP": "Japão",
        "KE": "Quênia",
        "KG": "Quirguistão",
        "KH": "Camboja",
        "KI": "Quiribati",
        "KM": "Comores",
        "KN": "São Cristovão e Nevis",
        "KP": "Coréia do Norte",
        "KR": "Coréia do Sul",
        "KY": "Ilhas Caiman",
        "KZ": "Casaquistão",
        "LB": "Líbano",
        "LC": "Santa Lúcia",
        "LR": "Libéria",
        "LS": "Lesoto",
        "LT": "Lituânia",
        "LU": "Luxemburgo",
        "LV": "Letônia",
        "LY": "Líbia",
        "MA": "Marrocos",
        "MC": "Mônaco",
        "MD": "Moldávia",
        "MH": "Ilhas Marshall",
        "MK": "Macedônia",
        "MM": "Mianmar",
        "MN": "Mongólia",
        "MP": "Ilhas Marianas do Norte",
        "MQ": "Martinica",
        "MR": "Mauritânia",
        "MU": "Maurício",
        "MV": "Maldivas",
        "MX": "México",
        "MY": "Malásia",
        "MZ": "Moçambique",
        "NA": "Namíbia",
        "NC": "Nova Caledônia",
        "NE": "Níger",
        "NF": "Ilhas Norfolk",
        "NG": "Nigéria",
        "NI": "Nicarágua",
        "NL": "Holanda",
        "NO": "Noruega",
        "NZ": "Nova Zelândia",
        "OM": "Omã",
        "PA": "Panamá",
        "PF": "Polinésia Francesa",
        "PG": "Papua-Nova Guiné",
        "PH": "Filipinas",
        "PK": "Paquistão",
        "PL": "Polônia",
        "PM": "Saint Pierre e Miquelon",
        "PN": "Pitcairn",
        "PR": "Porto Rico",
        "PS": "Território da Palestina",
        "PY": "Paraguai",
        "QA": "Catar",
        "RE": "Reunião",
        "RO": "Romênia",
        "RU": "Rússia",
        "RW": "Ruanda",
        "SA": "Arábia Saudita",
        "SB": "Ilhas Salomão",
        "SD": "Sudão",
        "SE": "Suécia",
        "SG": "Cingapura",
        "SH": "Santa Helena",
        "SI": "Eslovênia",
        "SK": "Eslováquia",
        "SL": "Serra Leoa",
        "SO": "Somália",
        "ST": "São Tomé e Príncipe",
        "SY": "Síria",
        "SZ": "Suazilândia",
        "TC": "Ilhas Turks e Caicos",
        "TD": "Chade",
        "TH": "Tailândia",
        "TJ": "Tadjiquistão",
        "TL": "Timor Leste",
        "TM": "Turcomenistão",
        "TN": "Tunísia",
        "TR": "Turquia",
        "TT": "Trinidad e Tobago",
        "UA": "Ucrânia",
        "US": "Estados Unidos",
        "UY": "Uruguai",
        "UZ": "Uzbequistão",
        "VA": "Vaticano",
        "VC": "São Vicente e Granadinas",
        "VG": "Ilhas Virgens Britânicas",
        "VI": "Ilhas Virgens dos EUA",
        "VN": "Vietnã",
        "WF": "Wallis e Futuna",
        "YE": "Iêmen",
        "ZA": "África do Sul",
        "ZM": "Zâmbia",
        "ZW": "Zimbábue"
    };
  }-*/;
}
