/*
 * Decompiled with CFR 0.152.
 */
package javaemul.internal;

import javaemul.internal.Coercions;
import javaemul.internal.JsUtils;

class StringHashCache {
    private static Object back = StringHashCache.createNativeObject();
    private static int count = 0;
    private static Object front = StringHashCache.createNativeObject();
    private static final int MAX_CACHE = 256;

    StringHashCache() {
    }

    public static int getHashCode(String str) {
        String key = ":" + str;
        Object result = StringHashCache.getProperty(front, key);
        if (!JsUtils.isUndefined(result)) {
            return StringHashCache.unsafeCastToInt(result);
        }
        result = StringHashCache.getProperty(back, key);
        int hashCode = JsUtils.isUndefined(result) ? StringHashCache.compute(str) : StringHashCache.unsafeCastToInt(result);
        StringHashCache.increment();
        JsUtils.setIntProperty(front, key, hashCode);
        return hashCode;
    }

    private static int compute(String str) {
        int i;
        int hashCode = 0;
        int n = str.length();
        int nBatch = n - 4;
        for (i = 0; i < nBatch; i += 4) {
            hashCode = str.charAt(i + 3) + 31 * (str.charAt(i + 2) + 31 * (str.charAt(i + 1) + 31 * (str.charAt(i) + 31 * hashCode)));
            hashCode = Coercions.ensureInt(hashCode);
        }
        while (i < n) {
            hashCode = hashCode * 31 + str.charAt(i++);
        }
        hashCode = Coercions.ensureInt(hashCode);
        return hashCode;
    }

    private static void increment() {
        if (count == 256) {
            back = front;
            front = StringHashCache.createNativeObject();
            count = 0;
        }
        ++count;
    }

    private static Object getProperty(Object object, String string) {
        throw new RuntimeException("Cannot call native method");
    }

    private static Object createNativeObject() {
        throw new RuntimeException("Cannot call native method");
    }

    private static int unsafeCastToInt(Object object) {
        throw new RuntimeException("Cannot call native method");
    }
}

