/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.scripting.groovy;

import com.sun.faces.scripting.ScriptManager;
import com.sun.faces.util.FacesLogger;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyScriptManager
implements ScriptManager {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final String SCRIPT_PATH = "/WEB-INF/groovy/";
    private static final String SUFFIX = ".groovy";
    private ServletContext servletContext;
    public static final Set<String> FACES_ANNOTATIONS;

    public GroovyScriptManager(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public Set<String> getScripts() {
        HashSet<String> scripts = new HashSet<String>();
        this.processWebInfGroovy(this.servletContext, this.servletContext.getResourcePaths(SCRIPT_PATH), scripts);
        return scripts;
    }

    private void processWebInfGroovy(ServletContext sc, Set<String> paths, Set<String> classList) {
        if (paths != null && !paths.isEmpty()) {
            for (String pathElement : paths) {
                if (pathElement.endsWith("/")) {
                    this.processWebInfGroovy(sc, sc.getResourcePaths(pathElement), classList);
                    continue;
                }
                if (!pathElement.endsWith(SUFFIX)) continue;
                String cname = this.convertToClassName(SCRIPT_PATH, pathElement);
                if (!this.containsAnnotation(sc, pathElement)) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "[WEB-INF/groovy] Found annotated Class: {0}", cname);
                }
                classList.add(cname);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsAnnotation(ServletContext sc, String pathElement) {
        boolean containsAnnotation = false;
        BufferedReader in = null;
        try {
            URL url = sc.getResource(pathElement);
            in = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
            String line = in.readLine();
            while (line != null && !containsAnnotation) {
                if ((line = line.trim()).length() != 0) {
                    for (String pattern : FACES_ANNOTATIONS) {
                        if (line.indexOf(pattern) <= -1) continue;
                        containsAnnotation = true;
                        break;
                    }
                }
                line = in.readLine();
            }
        }
        catch (Exception ioe) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, null, ioe);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ignore) {}
            }
        }
        return containsAnnotation;
    }

    private String convertToClassName(String prefix, String pathEntry) {
        String className = pathEntry;
        if (prefix != null) {
            className = className.substring(prefix.length());
        }
        className = className.substring(0, className.length() - 7);
        return className.replace('/', '.');
    }

    static {
        HashSet annotations = new HashSet(15, 1.0f);
        Collections.addAll(annotations, "javax.faces.component.FacesComponent", "javax.faces.component.*", "javax.faces.convert.FacesConverter", "javax.faces.convert.*", "javax.faces.validator.FacesValidator", "javax.faces.validator.*", "javax.faces.render.FacesRenderer", "javax.faces.render.*", "javax.faces.bean.ManagedBean", "javax.faces.bean.*", "javax.faces.event.NamedEvent", "javax.faces.event.*", "javax.faces.component.behavior.FacesBehavior", "javax.faces.component.behavior.*", "javax.faces.render.FacesBehaviorRenderer");
        FACES_ANNOTATIONS = Collections.unmodifiableSet(annotations);
    }
}

