/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.SharedUtils;
import com.sun.faces.application.view.ViewScopeManager;
import com.sun.faces.config.InitFacesContext;
import com.sun.faces.facelets.flow.FlowNavigationCase;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.FacesMessage;
import javax.faces.application.NavigationCase;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewAction;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.faces.context.PartialViewContext;
import javax.faces.flow.Flow;
import javax.faces.flow.FlowCallNode;
import javax.faces.flow.FlowHandler;
import javax.faces.flow.FlowNode;
import javax.faces.flow.MethodCallNode;
import javax.faces.flow.Parameter;
import javax.faces.flow.ReturnNode;
import javax.faces.flow.SwitchCase;
import javax.faces.flow.SwitchNode;
import javax.faces.flow.ViewNode;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationHandlerImpl
extends ConfigurableNavigationHandler {
    private static final Logger logger = FacesLogger.APPLICATION.getLogger();
    private volatile Map<String, NavigationInfo> navigationMaps;
    private boolean development;
    private static final Pattern REDIRECT_EQUALS_TRUE = Pattern.compile("(.*)(faces-redirect=true)(.*)");
    private static final Pattern INCLUDE_VIEW_PARAMS_EQUALS_TRUE = Pattern.compile("(.*)(includeViewParams=true)(.*)");
    private static final String ROOT_NAVIGATION_MAP_ID = NavigationHandlerImpl.class.getName() + ".NAVIGATION_MAP";

    public NavigationHandlerImpl() {
        ApplicationAssociate associate;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created NavigationHandler instance ");
        }
        if ((associate = ApplicationAssociate.getInstance(FacesContext.getCurrentInstance().getExternalContext())) != null) {
            this.development = associate.isDevModeEnabled();
        }
    }

    public NavigationCase getNavigationCase(FacesContext context, String fromAction, String outcome) {
        Util.notNull("context", context);
        NavigationCase result = null;
        CaseStruct caseStruct = this.getViewId(context, fromAction, outcome, null);
        if (null != caseStruct) {
            result = caseStruct.navCase;
        }
        return result;
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        NavigationMap result = this.getNavigationMap();
        return result;
    }

    public void inspectFlow(FacesContext context, Flow flow) {
        this.initializeNavigationFromFlow(context, flow);
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        this.handleNavigation(context, fromAction, outcome, "");
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome, String toFlowDocumentId) {
        Util.notNull("context", context);
        CaseStruct caseStruct = this.getViewId(context, fromAction, outcome, toFlowDocumentId);
        if (caseStruct != null) {
            ExternalContext extContext = context.getExternalContext();
            ViewHandler viewHandler = Util.getViewHandler(context);
            assert (null != viewHandler);
            Flash flash = extContext.getFlash();
            boolean isUIViewActionBroadcastAndViewdsDiffer = false;
            if (UIViewAction.isProcessingBroadcast((FacesContext)context)) {
                flash.setKeepMessages(true);
                String viewIdBefore = context.getViewRoot().getViewId();
                viewIdBefore = null == viewIdBefore ? "" : viewIdBefore;
                String viewIdAfter = caseStruct.navCase.getToViewId(context);
                viewIdAfter = null == viewIdAfter ? "" : viewIdAfter;
                isUIViewActionBroadcastAndViewdsDiffer = !viewIdBefore.equals(viewIdAfter);
            }
            this.clearViewMapIfNecessary(context, caseStruct.viewId);
            if (caseStruct.navCase.isRedirect() || isUIViewActionBroadcastAndViewdsDiffer) {
                String redirectUrl = viewHandler.getRedirectURL(context, caseStruct.viewId, SharedUtils.evaluateExpressions(context, caseStruct.navCase.getParameters()), caseStruct.navCase.isIncludeViewParams());
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Redirecting to path {0} for outcome {1}and viewId {2}", new Object[]{redirectUrl, outcome, caseStruct.viewId});
                    }
                    this.updateRenderTargets(context, caseStruct.viewId);
                    flash.setRedirect(true);
                    extContext.redirect(redirectUrl);
                }
                catch (IOException ioe) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "jsf.redirect_failed_error", redirectUrl);
                    }
                    throw new FacesException(ioe.getMessage(), (Throwable)ioe);
                }
                context.responseComplete();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Response complete for {0}", caseStruct.viewId);
                }
            } else {
                UIViewRoot newRoot = viewHandler.createView(context, caseStruct.viewId);
                this.updateRenderTargets(context, caseStruct.viewId);
                context.setViewRoot(newRoot);
                FlowHandler flowHandler = context.getApplication().getFlowHandler();
                if (null != flowHandler) {
                    flowHandler.transition(context, caseStruct.currentFlow, caseStruct.newFlow, caseStruct.facesFlowCallNode);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Set new view in FacesContext for {0}", caseStruct.viewId);
                }
            }
        }
    }

    private void loadFlowDefinition(FacesContext context, ViewHandler viewHandler, String viewId) {
        String flowDefId;
        ViewDeclarationLanguage vdl = viewHandler.getViewDeclarationLanguage(context, viewId);
        if (null != vdl && null != (flowDefId = this.deriveValidFlowDefIdFromViewId(context, vdl, viewId))) {
            ViewMetadata metadata = null;
            metadata = vdl.getViewMetadata(context, flowDefId);
            if (null != metadata) {
                metadata.createMetadataView(context);
            }
        }
    }

    private String deriveValidFlowDefIdFromViewId(FacesContext context, ViewDeclarationLanguage vdl, String viewId) {
        int i = viewId.indexOf(".");
        String flowDefId = null;
        if (-1 != i && !vdl.viewExists(context, flowDefId = viewId.substring(0, i) + "-flow.xml") && !vdl.viewExists(context, flowDefId = flowDefId.startsWith("/") ? "WEB-INF" + flowDefId : "WEB-INF/" + flowDefId)) {
            flowDefId = null;
        }
        return flowDefId;
    }

    private NavigationMap getNavigationMap() {
        NavigationMap result = null;
        if (null == this.navigationMaps) {
            this.navigationMaps = new ConcurrentHashMap<String, NavigationInfo>();
            result = new NavigationMap();
            NavigationInfo info = new NavigationInfo();
            info.ruleSet = result;
            this.navigationMaps.put(ROOT_NAVIGATION_MAP_ID, info);
        } else {
            NavigationInfo info = this.navigationMaps.get(ROOT_NAVIGATION_MAP_ID);
            result = info.ruleSet;
        }
        return result;
    }

    private NavigationInfo getNavigationInfo(FacesContext context, String flowId) {
        Flow currentFlow;
        FlowHandler fh;
        NavigationInfo result = null;
        assert (null != this.navigationMaps);
        result = this.navigationMaps.get(flowId);
        if (null == result && null != (fh = context.getApplication().getFlowHandler()) && null != (currentFlow = fh.getCurrentFlow(context))) {
            result = this.navigationMaps.get(currentFlow.getId());
        }
        return result;
    }

    private void initializeNavigationFromAssociate() {
        ApplicationAssociate associate = ApplicationAssociate.getCurrentInstance();
        if (associate != null) {
            Map<String, Set<NavigationCase>> m = associate.getNavigationCaseListMappings();
            NavigationMap rootMap = this.getNavigationMap();
            if (m != null) {
                rootMap.putAll((Map<? extends String, ? extends Set<NavigationCase>>)m);
            }
        }
    }

    private void initializeNavigationFromFlow(FacesContext context, Flow toInspect) {
        if (context instanceof InitFacesContext) {
            this.getNavigationMap();
            this.initializeNavigationFromFlowNonThreadSafe(toInspect);
        } else {
            assert (null != this.navigationMaps);
            this.initializeNavigationFromFlowThreadSafe(toInspect);
        }
    }

    private void initializeNavigationFromFlowNonThreadSafe(Flow toInspect) {
        Map switches = toInspect.getSwitches();
        String flowId = toInspect.getId();
        if (this.navigationMaps.containsKey(flowId)) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "PENDING(edburns): merge existing map");
            }
        } else if (!switches.isEmpty()) {
            NavigationInfo info = new NavigationInfo();
            info.switches = new ConcurrentHashMap();
            for (Map.Entry cur : switches.entrySet()) {
                info.switches.put(cur.getKey(), cur.getValue());
            }
            this.navigationMaps.put(flowId, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeNavigationFromFlowThreadSafe(Flow toInspect) {
        NavigationHandlerImpl navigationHandlerImpl = this;
        synchronized (navigationHandlerImpl) {
            this.initializeNavigationFromFlowNonThreadSafe(toInspect);
        }
    }

    private void clearViewMapIfNecessary(FacesContext facesContext, String newId) {
        Map viewMap;
        UIViewRoot root = facesContext.getViewRoot();
        if (root != null && !root.getViewId().equals(newId) && (viewMap = root.getViewMap(false)) != null) {
            ViewScopeManager manager = ViewScopeManager.getInstance(facesContext);
            manager.clear(facesContext);
        }
    }

    private void updateRenderTargets(FacesContext ctx, String newId) {
        PartialViewContext pctx;
        if (!(ctx.getViewRoot() != null && ctx.getViewRoot().getViewId().equals(newId) || (pctx = ctx.getPartialViewContext()).isRenderAll())) {
            pctx.setRenderAll(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseStruct getViewId(FacesContext ctx, String fromAction, String outcome, String toFlowDocumentId) {
        UIViewRoot root;
        if (this.navigationMaps == null) {
            NavigationHandlerImpl navigationHandlerImpl = this;
            synchronized (navigationHandlerImpl) {
                this.initializeNavigationFromAssociate();
            }
        }
        String viewId = (root = ctx.getViewRoot()) != null ? root.getViewId() : null;
        CaseStruct caseStruct = null;
        if (viewId != null && (caseStruct = this.findExactMatch(ctx, viewId, fromAction, outcome)) == null) {
            caseStruct = this.findWildCardMatch(ctx, viewId, fromAction, outcome);
        }
        if (caseStruct == null) {
            caseStruct = this.findDefaultMatch(ctx, fromAction, outcome);
        }
        if (null == caseStruct && null != fromAction && null != outcome) {
            caseStruct = this.findSwitchMatch(ctx, fromAction, outcome, toFlowDocumentId);
        }
        if (null == caseStruct && null != fromAction && null != outcome) {
            caseStruct = this.findMethodCallMatch(ctx, fromAction, outcome);
        }
        if (null == caseStruct && null != fromAction && null != outcome) {
            caseStruct = this.findFacesFlowCallMatch(ctx, fromAction, outcome, toFlowDocumentId);
        }
        if (null == caseStruct && null != fromAction && null != outcome) {
            caseStruct = this.findReturnMatch(ctx, fromAction, outcome, toFlowDocumentId);
        }
        if (caseStruct == null && outcome != null && viewId != null) {
            if (0 == outcome.length()) {
                outcome = null;
            } else {
                caseStruct = this.findImplicitMatch(ctx, viewId, fromAction, outcome, toFlowDocumentId);
            }
        }
        if (caseStruct == null && outcome != null && this.development) {
            Object[] params;
            String key;
            if (fromAction == null) {
                key = "com.sun.faces.NAVIGATION_NO_MATCHING_OUTCOME";
                params = new Object[]{viewId, outcome};
            } else {
                key = "com.sun.faces.NAVIGATION_NO_MATCHING_OUTCOME_ACTION";
                params = new Object[]{viewId, fromAction, outcome};
            }
            FacesMessage m = MessageUtils.getExceptionMessage(key, params);
            m.setSeverity(FacesMessage.SEVERITY_WARN);
            ctx.addMessage(null, m);
        }
        return caseStruct;
    }

    private CaseStruct findExactMatch(FacesContext ctx, String viewId, String fromAction, String outcome) {
        FlowHandler flowHandler;
        NavigationMap navMap = this.getNavigationMap();
        Set caseSet = (Set)navMap.get(viewId);
        if (caseSet == null) {
            return null;
        }
        CaseStruct result = this.determineViewFromActionOutcome(ctx, caseSet, fromAction, outcome);
        if (null != result && null != (flowHandler = ctx.getApplication().getFlowHandler())) {
            result.newFlow = result.currentFlow = flowHandler.getCurrentFlow();
        }
        return result;
    }

    private CaseStruct findWildCardMatch(FacesContext ctx, String viewId, String fromAction, String outcome) {
        FlowHandler flowHandler;
        CaseStruct result = null;
        NavigationMap navMap = this.getNavigationMap();
        for (String fromViewId : navMap.wildcardMatchList) {
            if (!viewId.startsWith(fromViewId)) continue;
            String wcFromViewId = new StringBuilder(32).append(fromViewId).append('*').toString();
            Set ccaseSet = (Set)navMap.get(wcFromViewId);
            if (ccaseSet == null) {
                return null;
            }
            result = this.determineViewFromActionOutcome(ctx, ccaseSet, fromAction, outcome);
            if (result == null) continue;
            break;
        }
        if (null != result && null != (flowHandler = ctx.getApplication().getFlowHandler())) {
            result.newFlow = result.currentFlow = flowHandler.getCurrentFlow();
        }
        return result;
    }

    private CaseStruct findDefaultMatch(FacesContext ctx, String fromAction, String outcome) {
        FlowHandler flowHandler;
        NavigationMap navMap = this.getNavigationMap();
        Set caseSet = (Set)navMap.get("*");
        if (caseSet == null) {
            return null;
        }
        CaseStruct result = this.determineViewFromActionOutcome(ctx, caseSet, fromAction, outcome);
        if (null != result && null != (flowHandler = ctx.getApplication().getFlowHandler())) {
            result.newFlow = result.currentFlow = flowHandler.getCurrentFlow();
        }
        return result;
    }

    private CaseStruct findImplicitMatch(FacesContext context, String viewId, String fromAction, String outcome, String flowDefiningDocumentId) {
        int idx;
        String viewIdToTest = outcome;
        String currentViewId = viewId;
        LinkedHashMap<String, ArrayList<String>> parameters = null;
        boolean isRedirect = false;
        boolean isIncludeViewParams = false;
        CaseStruct result = null;
        int questionMark = viewIdToTest.indexOf(63);
        if (-1 != questionMark) {
            String queryString;
            int viewIdLen = viewIdToTest.length();
            if (viewIdLen <= questionMark + 1) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "jsf.navigation_invalid_query_string", viewIdToTest);
                }
                if (this.development) {
                    String key = "com.sun.faces.NAVIGATION_INVALID_QUERY_STRING";
                    Object[] params = new Object[]{viewIdToTest};
                    FacesMessage m = MessageUtils.getExceptionMessage(key, params);
                    m.setSeverity(FacesMessage.SEVERITY_WARN);
                    context.addMessage(null, m);
                }
                queryString = null;
                viewIdToTest = viewIdToTest.substring(0, questionMark);
            } else {
                queryString = viewIdToTest.substring(questionMark + 1);
                viewIdToTest = viewIdToTest.substring(0, questionMark);
                Matcher m = REDIRECT_EQUALS_TRUE.matcher(queryString);
                if (m.find()) {
                    isRedirect = true;
                    queryString = queryString.replace(m.group(2), "");
                }
                if ((m = INCLUDE_VIEW_PARAMS_EQUALS_TRUE.matcher(queryString)).find()) {
                    isIncludeViewParams = true;
                    queryString = queryString.replace(m.group(2), "");
                }
            }
            if (queryString != null && queryString.length() > 0) {
                Map appMap = context.getExternalContext().getApplicationMap();
                String[] queryElements = Util.split(appMap, queryString, "&amp;|&");
                int len = queryElements.length;
                for (int i = 0; i < len; ++i) {
                    ArrayList<String> values;
                    String[] elements = Util.split(appMap, queryElements[i], "=");
                    if (elements.length != 2) continue;
                    if (parameters == null) {
                        parameters = new LinkedHashMap<String, ArrayList<String>>(len / 2, 1.0f);
                        values = new ArrayList<String>(2);
                        values.add(elements[1]);
                        parameters.put(elements[0], values);
                        continue;
                    }
                    values = (ArrayList<String>)parameters.get(elements[0]);
                    if (values == null) {
                        values = new ArrayList(2);
                        parameters.put(elements[0], values);
                    }
                    values.add(elements[1]);
                }
            }
        }
        if (viewIdToTest.lastIndexOf(46) == -1 && (idx = currentViewId.lastIndexOf(46)) != -1) {
            viewIdToTest = viewIdToTest + currentViewId.substring(idx);
        }
        if (!viewIdToTest.startsWith("/")) {
            int lastSlash = currentViewId.lastIndexOf("/");
            if (lastSlash != -1) {
                currentViewId = currentViewId.substring(0, lastSlash + 1);
                viewIdToTest = currentViewId + viewIdToTest;
            } else {
                viewIdToTest = "/" + viewIdToTest;
            }
        }
        ViewHandler viewHandler = Util.getViewHandler(context);
        viewIdToTest = viewHandler.deriveViewId(context, viewIdToTest);
        FlowHandler flowHandler = context.getApplication().getFlowHandler();
        Flow currentFlow = null;
        Flow newFlow = null;
        if (null != flowHandler) {
            newFlow = currentFlow = flowHandler.getCurrentFlow(context);
            if (null == currentFlow) {
                if (null == viewIdToTest) {
                    int idx2 = currentViewId.lastIndexOf(46);
                    String currentExtension = idx2 != -1 ? currentViewId.substring(idx2) : ".xhtml";
                    viewIdToTest = "/" + outcome + "/" + outcome + currentExtension;
                    if (null != (viewIdToTest = viewHandler.deriveViewId(context, viewIdToTest))) {
                        this.loadFlowDefinition(context, viewHandler, viewIdToTest);
                        newFlow = flowHandler.getFlow(context, flowDefiningDocumentId, outcome);
                        if (null != newFlow) {
                            String startNodeId = newFlow.getStartNodeId();
                            result = this.getViewId(context, fromAction, startNodeId, newFlow.getDefiningDocumentId());
                        }
                    }
                }
            } else if (null != viewIdToTest && !viewIdToTest.startsWith("/" + currentFlow.getId())) {
                newFlow = null;
            }
        }
        if (null == result && null != viewIdToTest) {
            result = new CaseStruct();
            result.viewId = viewIdToTest;
            result.navCase = new NavigationCase(currentViewId, fromAction, outcome, null, viewIdToTest, parameters, isRedirect, isIncludeViewParams);
        }
        if (null != result) {
            result.currentFlow = currentFlow;
            result.newFlow = newFlow;
        }
        return result;
    }

    private CaseStruct findSwitchMatch(FacesContext context, String fromAction, String outcome, String toFlowDocumentId) {
        SwitchNode switchNode;
        CaseStruct result = null;
        NavigationInfo info = this.getNavigationInfo(context, fromAction);
        FlowHandler flowHandler = context.getApplication().getFlowHandler();
        if (null != flowHandler && null != info && null != info.switches && !info.switches.isEmpty() && null != (switchNode = (SwitchNode)info.switches.get(outcome))) {
            Flow currentFlow;
            List cases = switchNode.getCases();
            for (SwitchCase cur : cases) {
                if (!cur.getCondition(context).booleanValue()) continue;
                outcome = cur.getFromOutcome();
                Flow newFlow = flowHandler.getFlow(context, toFlowDocumentId, fromAction);
                if (null != newFlow) {
                    result = this.synthesizeCaseStruct(context, newFlow, fromAction, outcome);
                } else {
                    newFlow = flowHandler.getCurrentFlow(context);
                    if (null != newFlow) {
                        result = this.synthesizeCaseStruct(context, newFlow, fromAction, outcome);
                    }
                }
                if (null == result) continue;
                break;
            }
            if (null == result && null != (outcome = switchNode.getDefaultOutcome(context)) && null != (currentFlow = flowHandler.getCurrentFlow(context)) && null != (result = this.synthesizeCaseStruct(context, currentFlow, fromAction, outcome))) {
                result.currentFlow = currentFlow;
                result.newFlow = currentFlow;
            }
        }
        return result;
    }

    private CaseStruct synthesizeCaseStruct(FacesContext context, Flow flow, String fromAction, String outcome) {
        CaseStruct result = null;
        FlowNode node = flow.getNode(outcome);
        if (null != node) {
            if (node instanceof ViewNode) {
                result = new CaseStruct();
                result.viewId = ((ViewNode)node).getVdlDocumentId();
                result.navCase = new FlowNavigationCase(fromAction, fromAction, outcome, null, result.viewId, null, false, false);
            } else if (node instanceof ReturnNode) {
                String fromOutcome = ((ReturnNode)node).getFromOutcome(context);
                result = this.getViewId(context, fromAction, fromOutcome, flow.getDefiningDocumentId());
            }
        } else {
            String currentViewId = outcome;
            int idx = currentViewId.lastIndexOf(46);
            String currentExtension = idx != -1 ? currentViewId.substring(idx) : ".xhtml";
            String viewIdToTest = "/" + flow.getId() + "/" + outcome + currentExtension;
            ViewHandler viewHandler = Util.getViewHandler(context);
            viewIdToTest = viewHandler.deriveViewId(context, viewIdToTest);
            if (null != viewIdToTest) {
                result = new CaseStruct();
                result.viewId = viewIdToTest;
                result.navCase = new FlowNavigationCase(fromAction, fromAction, outcome, null, result.viewId, null, false, false);
            }
        }
        return result;
    }

    private CaseStruct findMethodCallMatch(FacesContext context, String fromAction, String outcome) {
        MethodCallNode methodCallNode;
        MethodExpression me;
        FlowNode node;
        CaseStruct result = null;
        FlowHandler flowHandler = context.getApplication().getFlowHandler();
        if (null == flowHandler) {
            return null;
        }
        Flow currentFlow = flowHandler.getCurrentFlow(context);
        if (null != currentFlow && (node = currentFlow.getNode(outcome)) instanceof MethodCallNode && null != (me = (methodCallNode = (MethodCallNode)node).getMethodExpression())) {
            ValueExpression ve;
            Object invokeResult;
            List paramList = methodCallNode.getParameters();
            Object[] params = null;
            if (null != paramList) {
                params = new Object[paramList.size()];
                int i = 0;
                ELContext elContext = context.getELContext();
                for (Parameter cur : paramList) {
                    params[i++] = cur.getValue().getValue(elContext);
                }
            }
            if (null == (invokeResult = me.invoke(context.getELContext(), params)) && null != (ve = methodCallNode.getOutcome())) {
                invokeResult = ve.getValue(context.getELContext());
            }
            if (null != (result = this.synthesizeCaseStruct(context, currentFlow, fromAction, outcome = (String)invokeResult))) {
                result.currentFlow = currentFlow;
                result.newFlow = currentFlow;
            }
        }
        return result;
    }

    private CaseStruct findFacesFlowCallMatch(FacesContext context, String fromAction, String outcome, String toFlowDocumentId) {
        CaseStruct result = null;
        FlowHandler flowHandler = context.getApplication().getFlowHandler();
        if (null == flowHandler) {
            return null;
        }
        Flow currentFlow = flowHandler.getCurrentFlow(context);
        Flow newFlow = null;
        FlowCallNode facesFlowCallNode = null;
        if (null != currentFlow) {
            FlowNode node = currentFlow.getNode(outcome);
            if (node instanceof FlowCallNode) {
                facesFlowCallNode = (FlowCallNode)node;
                String flowId = facesFlowCallNode.getCalledFlowId(context);
                String flowDocumentId = facesFlowCallNode.getCalledFlowDocumentId(context);
                if (null != flowId) {
                    newFlow = flowHandler.getFlow(context, flowDocumentId, flowId);
                    if (null == newFlow) {
                        String potentialFlowDef = flowId + "/" + flowId + ".xhtml";
                        ViewHandler vh = context.getApplication().getViewHandler();
                        this.loadFlowDefinition(context, vh, potentialFlowDef);
                        newFlow = flowHandler.getFlow(context, flowDocumentId, flowId);
                    }
                    if (null != newFlow) {
                        result = this.synthesizeCaseStruct(context, newFlow, fromAction, flowId);
                    }
                }
            }
        } else {
            String startNodeId;
            newFlow = flowHandler.getFlow(context, toFlowDocumentId, outcome);
            if (null != newFlow && null == (result = this.synthesizeCaseStruct(context, newFlow, fromAction, startNodeId = newFlow.getStartNodeId()))) {
                result = this.getViewId(context, fromAction, startNodeId, toFlowDocumentId);
            }
        }
        if (null != result) {
            result.currentFlow = currentFlow;
            result.newFlow = newFlow;
            result.facesFlowCallNode = facesFlowCallNode;
        }
        return result;
    }

    private CaseStruct findReturnMatch(FacesContext context, String fromAction, String outcome, String toFlowDocumentId) {
        ReturnNode returnNode;
        CaseStruct result = null;
        FlowHandler flowHandler = context.getApplication().getFlowHandler();
        if (null == flowHandler) {
            return null;
        }
        Flow currentFlow = flowHandler.getCurrentFlow(context);
        if (null != currentFlow && null != (returnNode = (ReturnNode)currentFlow.getReturns().get(outcome))) {
            String fromOutcome = returnNode.getFromOutcome(context);
            result = this.getViewId(context, fromAction, fromOutcome, toFlowDocumentId);
        }
        if (null != result) {
            result.currentFlow = currentFlow;
            result.newFlow = null;
        }
        return result;
    }

    private CaseStruct determineViewFromActionOutcome(FacesContext ctx, Set<NavigationCase> caseSet, String fromAction, String outcome) {
        CaseStruct result = new CaseStruct();
        boolean match = false;
        for (NavigationCase cnc : caseSet) {
            String cncFromAction = cnc.getFromAction();
            String cncFromOutcome = cnc.getFromOutcome();
            boolean cncHasCondition = cnc.hasCondition();
            String cncToViewId = cnc.getToViewId(ctx);
            if (cncFromAction != null && cncFromOutcome != null) {
                if (cncFromAction.equals(fromAction) && cncFromOutcome.equals(outcome)) {
                    result.viewId = cncToViewId;
                    result.navCase = cnc;
                    match = true;
                }
            } else if (cncFromAction == null && cncFromOutcome != null) {
                if (cncFromOutcome.equals(outcome)) {
                    result.viewId = cncToViewId;
                    result.navCase = cnc;
                    match = true;
                }
            } else if (cncFromAction != null && cncFromOutcome == null) {
                if (cncFromAction.equals(fromAction) && (outcome != null || cncHasCondition)) {
                    result.viewId = cncToViewId;
                    result.navCase = cnc;
                    match = true;
                }
            } else if (cncFromAction == null && cncFromOutcome == null && (outcome != null || cncHasCondition)) {
                result.viewId = cncToViewId;
                result.navCase = cnc;
                match = true;
            }
            if (!match) continue;
            if (cncHasCondition && Boolean.FALSE.equals(cnc.getCondition(ctx))) {
                match = false;
                continue;
            }
            return result;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NavigationMap
    extends AbstractMap<String, Set<NavigationCase>> {
        private HashMap<String, Set<NavigationCase>> navigationMap = new HashMap();
        private TreeSet<String> wildcardMatchList = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String fromViewId1, String fromViewId2) {
                return -fromViewId1.compareTo(fromViewId2);
            }
        });

        private NavigationMap() {
        }

        @Override
        public int size() {
            return this.navigationMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.navigationMap.isEmpty();
        }

        @Override
        public Set<NavigationCase> put(String key, Set<NavigationCase> value) {
            if (key == null) {
                throw new IllegalArgumentException(key);
            }
            if (value == null) {
                throw new IllegalArgumentException();
            }
            this.updateWildcards(key);
            Set<NavigationCase> existing = this.navigationMap.get(key);
            if (existing == null) {
                this.navigationMap.put(key, value);
                return null;
            }
            existing.addAll(value);
            return existing;
        }

        @Override
        public void putAll(Map<? extends String, ? extends Set<NavigationCase>> m) {
            if (m == null) {
                return;
            }
            for (Map.Entry<? extends String, ? extends Set<NavigationCase>> entry : m.entrySet()) {
                String key = entry.getKey();
                this.updateWildcards(key);
                Set<NavigationCase> existing = this.navigationMap.get(key);
                if (existing == null) {
                    this.navigationMap.put(key, entry.getValue());
                    continue;
                }
                existing.addAll((Collection<NavigationCase>)entry.getValue());
            }
        }

        @Override
        public Set<String> keySet() {
            return new AbstractSet<String>(){

                @Override
                public Iterator<String> iterator() {
                    return new Iterator<String>(){
                        Iterator<Map.Entry<String, Set<NavigationCase>>> i;
                        {
                            this.i = NavigationMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public String next() {
                            return this.i.next().getKey();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return NavigationMap.this.size();
                }
            };
        }

        @Override
        public Collection<Set<NavigationCase>> values() {
            return new AbstractCollection<Set<NavigationCase>>(){

                @Override
                public Iterator<Set<NavigationCase>> iterator() {
                    return new Iterator<Set<NavigationCase>>(){
                        Iterator<Map.Entry<String, Set<NavigationCase>>> i;
                        {
                            this.i = NavigationMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public Set<NavigationCase> next() {
                            return this.i.next().getValue();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return NavigationMap.this.size();
                }
            };
        }

        @Override
        public Set<Map.Entry<String, Set<NavigationCase>>> entrySet() {
            return new AbstractSet<Map.Entry<String, Set<NavigationCase>>>(){

                @Override
                public Iterator<Map.Entry<String, Set<NavigationCase>>> iterator() {
                    return new Iterator<Map.Entry<String, Set<NavigationCase>>>(){
                        Iterator<Map.Entry<String, Set<NavigationCase>>> i;
                        {
                            this.i = NavigationMap.this.navigationMap.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public Map.Entry<String, Set<NavigationCase>> next() {
                            return this.i.next();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return NavigationMap.this.size();
                }
            };
        }

        private void updateWildcards(String fromViewId) {
            if (!this.navigationMap.containsKey(fromViewId) && fromViewId.endsWith("*")) {
                this.wildcardMatchList.add(fromViewId.substring(0, fromViewId.lastIndexOf(42)));
            }
        }
    }

    private static final class NavigationInfo {
        private NavigationMap ruleSet;
        private Map<String, SwitchNode> switches;

        private NavigationInfo() {
        }
    }

    private static class CaseStruct {
        String viewId;
        NavigationCase navCase;
        Flow currentFlow;
        Flow newFlow;
        FlowCallNode facesFlowCallNode;

        private CaseStruct() {
        }
    }
}

