/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.ContractInfo;
import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.VersionInfo;

public class ResourceInfo {
    ResourceHelper helper;
    LibraryInfo library;
    ContractInfo contract;
    String libraryName;
    String localePrefix;
    String name;
    String path;
    VersionInfo version;

    public ResourceInfo(LibraryInfo library, ContractInfo contract, String name, VersionInfo version) {
        this.contract = contract;
        this.library = library;
        this.helper = library.getHelper();
        this.localePrefix = library.getLocalePrefix();
        this.name = name;
        this.version = version;
        this.libraryName = library.getName();
    }

    public ResourceInfo(ContractInfo contract, String name, VersionInfo version, ResourceHelper helper) {
        this.contract = contract;
        this.name = name;
        this.version = version;
        this.helper = helper;
    }

    public ResourceInfo(ResourceInfo other, boolean copyLocalePrefix) {
        this.helper = other.helper;
        this.library = new LibraryInfo(other.library, copyLocalePrefix);
        this.libraryName = this.library.getName();
        if (copyLocalePrefix) {
            this.localePrefix = other.localePrefix;
        }
        this.name = other.name;
        this.path = other.path;
        this.version = other.version;
    }

    public void copy(ResourceInfo other) {
        this.helper = other.helper;
        this.library = other.library;
        this.libraryName = other.libraryName;
        this.localePrefix = other.localePrefix;
        this.name = other.name;
        this.path = other.path;
        this.version = other.version;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ResourceInfo other = (ResourceInfo)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.libraryName == null ? other.libraryName != null : !this.libraryName.equals(other.libraryName)) {
            return false;
        }
        if (this.localePrefix == null ? other.localePrefix != null : !this.localePrefix.equals(other.localePrefix)) {
            return false;
        }
        if (!(this.version == other.version || this.version != null && this.version.equals(other.version))) {
            return false;
        }
        if (!(this.library == other.library || this.library != null && this.library.equals(other.library))) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return !(this.helper == null ? other.helper != null : !this.helper.equals(other.helper));
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 97 * hash + (this.libraryName != null ? this.libraryName.hashCode() : 0);
        hash = 97 * hash + (this.localePrefix != null ? this.localePrefix.hashCode() : 0);
        hash = 97 * hash + (this.version != null ? this.version.hashCode() : 0);
        hash = 97 * hash + (this.library != null ? this.library.hashCode() : 0);
        hash = 97 * hash + (this.path != null ? this.path.hashCode() : 0);
        hash = 97 * hash + (this.helper != null ? this.helper.hashCode() : 0);
        return hash;
    }

    public ResourceHelper getHelper() {
        return this.helper;
    }

    public LibraryInfo getLibraryInfo() {
        return this.library;
    }

    public String getLocalePrefix() {
        return this.localePrefix;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getContract() {
        return null != this.contract ? this.contract.toString() : null;
    }

    public VersionInfo getVersion() {
        return this.version;
    }
}

