/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.ViewScopeContextObject;
import com.sun.faces.application.view.ViewScopedCDIEventFireHelper;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewScopeContextManager {
    private static final Logger LOGGER = FacesLogger.APPLICATION_VIEW.getLogger();
    private boolean isCdiOneOneOrGreater;
    private Class viewScopedCDIEventFireHelperImplClass;
    private static final String ACTIVE_VIEW_CONTEXTS = "com.sun.faces.application.view.activeViewContexts";
    private static final String ACTIVE_VIEW_MAPS = "com.sun.faces.application.view.activeViewMaps";
    private final BeanManager beanManager;

    public ViewScopeContextManager() {
        block2: {
            this.isCdiOneOneOrGreater = Util.isCdiOneOneOrGreater();
            try {
                this.viewScopedCDIEventFireHelperImplClass = Class.forName("com.sun.faces.application.view.ViewScopedCDIEventFireHelperImpl");
            }
            catch (ClassNotFoundException ex) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block2;
                LOGGER.log(Level.SEVERE, "CDI 1.1 events not enabled", ex);
            }
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.beanManager = (BeanManager)Util.getCDIBeanManager(facesContext.getExternalContext().getApplicationMap());
    }

    public void clear(FacesContext facesContext) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Clearing @ViewScoped CDI beans for current view map");
        }
        Map viewMap = facesContext.getViewRoot().getViewMap(false);
        Map<String, ViewScopeContextObject> contextMap = this.getContextMap(facesContext, false);
        if (contextMap != null) {
            this.destroyBeans(viewMap, contextMap);
        }
    }

    public void clear(FacesContext facesContext, Map<String, Object> viewMap) {
        Map<String, ViewScopeContextObject> contextMap;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Clearing @ViewScoped CDI beans for given view map: {0}");
        }
        if ((contextMap = this.getContextMap(facesContext, viewMap)) != null) {
            this.destroyBeans(viewMap, contextMap);
        }
    }

    public <T> T createBean(FacesContext facesContext, Contextual<T> contextual, CreationalContext<T> creational) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Creating @ViewScoped CDI bean using contextual: {0}", contextual);
        }
        if (!(contextual instanceof PassivationCapable)) {
            throw new IllegalArgumentException("ViewScoped bean " + contextual.toString() + " must be PassivationCapable, but is not.");
        }
        Object result = contextual.create(creational);
        if (result != null) {
            String name = this.getName(result);
            facesContext.getViewRoot().getViewMap(true).put(name, result);
            String passivationCapableId = ((PassivationCapable)contextual).getId();
            this.getContextMap(facesContext).put(passivationCapableId, new ViewScopeContextObject(passivationCapableId, name));
        }
        return (T)result;
    }

    private void destroyBeans(Map<String, Object> viewMap, Map<String, ViewScopeContextObject> contextMap) {
        ArrayList<String> removalNameList = new ArrayList<String>();
        if (contextMap != null) {
            for (Map.Entry<String, ViewScopeContextObject> entry : contextMap.entrySet()) {
                String passivationCapableId = entry.getKey();
                Bean contextual = this.beanManager.getPassivationCapableBean(passivationCapableId);
                ViewScopeContextObject contextObject = entry.getValue();
                CreationalContext creationalContext = this.beanManager.createCreationalContext((Contextual)contextual);
                contextual.destroy(viewMap.get(contextObject.getName()), creationalContext);
                removalNameList.add(contextObject.getName());
            }
            for (String name : removalNameList) {
                viewMap.remove(name);
            }
            contextMap.clear();
        }
    }

    public <T> T getBean(FacesContext facesContext, Contextual<T> contextual) {
        T result = null;
        Map<String, ViewScopeContextObject> contextMap = this.getContextMap(facesContext);
        if (contextMap != null) {
            if (!(contextual instanceof PassivationCapable)) {
                throw new IllegalArgumentException("ViewScoped bean " + contextual.toString() + " must be PassivationCapable, but is not.");
            }
            ViewScopeContextObject contextObject = contextMap.get(((PassivationCapable)contextual).getId());
            if (contextObject != null) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Getting value for @ViewScoped bean with name: {0}", contextObject.getName());
                }
                result = (T)facesContext.getViewRoot().getViewMap(true).get(contextObject.getName());
            }
        }
        return result;
    }

    private Map<String, ViewScopeContextObject> getContextMap(FacesContext facesContext) {
        return this.getContextMap(facesContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ViewScopeContextObject> getContextMap(FacesContext facesContext, boolean create) {
        Map result = null;
        ExternalContext externalContext = facesContext.getExternalContext();
        if (externalContext != null) {
            Map map;
            Map sessionMap = externalContext.getSessionMap();
            ConcurrentHashMap activeViewScopeContexts = (ConcurrentHashMap)sessionMap.get(ACTIVE_VIEW_CONTEXTS);
            Map viewMap = facesContext.getViewRoot().getViewMap(false);
            if (activeViewScopeContexts == null && create) {
                map = sessionMap;
                synchronized (map) {
                    activeViewScopeContexts = new ConcurrentHashMap();
                    sessionMap.put(ACTIVE_VIEW_CONTEXTS, activeViewScopeContexts);
                }
            }
            if (activeViewScopeContexts != null && create) {
                map = activeViewScopeContexts;
                synchronized (map) {
                    if (!activeViewScopeContexts.containsKey(System.identityHashCode(viewMap)) && create) {
                        activeViewScopeContexts.put(System.identityHashCode(viewMap), new ConcurrentHashMap());
                        sessionMap.put(ACTIVE_VIEW_CONTEXTS, activeViewScopeContexts);
                    }
                }
            }
            if (activeViewScopeContexts != null) {
                result = (Map)activeViewScopeContexts.get(System.identityHashCode(viewMap));
            }
        }
        return result;
    }

    private Map<String, ViewScopeContextObject> getContextMap(FacesContext facesContext, Map<String, Object> viewMap) {
        Map sessionMap;
        Map activeViewScopeContexts;
        Map result = null;
        ExternalContext externalContext = facesContext.getExternalContext();
        if (externalContext != null && (activeViewScopeContexts = (Map)(sessionMap = externalContext.getSessionMap()).get(ACTIVE_VIEW_CONTEXTS)) != null) {
            result = (Map)activeViewScopeContexts.get(System.identityHashCode(viewMap));
        }
        return result;
    }

    private String getName(Object instance) {
        String name = instance.getClass().getSimpleName().substring(0, 1).toLowerCase() + instance.getClass().getSimpleName().substring(1);
        Named named = instance.getClass().getAnnotation(Named.class);
        if (named != null && named.value() != null && !named.value().trim().equals("")) {
            name = named.value();
        }
        return name;
    }

    public void sessionDestroyed(HttpSessionEvent hse) {
        HttpSession session;
        Map activeViewScopeContexts;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Cleaning up session for CDI @ViewScoped beans");
        }
        if ((activeViewScopeContexts = (Map)(session = hse.getSession()).getAttribute(ACTIVE_VIEW_CONTEXTS)) != null) {
            Map activeViewMaps = (Map)session.getAttribute(ACTIVE_VIEW_MAPS);
            if (activeViewMaps != null) {
                for (Map instanceMap : activeViewMaps.values()) {
                    Map contextMap = (Map)activeViewScopeContexts.get(System.identityHashCode(instanceMap));
                    this.destroyBeans(instanceMap, contextMap);
                }
            }
            activeViewScopeContexts.clear();
            session.removeAttribute(ACTIVE_VIEW_CONTEXTS);
        }
    }

    public void fireInitializedEvent(FacesContext facesContext, UIViewRoot root) {
        Set availableBeans;
        BeanManager beanManager;
        if (this.isCdiOneOneOrGreater && null != this.viewScopedCDIEventFireHelperImplClass && null != (beanManager = (BeanManager)Util.getCDIBeanManager(facesContext.getExternalContext().getApplicationMap())) && null != (availableBeans = beanManager.getBeans((Type)this.viewScopedCDIEventFireHelperImplClass, new Annotation[0])) && !availableBeans.isEmpty()) {
            Bean bean = beanManager.resolve(availableBeans);
            CreationalContext creationalContext = beanManager.createCreationalContext(null);
            ViewScopedCDIEventFireHelper eventHelper = (ViewScopedCDIEventFireHelper)beanManager.getReference(bean, (Type)bean.getBeanClass(), creationalContext);
            eventHelper.fireInitializedEvent(root);
        }
    }

    public void fireDestroyedEvent(FacesContext facesContext, UIViewRoot root) {
        Set availableBeans;
        BeanManager beanManager;
        if (this.isCdiOneOneOrGreater && null != this.viewScopedCDIEventFireHelperImplClass && null != (beanManager = (BeanManager)Util.getCDIBeanManager(facesContext.getExternalContext().getApplicationMap())) && null != (availableBeans = beanManager.getBeans((Type)this.viewScopedCDIEventFireHelperImplClass, new Annotation[0])) && !availableBeans.isEmpty()) {
            Bean bean = beanManager.resolve(availableBeans);
            CreationalContext creationalContext = beanManager.createCreationalContext(null);
            ViewScopedCDIEventFireHelper eventHelper = (ViewScopedCDIEventFireHelper)beanManager.getReference(bean, (Type)bean.getBeanClass(), creationalContext);
            eventHelper.fireDestroyedEvent(root);
        }
    }
}

