/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.io.FastStringWriter;
import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.SelectItemsIterator;
import com.sun.faces.renderkit.html_basic.HtmlBasicInputRenderer;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.Util;
import jakarta.el.ELException;
import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UISelectMany;
import jakarta.faces.component.UISelectOne;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.model.SelectItem;
import jakarta.faces.model.SelectItemGroup;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class MenuRenderer
extends HtmlBasicInputRenderer {
    private static final Attribute[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.SELECTMANYMENU);

    public Object convertSelectManyValue(FacesContext context, UISelectMany uiSelectMany, String[] newValues) throws ConverterException {
        ValueExpression valueExpression = uiSelectMany.getValueExpression("value");
        Object convertedValue = newValues;
        if (valueExpression != null) {
            Object value;
            Class modelType = valueExpression.getType(context.getELContext());
            if (modelType != null) {
                convertedValue = this.convertSelectManyValuesForModel(context, uiSelectMany, modelType, newValues);
            }
            if (convertedValue == null && (value = valueExpression.getValue(context.getELContext())) != null) {
                convertedValue = this.convertSelectManyValuesForModel(context, uiSelectMany, value.getClass(), newValues);
            }
            if (convertedValue == null) {
                Object[] params = new Object[]{newValues == null ? "" : Arrays.stream(newValues).collect(Collectors.joining("")), valueExpression.getExpressionString()};
                throw new ConverterException(MessageUtils.getExceptionMessage("com.sun.faces.TYPECONVERSION_ERROR", params));
            }
        } else {
            convertedValue = this.convertSelectManyValuesForArray(context, uiSelectMany, Object.class, newValues);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SelectMany Component  " + uiSelectMany.getId() + " convertedValues " + convertedValue);
        }
        return convertedValue;
    }

    public Object convertSelectOneValue(FacesContext context, UISelectOne uiSelectOne, String newValue) throws ConverterException {
        if (this.isNoValueOrNull(newValue, (UIComponent)uiSelectOne)) {
            return null;
        }
        Object convertedValue = super.getConvertedValue(context, (UIComponent)uiSelectOne, newValue);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SelectOne Component  " + uiSelectOne.getId() + " convertedValue " + convertedValue);
        }
        return convertedValue;
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldDecode(component)) {
            return;
        }
        String clientId = this.decodeBehaviors(context, component);
        if (clientId == null) {
            clientId = component.getClientId(context);
        }
        if (component instanceof UISelectMany) {
            this.decodeUISelectMany(context, (UISelectMany)component, clientId);
        } else {
            this.decodeUISelectOne(context, component, clientId);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        this.renderSelect(context, component);
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if (component instanceof UISelectMany) {
            RequestStateManager.set(context, "com.sun.faces.ComponentForValue", component);
            return this.convertSelectManyValue(context, (UISelectMany)component, (String[])submittedValue);
        }
        return this.convertSelectOneValue(context, (UISelectOne)component, (String)submittedValue);
    }

    protected Object convertSelectManyValuesForModel(FacesContext context, UISelectMany uiSelectMany, Class<?> modelType, String[] newValues) {
        if (modelType.isArray()) {
            return this.convertSelectManyValuesForArray(context, uiSelectMany, modelType.getComponentType(), newValues);
        }
        if (Collection.class.isAssignableFrom(modelType)) {
            return this.convertSelectManyValuesForCollection(context, uiSelectMany, modelType, newValues);
        }
        if (Object.class.equals(modelType)) {
            return this.convertSelectManyValuesForArray(context, uiSelectMany, modelType, newValues);
        }
        throw new FacesException("Target model Type is no a Collection or Array");
    }

    protected Object convertSelectManyValuesForArray(FacesContext context, UISelectMany uiSelectMany, Class<?> elementType, String[] newValues) throws ConverterException {
        Object array;
        int length;
        int n = length = newValues != null ? newValues.length : 0;
        if (elementType.equals(String.class)) {
            return newValues;
        }
        try {
            array = Array.newInstance(elementType, length);
        }
        catch (Exception e) {
            throw new ConverterException((Throwable)e);
        }
        if (newValues == null) {
            return array;
        }
        Converter converter = uiSelectMany.getConverter();
        if (converter == null && (converter = Util.getConverterForClass(elementType, context)) == null) {
            if (elementType.equals(Object.class)) {
                return newValues;
            }
            Object[] params = new Object[]{Arrays.stream(newValues).collect(Collectors.joining(" ")), "null Converter"};
            throw new ConverterException(MessageUtils.getExceptionMessage("com.sun.faces.TYPECONVERSION_ERROR", params));
        }
        for (int i = 0; i < length; ++i) {
            Object converted = converter.getAsObject(context, (UIComponent)uiSelectMany, newValues[i]);
            Array.set(array, i, converted);
            if (elementType.isPrimitive() || !logger.isLoggable(Level.FINE)) continue;
            logger.fine("String value: " + newValues[i] + " converts to : " + converted);
        }
        return array;
    }

    protected Collection<Object> convertSelectManyValuesForCollection(FacesContext context, UISelectMany uiSelectMany, Class<? extends Collection<Object>> collectionType, String[] newValues) {
        Collection<Object> collection = null;
        int length = null != newValues ? newValues.length : 0;
        Object collectionTypeHint = uiSelectMany.getAttributes().get("collectionType");
        if (collectionTypeHint != null) {
            collection = this.createCollectionFromHint(collectionTypeHint);
        } else {
            String[] currentValue = (String[])uiSelectMany.getValue();
            if (currentValue != null) {
                collection = this.cloneValue(currentValue);
            }
            if (collection == null) {
                collection = this.createCollection((Collection<Object>)currentValue, collectionType);
            }
            if (collection == null) {
                collection = this.bestGuess(collectionType, length);
            }
        }
        if (newValues == null) {
            return collection;
        }
        Converter converter = uiSelectMany.getConverter();
        if (converter != null) {
            for (String newValue : newValues) {
                Object converted = converter.getAsObject(context, (UIComponent)uiSelectMany, newValue);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("String value: " + newValue + " converts to : " + converted);
                }
                collection.add(converted);
            }
        } else {
            SelectItemsIterator iterator = new SelectItemsIterator(context, (UIComponent)uiSelectMany);
            HashMap<String, Object> availableItems = new HashMap<String, Object>();
            while (iterator.hasNext()) {
                SelectItem item = iterator.next();
                if (item instanceof SelectItemGroup) {
                    SelectItem[] newValue = ((SelectItemGroup)item).getSelectItems();
                    int n = newValue.length;
                    for (int i = 0; i < n; ++i) {
                        SelectItem groupItem = newValue[i];
                        String asString = this.getFormattedValue(context, (UIComponent)uiSelectMany, groupItem.getValue());
                        availableItems.put(asString, groupItem.getValue());
                    }
                    continue;
                }
                String asString = this.getFormattedValue(context, (UIComponent)uiSelectMany, item.getValue());
                availableItems.put(asString, item.getValue());
            }
            for (String newValue : newValues) {
                collection.add(availableItems.containsKey(newValue) ? availableItems.get(newValue) : newValue);
            }
        }
        return collection;
    }

    protected boolean renderOption(FacesContext context, UIComponent component, UIComponent selectComponent, Converter<?> converter, SelectItem curItem, Object currentSelections, Object[] submittedValues, HtmlBasicRenderer.OptionComponentInfo optionInfo) throws IOException {
        String labelClass;
        Object itemValue;
        Object[] valuesArray;
        String valueString = this.getFormattedValue(context, component, curItem.getValue(), converter);
        if (submittedValues != null) {
            boolean containsValue = this.containsaValue(submittedValues);
            if (containsValue) {
                valuesArray = submittedValues;
                itemValue = valueString;
            } else {
                valuesArray = currentSelections;
                itemValue = curItem.getValue();
            }
        } else {
            valuesArray = currentSelections;
            itemValue = curItem.getValue();
        }
        boolean isSelected = this.isSelected(context, component, itemValue, valuesArray, converter);
        if (optionInfo.isHideNoSelection() && curItem.isNoSelectionOption() && currentSelections != null && !isSelected) {
            return false;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        writer.writeText((Object)"\t", component, null);
        writer.startElement("option", null != selectComponent ? selectComponent : component);
        writer.writeAttribute("value", (Object)valueString, "value");
        if (isSelected) {
            writer.writeAttribute("selected", (Object)true, "selected");
        }
        if (!optionInfo.isDisabled() && curItem.isDisabled()) {
            writer.writeAttribute("disabled", (Object)true, "disabled");
        }
        if ((labelClass = optionInfo.isDisabled() || curItem.isDisabled() ? optionInfo.getDisabledClass() : optionInfo.getEnabledClass()) != null) {
            writer.writeAttribute("class", (Object)labelClass, "labelClass");
        }
        if (curItem.isEscape()) {
            String label = curItem.getLabel();
            if (label == null) {
                label = valueString;
            }
            writer.writeText((Object)label, component, "label");
        } else {
            writer.write(curItem.getLabel());
        }
        writer.endElement("option");
        writer.writeText((Object)"\n", component, null);
        return true;
    }

    protected void writeDefaultSize(ResponseWriter writer, int itemCount) throws IOException {
        writer.writeAttribute("size", (Object)"1", "size");
    }

    protected boolean containsaValue(Object valueArray) {
        if (valueArray != null) {
            int len = Array.getLength(valueArray);
            for (int i = 0; i < len; ++i) {
                Object value = Array.get(valueArray, i);
                if (value == null || value.equals("")) continue;
                return true;
            }
        }
        return false;
    }

    protected Object getCurrentSelectedValues(UIComponent component) {
        if (component instanceof UISelectMany) {
            UISelectMany select = (UISelectMany)component;
            Object value = select.getValue();
            if (value == null) {
                return null;
            }
            if (value instanceof Collection) {
                return ((Collection)value).toArray();
            }
            if (value.getClass().isArray()) {
                if (Array.getLength(value) == 0) {
                    return null;
                }
            } else if (!value.getClass().isArray()) {
                logger.warning("The UISelectMany value should be an array or a collection type, the actual type is " + value.getClass().getName());
            }
            return value;
        }
        UISelectOne select = (UISelectOne)component;
        Object val = select.getValue();
        if (val != null) {
            return new Object[]{val};
        }
        return null;
    }

    protected String getMultipleText(UIComponent component) {
        if (component instanceof UISelectMany) {
            return " multiple ";
        }
        return "";
    }

    protected Object[] getSubmittedSelectedValues(UIComponent component) {
        if (component instanceof UISelectMany) {
            UISelectMany select = (UISelectMany)component;
            return (Object[])select.getSubmittedValue();
        }
        UISelectOne select = (UISelectOne)component;
        Object val = select.getSubmittedValue();
        if (val != null) {
            return new Object[]{val};
        }
        return null;
    }

    protected boolean isSelected(FacesContext context, UIComponent component, Object itemValue, Object valueArray, Converter<?> converter) {
        if (Util.isAllNull(itemValue, valueArray)) {
            return true;
        }
        if (valueArray != null) {
            if (!valueArray.getClass().isArray()) {
                logger.warning("valueArray is not an array, the actual type is " + valueArray.getClass());
                return valueArray.equals(itemValue);
            }
            int len = Array.getLength(valueArray);
            for (int i = 0; i < len; ++i) {
                Object compareValue;
                Object value = Array.get(valueArray, i);
                if (Util.isAllNull(itemValue, value)) {
                    return true;
                }
                if (value == null ^ itemValue == null) continue;
                if (converter == null) {
                    compareValue = this.coerceToModelType(context, itemValue, value.getClass());
                } else {
                    compareValue = itemValue;
                    if (compareValue instanceof String && !(value instanceof String)) {
                        compareValue = converter.getAsObject(context, component, (String)compareValue);
                    }
                }
                if (!value.equals(compareValue)) continue;
                return true;
            }
        }
        return false;
    }

    protected int renderOptions(FacesContext context, UIComponent component, SelectItemsIterator<SelectItem> items) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Converter converter = null;
        if (component instanceof ValueHolder) {
            converter = ((ValueHolder)component).getConverter();
        }
        int count = 0;
        Object currentSelections = this.getCurrentSelectedValues(component);
        Object[] submittedValues = this.getSubmittedSelectedValues(component);
        HtmlBasicRenderer.OptionComponentInfo optionInfo = new HtmlBasicRenderer.OptionComponentInfo(component);
        RequestStateManager.set(context, "com.sun.faces.ComponentForValue", component);
        while (items.hasNext()) {
            SelectItem item = items.next();
            UIComponent selectComponent = items.currentSelectComponent();
            if (item instanceof SelectItemGroup) {
                SelectItem[] itemsArray;
                writer.startElement("optgroup", null != selectComponent ? selectComponent : component);
                writer.writeAttribute("label", (Object)item.getLabel(), "label");
                if (!optionInfo.isDisabled() && item.isDisabled()) {
                    writer.writeAttribute("disabled", (Object)true, "disabled");
                }
                ++count;
                for (SelectItem element : itemsArray = ((SelectItemGroup)item).getSelectItems()) {
                    if (!this.renderOption(context, component, selectComponent, converter, element, currentSelections, submittedValues, optionInfo)) continue;
                    ++count;
                }
                writer.endElement("optgroup");
                continue;
            }
            if (!this.renderOption(context, component, selectComponent, converter, item, currentSelections, submittedValues, optionInfo)) continue;
            ++count;
        }
        return count;
    }

    protected void renderSelect(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Rendering 'select'");
        }
        writer.startElement("select", component);
        this.writeIdAttributeIfNecessary(context, writer, component);
        writer.writeAttribute("name", (Object)component.getClientId(context), "clientId");
        String styleClass = (String)component.getAttributes().get("styleClass");
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        if (!this.getMultipleText(component).equals("")) {
            writer.writeAttribute("multiple", (Object)true, "multiple");
        }
        SelectItemsIterator<SelectItem> items = RenderKitUtils.getSelectItems(context, component);
        FastStringWriter bufferedWriter = new FastStringWriter(128);
        context.setResponseWriter(writer.cloneWithWriter((Writer)bufferedWriter));
        int count = this.renderOptions(context, component, items);
        context.setResponseWriter(writer);
        Integer size = (Integer)component.getAttributes().get("size");
        if (size == null || size == Integer.MIN_VALUE) {
            size = count;
        }
        this.writeDefaultSize(writer, size);
        RenderKitUtils.renderPassThruAttributes(context, writer, component, ATTRIBUTES, MenuRenderer.getNonOnChangeBehaviors(component));
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component);
        RenderKitUtils.renderOnchange(context, component, false);
        writer.write(bufferedWriter.toString());
        writer.endElement("select");
    }

    protected Object coerceToModelType(FacesContext ctx, Object value, Class<?> itemValueType) {
        Object newValue;
        try {
            ExpressionFactory ef = ctx.getApplication().getExpressionFactory();
            newValue = ef.coerceToType(value, itemValueType);
        }
        catch (ELException | IllegalArgumentException ele) {
            newValue = value;
        }
        return newValue;
    }

    protected Collection<Object> createCollection(Collection<Object> collection, Class<? extends Collection<Object>> fallBackType) {
        block4: {
            Class<Collection<Object>> lookupClass = fallBackType;
            if (collection != null && (lookupClass = collection.getClass()).getName().equals(Arrays.class.getName() + "$ArrayList")) {
                lookupClass = ArrayList.class;
            }
            if (!lookupClass.isInterface() && !Modifier.isAbstract(lookupClass.getModifiers())) {
                try {
                    return lookupClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    if (!logger.isLoggable(Level.SEVERE)) break block4;
                    logger.log(Level.SEVERE, "Unable to create new Collection instance for type " + lookupClass.getName(), e);
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Collection<Object> cloneValue(Object value) {
        if (!(value instanceof Cloneable)) return null;
        Method cloneMethod = ReflectionUtils.lookupMethod(value, "clone", new Class[0]);
        if (cloneMethod != null) {
            try {
                Collection clonedCollected = (Collection)cloneMethod.invoke(value, new Object[0]);
                clonedCollected.clear();
                return clonedCollected;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                if (!logger.isLoggable(Level.SEVERE)) return null;
                logger.log(Level.SEVERE, "Unable to clone collection type: {0}", value.getClass().getName());
                logger.log(Level.SEVERE, e.toString(), e);
                return null;
            }
        } else {
            if (!logger.isLoggable(Level.FINE)) return null;
            logger.log(Level.FINE, "Type {0} implements Cloneable, but has no public clone method.", value.getClass().getName());
        }
        return null;
    }

    protected Collection<Object> bestGuess(Class<? extends Collection<Object>> type, int initialSize) {
        if (SortedSet.class.isAssignableFrom(type)) {
            return new TreeSet<Object>();
        }
        if (Queue.class.isAssignableFrom(type)) {
            return new LinkedList<Object>();
        }
        if (Set.class.isAssignableFrom(type)) {
            return new HashSet<Object>(initialSize);
        }
        return new ArrayList<Object>(initialSize);
    }

    protected Collection<Object> createCollectionFromHint(Object collectionTypeHint) {
        Class collectionType;
        if (collectionTypeHint instanceof Class) {
            collectionType = (Class)collectionTypeHint;
        } else if (collectionTypeHint instanceof String) {
            try {
                collectionType = Util.loadClass((String)collectionTypeHint, (Object)this);
            }
            catch (ClassNotFoundException cnfe) {
                throw new FacesException((Throwable)cnfe);
            }
        } else {
            throw new FacesException("'collectionType' should resolve to type String or Class.  Found: " + collectionTypeHint.getClass().getName());
        }
        Collection<Object> createdCollection = this.createCollection(null, collectionType);
        if (createdCollection == null) {
            throw new FacesException("Unable to create collection type " + collectionType);
        }
        return createdCollection;
    }

    protected static boolean isHideNoSelection(UIComponent component) {
        Object result = component.getAttributes().get("hideNoSelectionOption");
        return result != null ? (Boolean)result : false;
    }

    private void decodeUISelectMany(FacesContext context, UISelectMany component, String clientId) {
        Map requestParameterValuesMap = context.getExternalContext().getRequestParameterValuesMap();
        if (requestParameterValuesMap.containsKey(clientId)) {
            ArrayList<String> newValuesList;
            Set<String> disabledSelectItemValues;
            Object[] newValues = (String[])requestParameterValuesMap.get(clientId);
            if (newValues != null && newValues.length > 0 && !(disabledSelectItemValues = this.getDisabledSelectItemValues(context, (UIComponent)component)).isEmpty() && (newValuesList = new ArrayList<String>(Arrays.asList(newValues))).removeAll(disabledSelectItemValues)) {
                newValues = newValuesList.toArray(new String[newValuesList.size()]);
            }
            this.setSubmittedValue((UIComponent)component, newValues);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("submitted values for UISelectMany component " + component.getId() + " after decoding " + Arrays.toString(newValues));
            }
        } else {
            this.setSubmittedValue((UIComponent)component, new String[0]);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Set empty array for UISelectMany component " + component.getId() + " after decoding ");
            }
        }
    }

    private void decodeUISelectOne(FacesContext context, UIComponent component, String clientId) {
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey(clientId)) {
            Set<String> disabledSelectItemValues;
            String newValue = (String)requestParameterMap.get(clientId);
            if (newValue != null && !newValue.isEmpty() && (disabledSelectItemValues = this.getDisabledSelectItemValues(context, component)).contains(newValue)) {
                newValue = "";
            }
            this.setSubmittedValue(component, newValue);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("submitted value for UISelectOne component " + component.getId() + " after decoding " + newValue);
            }
        } else {
            this.setSubmittedValue(component, "");
        }
    }

    private Set<String> getDisabledSelectItemValues(FacesContext context, UIComponent component) {
        HashSet<String> disabledSelectItemValues = new HashSet<String>(2);
        RenderKitUtils.getSelectItems(context, component).forEachRemaining(selectItem -> {
            if (selectItem.isDisabled()) {
                disabledSelectItemValues.add(this.getFormattedValue(context, component, selectItem.getValue()));
            }
        });
        return disabledSelectItemValues;
    }

    private boolean isNoValueOrNull(String newValue, UIComponent component) {
        if ("".equals(newValue)) {
            return true;
        }
        if (newValue == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("No conversion necessary for SelectOne Component  " + component.getId() + " since the new value is null ");
            }
            return true;
        }
        return false;
    }
}

